/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerIndexHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlanningCostPolicy;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProviderTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class OptimizedCoMTrajectoryPlanner
implements CoMTrajectoryProvider {
    private static boolean verbose = false;
    private static final int maxCapacity = 10;
    private static final boolean includeVelocityObjective = true;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double CONSTRAINT_WEIGHT = 1.0E7;
    private static final double HIGH_WEIGHT = 1000.0;
    public static final double MEDIUM_WEIGHT = 10.0;
    private static final double LOW_WEIGHT = 0.1;
    private static final double VERY_LOW_WEIGHT = 1.0E-5;
    private static final double CONSTRAINT_WEIGHT_SQRT = Math.sqrt(1.0E7);
    private static final double HIGH_WEIGHT_SQRT = Math.sqrt(1000.0);
    private static final double MEDIUM_WEIGHT_SQRT = Math.sqrt(10.0);
    private static final double LOW_WEIGHT_SQRT = Math.sqrt(0.1);
    private static final double VERY_LOW_WEIGHT_SQRT = Math.sqrt(1.0E-5);
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DMatrixSparseCSC coefficientJacobian = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC lowerTriangularHessian = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC hessian = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC xGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC yGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC zGradient = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC tempSparse = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC xEquivalents = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC yEquivalents = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC zEquivalents = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC xConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC yConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC zConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpWaypointJacobian = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpXWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpYWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpZWaypoints = new DMatrixSparseCSC(0, 1);
    private final LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> sparseSolver = LinearSolverFactory_DSCC.lu((FillReducing)FillReducing.NONE);
    final DMatrixSparseCSC xCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC yCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC zCoefficientVector = new DMatrixSparseCSC(0, 1);
    private final List<CoMTrajectoryPlanningCostPolicy> costPolicies = new ArrayList<CoMTrajectoryPlanningCostPolicy>();
    private final DoubleProvider omega;
    private final YoDouble comHeight = new YoDouble("comHeightForPlanning", this.registry);
    private final double gravityZ;
    private final CoMTrajectoryPlannerIndexHandler indexHandler = new CoMTrajectoryPlannerIndexHandler();
    private final FixedFramePoint3DBasics desiredCoMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMVelocity = new FrameVector3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMAcceleration = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredDCMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredDCMVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredVRPPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredVRPVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredECMPPosition = new FramePoint3D(worldFrame);
    private final RecyclingArrayList<FramePoint3D> startVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> endVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final YoBoolean maintainInitialCoMVelocityContinuity = new YoBoolean("maintainInitialCoMVelocityContinuity", this.registry);
    private final YoFramePoint3D finalDCMPosition = new YoFramePoint3D("goalDCMPosition", worldFrame, this.registry);
    private final YoFramePoint3D currentCoMPosition = new YoFramePoint3D("currentCoMPosition", worldFrame, this.registry);
    private final YoFrameVector3D currentCoMVelocity = new YoFrameVector3D("currentCoMVelocity", worldFrame, this.registry);
    private final YoFramePoint3D yoFirstCoefficient = new YoFramePoint3D("comFirstCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoSecondCoefficient = new YoFramePoint3D("comSecondCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoThirdCoefficient = new YoFramePoint3D("comThirdCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoFourthCoefficient = new YoFramePoint3D("comFourthCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoFifthCoefficient = new YoFramePoint3D("comFifthCoefficient", worldFrame, this.registry);
    private final YoFramePoint3D yoSixthCoefficient = new YoFramePoint3D("comSixthCoefficient", worldFrame, this.registry);
    private final RecyclingArrayList<FramePoint3D> dcmCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> comCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<Polynomial3D> vrpTrajectoryPool = new RecyclingArrayList(() -> new Polynomial3D(4));
    private final RecyclingArrayList<LineSegment3D> vrpSegments = new RecyclingArrayList(LineSegment3D::new);
    private final List<Polynomial3D> vrpTrajectories = new ArrayList<Polynomial3D>();
    private int numberOfConstraints = 0;
    private CornerPointViewer viewer = null;
    private BagOfBalls comTrajectoryViewer = null;
    private final IGrowArray gw = new IGrowArray();
    private final DGrowArray gx = new DGrowArray();
    private final FramePoint3D comPositionToThrowAway = new FramePoint3D();
    private final FramePoint3D dcmPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D comVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D comAccelerationToThrowAway = new FrameVector3D();
    private final FrameVector3D dcmVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D vrpVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D vrpStartPosition = new FramePoint3D();
    private final FrameVector3D vrpStartVelocity = new FrameVector3D();
    private final FramePoint3D vrpEndPosition = new FramePoint3D();
    private final FrameVector3D vrpEndVelocity = new FrameVector3D();
    private final FramePoint3D ecmpPositionToThrowAway = new FramePoint3D();
    private final FramePoint3D firstCoefficient = new FramePoint3D();
    private final FramePoint3D secondCoefficient = new FramePoint3D();
    private final FramePoint3D thirdCoefficient = new FramePoint3D();
    private final FramePoint3D fourthCoefficient = new FramePoint3D();
    private final FramePoint3D fifthCoefficient = new FramePoint3D();
    private final FramePoint3D sixthCoefficient = new FramePoint3D();
    private final FrameVector3D desiredVelocity = new FrameVector3D();

    public OptimizedCoMTrajectoryPlanner(double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry) {
        this.gravityZ = Math.abs(gravityZ);
        YoDouble omega = new YoDouble("omegaForPlanning", this.registry);
        this.comHeight.addListener(v -> omega.set(Math.sqrt(Math.abs(gravityZ) / this.comHeight.getDoubleValue())));
        this.comHeight.set(nominalCoMHeight);
        this.omega = omega;
        parentRegistry.addChild(this.registry);
    }

    public OptimizedCoMTrajectoryPlanner(double gravityZ, YoDouble omega, YoRegistry parentRegistry) {
        this.omega = omega;
        this.gravityZ = Math.abs(gravityZ);
        omega.addListener(v -> this.comHeight.set(gravityZ / MathTools.square((double)omega.getValue())));
        omega.notifyListeners();
        parentRegistry.addChild(this.registry);
    }

    public void setMaintainInitialCoMVelocityContinuity(boolean maintainInitialCoMVelocityContinuity) {
        this.maintainInitialCoMVelocityContinuity.set(maintainInitialCoMVelocityContinuity);
    }

    public void setCornerPointViewer(CornerPointViewer viewer) {
        this.viewer = viewer;
    }

    public void setupCoMTrajectoryViewer(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.comTrajectoryViewer = new BagOfBalls(50, 0.01, YoAppearance.Black(), this.registry, yoGraphicsListRegistry);
    }

    public void addCostPolicy(CoMTrajectoryPlanningCostPolicy costPolicy) {
        this.costPolicies.add(costPolicy);
    }

    @Override
    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.comHeight.set(nominalCoMHeight);
    }

    @Override
    public double getNominalCoMHeight() {
        return this.comHeight.getDoubleValue();
    }

    @Override
    public void solveForTrajectory(List<? extends ContactStateProvider> contactSequence) {
        if (!ContactStateProviderTools.checkContactSequenceIsValid(contactSequence)) {
            throw new IllegalArgumentException("The contact sequence is not valid.");
        }
        this.indexHandler.update(contactSequence);
        this.resetMatrices();
        CoMTrajectoryPlannerTools.computeVRPWaypoints(this.comHeight.getDoubleValue(), this.gravityZ, this.omega.getValue(), (FrameVector3DReadOnly)this.currentCoMVelocity, contactSequence, this.startVRPPositions, this.endVRPPositions, true);
        this.solveForCoefficientConstraintMatrix(contactSequence);
        int firstCoefficientIndex = 0;
        int secondCoefficientIndex = 1;
        int thirdCoefficientIndex = 2;
        int fourthCoefficientIndex = 3;
        int fifthCoefficientIndex = 4;
        int sixthCoefficientIndex = 5;
        this.yoFirstCoefficient.setX(this.xCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoFirstCoefficient.setY(this.yCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoFirstCoefficient.setZ(this.zCoefficientVector.get(firstCoefficientIndex, 0));
        this.yoSecondCoefficient.setX(this.xCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoSecondCoefficient.setY(this.yCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoSecondCoefficient.setZ(this.zCoefficientVector.get(secondCoefficientIndex, 0));
        this.yoThirdCoefficient.setX(this.xCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoThirdCoefficient.setY(this.yCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoThirdCoefficient.setZ(this.zCoefficientVector.get(thirdCoefficientIndex, 0));
        this.yoFourthCoefficient.setX(this.xCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFourthCoefficient.setY(this.yCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFourthCoefficient.setZ(this.zCoefficientVector.get(fourthCoefficientIndex, 0));
        this.yoFifthCoefficient.setX(this.xCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoFifthCoefficient.setY(this.yCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoFifthCoefficient.setZ(this.zCoefficientVector.get(fifthCoefficientIndex, 0));
        this.yoSixthCoefficient.setX(this.xCoefficientVector.get(sixthCoefficientIndex, 0));
        this.yoSixthCoefficient.setY(this.yCoefficientVector.get(sixthCoefficientIndex, 0));
        this.yoSixthCoefficient.setZ(this.zCoefficientVector.get(sixthCoefficientIndex, 0));
        this.updateCornerPoints(contactSequence);
        if (this.viewer != null) {
            this.viewer.updateDCMCornerPoints((List<FramePoint3D>)this.dcmCornerPoints);
            this.viewer.updateCoMCornerPoints((List<FramePoint3D>)this.comCornerPoints);
            this.viewer.updateVRPWaypoints((List<LineSegment3D>)this.vrpSegments);
        }
        if (this.comTrajectoryViewer != null) {
            this.updateCoMTrajectoryViewer();
        }
    }

    private void solveForCoefficientConstraintMatrix(List<? extends ContactStateProvider> contactSequence) {
        int numberOfPhases = contactSequence.size();
        int numberOfTransitions = numberOfPhases - 1;
        this.numberOfConstraints = 0;
        this.addCoMPositionObjective(HIGH_WEIGHT_SQRT, (FramePoint3DReadOnly)this.currentCoMPosition);
        if (this.maintainInitialCoMVelocityContinuity.getBooleanValue()) {
            this.addCoMVelocityObjective(MEDIUM_WEIGHT_SQRT, (FrameVector3DReadOnly)this.currentCoMVelocity);
        }
        this.addDynamicsInitialObjective(HIGH_WEIGHT_SQRT, MEDIUM_WEIGHT_SQRT, contactSequence, 0);
        int transition = 0;
        this.addCoMPositionContinuityObjective(CONSTRAINT_WEIGHT_SQRT, contactSequence, 0, 1);
        this.addCoMVelocityContinuityObjective(CONSTRAINT_WEIGHT_SQRT, contactSequence, 0, 1);
        this.addDynamicsFinalObjective(LOW_WEIGHT_SQRT, VERY_LOW_WEIGHT_SQRT, contactSequence, 0);
        this.addDynamicsInitialObjective(LOW_WEIGHT_SQRT, VERY_LOW_WEIGHT_SQRT, contactSequence, 1);
        ++transition;
        while (transition < numberOfTransitions) {
            int previousSequence = transition;
            int nextSequence = transition + 1;
            this.addCoMPositionContinuityObjective(CONSTRAINT_WEIGHT_SQRT, contactSequence, previousSequence, nextSequence);
            this.addCoMVelocityContinuityObjective(CONSTRAINT_WEIGHT_SQRT, contactSequence, previousSequence, nextSequence);
            this.addDynamicsFinalObjective(MEDIUM_WEIGHT_SQRT, LOW_WEIGHT_SQRT, contactSequence, previousSequence);
            this.addDynamicsInitialObjective(MEDIUM_WEIGHT_SQRT, LOW_WEIGHT_SQRT, contactSequence, nextSequence);
            ++transition;
        }
        ContactStateProvider lastContactPhase = contactSequence.get(numberOfPhases - 1);
        this.finalDCMPosition.set((FrameTuple3DReadOnly)this.endVRPPositions.getLast());
        double finalDuration = Math.min(lastContactPhase.getTimeInterval().getDuration(), 10.0);
        this.addDCMPositionObjective(HIGH_WEIGHT_SQRT, numberOfPhases - 1, finalDuration, (FramePoint3DReadOnly)this.finalDCMPosition);
        this.addDynamicsFinalObjective(HIGH_WEIGHT_SQRT, MEDIUM_WEIGHT_SQRT, contactSequence, numberOfPhases - 1);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpXWaypoints, (DMatrixSparseCSC)this.tempSparse);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.xConstants, (DMatrixSparseCSC)this.xEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpYWaypoints, (DMatrixSparseCSC)this.tempSparse);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.yConstants, (DMatrixSparseCSC)this.yEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpZWaypoints, (DMatrixSparseCSC)this.tempSparse);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.zConstants, (DMatrixSparseCSC)this.zEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.innerProductLower((DMatrixSparseCSC)this.coefficientJacobian, (DMatrixSparseCSC)this.lowerTriangularHessian, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.symmLowerToFull((DMatrixSparseCSC)this.lowerTriangularHessian, (DMatrixSparseCSC)this.hessian, (IGrowArray)this.gw);
        CommonOps_DSCC.multTransA((DMatrixSparseCSC)this.coefficientJacobian, (DMatrixSparseCSC)this.xEquivalents, (DMatrixSparseCSC)this.xGradient, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.multTransA((DMatrixSparseCSC)this.coefficientJacobian, (DMatrixSparseCSC)this.yEquivalents, (DMatrixSparseCSC)this.yGradient, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.multTransA((DMatrixSparseCSC)this.coefficientJacobian, (DMatrixSparseCSC)this.zEquivalents, (DMatrixSparseCSC)this.zGradient, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.scale((double)2.0, (DMatrixSparseCSC)this.xGradient, (DMatrixSparseCSC)this.xGradient);
        CommonOps_DSCC.scale((double)2.0, (DMatrixSparseCSC)this.yGradient, (DMatrixSparseCSC)this.yGradient);
        CommonOps_DSCC.scale((double)2.0, (DMatrixSparseCSC)this.zGradient, (DMatrixSparseCSC)this.zGradient);
        for (int segment = 0; segment < numberOfPhases; ++segment) {
            double duration = contactSequence.get(segment).getTimeInterval().getDuration();
            CoMTrajectoryPlannerTools.addMinimizeCoMAccelerationObjective(0.1, 0.0, duration, this.omega.getValue(), segment, (DMatrix)this.hessian);
            CoMTrajectoryPlannerTools.addMinimizeCoMJerkObjective(1.0E-5, 0.0, duration, this.omega.getValue(), segment, (DMatrix)this.hessian);
        }
        for (int i = 0; i < this.costPolicies.size(); ++i) {
            this.costPolicies.get(i).assessPolicy(this, contactSequence, (DMatrix)this.hessian, (DMatrix)this.xGradient, (DMatrix)this.yGradient, (DMatrix)this.zGradient);
        }
        CommonOps_DSCC.scale((double)0.5, (DMatrixSparseCSC)this.xGradient, (DMatrixSparseCSC)this.xGradient);
        CommonOps_DSCC.scale((double)0.5, (DMatrixSparseCSC)this.yGradient, (DMatrixSparseCSC)this.yGradient);
        CommonOps_DSCC.scale((double)0.5, (DMatrixSparseCSC)this.zGradient, (DMatrixSparseCSC)this.zGradient);
        this.sparseSolver.setA((Matrix)this.hessian);
        this.sparseSolver.solveSparse((Matrix)this.xGradient, (Matrix)this.xCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.yGradient, (Matrix)this.yCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.zGradient, (Matrix)this.zCoefficientVector);
    }

    private void updateCornerPoints(List<? extends ContactStateProvider> contactSequence) {
        this.vrpTrajectoryPool.clear();
        this.vrpTrajectories.clear();
        this.comCornerPoints.clear();
        this.dcmCornerPoints.clear();
        this.vrpSegments.clear();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int segmentId = 0; segmentId < Math.min(contactSequence.size(), 11); ++segmentId) {
            double duration = contactSequence.get(segmentId).getTimeInterval().getDuration();
            duration = Math.min(duration, 10.0);
            this.compute(segmentId, 0.0, (FixedFramePoint3DBasics)this.comCornerPoints.add(), (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmCornerPoints.add(), (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFrameVector3DBasics)this.vrpStartVelocity, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.compute(segmentId, duration, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFrameVector3DBasics)this.vrpEndVelocity, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            Polynomial3D trajectory3D = (Polynomial3D)this.vrpTrajectoryPool.add();
            trajectory3D.setCubic(0.0, duration, (Point3DReadOnly)this.vrpStartPosition, (Vector3DReadOnly)this.vrpStartVelocity, (Point3DReadOnly)this.vrpEndPosition, (Vector3DReadOnly)this.vrpEndVelocity);
            this.vrpTrajectories.add(trajectory3D);
            ((LineSegment3D)this.vrpSegments.add()).set((Point3DReadOnly)this.vrpStartPosition, (Point3DReadOnly)this.vrpEndPosition);
        }
        verbose = verboseBefore;
    }

    private void updateCoMTrajectoryViewer() {
        this.comTrajectoryViewer.reset();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int i = 0; i < this.comTrajectoryViewer.getNumberOfBalls(); ++i) {
            double time = 0.05 * (double)i;
            int segmentId = this.getSegmentNumber(time);
            double timeInSegment = this.getTimeInSegment(segmentId, time);
            this.compute(segmentId, timeInSegment, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.comTrajectoryViewer.setBall((FramePoint3DReadOnly)this.comPositionToThrowAway);
        }
        verbose = verboseBefore;
    }

    @Override
    public void compute(int segmentId, double timeInPhase) {
        this.compute(segmentId, timeInPhase, this.desiredCoMPosition, this.desiredCoMVelocity, this.desiredCoMAcceleration, this.desiredDCMPosition, this.desiredDCMVelocity, this.desiredVRPPosition, this.desiredECMPPosition);
        if (verbose) {
            LogTools.info((String)("At time " + timeInPhase + ", Desired DCM = " + this.desiredDCMPosition + ", Desired CoM = " + this.desiredCoMPosition));
        }
    }

    @Override
    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        this.compute(segmentId, timeInPhase, comPositionToPack, comVelocityToPack, comAccelerationToPack, dcmPositionToPack, dcmVelocityToPack, vrpPositionToPack, (FixedFrameVector3DBasics)this.vrpVelocityToThrowAway, ecmpPositionToPack);
    }

    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        if (segmentId < 0) {
            throw new IllegalArgumentException("time is invalid.");
        }
        int startIndex = this.indexHandler.getContactSequenceStartIndex(segmentId);
        this.firstCoefficient.setX(this.xCoefficientVector.get(startIndex, 0));
        this.firstCoefficient.setY(this.yCoefficientVector.get(startIndex, 0));
        this.firstCoefficient.setZ(this.zCoefficientVector.get(startIndex, 0));
        int secondCoefficientIndex = startIndex + 1;
        this.secondCoefficient.setX(this.xCoefficientVector.get(secondCoefficientIndex, 0));
        this.secondCoefficient.setY(this.yCoefficientVector.get(secondCoefficientIndex, 0));
        this.secondCoefficient.setZ(this.zCoefficientVector.get(secondCoefficientIndex, 0));
        int thirdCoefficientIndex = startIndex + 2;
        this.thirdCoefficient.setX(this.xCoefficientVector.get(thirdCoefficientIndex, 0));
        this.thirdCoefficient.setY(this.yCoefficientVector.get(thirdCoefficientIndex, 0));
        this.thirdCoefficient.setZ(this.zCoefficientVector.get(thirdCoefficientIndex, 0));
        int fourthCoefficientIndex = startIndex + 3;
        this.fourthCoefficient.setX(this.xCoefficientVector.get(fourthCoefficientIndex, 0));
        this.fourthCoefficient.setY(this.yCoefficientVector.get(fourthCoefficientIndex, 0));
        this.fourthCoefficient.setZ(this.zCoefficientVector.get(fourthCoefficientIndex, 0));
        int fifthCoefficientIndex = startIndex + 4;
        this.fifthCoefficient.setX(this.xCoefficientVector.get(fifthCoefficientIndex, 0));
        this.fifthCoefficient.setY(this.yCoefficientVector.get(fifthCoefficientIndex, 0));
        this.fifthCoefficient.setZ(this.zCoefficientVector.get(fifthCoefficientIndex, 0));
        int sixthCoefficientIndex = startIndex + 5;
        this.sixthCoefficient.setX(this.xCoefficientVector.get(sixthCoefficientIndex, 0));
        this.sixthCoefficient.setY(this.yCoefficientVector.get(sixthCoefficientIndex, 0));
        this.sixthCoefficient.setZ(this.zCoefficientVector.get(sixthCoefficientIndex, 0));
        double omega = this.omega.getValue();
        CoMTrajectoryPlannerTools.constructDesiredCoMPosition(comPositionToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredCoMVelocity(comVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredCoMAcceleration(comAccelerationToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CoMTrajectoryPlannerTools.constructDesiredVRPVelocity(vrpVelocityToPack, (FramePoint3DReadOnly)this.firstCoefficient, (FramePoint3DReadOnly)this.secondCoefficient, (FramePoint3DReadOnly)this.thirdCoefficient, (FramePoint3DReadOnly)this.fourthCoefficient, (FramePoint3DReadOnly)this.fifthCoefficient, (FramePoint3DReadOnly)this.sixthCoefficient, timeInPhase, omega);
        CapturePointTools.computeCapturePointPosition((FramePoint3DReadOnly)comPositionToPack, (FrameVector3DReadOnly)comVelocityToPack, omega, dcmPositionToPack);
        CapturePointTools.computeCapturePointVelocity((FrameVector3DReadOnly)comVelocityToPack, (FrameVector3DReadOnly)comAccelerationToPack, omega, dcmVelocityToPack);
        CapturePointTools.computeCentroidalMomentumPivot((FramePoint3DReadOnly)dcmPositionToPack, (FrameVector3DReadOnly)dcmVelocityToPack, omega, vrpPositionToPack);
        ecmpPositionToPack.set((FrameTuple3DReadOnly)vrpPositionToPack);
        ecmpPositionToPack.subZ(this.comHeight.getDoubleValue());
    }

    @Override
    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.currentCoMPosition.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassPosition);
        this.currentCoMVelocity.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassVelocity);
    }

    @Override
    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.desiredDCMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.desiredDCMVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.desiredCoMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.desiredCoMVelocity;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.desiredCoMAcceleration;
    }

    @Override
    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.desiredVRPPosition;
    }

    public FrameVector3DReadOnly getDesiredVRPVelocity() {
        return this.desiredVRPVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredECMPPosition() {
        return this.desiredECMPPosition;
    }

    private void resetMatrices() {
        int size = this.indexHandler.getTotalNumberOfCoefficients();
        int numberOfVRPWaypoints = this.indexHandler.getNumberOfVRPWaypoints();
        int extraObjectives = this.maintainInitialCoMVelocityContinuity.getBooleanValue() ? 1 : 0;
        this.coefficientJacobian.reshape(size + extraObjectives, size);
        this.hessian.reshape(size, size);
        this.lowerTriangularHessian.reshape(size, size);
        this.xGradient.reshape(size, 1);
        this.yGradient.reshape(size, 1);
        this.zGradient.reshape(size, 1);
        this.tempSparse.reshape(size, 1);
        this.xEquivalents.reshape(size + extraObjectives, 1);
        this.yEquivalents.reshape(size + extraObjectives, 1);
        this.zEquivalents.reshape(size + extraObjectives, 1);
        this.xConstants.reshape(size + extraObjectives, 1);
        this.yConstants.reshape(size + extraObjectives, 1);
        this.zConstants.reshape(size + extraObjectives, 1);
        this.vrpWaypointJacobian.reshape(size + extraObjectives, numberOfVRPWaypoints);
        this.vrpXWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpYWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpZWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.xCoefficientVector.reshape(size, 1);
        this.yCoefficientVector.reshape(size, 1);
        this.zCoefficientVector.reshape(size, 1);
        this.coefficientJacobian.zero();
        this.lowerTriangularHessian.zero();
        this.hessian.zero();
        this.xEquivalents.zero();
        this.yEquivalents.zero();
        this.zEquivalents.zero();
        this.xConstants.zero();
        this.yConstants.zero();
        this.zConstants.zero();
        this.vrpWaypointJacobian.zero();
        this.vrpXWaypoints.zero();
        this.vrpYWaypoints.zero();
        this.vrpZWaypoints.zero();
    }

    private void addCoMPositionObjective(double weight, FramePoint3DReadOnly centerOfMassLocationForConstraint) {
        CoMTrajectoryPlannerTools.addCoMPositionObjective(weight, centerOfMassLocationForConstraint, this.omega.getValue(), 0.0, 0, this.numberOfConstraints, (DMatrix)this.coefficientJacobian, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void addCoMVelocityObjective(double weight, FrameVector3DReadOnly desiredCoMVelocity) {
        CoMTrajectoryPlannerTools.addCoMVelocityObjective(weight, desiredCoMVelocity, this.omega.getValue(), 0.0, 0, this.numberOfConstraints, (DMatrix)this.coefficientJacobian, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void addDCMPositionObjective(double weight, int sequenceId, double time, FramePoint3DReadOnly desiredDCMPosition) {
        CoMTrajectoryPlannerTools.addDCMPositionObjective(weight, sequenceId, this.numberOfConstraints, time, this.omega.getValue(), desiredDCMPosition, (DMatrix)this.coefficientJacobian, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void addCoMPositionContinuityObjective(double weight, List<? extends ContactStateProvider> contactSequence, int previousSequence, int nextSequence) {
        double previousDuration = contactSequence.get(previousSequence).getTimeInterval().getDuration();
        CoMTrajectoryPlannerTools.addCoMPositionContinuityObjective(weight, previousSequence, nextSequence, this.numberOfConstraints, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientJacobian);
        ++this.numberOfConstraints;
    }

    private void addCoMVelocityContinuityObjective(double weight, List<? extends ContactStateProvider> contactSequence, int previousSequence, int nextSequence) {
        double previousDuration = contactSequence.get(previousSequence).getTimeInterval().getDuration();
        CoMTrajectoryPlannerTools.addCoMVelocityContinuityObjective(weight, previousSequence, nextSequence, this.numberOfConstraints, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientJacobian);
        ++this.numberOfConstraints;
    }

    private void addDynamicsInitialObjective(double positionWeight, double velocityWeight, List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        if (contactState.isLoadBearing()) {
            double duration = contactStateProvider.getTimeInterval().getDuration();
            this.desiredVelocity.sub((FrameTuple3DReadOnly)this.endVRPPositions.get(sequenceId), (FrameTuple3DReadOnly)this.startVRPPositions.get(sequenceId));
            this.desiredVelocity.scale(1.0 / duration);
            this.addVRPPositionObjective(positionWeight, sequenceId, this.indexHandler.getVRPWaypointStartPositionIndex(sequenceId), 0.0, (FramePoint3DReadOnly)this.startVRPPositions.get(sequenceId));
            this.addVRPVelocityObjective(velocityWeight, sequenceId, this.indexHandler.getVRPWaypointStartVelocityIndex(sequenceId), 0.0, (FrameVector3DReadOnly)this.desiredVelocity);
        } else {
            this.addCoMAccelerationIsGravityObjective(CONSTRAINT_WEIGHT_SQRT, sequenceId, 0.0);
            this.addZeroCoMJerkObjective(CONSTRAINT_WEIGHT_SQRT, sequenceId, 0.0);
        }
    }

    private void addDynamicsFinalObjective(double positionWeight, double velocityWeight, List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        double duration = contactStateProvider.getTimeInterval().getDuration();
        if (contactState.isLoadBearing()) {
            this.desiredVelocity.sub((FrameTuple3DReadOnly)this.endVRPPositions.get(sequenceId), (FrameTuple3DReadOnly)this.startVRPPositions.get(sequenceId));
            this.desiredVelocity.scale(1.0 / duration);
            this.addVRPPositionObjective(positionWeight, sequenceId, this.indexHandler.getVRPWaypointFinalPositionIndex(sequenceId), duration, (FramePoint3DReadOnly)this.endVRPPositions.get(sequenceId));
            this.addVRPVelocityObjective(velocityWeight, sequenceId, this.indexHandler.getVRPWaypointFinalVelocityIndex(sequenceId), duration, (FrameVector3DReadOnly)this.desiredVelocity);
        } else {
            this.addCoMAccelerationIsGravityObjective(CONSTRAINT_WEIGHT_SQRT, sequenceId, duration);
            this.addZeroCoMJerkObjective(CONSTRAINT_WEIGHT_SQRT, sequenceId, duration);
        }
    }

    private void addVRPPositionObjective(double weight, int sequenceId, int vrpWaypointPositionIndex, double time, FramePoint3DReadOnly desiredVRPPosition) {
        CoMTrajectoryPlannerTools.addVRPPositionObjective(weight, sequenceId, this.numberOfConstraints, vrpWaypointPositionIndex, time, this.omega.getValue(), desiredVRPPosition, (DMatrix)this.coefficientJacobian, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
        ++this.numberOfConstraints;
    }

    private void addVRPVelocityObjective(double weight, int sequenceId, int vrpWaypointVelocityIndex, double time, FrameVector3DReadOnly desiredVRPVelocity) {
        CoMTrajectoryPlannerTools.addVRPVelocityObjective(weight, sequenceId, this.numberOfConstraints, vrpWaypointVelocityIndex, this.omega.getValue(), time, desiredVRPVelocity, (DMatrix)this.coefficientJacobian, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
        ++this.numberOfConstraints;
    }

    private void addCoMAccelerationIsGravityObjective(double weight, int sequenceId, double time) {
        CoMTrajectoryPlannerTools.addCoMAccelerationIsGravityObjective(weight, sequenceId, this.numberOfConstraints, this.omega.getValue(), time, this.gravityZ, (DMatrix)this.coefficientJacobian, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void addZeroCoMJerkObjective(double weight, int sequenceId, double time) {
        CoMTrajectoryPlannerTools.addZeroCoMJerkObjective(weight, time, this.omega.getValue(), sequenceId, this.numberOfConstraints, (DMatrix)this.coefficientJacobian);
        ++this.numberOfConstraints;
    }

    public List<Polynomial3D> getVRPTrajectories() {
        return this.vrpTrajectories;
    }

    @Override
    public MultipleSegmentPositionTrajectoryGenerator<?> getCoMTrajectory() {
        throw new UnsupportedOperationException();
    }
}

