/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.WrenchTrajectorySegment;
import us.ihmc.commonWalkingControlModules.modelPredictiveController.ioHandling.MPCContactPlane;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.robotics.time.TimeIntervalTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class MultipleWrenchSegmentTrajectoryGenerator
implements ReferenceFrameHolder {
    private final String namePrefix;
    private final int maximumNumberOfSegments;
    private final YoRegistry registry;
    private final YoDouble currentSegmentTime;
    protected final YoInteger numberOfSegments;
    private final YoInteger currentSegmentIndex;
    protected final RecyclingArrayList<WrenchTrajectorySegment> segments;
    private final FixedFrameWrenchBasics currentWrench;

    public MultipleWrenchSegmentTrajectoryGenerator(String namePrefix, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this(namePrefix, 30, referenceFrame, parentRegistry);
    }

    public MultipleWrenchSegmentTrajectoryGenerator(String namePrefix, int maximumNumberOfSegments, ReferenceFrame referenceFrame, YoRegistry parentRegistry) {
        this.namePrefix = namePrefix;
        this.maximumNumberOfSegments = maximumNumberOfSegments;
        this.registry = new YoRegistry(namePrefix + this.getClass().getSimpleName());
        this.numberOfSegments = new YoInteger(namePrefix + "NumberOfSegments", this.registry);
        this.numberOfSegments.set(0);
        this.segments = new RecyclingArrayList(WrenchTrajectorySegment::new);
        this.currentSegmentTime = new YoDouble(namePrefix + "CurrentTrajectoryTime", this.registry);
        this.currentSegmentIndex = new YoInteger(namePrefix + "CurrentSegmentIndex", this.registry);
        String currentPositionName = namePrefix + "CurrentWrench";
        this.currentWrench = new YoFixedFrameWrench(currentPositionName, referenceFrame, referenceFrame, this.registry);
        this.clear();
        parentRegistry.addChild(this.registry);
    }

    public ReferenceFrame getReferenceFrame() {
        return this.getWrench().getReferenceFrame();
    }

    public void clear() {
        this.numberOfSegments.set(0);
        this.currentSegmentIndex.set(0);
        this.segments.clear();
    }

    public void appendSegment(WrenchTrajectorySegment segment) {
        this.checkReferenceFrameMatch(segment);
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + 1);
        this.checkNextSegmentIsContinuous(segment);
        this.appendSegmentsUnsafe(segment);
    }

    private void appendSegmentsUnsafe(WrenchTrajectorySegment segment) {
        ((WrenchTrajectorySegment)this.segments.add()).set(segment);
        this.numberOfSegments.increment();
    }

    public void appendSegment(TimeIntervalReadOnly timeInterval, double mass, double omega, List<MPCContactPlane> contactPlanes) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + 1);
        WrenchTrajectorySegment segment = (WrenchTrajectorySegment)this.segments.add();
        this.checkReferenceFrameMatch(segment);
        segment.getTimeInterval().set(timeInterval);
        this.checkNextSegmentIsContinuous(segment);
        segment.setOmega(omega);
        segment.setMass(mass);
        segment.setCoefficients(contactPlanes);
        this.numberOfSegments.increment();
    }

    public void appendSegments(WrenchTrajectorySegment[] segments) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + segments.length);
        for (int i = 0; i < segments.length; ++i) {
            this.appendSegment(segments[i]);
        }
    }

    public void appendSegments(List<WrenchTrajectorySegment> segments) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + segments.size());
        for (int i = 0; i < segments.size(); ++i) {
            this.appendSegment(segments.get(i));
        }
    }

    protected void checkNumberOfSegments(int length) {
        if (length > this.maximumNumberOfSegments) {
            throw new RuntimeException("Cannot exceed the maximum number of segments. Number of segments provided: " + length);
        }
    }

    protected void checkNextSegmentIsContinuous(WrenchTrajectorySegment segment) {
        if (this.getCurrentNumberOfSegments() == 0) {
            return;
        }
        if (!TimeIntervalTools.areTimeIntervalsConsecutive((TimeIntervalProvider)((TimeIntervalProvider)this.segments.get(this.getCurrentNumberOfSegments() - 1)), (TimeIntervalProvider)segment, (double)0.005)) {
            throw new RuntimeException("The next segment doesn't start where the previous one ended.");
        }
    }

    public void initialize() {
        if (this.numberOfSegments.getIntegerValue() == 0) {
            throw new RuntimeException("Trajectory has no segments.");
        }
        this.currentSegmentIndex.set(0);
    }

    public void compute(double time) {
        if (this.isEmpty()) {
            throw new RuntimeException("Can not call compute on an empty trajectory.");
        }
        this.currentSegmentTime.set(time);
        if (!TimeIntervalTools.isTimeSequenceContinuous(this.segments)) {
            throw new RuntimeException("The segments do not represent a continuous time trajectory.");
        }
        if (time < ((WrenchTrajectorySegment)this.segments.get(this.currentSegmentIndex.getIntegerValue())).getTimeInterval().getStartTime()) {
            this.currentSegmentIndex.set(0);
        }
        while (this.currentSegmentIndex.getIntegerValue() < this.numberOfSegments.getIntegerValue() - 1 && time > ((WrenchTrajectorySegment)this.segments.get(this.currentSegmentIndex.getIntegerValue())).getTimeInterval().getEndTime()) {
            this.currentSegmentIndex.increment();
        }
        WrenchTrajectorySegment segment = (WrenchTrajectorySegment)this.segments.get(this.currentSegmentIndex.getValue());
        TimeIntervalBasics timeInterval = segment.getTimeInterval();
        double subTrajectoryTime = MathTools.clamp((double)(time - timeInterval.getStartTime()), (double)0.0, (double)timeInterval.getDuration());
        segment.compute(subTrajectoryTime);
        this.currentWrench.set(segment.getWrench());
    }

    public boolean isDone() {
        boolean isLastWaypoint;
        if (this.isEmpty()) {
            return true;
        }
        boolean bl = isLastWaypoint = this.currentSegmentIndex.getIntegerValue() >= this.numberOfSegments.getIntegerValue() - 1;
        if (!isLastWaypoint) {
            return false;
        }
        return this.currentSegmentTime.getValue() >= this.getEndTime();
    }

    public boolean isEmpty() {
        return this.numberOfSegments.getIntegerValue() == 0;
    }

    public int getCurrentSegmentIndex() {
        return this.currentSegmentIndex.getIntegerValue();
    }

    public double getCurrentSegmentTrajectoryTime() {
        return this.currentSegmentTime.getDoubleValue();
    }

    public WrenchReadOnly getWrench() {
        return this.currentWrench;
    }

    public int getCurrentNumberOfSegments() {
        return this.numberOfSegments.getIntegerValue();
    }

    public int getMaximumNumberOfSegments() {
        return this.maximumNumberOfSegments;
    }

    public double getEndTime() {
        return ((WrenchTrajectorySegment)this.segments.get(this.getCurrentNumberOfSegments() - 1)).getTimeInterval().getEndTime();
    }

    public List<WrenchTrajectorySegment> getSegments() {
        return this.segments;
    }

    public WrenchTrajectorySegment getSegment(int segmentIdx) {
        return (WrenchTrajectorySegment)this.segments.get(segmentIdx);
    }

    public void removeSegment(int segmentIdx) {
        this.segments.remove(segmentIdx);
        this.numberOfSegments.decrement();
    }

    public String toString() {
        if (this.numberOfSegments.getIntegerValue() == 0) {
            return this.namePrefix + ": Has no segments.";
        }
        return this.namePrefix + ": number of segments = " + this.numberOfSegments.getIntegerValue() + ", current segment index = " + this.currentSegmentIndex.getIntegerValue();
    }
}

