/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectorySegment;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public class MultipleCoMSegmentTrajectoryGenerator
extends MultipleSegmentPositionTrajectoryGenerator<CoMTrajectorySegment> {
    public MultipleCoMSegmentTrajectoryGenerator(String namePrefix, YoRegistry parentRegistry) {
        this(namePrefix, 30, parentRegistry);
    }

    public MultipleCoMSegmentTrajectoryGenerator(String namePrefix, int maximumNumberOfWaypoints, YoRegistry parentRegistry) {
        super(namePrefix, maximumNumberOfWaypoints, ReferenceFrame.getWorldFrame(), CoMTrajectorySegment::new, parentRegistry);
    }

    public void appendLinearSegment(FramePoint3DReadOnly startPosition, FramePoint3DReadOnly endPosition, double omega, double startTime, double endTime) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + 1);
        CoMTrajectorySegment segment = (CoMTrajectorySegment)this.segments.add();
        this.checkReferenceFrameMatch((ReferenceFrameHolder)segment);
        segment.getTimeInterval().setInterval(startTime, endTime);
        this.checkNextSegmentIsContinuous(segment);
        segment.setOmega(omega);
        double duration = endTime - startTime;
        double rateX = (endPosition.getX() - startPosition.getX()) / duration;
        double rateY = (endPosition.getY() - startPosition.getY()) / duration;
        double rateZ = (endPosition.getZ() - startPosition.getZ()) / duration;
        segment.setFirstCoefficient(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        segment.setSecondCoefficient(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        segment.setThirdCoefficient(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        segment.setFourthCoefficient(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        segment.setFifthCoefficient(ReferenceFrame.getWorldFrame(), rateX, rateY, rateZ);
        segment.setSixthCoefficient(ReferenceFrame.getWorldFrame(), startPosition.getX(), startPosition.getY(), startPosition.getZ());
        this.numberOfSegments.increment();
    }

    public void appendSegment(TimeIntervalReadOnly timeInterval, double omega, DMatrixRMaj coefficientsArray, int startRow) {
        this.checkNumberOfSegments(this.numberOfSegments.getIntegerValue() + 1);
        CoMTrajectorySegment segment = (CoMTrajectorySegment)this.segments.add();
        this.checkReferenceFrameMatch((ReferenceFrameHolder)segment);
        segment.getTimeInterval().set(timeInterval);
        this.checkNextSegmentIsContinuous(segment);
        segment.setOmega(omega);
        segment.setCoefficients(coefficientsArray, startRow);
        this.numberOfSegments.increment();
    }
}

