/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectorySegment;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.MultipleCoMSegmentTrajectoryGenerator;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.math.trajectories.core.Polynomial3D;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DBasics;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.robotics.time.TimeIntervalBasics;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;

public class LinearCoMTrajectoryHandler {
    private final DMatrixRMaj coefficientArray = new DMatrixRMaj(0, 3);
    private final MultipleCoMSegmentTrajectoryGenerator comTrajectory;
    private final RecyclingArrayList<Polynomial3DBasics> vrpTrajectoryPool = new RecyclingArrayList(() -> new Polynomial3D(4));
    private final List<Polynomial3DReadOnly> vrpTrajectories = new ArrayList<Polynomial3DReadOnly>();
    private boolean hasTrajectory = false;
    private final FramePoint3D vrpStartPosition = new FramePoint3D();
    private final FrameVector3D vrpStartVelocity = new FrameVector3D();
    private final FramePoint3D vrpEndPosition = new FramePoint3D();
    private final FrameVector3D vrpEndVelocity = new FrameVector3D();

    public LinearCoMTrajectoryHandler(YoRegistry registry) {
        this.comTrajectory = new MultipleCoMSegmentTrajectoryGenerator("desiredComTrajectory", registry);
    }

    public void clearTrajectory() {
        this.comTrajectory.clear();
        this.vrpTrajectories.clear();
        this.vrpTrajectoryPool.clear();
        this.hasTrajectory = false;
    }

    public boolean hasTrajectory() {
        return this.hasTrajectory;
    }

    public void removeCompletedSegments(double timeToCrop) {
        while (this.comTrajectory.getCurrentNumberOfSegments() > 0 && ((CoMTrajectorySegment)this.comTrajectory.getSegment(0)).getTimeInterval().getEndTime() <= timeToCrop) {
            this.comTrajectory.removeSegment(0);
        }
        if (this.comTrajectory.getCurrentNumberOfSegments() < 1) {
            this.hasTrajectory = false;
            return;
        }
        for (int i = 0; i < this.comTrajectory.getCurrentNumberOfSegments(); ++i) {
            ((CoMTrajectorySegment)this.comTrajectory.getSegment(i)).getTimeInterval().shiftInterval(-timeToCrop);
        }
    }

    public MultipleCoMSegmentTrajectoryGenerator getComTrajectory() {
        return this.comTrajectory;
    }

    public List<Polynomial3DReadOnly> getVrpTrajectories() {
        return this.vrpTrajectories;
    }

    public void setLinear(FramePoint3DReadOnly start, FramePoint3DReadOnly end, double omega, double duration) {
        this.clearTrajectory();
        this.comTrajectory.appendLinearSegment(start, end, omega, 0.0, duration);
        this.comTrajectory.initialize();
        Polynomial3DBasics vrpTrajectory = (Polynomial3DBasics)this.vrpTrajectoryPool.add();
        vrpTrajectory.setLinear(0.0, duration, (Point3DReadOnly)start, (Point3DReadOnly)end);
        this.vrpTrajectories.add((Polynomial3DReadOnly)vrpTrajectory);
        this.hasTrajectory = true;
    }

    public void setCoefficientsFromSolution(double omega, List<? extends ContactStateProvider> contacts, DMatrix1Row xSolution, DMatrix1Row ySolution, DMatrix1Row zSolution) {
        if (xSolution.getNumCols() != 1 || ySolution.getNumCols() != 1 || zSolution.getNumCols() != 1) {
            throw new IllegalArgumentException("Solution vectors don't match in size");
        }
        if (xSolution.getNumRows() != ySolution.getNumRows() || xSolution.getNumRows() != zSolution.getNumRows()) {
            throw new IllegalArgumentException("Solution vectors don't match in size");
        }
        int numRows = xSolution.getNumRows();
        this.coefficientArray.reshape(numRows, 3);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)0, (DMatrix)xSolution, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)1, (DMatrix)ySolution, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        MatrixTools.setMatrixBlock((DMatrix)this.coefficientArray, (int)0, (int)2, (DMatrix)zSolution, (int)0, (int)0, (int)numRows, (int)1, (double)1.0);
        this.clearTrajectory();
        int startRow = 0;
        for (int i = 0; i < contacts.size(); ++i) {
            TimeIntervalBasics timeInterval = contacts.get(i).getTimeInterval();
            this.comTrajectory.appendSegment((TimeIntervalReadOnly)timeInterval, omega, this.coefficientArray, startRow);
            double duration = Math.min(timeInterval.getDuration(), 10.0);
            LinearCoMTrajectoryHandler.computeVRPBoundaryConditionsFromCoefficients(startRow, this.coefficientArray, omega, duration, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFrameVector3DBasics)this.vrpStartVelocity, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFrameVector3DBasics)this.vrpEndVelocity);
            Polynomial3DBasics vrpTrajectory = (Polynomial3DBasics)this.vrpTrajectoryPool.add();
            vrpTrajectory.setCubic(0.0, duration, (Point3DReadOnly)this.vrpStartPosition, (Vector3DReadOnly)this.vrpStartVelocity, (Point3DReadOnly)this.vrpEndPosition, (Vector3DReadOnly)this.vrpEndVelocity);
            vrpTrajectory.getTimeInterval().setInterval(0.0, timeInterval.getDuration());
            this.vrpTrajectories.add((Polynomial3DReadOnly)vrpTrajectory);
            startRow += 6;
        }
        this.comTrajectory.initialize();
        this.hasTrajectory = true;
    }

    private static void computeVRPBoundaryConditionsFromCoefficients(int startRow, DMatrixRMaj coefficientArray, double omega, double duration, FixedFramePoint3DBasics startPosition, FixedFrameVector3DBasics startVelocity, FixedFramePoint3DBasics endPosition, FixedFrameVector3DBasics endVelocity) {
        startPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        startVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endPosition.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        endVelocity.checkReferenceFrameMatch(ReferenceFrame.getWorldFrame());
        double omega2 = omega * omega;
        double t2 = duration * duration;
        double t3 = duration * t2;
        for (Axis3D axis : Axis3D.values) {
            int element = axis.ordinal();
            double startPositionElement = coefficientArray.get(startRow + 5, element) - 2.0 / omega2 * coefficientArray.get(startRow + 3, element);
            double startVelocityElement = coefficientArray.get(startRow + 4, element) - 6.0 / omega2 * coefficientArray.get(startRow + 2, element);
            startPosition.setElement(element, startPositionElement);
            startVelocity.setElement(element, startVelocityElement);
            double endPositionElement = coefficientArray.get(startRow + 2, element) * t3 + coefficientArray.get(startRow + 3, element) * t2 + startVelocityElement * duration + startPositionElement;
            double endVelocityElement = 3.0 * coefficientArray.get(startRow + 2, element) * t2 + 2.0 * coefficientArray.get(startRow + 3, element) * duration + startVelocityElement;
            endPosition.setElement(element, endPositionElement);
            endVelocity.setElement(element, endVelocityElement);
        }
    }

    public void computeCoMPosition(int segment, double timeInSegment, FixedFramePoint3DBasics comPositionToPack) {
        ((CoMTrajectorySegment)this.comTrajectory.getSegment(segment)).computeCoMPosition(timeInSegment, comPositionToPack);
    }

    public void computeCoMVelocity(int segment, double timeInSegment, FixedFrameVector3DBasics comVelocityToPack) {
        ((CoMTrajectorySegment)this.comTrajectory.getSegment(segment)).computeCoMVelocity(timeInSegment, comVelocityToPack);
    }

    public void computeCoMAcceleration(int segment, double timeInSegment, FixedFrameVector3DBasics comAccelerationToPack) {
        ((CoMTrajectorySegment)this.comTrajectory.getSegment(segment)).computeCoMAcceleration(timeInSegment, comAccelerationToPack);
    }

    public void computeVRPVelocity(int segment, double timeInSegment, FixedFrameVector3DBasics vrpVelocityToPack) {
        ((CoMTrajectorySegment)this.comTrajectory.getSegment(segment)).computeVRPVelocity(timeInSegment, vrpVelocityToPack);
    }

    public void compute(int segment, double timeInSegment, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFrameVector3DBasics vrpVelocityToPack) {
        ((CoMTrajectorySegment)this.comTrajectory.getSegment(segment)).compute(timeInSegment, comPositionToPack, comVelocityToPack, comAccelerationToPack, dcmPositionToPack, dcmVelocityToPack, vrpPositionToPack, vrpVelocityToPack);
    }
}

