/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CornerPointViewer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double size = 0.005;
    private static final int maxPoints = 20;
    private final List<YoFramePoint3D> dcmCornerPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> comCornerPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> vrpStartPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> vrpEndPoints = new ArrayList<YoFramePoint3D>();
    private static final String name = "Corner Points";

    public CornerPointViewer(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this(false, true, registry, yoGraphicsListRegistry);
    }

    public CornerPointViewer(boolean artifactsOnly, boolean viewCoM, YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        for (int i = 0; i < 20; ++i) {
            YoFramePoint3D dcmCornerPoint = new YoFramePoint3D("dcmCornerPoint" + i, worldFrame, registry);
            YoFramePoint3D vrpStartPoint = new YoFramePoint3D("vrpStartPoint" + i, worldFrame, registry);
            YoFramePoint3D vrpEndPoint = new YoFramePoint3D("vrpEndPoint" + i, worldFrame, registry);
            dcmCornerPoint.setToNaN();
            vrpStartPoint.setToNaN();
            vrpEndPoint.setToNaN();
            this.dcmCornerPoints.add(dcmCornerPoint);
            this.vrpStartPoints.add(vrpStartPoint);
            this.vrpEndPoints.add(vrpEndPoint);
            YoGraphicPosition dcmCornerPointGraphic = new YoGraphicPosition("dcmCornerPoint" + i, dcmCornerPoint, 0.005, YoAppearance.Blue(), YoGraphicPosition.GraphicType.BALL_WITH_CROSS);
            YoGraphicPosition vrpStartPointGraphic = new YoGraphicPosition("vrpStartPoint" + i, vrpStartPoint, 0.005, YoAppearance.Green(), YoGraphicPosition.GraphicType.BALL);
            YoGraphicPosition vrpEndPointGraphic = new YoGraphicPosition("vrpEndPoint" + i, vrpEndPoint, 0.005, YoAppearance.Green(), YoGraphicPosition.GraphicType.SOLID_BALL);
            if (viewCoM) {
                YoFramePoint3D comCornerPoint = new YoFramePoint3D("comCornerPoint" + i, worldFrame, registry);
                comCornerPoint.setToNaN();
                this.comCornerPoints.add(comCornerPoint);
                YoGraphicPosition comCornerPointGraphic = new YoGraphicPosition("comCornerPoint" + i, comCornerPoint, 0.005, YoAppearance.Black(), YoGraphicPosition.GraphicType.SOLID_BALL);
                yoGraphicsListRegistry.registerArtifact(name, (Artifact)comCornerPointGraphic.createArtifact());
                if (!artifactsOnly) {
                    yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)comCornerPointGraphic);
                }
            }
            if (!artifactsOnly) {
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)dcmCornerPointGraphic);
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)vrpStartPointGraphic);
                yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)vrpEndPointGraphic);
            }
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)dcmCornerPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)vrpStartPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)vrpEndPointGraphic.createArtifact());
        }
    }

    public void updateDCMCornerPoints(List<FramePoint3D> dcmCornerPoints) {
        int i;
        int size = Math.min(dcmCornerPoints.size(), this.dcmCornerPoints.size());
        for (i = 0; i < size; ++i) {
            this.dcmCornerPoints.get(i).set((FrameTuple3DReadOnly)dcmCornerPoints.get(i));
        }
        while (i < this.dcmCornerPoints.size()) {
            this.dcmCornerPoints.get(i).setToNaN();
            ++i;
        }
    }

    public void updateCoMCornerPoints(List<FramePoint3D> comCornerPoints) {
        int i;
        int size = Math.min(comCornerPoints.size(), this.comCornerPoints.size());
        for (i = 0; i < size; ++i) {
            this.comCornerPoints.get(i).set((FrameTuple3DReadOnly)comCornerPoints.get(i));
        }
        while (i < this.comCornerPoints.size()) {
            this.comCornerPoints.get(i).setToNaN();
            ++i;
        }
    }

    public void updateVRPWaypoints(List<LineSegment3D> vrpSegments) {
        int i;
        int size = Math.min(vrpSegments.size(), this.vrpStartPoints.size());
        for (i = 0; i < size; ++i) {
            this.vrpStartPoints.get(i).set((Tuple3DReadOnly)vrpSegments.get(i).getFirstEndpoint());
            this.vrpEndPoints.get(i).set((Tuple3DReadOnly)vrpSegments.get(i).getSecondEndpoint());
        }
        while (i < this.vrpStartPoints.size()) {
            this.vrpStartPoints.get(i).setToNaN();
            this.vrpEndPoints.get(i).setToNaN();
            ++i;
        }
    }
}

