/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoPWaypointCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.TimedContactInterval;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.time.TimeIntervalReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ContactSequenceCalculator<T extends TimedContactInterval> {
    private final CoPWaypointCalculator<T> copWaypointCalculator;
    private final RecyclingArrayList<SettableContactStateProvider> contactStates = new RecyclingArrayList(SettableContactStateProvider::new);
    private final LineSegment2D tempLine = new LineSegment2D();
    private final YoDouble startTime;
    private final YoFramePoint3D initialCoPPosition;
    private final FramePoint3D initialCoPWaypoint = new FramePoint3D();
    private final FramePoint2D initialCoPWaypoint2D = new FramePoint2D();
    private final Point2D waypoint = new Point2D();
    private final FramePoint3D tempCoPWaypoint = new FramePoint3D();
    private final FramePoint3D tempPreviousCoPWaypoint = new FramePoint3D();

    public ContactSequenceCalculator(CoPWaypointCalculator<T> copWaypointCalculator, YoRegistry registry) {
        this.copWaypointCalculator = copWaypointCalculator;
        this.startTime = new YoDouble("contactSequenceStartTime", registry);
        this.initialCoPPosition = new YoFramePoint3D("initialCoPPosition", ReferenceFrame.getWorldFrame(), registry);
    }

    public List<? extends ContactStateProvider> compute(List<T> timedContactPhases) {
        this.contactStates.clear();
        TimedContactInterval initialPhase = (TimedContactInterval)timedContactPhases.get(0);
        if (ContactSequenceCalculator.isPhaseInContact(timedContactPhases, 0)) {
            if (this.startTime.getDoubleValue() < initialPhase.getTimeInterval().getStartTime()) {
                SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStates.add();
                contactStateProvider.reset();
                contactStateProvider.setStartECMPPosition((FramePoint3DReadOnly)this.initialCoPPosition);
                contactStateProvider.getTimeInterval().setInterval(this.startTime.getDoubleValue(), initialPhase.getTimeInterval().getStartTime());
                contactStateProvider.setContactState(ContactSequenceCalculator.getContactState(initialPhase));
                this.copWaypointCalculator.computeCoPWaypoint((FixedFramePoint3DBasics)this.initialCoPWaypoint, initialPhase);
                contactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)this.initialCoPWaypoint);
                contactStateProvider.setLinearECMPVelocity();
            } else {
                this.initialCoPWaypoint.set((FrameTuple3DReadOnly)this.initialCoPPosition);
            }
        } else {
            this.initialCoPWaypoint.setToNaN();
        }
        this.initialCoPWaypoint2D.set((FrameTuple3DReadOnly)this.initialCoPWaypoint);
        ConvexPolygon2DReadOnly initialPolygon = initialPhase.getSupportPolygon();
        if (!initialPolygon.isPointInside((Point2DReadOnly)this.initialCoPWaypoint2D)) {
            initialPolygon.orthogonalProjection((Point2DBasics)this.initialCoPWaypoint2D);
        }
        this.initialCoPWaypoint.set((FrameTuple2DReadOnly)this.initialCoPWaypoint2D);
        SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStates.add();
        contactStateProvider.reset();
        contactStateProvider.setStartECMPPosition((FramePoint3DReadOnly)this.initialCoPWaypoint);
        contactStateProvider.setTimeInterval((TimeIntervalReadOnly)initialPhase.getTimeInterval());
        contactStateProvider.setContactState(ContactSequenceCalculator.getContactState(initialPhase));
        for (int i = 1; i < timedContactPhases.size(); ++i) {
            this.addComputedCoP(timedContactPhases, i);
        }
        TimedContactInterval finalPhase = (TimedContactInterval)timedContactPhases.get(timedContactPhases.size() - 1);
        SettableContactStateProvider finalContact = (SettableContactStateProvider)this.contactStates.getLast();
        this.copWaypointCalculator.computeCoPWaypoint((FixedFramePoint3DBasics)this.initialCoPWaypoint, finalPhase);
        finalContact.setEndECMPPosition((FramePoint3DReadOnly)this.initialCoPWaypoint);
        finalContact.setLinearECMPVelocity();
        finalContact.setContactState(ContactSequenceCalculator.getContactState(finalPhase));
        return this.contactStates;
    }

    public void setInitialCoP(double startTime, FramePoint3DReadOnly initialCoPPosition) {
        this.startTime.set(startTime);
        this.initialCoPPosition.set((FrameTuple3DReadOnly)initialCoPPosition);
    }

    private void addComputedCoP(List<T> timedContactPhases, int contactIndex) {
        TimedContactInterval previousContact = (TimedContactInterval)timedContactPhases.get(contactIndex - 1);
        TimedContactInterval contact = (TimedContactInterval)timedContactPhases.get(contactIndex);
        ConvexPolygon2DReadOnly previousPolygon = previousContact.getSupportPolygon();
        SettableContactStateProvider previousContactPhase = (SettableContactStateProvider)this.contactStates.getLast();
        SettableContactStateProvider contactPhase = (SettableContactStateProvider)this.contactStates.add();
        contactPhase.reset();
        contactPhase.setTimeInterval((TimeIntervalReadOnly)contact.getTimeInterval());
        contactPhase.setContactState(ContactSequenceCalculator.getContactState(contact));
        this.copWaypointCalculator.computeCoPWaypoint((FixedFramePoint3DBasics)this.tempCoPWaypoint, contact);
        this.waypoint.set((Tuple3DReadOnly)this.tempCoPWaypoint);
        boolean previousPhaseInContact = ContactSequenceCalculator.isPhaseInContact(timedContactPhases, contactIndex - 1);
        boolean currentPhaseInContact = ContactSequenceCalculator.isPhaseInContact(timedContactPhases, contactIndex);
        if (previousPhaseInContact && currentPhaseInContact && !previousPolygon.isPointInside((Point2DReadOnly)this.waypoint)) {
            this.tempLine.set(previousPolygon.getCentroid(), (Point2DReadOnly)this.waypoint);
            previousPolygon.intersectionWith((LineSegment2DReadOnly)this.tempLine, (Point2DBasics)this.waypoint, (Point2DBasics)this.waypoint);
        }
        this.tempCoPWaypoint.set((Tuple2DReadOnly)this.waypoint);
        if (currentPhaseInContact) {
            previousContactPhase.setEndECMPPosition((FramePoint3DReadOnly)this.tempCoPWaypoint);
        } else {
            this.copWaypointCalculator.computeCoPWaypoint((FixedFramePoint3DBasics)this.tempPreviousCoPWaypoint, previousContact);
            previousContactPhase.setEndECMPPosition((FramePoint3DReadOnly)this.tempPreviousCoPWaypoint);
        }
        previousContactPhase.setLinearECMPVelocity();
        if (previousContactPhase.getECMPStartPosition().containsNaN()) {
            previousContactPhase.setStartECMPPosition(previousContactPhase.getECMPEndPosition());
        }
        contactPhase.setStartECMPPosition((FramePoint3DReadOnly)this.tempCoPWaypoint);
        if (!ContactSequenceCalculator.peekIsNextPhaseInContact(timedContactPhases, contactIndex)) {
            contactPhase.setEndECMPPosition((FramePoint3DReadOnly)this.tempCoPWaypoint);
            contactPhase.setLinearECMPVelocity();
        }
    }

    private static <T extends TimedContactInterval> boolean isPhaseInContact(List<T> timedContactPhases, int contactPhases) {
        return ContactSequenceCalculator.isPhaseInContact((TimedContactInterval)timedContactPhases.get(contactPhases));
    }

    private static <T extends TimedContactInterval> ContactState getContactState(T phase) {
        return ContactSequenceCalculator.isPhaseInContact(phase) ? ContactState.IN_CONTACT : ContactState.FLIGHT;
    }

    private static <T extends TimedContactInterval> boolean isPhaseInContact(T contactPhase) {
        return !contactPhase.getSupportPolygon().isEmpty();
    }

    private static <T extends TimedContactInterval> boolean peekIsNextPhaseInContact(List<T> timedContactPhases, int contactIndex) {
        if (timedContactPhases.size() > contactIndex + 1) {
            return ContactSequenceCalculator.isPhaseInContact(timedContactPhases, contactIndex + 1);
        }
        return true;
    }
}

