/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import gnu.trove.map.hash.TIntIntHashMap;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;

public class CoMTrajectoryPlannerIndexHandler {
    public static final int polynomialCoefficientsPerSegment = 6;
    private static final int vrpConstraintsPerSegment = 4;
    private int totalNumberOfCoefficients;
    private int numberOfVRPWaypoints;
    private final TIntIntHashMap vrpWaypointIndices = new TIntIntHashMap();

    public void update(List<? extends ContactStateProvider> contactSequence) {
        this.vrpWaypointIndices.clear();
        this.totalNumberOfCoefficients = 0;
        this.numberOfVRPWaypoints = 0;
        if (contactSequence.get(0).getContactState() == ContactState.IN_CONTACT) {
            this.vrpWaypointIndices.put(0, this.numberOfVRPWaypoints);
            this.numberOfVRPWaypoints += 4;
        }
        this.totalNumberOfCoefficients += 6;
        for (int sequenceId = 1; sequenceId < contactSequence.size(); ++sequenceId) {
            if (contactSequence.get(sequenceId).getContactState() == ContactState.IN_CONTACT) {
                this.vrpWaypointIndices.put(sequenceId, this.numberOfVRPWaypoints);
                this.numberOfVRPWaypoints += 4;
            }
            this.totalNumberOfCoefficients += 6;
        }
    }

    public int getTotalNumberOfCoefficients() {
        return this.totalNumberOfCoefficients;
    }

    public int getNumberOfVRPWaypoints() {
        return this.numberOfVRPWaypoints;
    }

    public int getContactSequenceStartIndex(int sequenceNumber) {
        return 6 * sequenceNumber;
    }

    public int getVRPWaypointStartPositionIndex(int sequenceNumber) {
        return this.vrpWaypointIndices.get(sequenceNumber);
    }

    public int getVRPWaypointStartVelocityIndex(int sequenceNumber) {
        return this.vrpWaypointIndices.get(sequenceNumber) + 1;
    }

    public int getVRPWaypointFinalPositionIndex(int sequenceNumber) {
        return this.vrpWaypointIndices.get(sequenceNumber) + 2;
    }

    public int getVRPWaypointFinalVelocityIndex(int sequenceNumber) {
        return this.vrpWaypointIndices.get(sequenceNumber) + 3;
    }
}

