/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMContinuityCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerIndexHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProviderTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CornerPointViewer;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.LinearCoMTrajectoryHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.MultipleCoMSegmentTrajectoryGenerator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.math.trajectories.interfaces.Polynomial3DReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class CoMTrajectoryPlanner
implements CoMTrajectoryProvider {
    private static boolean verbose = false;
    private static final int maxCapacity = 10;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final DMatrixSparseCSC coefficientMultipliersSparse = new DMatrixSparseCSC(0, 0);
    private final DMatrixRMaj xEquivalents = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj yEquivalents = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj zEquivalents = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj xConstants = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj yConstants = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj zConstants = new DMatrixRMaj(0, 1);
    private final DMatrixSparseCSC vrpWaypointJacobian = new DMatrixSparseCSC(0, 1);
    private final DMatrixRMaj vrpXWaypoints = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj vrpYWaypoints = new DMatrixRMaj(0, 1);
    private final DMatrixRMaj vrpZWaypoints = new DMatrixRMaj(0, 1);
    private final LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> sparseSolver = LinearSolverFactory_DSCC.lu((FillReducing)FillReducing.NONE);
    final DMatrixRMaj xCoefficientVector = new DMatrixRMaj(0, 1);
    final DMatrixRMaj yCoefficientVector = new DMatrixRMaj(0, 1);
    final DMatrixRMaj zCoefficientVector = new DMatrixRMaj(0, 1);
    private final DoubleProvider omega;
    private final YoDouble comHeight = new YoDouble("comHeightForPlanning", this.registry);
    private final double gravityZ;
    private final CoMTrajectoryPlannerIndexHandler indexHandler = new CoMTrajectoryPlannerIndexHandler();
    private final LinearCoMTrajectoryHandler trajectoryHandler = new LinearCoMTrajectoryHandler(this.registry);
    private final FixedFramePoint3DBasics desiredCoMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMVelocity = new FrameVector3D(worldFrame);
    private final FixedFrameVector3DBasics desiredCoMAcceleration = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredDCMPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredDCMVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredVRPPosition = new FramePoint3D(worldFrame);
    private final FixedFrameVector3DBasics desiredVRPVelocity = new FrameVector3D(worldFrame);
    private final FixedFramePoint3DBasics desiredECMPPosition = new FramePoint3D(worldFrame);
    private final RecyclingArrayList<FramePoint3D> startVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> endVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final YoFramePoint3D finalDCMPosition = new YoFramePoint3D("goalDCMPosition", worldFrame, this.registry);
    private final YoFramePoint3D currentCoMPosition = new YoFramePoint3D("currentCoMPosition", worldFrame, this.registry);
    private final YoFrameVector3D currentCoMVelocity = new YoFrameVector3D("currentCoMVelocity", worldFrame, this.registry);
    private final RecyclingArrayList<FramePoint3D> dcmCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> comCornerPoints = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<LineSegment3D> vrpSegments = new RecyclingArrayList(LineSegment3D::new);
    private int numberOfConstraints = 0;
    private final YoBoolean maintainInitialCoMVelocityContinuity = new YoBoolean("maintainInitialComVelocityContinuity", this.registry);
    private CornerPointViewer viewer = null;
    private BagOfBalls comTrajectoryViewer = null;
    private CoMContinuityCalculator comContinuityCalculator = null;
    private final FramePoint3D comPositionToThrowAway = new FramePoint3D();
    private final FramePoint3D dcmPositionToThrowAway = new FramePoint3D();
    private final FrameVector3D comVelocityToThrowAway = new FrameVector3D();
    private final FrameVector3D comAccelerationToThrowAway = new FrameVector3D();
    private final FrameVector3D dcmVelocityToThrowAway = new FrameVector3D();
    private final FramePoint3D vrpStartPosition = new FramePoint3D();
    private final FramePoint3D vrpEndPosition = new FramePoint3D();
    private final FramePoint3D ecmpPositionToThrowAway = new FramePoint3D();

    public CoMTrajectoryPlanner(double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry) {
        this.gravityZ = Math.abs(gravityZ);
        YoDouble omega = new YoDouble("omegaForPlanning", this.registry);
        this.comHeight.addListener(v -> omega.set(Math.sqrt(Math.abs(gravityZ) / this.comHeight.getDoubleValue())));
        this.comHeight.set(nominalCoMHeight);
        this.omega = omega;
        this.maintainInitialCoMVelocityContinuity.set(false);
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public CoMTrajectoryPlanner(double gravityZ, YoDouble omega, YoRegistry parentRegistry) {
        this.omega = omega;
        this.gravityZ = Math.abs(gravityZ);
        omega.addListener(v -> this.comHeight.set(gravityZ / MathTools.square((double)omega.getValue())));
        omega.notifyListeners();
        this.maintainInitialCoMVelocityContinuity.set(false);
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
    }

    public void setMaintainInitialCoMVelocityContinuity(boolean maintainInitialCoMVelocityContinuity) {
        this.maintainInitialCoMVelocityContinuity.set(maintainInitialCoMVelocityContinuity);
    }

    public void setCornerPointViewer(CornerPointViewer viewer) {
        this.viewer = viewer;
    }

    public void setupCoMTrajectoryViewer(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.comTrajectoryViewer = new BagOfBalls(50, 0.01, YoAppearance.Black(), this.registry, yoGraphicsListRegistry);
    }

    public void setComContinuityCalculator(CoMContinuityCalculator comContinuityCalculator) {
        this.comContinuityCalculator = comContinuityCalculator;
    }

    public void reset() {
        this.trajectoryHandler.clearTrajectory();
    }

    public void initializeTrajectory(FramePoint3DReadOnly endPosition, double stepDuration) {
        stepDuration = Math.min(10.0, stepDuration);
        this.trajectoryHandler.setLinear((FramePoint3DReadOnly)this.currentCoMPosition, endPosition, this.omega.getValue(), stepDuration);
    }

    @Override
    public void setNominalCoMHeight(double nominalCoMHeight) {
        this.comHeight.set(nominalCoMHeight);
    }

    @Override
    public double getNominalCoMHeight() {
        return this.comHeight.getDoubleValue();
    }

    public double getOmega() {
        return this.omega.getValue();
    }

    @Override
    public void solveForTrajectory(List<? extends ContactStateProvider> contactSequence) {
        if (!ContactStateProviderTools.checkContactSequenceIsValid(contactSequence)) {
            throw new IllegalArgumentException("The contact sequence is not valid.");
        }
        this.indexHandler.update(contactSequence);
        this.resetMatrices();
        CoMTrajectoryPlannerTools.computeVRPWaypoints(this.comHeight.getDoubleValue(), this.gravityZ, this.omega.getValue(), (FrameVector3DReadOnly)this.currentCoMVelocity, contactSequence, this.startVRPPositions, this.endVRPPositions, true);
        this.solveForCoefficientConstraintMatrix(contactSequence);
        this.trajectoryHandler.setCoefficientsFromSolution(this.omega.getValue(), contactSequence, (DMatrix1Row)this.xCoefficientVector, (DMatrix1Row)this.yCoefficientVector, (DMatrix1Row)this.zCoefficientVector);
        if (this.maintainInitialCoMVelocityContinuity.getBooleanValue() && this.comContinuityCalculator != null) {
            int segmentId = this.comContinuityCalculator.getDepthForCalculation() - 1;
            double time = contactSequence.get(segmentId).getTimeInterval().getDuration();
            this.compute(segmentId, time, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.comContinuityCalculator.setInitialCoMPosition((FramePoint3DReadOnly)this.currentCoMPosition);
            this.comContinuityCalculator.setInitialCoMVelocity((FrameVector3DReadOnly)this.currentCoMVelocity);
            this.comContinuityCalculator.setFinalICPToAchieve((FramePoint3DReadOnly)this.dcmPositionToThrowAway);
            if (this.comContinuityCalculator.solve(contactSequence)) {
                this.comContinuityCalculator.getXCoefficientOverrides((DMatrix)this.xCoefficientVector);
                this.comContinuityCalculator.getYCoefficientOverrides((DMatrix)this.yCoefficientVector);
                this.comContinuityCalculator.getZCoefficientOverrides((DMatrix)this.zCoefficientVector);
            }
        }
        this.trajectoryHandler.setCoefficientsFromSolution(this.omega.getValue(), contactSequence, (DMatrix1Row)this.xCoefficientVector, (DMatrix1Row)this.yCoefficientVector, (DMatrix1Row)this.zCoefficientVector);
        this.updateCornerPoints(contactSequence);
        if (this.viewer != null) {
            this.viewer.updateDCMCornerPoints((List<FramePoint3D>)this.dcmCornerPoints);
            this.viewer.updateCoMCornerPoints((List<FramePoint3D>)this.comCornerPoints);
            this.viewer.updateVRPWaypoints((List<LineSegment3D>)this.vrpSegments);
        }
        if (this.comTrajectoryViewer != null) {
            this.updateCoMTrajectoryViewer();
        }
    }

    private void solveForCoefficientConstraintMatrix(List<? extends ContactStateProvider> contactSequence) {
        int numberOfPhases = contactSequence.size();
        int numberOfTransitions = numberOfPhases - 1;
        this.numberOfConstraints = 0;
        this.setCoMPositionConstraint((FramePoint3DReadOnly)this.currentCoMPosition);
        this.setDynamicsInitialConstraint(contactSequence, 0);
        for (int transition = 0; transition < numberOfTransitions; ++transition) {
            int previousSequence = transition;
            int nextSequence = transition + 1;
            this.setCoMPositionContinuity(contactSequence, previousSequence, nextSequence);
            this.setCoMVelocityContinuity(contactSequence, previousSequence, nextSequence);
            this.setDynamicsFinalConstraint(contactSequence, previousSequence);
            this.setDynamicsInitialConstraint(contactSequence, nextSequence);
        }
        ContactStateProvider lastContactPhase = contactSequence.get(numberOfPhases - 1);
        this.finalDCMPosition.set((FrameTuple3DReadOnly)this.endVRPPositions.getLast());
        double finalDuration = lastContactPhase.getTimeInterval().getDuration();
        this.setDCMPositionConstraint(numberOfPhases - 1, finalDuration, (FramePoint3DReadOnly)this.finalDCMPosition);
        this.setDynamicsFinalConstraint(contactSequence, numberOfPhases - 1);
        this.sparseSolver.setA((Matrix)this.coefficientMultipliersSparse);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixRMaj)this.vrpXWaypoints, (DMatrixRMaj)this.xEquivalents);
        CommonOps_DDRM.addEquals((DMatrixD1)this.xEquivalents, (DMatrixD1)this.xConstants);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixRMaj)this.vrpYWaypoints, (DMatrixRMaj)this.yEquivalents);
        CommonOps_DDRM.addEquals((DMatrixD1)this.yEquivalents, (DMatrixD1)this.yConstants);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixRMaj)this.vrpZWaypoints, (DMatrixRMaj)this.zEquivalents);
        CommonOps_DDRM.addEquals((DMatrixD1)this.zEquivalents, (DMatrixD1)this.zConstants);
        this.sparseSolver.solve((Matrix)this.xEquivalents, (Matrix)this.xCoefficientVector);
        this.sparseSolver.solve((Matrix)this.yEquivalents, (Matrix)this.yCoefficientVector);
        this.sparseSolver.solve((Matrix)this.zEquivalents, (Matrix)this.zCoefficientVector);
    }

    private void updateCornerPoints(List<? extends ContactStateProvider> contactSequence) {
        this.comCornerPoints.clear();
        this.dcmCornerPoints.clear();
        this.vrpSegments.clear();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int segmentId = 0; segmentId < Math.min(contactSequence.size(), 11); ++segmentId) {
            double duration = contactSequence.get(segmentId).getTimeInterval().getDuration();
            this.compute(segmentId, 0.0, (FixedFramePoint3DBasics)this.comCornerPoints.add(), (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmCornerPoints.add(), (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.compute(segmentId, duration, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpEndPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            ((LineSegment3D)this.vrpSegments.add()).set((Point3DReadOnly)this.vrpStartPosition, (Point3DReadOnly)this.vrpEndPosition);
        }
        verbose = verboseBefore;
    }

    @Override
    public void compute(int segmentId, double timeInPhase) {
        this.compute(segmentId, timeInPhase, this.desiredCoMPosition, this.desiredCoMVelocity, this.desiredCoMAcceleration, this.desiredDCMPosition, this.desiredDCMVelocity, this.desiredVRPPosition, this.desiredECMPPosition);
        if (verbose) {
            LogTools.info((String)("At time " + timeInPhase + ", Desired DCM = " + this.desiredDCMPosition + ", Desired CoM = " + this.desiredCoMPosition));
        }
    }

    @Override
    public void compute(int segmentId, double timeInPhase, FixedFramePoint3DBasics comPositionToPack, FixedFrameVector3DBasics comVelocityToPack, FixedFrameVector3DBasics comAccelerationToPack, FixedFramePoint3DBasics dcmPositionToPack, FixedFrameVector3DBasics dcmVelocityToPack, FixedFramePoint3DBasics vrpPositionToPack, FixedFramePoint3DBasics ecmpPositionToPack) {
        if (segmentId < 0) {
            throw new IllegalArgumentException("time is invalid.");
        }
        this.trajectoryHandler.compute(segmentId, timeInPhase, comPositionToPack, comVelocityToPack, comAccelerationToPack, dcmPositionToPack, dcmVelocityToPack, vrpPositionToPack, this.desiredVRPVelocity);
        ecmpPositionToPack.set((FrameTuple3DReadOnly)vrpPositionToPack);
        ecmpPositionToPack.subZ(this.comHeight.getDoubleValue());
    }

    @Override
    public void setInitialCenterOfMassState(FramePoint3DReadOnly centerOfMassPosition, FrameVector3DReadOnly centerOfMassVelocity) {
        this.currentCoMPosition.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassPosition);
        this.currentCoMVelocity.setMatchingFrame((FrameTuple3DReadOnly)centerOfMassVelocity);
    }

    @Override
    public FramePoint3DReadOnly getDesiredDCMPosition() {
        return this.desiredDCMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredDCMVelocity() {
        return this.desiredDCMVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredCoMPosition() {
        return this.desiredCoMPosition;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMVelocity() {
        return this.desiredCoMVelocity;
    }

    @Override
    public FrameVector3DReadOnly getDesiredCoMAcceleration() {
        return this.desiredCoMAcceleration;
    }

    @Override
    public FramePoint3DReadOnly getDesiredVRPPosition() {
        return this.desiredVRPPosition;
    }

    public FrameVector3DReadOnly getDesiredVRPVelocity() {
        return this.desiredVRPVelocity;
    }

    @Override
    public FramePoint3DReadOnly getDesiredECMPPosition() {
        return this.desiredECMPPosition;
    }

    private void updateCoMTrajectoryViewer() {
        this.comTrajectoryViewer.reset();
        boolean verboseBefore = verbose;
        verbose = false;
        for (int i = 0; i < this.comTrajectoryViewer.getNumberOfBalls(); ++i) {
            double time = 0.05 * (double)i;
            int segmentId = this.getSegmentNumber(time);
            double timeInSegment = this.getTimeInSegment(segmentId, time);
            this.compute(segmentId, timeInSegment, (FixedFramePoint3DBasics)this.comPositionToThrowAway, (FixedFrameVector3DBasics)this.comVelocityToThrowAway, (FixedFrameVector3DBasics)this.comAccelerationToThrowAway, (FixedFramePoint3DBasics)this.dcmPositionToThrowAway, (FixedFrameVector3DBasics)this.dcmVelocityToThrowAway, (FixedFramePoint3DBasics)this.vrpStartPosition, (FixedFramePoint3DBasics)this.ecmpPositionToThrowAway);
            this.comTrajectoryViewer.setBall((FramePoint3DReadOnly)this.comPositionToThrowAway);
        }
        verbose = verboseBefore;
    }

    private void resetMatrices() {
        int size = this.indexHandler.getTotalNumberOfCoefficients();
        int numberOfVRPWaypoints = this.indexHandler.getNumberOfVRPWaypoints();
        this.coefficientMultipliersSparse.reshape(size, size);
        this.xEquivalents.reshape(size, 1);
        this.yEquivalents.reshape(size, 1);
        this.zEquivalents.reshape(size, 1);
        this.xConstants.reshape(size, 1);
        this.yConstants.reshape(size, 1);
        this.zConstants.reshape(size, 1);
        this.vrpWaypointJacobian.reshape(size, numberOfVRPWaypoints);
        this.vrpXWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpYWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpZWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.xCoefficientVector.reshape(size, 1);
        this.yCoefficientVector.reshape(size, 1);
        this.zCoefficientVector.reshape(size, 1);
        this.coefficientMultipliersSparse.zero();
        this.xEquivalents.zero();
        this.yEquivalents.zero();
        this.zEquivalents.zero();
        this.xConstants.zero();
        this.yConstants.zero();
        this.zConstants.zero();
        this.vrpWaypointJacobian.zero();
        this.vrpXWaypoints.zero();
        this.vrpYWaypoints.zero();
        this.vrpZWaypoints.zero();
    }

    private void setCoMPositionConstraint(FramePoint3DReadOnly centerOfMassLocationForConstraint) {
        CoMTrajectoryPlannerTools.addCoMPositionConstraint(centerOfMassLocationForConstraint, this.omega.getValue(), 0.0, 0, this.numberOfConstraints, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void setDCMPositionConstraint(int sequenceId, double time, FramePoint3DReadOnly desiredDCMPosition) {
        CoMTrajectoryPlannerTools.addDCMPositionConstraint(sequenceId, this.numberOfConstraints, time, this.omega.getValue(), desiredDCMPosition, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void setCoMPositionContinuity(List<? extends ContactStateProvider> contactSequence, int previousSequence, int nextSequence) {
        double previousDuration = contactSequence.get(previousSequence).getTimeInterval().getDuration();
        CoMTrajectoryPlannerTools.addCoMPositionContinuityConstraint(previousSequence, nextSequence, this.numberOfConstraints, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientMultipliersSparse);
        ++this.numberOfConstraints;
    }

    private void setCoMVelocityContinuity(List<? extends ContactStateProvider> contactSequence, int previousSequence, int nextSequence) {
        double previousDuration = contactSequence.get(previousSequence).getTimeInterval().getDuration();
        CoMTrajectoryPlannerTools.addCoMVelocityContinuityConstraint(previousSequence, nextSequence, this.numberOfConstraints, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientMultipliersSparse);
        ++this.numberOfConstraints;
    }

    private void setDynamicsInitialConstraint(List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        if (contactState.isLoadBearing()) {
            this.constrainVRPPosition(sequenceId, this.indexHandler.getVRPWaypointStartPositionIndex(sequenceId), 0.0, (FramePoint3DReadOnly)this.startVRPPositions.get(sequenceId));
            this.constrainVRPVelocity(sequenceId, this.indexHandler.getVRPWaypointStartVelocityIndex(sequenceId), 0.0, contactSequence.get(sequenceId).getECMPStartVelocity());
        } else {
            this.constrainCoMAccelerationToGravity(sequenceId, 0.0);
            this.constrainCoMJerkToZero(sequenceId, 0.0);
        }
    }

    private void setDynamicsFinalConstraint(List<? extends ContactStateProvider> contactSequence, int sequenceId) {
        ContactStateProvider contactStateProvider = contactSequence.get(sequenceId);
        ContactState contactState = contactStateProvider.getContactState();
        double duration = contactStateProvider.getTimeInterval().getDuration();
        if (contactState.isLoadBearing()) {
            this.constrainVRPPosition(sequenceId, this.indexHandler.getVRPWaypointFinalPositionIndex(sequenceId), duration, (FramePoint3DReadOnly)this.endVRPPositions.get(sequenceId));
            this.constrainVRPVelocity(sequenceId, this.indexHandler.getVRPWaypointFinalVelocityIndex(sequenceId), duration, contactSequence.get(sequenceId).getECMPEndVelocity());
        } else {
            this.constrainCoMAccelerationToGravity(sequenceId, duration);
            this.constrainCoMJerkToZero(sequenceId, duration);
        }
    }

    private void constrainVRPPosition(int sequenceId, int vrpWaypointPositionIndex, double time, FramePoint3DReadOnly desiredVRPPosition) {
        CoMTrajectoryPlannerTools.addVRPPositionConstraint(sequenceId, this.numberOfConstraints, vrpWaypointPositionIndex, time, this.omega.getValue(), desiredVRPPosition, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
        ++this.numberOfConstraints;
    }

    private void constrainVRPVelocity(int sequenceId, int vrpWaypointVelocityIndex, double time, FrameVector3DReadOnly desiredVRPVelocity) {
        CoMTrajectoryPlannerTools.addVRPVelocityConstraint(sequenceId, this.numberOfConstraints, vrpWaypointVelocityIndex, this.omega.getValue(), time, desiredVRPVelocity, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
        ++this.numberOfConstraints;
    }

    private void constrainCoMAccelerationToGravity(int sequenceId, double time) {
        CoMTrajectoryPlannerTools.constrainCoMAccelerationToGravity(sequenceId, this.numberOfConstraints, this.omega.getValue(), time, this.gravityZ, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void constrainCoMJerkToZero(int sequenceId, double time) {
        CoMTrajectoryPlannerTools.constrainCoMJerkToZero(time, this.omega.getValue(), sequenceId, this.numberOfConstraints, (DMatrix)this.coefficientMultipliersSparse);
        ++this.numberOfConstraints;
    }

    public boolean hasTrajectories() {
        return this.trajectoryHandler.hasTrajectory();
    }

    public void removeCompletedSegments(double timeToCrop) {
        this.trajectoryHandler.removeCompletedSegments(timeToCrop);
    }

    public List<Polynomial3DReadOnly> getVRPTrajectories() {
        if (!this.hasTrajectories()) {
            throw new RuntimeException("VRP Trajectories are not calculated");
        }
        return this.trajectoryHandler.getVrpTrajectories();
    }

    public MultipleCoMSegmentTrajectoryGenerator getCoMTrajectory() {
        if (!this.hasTrajectories()) {
            throw new RuntimeException("CoM Trajectories are not calculated");
        }
        return this.trajectoryHandler.getComTrajectory();
    }
}

