/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DGrowArray;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.interfaces.linsol.LinearSolverSparse;
import org.ejml.sparse.FillReducing;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.factory.LinearSolverFactory_DSCC;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMContinuityCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerIndexHandler;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.CoMTrajectoryPlannerTools;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.MatrixMissingTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CoMContinuousContinuityCalculator
implements CoMContinuityCalculator {
    private final FramePoint3D initialCoMPosition = new FramePoint3D();
    private final FrameVector3D initialCoMVelocity = new FrameVector3D();
    private final FramePoint3D finalICPToAchieve = new FramePoint3D();
    private final List<ContactStateProvider> contactSequenceInternal = new ArrayList<ContactStateProvider>();
    private int segmentContinuityDepth = 2;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    final DMatrixSparseCSC coefficientMultipliersSparse = new DMatrixSparseCSC(0, 0);
    private final DMatrixSparseCSC tempSparse = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC xEquivalents = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC yEquivalents = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC zEquivalents = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC xConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC yConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC zConstants = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpWaypointJacobian = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpXWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpYWaypoints = new DMatrixSparseCSC(0, 1);
    private final DMatrixSparseCSC vrpZWaypoints = new DMatrixSparseCSC(0, 1);
    private final LinearSolverSparse<DMatrixSparseCSC, DMatrixRMaj> sparseSolver = LinearSolverFactory_DSCC.lu((FillReducing)FillReducing.NONE);
    final DMatrixSparseCSC xCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC yCoefficientVector = new DMatrixSparseCSC(0, 1);
    final DMatrixSparseCSC zCoefficientVector = new DMatrixSparseCSC(0, 1);
    private final CoMTrajectoryPlannerIndexHandler indexHandler = new CoMTrajectoryPlannerIndexHandler();
    private final RecyclingArrayList<FramePoint3D> startVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final RecyclingArrayList<FramePoint3D> endVRPPositions = new RecyclingArrayList(FramePoint3D::new);
    private final DoubleProvider omega;
    private final YoDouble comHeight = new YoDouble("comHeightForPlanning", this.registry);
    private final double gravityZ;
    private int numberOfConstraints = 0;
    private final IGrowArray gw = new IGrowArray();
    private final DGrowArray gx = new DGrowArray();

    public CoMContinuousContinuityCalculator(double gravityZ, double nominalCoMHeight, YoRegistry parentRegistry) {
        this.gravityZ = Math.abs(gravityZ);
        YoDouble omega = new YoDouble("omegaForPlanning", this.registry);
        this.comHeight.addListener(v -> omega.set(Math.sqrt(Math.abs(gravityZ) / this.comHeight.getDoubleValue())));
        this.comHeight.set(nominalCoMHeight);
        this.omega = omega;
        parentRegistry.addChild(this.registry);
    }

    public CoMContinuousContinuityCalculator(double gravityZ, YoDouble omega, YoRegistry parentRegistry) {
        this.omega = omega;
        this.gravityZ = Math.abs(gravityZ);
        omega.addListener(v -> this.comHeight.set(gravityZ / MathTools.square((double)omega.getValue())));
        omega.notifyListeners();
        parentRegistry.addChild(this.registry);
    }

    @Override
    public void setInitialCoMPosition(FramePoint3DReadOnly initialCoMPosition) {
        this.initialCoMPosition.setMatchingFrame((FrameTuple3DReadOnly)initialCoMPosition);
    }

    @Override
    public void setInitialCoMVelocity(FrameVector3DReadOnly initialCoMVelocity) {
        this.initialCoMVelocity.setMatchingFrame((FrameTuple3DReadOnly)initialCoMVelocity);
    }

    @Override
    public void setFinalICPToAchieve(FramePoint3DReadOnly finalICPToAchieve) {
        this.finalICPToAchieve.setMatchingFrame((FrameTuple3DReadOnly)finalICPToAchieve);
    }

    @Override
    public boolean solve(List<? extends ContactStateProvider> contactSequence) {
        int i;
        if (contactSequence.size() < 2) {
            return false;
        }
        for (i = 0; i < this.segmentContinuityDepth; ++i) {
            if (contactSequence.get(i).getContactState().isLoadBearing()) continue;
            return false;
        }
        this.contactSequenceInternal.clear();
        for (i = 0; i < this.segmentContinuityDepth; ++i) {
            this.contactSequenceInternal.add(contactSequence.get(i));
        }
        this.indexHandler.update(this.contactSequenceInternal);
        this.resetMatrices();
        CoMTrajectoryPlannerTools.computeVRPWaypoints(this.comHeight.getDoubleValue(), this.gravityZ, this.omega.getValue(), (FrameVector3DReadOnly)this.initialCoMVelocity, this.contactSequenceInternal, this.startVRPPositions, this.endVRPPositions, false);
        this.numberOfConstraints = 0;
        double firstSegmentDuration = this.contactSequenceInternal.get(0).getTimeInterval().getDuration();
        double secondSegmentDuration = Math.min(this.contactSequenceInternal.get(1).getTimeInterval().getDuration(), 1.0E10);
        FramePoint3DReadOnly startVRPPosition = (FramePoint3DReadOnly)this.startVRPPositions.get(0);
        FramePoint3DReadOnly endVRPPosition = (FramePoint3DReadOnly)this.endVRPPositions.get(1);
        this.setCoMPositionConstraint((FramePoint3DReadOnly)this.initialCoMPosition);
        this.setCoMVelocityConstraint((FrameVector3DReadOnly)this.initialCoMVelocity);
        this.constrainVRPPosition(0, this.indexHandler.getVRPWaypointStartPositionIndex(0), 0.0, startVRPPosition);
        this.addLinearVRPFunctionConstraint(0, firstSegmentDuration, this.omega.getValue());
        this.setCoMPositionContinuity(firstSegmentDuration);
        this.setCoMVelocityContinuity(firstSegmentDuration);
        this.setVRPPositionContinuity(firstSegmentDuration);
        this.addImplicitVRPVelocityConstraint(0, this.indexHandler.getVRPWaypointStartPositionIndex(0), firstSegmentDuration, 0.0, startVRPPosition);
        this.addImplicitVRPVelocityConstraint(1, this.indexHandler.getVRPWaypointFinalPositionIndex(1), 0.0, secondSegmentDuration, endVRPPosition);
        this.constrainVRPPosition(1, this.indexHandler.getVRPWaypointFinalPositionIndex(1), secondSegmentDuration, endVRPPosition);
        this.addLinearVRPFunctionConstraint(1, secondSegmentDuration, this.omega.getValue());
        this.setFinalDCMPositionConstraint(secondSegmentDuration, (FramePoint3DReadOnly)this.finalICPToAchieve);
        this.sparseSolver.setA((Matrix)this.coefficientMultipliersSparse);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpXWaypoints, (DMatrixSparseCSC)this.tempSparse, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.xConstants, (DMatrixSparseCSC)this.xEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpYWaypoints, (DMatrixSparseCSC)this.tempSparse, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.yConstants, (DMatrixSparseCSC)this.yEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.mult((DMatrixSparseCSC)this.vrpWaypointJacobian, (DMatrixSparseCSC)this.vrpZWaypoints, (DMatrixSparseCSC)this.tempSparse, (IGrowArray)this.gw, (DGrowArray)this.gx);
        CommonOps_DSCC.add((double)1.0, (DMatrixSparseCSC)this.tempSparse, (double)1.0, (DMatrixSparseCSC)this.zConstants, (DMatrixSparseCSC)this.zEquivalents, (IGrowArray)this.gw, (DGrowArray)this.gx);
        this.sparseSolver.solveSparse((Matrix)this.xEquivalents, (Matrix)this.xCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.yEquivalents, (Matrix)this.yCoefficientVector);
        this.sparseSolver.solveSparse((Matrix)this.zEquivalents, (Matrix)this.zCoefficientVector);
        return true;
    }

    @Override
    public int getDepthForCalculation() {
        return this.segmentContinuityDepth;
    }

    @Override
    public void getXCoefficientOverrides(DMatrix xCoefficientVectorToPack) {
        int size = this.xCoefficientVector.getNumRows();
        MatrixMissingTools.setMatrixBlock((DMatrix)xCoefficientVectorToPack, (int)0, (int)0, (DMatrix)this.xCoefficientVector, (int)0, (int)0, (int)size, (int)1, (double)1.0);
    }

    @Override
    public void getYCoefficientOverrides(DMatrix yCoefficientVectorToPack) {
        int size = this.yCoefficientVector.getNumRows();
        MatrixMissingTools.setMatrixBlock((DMatrix)yCoefficientVectorToPack, (int)0, (int)0, (DMatrix)this.yCoefficientVector, (int)0, (int)0, (int)size, (int)1, (double)1.0);
    }

    @Override
    public void getZCoefficientOverrides(DMatrix zCoefficientVectorToPack) {
        int size = this.zCoefficientVector.getNumRows();
        MatrixMissingTools.setMatrixBlock((DMatrix)zCoefficientVectorToPack, (int)0, (int)0, (DMatrix)this.zCoefficientVector, (int)0, (int)0, (int)size, (int)1, (double)1.0);
    }

    private void resetMatrices() {
        int size = this.indexHandler.getTotalNumberOfCoefficients();
        int numberOfVRPWaypoints = this.indexHandler.getNumberOfVRPWaypoints();
        this.coefficientMultipliersSparse.reshape(size, size);
        this.tempSparse.reshape(size, 1);
        this.xEquivalents.reshape(size, 1);
        this.yEquivalents.reshape(size, 1);
        this.zEquivalents.reshape(size, 1);
        this.xConstants.reshape(size, 1);
        this.yConstants.reshape(size, 1);
        this.zConstants.reshape(size, 1);
        this.vrpWaypointJacobian.reshape(size, numberOfVRPWaypoints);
        this.vrpXWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpYWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.vrpZWaypoints.reshape(numberOfVRPWaypoints, 1);
        this.xCoefficientVector.reshape(size, 1);
        this.yCoefficientVector.reshape(size, 1);
        this.zCoefficientVector.reshape(size, 1);
        this.coefficientMultipliersSparse.zero();
        this.xEquivalents.zero();
        this.yEquivalents.zero();
        this.zEquivalents.zero();
        this.xConstants.zero();
        this.yConstants.zero();
        this.zConstants.zero();
        this.vrpWaypointJacobian.zero();
        this.vrpXWaypoints.zero();
        this.vrpYWaypoints.zero();
        this.vrpZWaypoints.zero();
    }

    private void setCoMPositionConstraint(FramePoint3DReadOnly centerOfMassLocationForConstraint) {
        CoMTrajectoryPlannerTools.addCoMPositionConstraint(centerOfMassLocationForConstraint, this.omega.getValue(), 0.0, 0, this.numberOfConstraints, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }

    private void setCoMVelocityConstraint(FrameVector3DReadOnly centerOfMassVelocityForConstraint) {
        CoMTrajectoryPlannerTools.addCoMVelocityConstraint(centerOfMassVelocityForConstraint, this.omega.getValue(), 0.0, 0, this.numberOfConstraints++, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
    }

    private void setCoMPositionContinuity(double previousDuration) {
        CoMTrajectoryPlannerTools.addCoMPositionContinuityConstraint(0, 1, this.numberOfConstraints++, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientMultipliersSparse);
    }

    private void setCoMVelocityContinuity(double previousDuration) {
        CoMTrajectoryPlannerTools.addCoMVelocityContinuityConstraint(0, 1, this.numberOfConstraints++, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientMultipliersSparse);
    }

    private void constrainVRPPosition(int sequenceId, int vrpWaypointPositionIndex, double time, FramePoint3DReadOnly desiredVRPPosition) {
        CoMTrajectoryPlannerTools.addVRPPositionConstraint(sequenceId, this.numberOfConstraints++, vrpWaypointPositionIndex, time, this.omega.getValue(), desiredVRPPosition, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
    }

    private void setVRPPositionContinuity(double previousDuration) {
        CoMTrajectoryPlannerTools.addVRPPositionContinuityConstraint(0, 1, this.numberOfConstraints++, this.omega.getValue(), previousDuration, (DMatrix)this.coefficientMultipliersSparse);
    }

    private void addLinearVRPFunctionConstraint(int segmentId, double duration, double omega) {
        CoMTrajectoryPlannerTools.addEquivalentVRPVelocityConstraint(segmentId, segmentId, this.numberOfConstraints++, 0.0, duration, omega, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
    }

    private void addImplicitVRPVelocityConstraint(int sequenceId, int vrpWaypointPositionIndex, double timeInSegment, double timeAtWaypoint, FramePoint3DReadOnly desiredVRPPosition) {
        CoMTrajectoryPlannerTools.addImplicitVRPVelocityConstraint(sequenceId, this.numberOfConstraints++, vrpWaypointPositionIndex, timeInSegment, timeAtWaypoint, this.omega.getValue(), desiredVRPPosition, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.vrpXWaypoints, (DMatrix)this.vrpYWaypoints, (DMatrix)this.vrpZWaypoints, (DMatrix)this.vrpWaypointJacobian);
    }

    private void setFinalDCMPositionConstraint(double timeInSegment, FramePoint3DReadOnly desiredDCMPosition) {
        CoMTrajectoryPlannerTools.addDCMPositionConstraint(1, this.numberOfConstraints, timeInSegment, this.omega.getValue(), desiredDCMPosition, (DMatrix)this.coefficientMultipliersSparse, (DMatrix)this.xConstants, (DMatrix)this.yConstants, (DMatrix)this.zConstants);
        ++this.numberOfConstraints;
    }
}

