/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning;

import us.ihmc.commonWalkingControlModules.capturePoint.CapturePointTools;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;

public class CenterOfMassDynamicsTools {
    public static void computeDesiredDCMPosition(double omega0, double time, FramePoint3DReadOnly initialDCM, FramePoint3DReadOnly initialVRP, FixedFramePoint3DBasics desiredDCMToPack) {
        CapturePointTools.computeDesiredCapturePointPosition(omega0, time, initialDCM, initialVRP, desiredDCMToPack);
    }

    public static void computeDesiredCoMPositionForwardTime(double omega0, double time, FramePoint3DReadOnly initialCoM, FramePoint3DReadOnly initialDCM, FramePoint3DReadOnly initialVRP, FixedFramePoint3DBasics desiredCoMToPack) {
        double exponential = Math.exp(omega0 * time);
        double negativeExponential = 1.0 / exponential;
        desiredCoMToPack.set((FrameTuple3DReadOnly)initialCoM);
        desiredCoMToPack.scale(negativeExponential);
        desiredCoMToPack.scaleAdd(0.5 * (exponential - negativeExponential), (FrameTuple3DReadOnly)initialDCM, (FrameTuple3DReadOnly)desiredCoMToPack);
        desiredCoMToPack.scaleAdd(1.0 - 0.5 * (exponential + negativeExponential), (FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
    }

    public static void computeDesiredCoMPositionBackwardTime(double omega0, double time, FramePoint3DReadOnly finalCoM, FramePoint3DReadOnly finalDCM, FramePoint3DReadOnly initialVRP, FixedFramePoint3DBasics desiredCoMToPack) {
        double exponential = Math.exp(omega0 * time);
        double negativeExponential = 1.0 / exponential;
        desiredCoMToPack.set((FrameTuple3DReadOnly)finalCoM);
        desiredCoMToPack.scale(exponential);
        desiredCoMToPack.scaleAdd(0.5 * (negativeExponential - exponential), (FrameTuple3DReadOnly)finalDCM, (FrameTuple3DReadOnly)desiredCoMToPack);
        desiredCoMToPack.scaleAdd(1.0 - 0.5 * (exponential + negativeExponential), (FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
    }

    public static void computeDesiredDCMPositionForwardTime(double omega0, double time, double duration, FramePoint3DReadOnly initialDCM, FramePoint3DReadOnly initialVRP, FramePoint3DReadOnly finalVRP, FixedFramePoint3DBasics desiredDCMToPack) {
        double sigmaT = CenterOfMassDynamicsTools.computeLinearSigma(omega0, time, duration);
        double sigma0 = CenterOfMassDynamicsTools.computeLinearSigma(omega0, 0.0, duration);
        double exponential = Math.exp(omega0 * time);
        double alpha = 1.0 - sigmaT - exponential * (1.0 - sigma0);
        double beta = sigmaT - exponential * sigma0;
        desiredDCMToPack.set((FrameTuple3DReadOnly)initialVRP);
        desiredDCMToPack.scale(alpha);
        desiredDCMToPack.scaleAdd(beta, (FrameTuple3DReadOnly)finalVRP, (FrameTuple3DReadOnly)desiredDCMToPack);
        desiredDCMToPack.scaleAdd(exponential, (FrameTuple3DReadOnly)initialDCM, (FrameTuple3DReadOnly)desiredDCMToPack);
    }

    public static void computeDesiredDCMPositionBackwardTime(double omega0, double time, double duration, FramePoint3DReadOnly finalDCM, FramePoint3DReadOnly initialVRP, FramePoint3DReadOnly finalVRP, FixedFramePoint3DBasics desiredDCMToPack) {
        double exponential = Math.exp(-omega0 * time);
        desiredDCMToPack.interpolate((FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)finalDCM, exponential);
        double linearFactor = -time / duration * exponential + 1.0 / (omega0 * duration) * (1.0 - exponential);
        desiredDCMToPack.scaleAdd(linearFactor, (FrameTuple3DReadOnly)finalVRP, (FrameTuple3DReadOnly)desiredDCMToPack);
        desiredDCMToPack.scaleAdd(-linearFactor, (FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)desiredDCMToPack);
    }

    public static void computeDesiredCoMPositionForwardTime(double omega0, double time, double duration, FramePoint3DReadOnly initialCoM, FramePoint3DReadOnly initialDCM, FramePoint3DReadOnly initialVRP, FramePoint3DReadOnly finalVRP, FixedFramePoint3DBasics desiredCoMToPack) {
        double wt = omega0 * time;
        double negativeExponential = Math.exp(-wt);
        double sinh = Math.sinh(wt);
        double cosh = Math.cosh(wt);
        desiredCoMToPack.set((FrameTuple3DReadOnly)initialCoM);
        desiredCoMToPack.scale(negativeExponential);
        desiredCoMToPack.scaleAdd(sinh, (FrameTuple3DReadOnly)initialDCM, (FrameTuple3DReadOnly)desiredCoMToPack);
        desiredCoMToPack.scaleAdd(1.0 / (omega0 * duration) * sinh - cosh - time / duration + 1.0, (FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
        desiredCoMToPack.scaleAdd(time / duration - 1.0 / (omega0 * duration) * sinh, (FrameTuple3DReadOnly)finalVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
    }

    public static void computeDesiredCoMPositionBackwardTime(double omega0, double time, double duration, FramePoint3DReadOnly finalCoM, FramePoint3DReadOnly finalDCM, FramePoint3DReadOnly initialVRP, FramePoint3DReadOnly finalVRP, FixedFramePoint3DBasics desiredCoMToPack) {
        double wt = omega0 * time;
        double exponential = Math.exp(wt);
        double sinh = Math.sinh(wt);
        desiredCoMToPack.set((FrameTuple3DReadOnly)finalCoM);
        desiredCoMToPack.scale(exponential);
        desiredCoMToPack.scaleAdd(-sinh, (FrameTuple3DReadOnly)finalDCM, (FrameTuple3DReadOnly)desiredCoMToPack);
        double initialCoefficient = exponential * (1.0 - time / duration - exponential) + sinh * (2.0 / (omega0 * duration) * exponential - 1.0 / (omega0 * duration) - time / duration + 1.0);
        double finalCoefficient = time / duration * exponential + sinh * (1.0 / (omega0 * duration) + time / duration - 2.0 / (omega0 * duration) * exponential);
        desiredCoMToPack.scaleAdd(initialCoefficient, (FrameTuple3DReadOnly)initialVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
        desiredCoMToPack.scaleAdd(finalCoefficient, (FrameTuple3DReadOnly)finalVRP, (FrameTuple3DReadOnly)desiredCoMToPack);
    }

    private static double computeLinearSigma(double omega0, double time, double duration) {
        return time / duration + 1.0 / (omega0 * duration);
    }

    private static double computeCubicSigma(double omega0, double time, double duration) {
        double t2 = time * time;
        double T2 = duration * duration;
        double T3 = duration * T2;
        double w2 = omega0 * omega0;
        double w3 = omega0 * w2;
        return t2 / T2 * (3.0 - 2.0 * time / duration) + 6.0 / omega0 * (time / T2) * (1.0 - time / duration) + 6.0 / (w2 * T2) * (1.0 - 2.0 * time / duration) - 12.0 / (w3 * T3);
    }
}

