/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.DefaultSplitFractionCalculatorParameters;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionCalculatorParametersReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionFromAreaCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.SplitFractionFromPositionCalculator;
import us.ihmc.commonWalkingControlModules.capturePoint.splitFractionCalculation.YoSplitFractionCalculatorParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPPointViewer;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGenerator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryParameters;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.DynamicPlanningFootstep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PlanningTiming;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.PreallocatedList;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.saveableModule.YoSaveableModuleState;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class WalkingCoPTrajectoryGenerator
extends CoPTrajectoryGenerator {
    private final CoPTrajectoryParameters parameters;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry;
    private final ConvexPolygon2D defaultSupportPolygon = new ConvexPolygon2D();
    private final SideDependentList<FrameConvexPolygon2D> movingPolygonsInSole = new SideDependentList((Object)new FrameConvexPolygon2D(), (Object)new FrameConvexPolygon2D());
    private final SideDependentList<RecyclingArrayList<PoseReferenceFrame>> stepFrames = new SideDependentList();
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(SettableContactStateProvider::new);
    private final FramePose3D tempPose = new FramePose3D();
    private final FrameConvexPolygon2D tempPolygon = new FrameConvexPolygon2D();
    private final ConvexPolygonScaler polygonScaler = new ConvexPolygonScaler();
    private final FramePoint3D tempFramePoint1 = new FramePoint3D();
    private final FramePoint3D tempFramePoint2 = new FramePoint3D();
    private final FramePoint3D tempPointForCoPCalculation = new FramePoint3D();
    private final FramePoint3D previousCoPPosition = new FramePoint3D();
    private final FramePoint3D midfootCoP = new FramePoint3D();
    private final FramePoint2D copInFootFrame = new FramePoint2D();
    private final YoDouble finalTransferSplitFraction;
    private final YoDouble finalTransferWeightDistribution;
    private final PreallocatedList<YoDouble> transferSplitFractions;
    private final PreallocatedList<YoDouble> transferWeightDistributions;
    private final SplitFractionFromPositionCalculator positionSplitFractionCalculator;
    private final SplitFractionFromAreaCalculator areaSplitFractionCalculator;
    private final YoSplitFractionCalculatorParameters splitFractionParameters;
    private int shiftFractionCounter = 0;
    private int weightDistributionCounter = 0;
    private boolean holdSplitFractionParameters = false;
    private CoPPointViewer viewer = null;
    private final FrameConvexPolygon2DBasics nextPolygon = new FrameConvexPolygon2D();
    private final FramePoint2D mostForwardPointOnOtherPolygon = new FramePoint2D();

    public WalkingCoPTrajectoryGenerator(CoPTrajectoryParameters parameters, ConvexPolygon2DReadOnly defaultSupportPolygon, YoRegistry parentRegistry) {
        this(parameters, new DefaultSplitFractionCalculatorParameters(), defaultSupportPolygon, parentRegistry);
    }

    public WalkingCoPTrajectoryGenerator(CoPTrajectoryParameters parameters, SplitFractionCalculatorParametersReadOnly defaultSplitFractionParameters, ConvexPolygon2DReadOnly defaultSupportPolygon, YoRegistry parentRegistry) {
        super(WalkingCoPTrajectoryGenerator.class, parentRegistry);
        this.parameters = parameters;
        this.defaultSupportPolygon.set((Vertex2DSupplier)defaultSupportPolygon);
        this.registry = new YoRegistry(((Object)((Object)this)).getClass().getSimpleName());
        this.splitFractionParameters = new YoSplitFractionCalculatorParameters(defaultSplitFractionParameters, this.registry);
        for (final RobotSide robotSide : RobotSide.values) {
            this.stepFrames.put((Enum)robotSide, (Object)new RecyclingArrayList(3, (Supplier)new Supplier<PoseReferenceFrame>(){
                private int frameIndexCounter = 0;

                @Override
                public PoseReferenceFrame get() {
                    return new PoseReferenceFrame(robotSide.getLowerCaseName() + "StepFrame" + this.frameIndexCounter++, ReferenceFrame.getWorldFrame());
                }
            }));
        }
        this.finalTransferWeightDistribution = new YoDouble("processedFinalTransferWeightDistribution", this.registry);
        this.finalTransferSplitFraction = new YoDouble("processedFinalTransferSplitFraction", this.registry);
        this.transferSplitFractions = new PreallocatedList(YoDouble.class, () -> new YoDouble("processedTransferSplitFraction" + this.shiftFractionCounter++, this.registry), parameters.getMaxNumberOfStepsToConsider());
        this.transferWeightDistributions = new PreallocatedList(YoDouble.class, () -> new YoDouble("processedTransferWeightDistribution" + this.weightDistributionCounter++, this.registry), parameters.getMaxNumberOfStepsToConsider());
        this.positionSplitFractionCalculator = new SplitFractionFromPositionCalculator(this.splitFractionParameters);
        SideDependentList defaultFootPolygons = new SideDependentList((Object)defaultSupportPolygon, (Object)defaultSupportPolygon);
        this.areaSplitFractionCalculator = new SplitFractionFromAreaCalculator(this.splitFractionParameters, (SideDependentList<? extends ConvexPolygon2DReadOnly>)defaultFootPolygons);
        parentRegistry.addChild(this.registry);
        this.clear();
    }

    public void registerState(CoPTrajectoryGeneratorState state) {
        super.registerState((YoSaveableModuleState)state);
        state.registerStateToSave(this.splitFractionParameters);
        this.positionSplitFractionCalculator.setNumberOfStepsProvider(state::getNumberOfFootstep);
        this.positionSplitFractionCalculator.setFinalTransferSplitFractionProvider(() -> ((YoDouble)this.finalTransferSplitFraction).getDoubleValue());
        this.positionSplitFractionCalculator.setFinalTransferWeightDistributionProvider(() -> ((YoDouble)this.finalTransferWeightDistribution).getDoubleValue());
        this.positionSplitFractionCalculator.setTransferSplitFractionProvider(i -> ((YoDouble)this.transferSplitFractions.get(i)).getDoubleValue());
        this.positionSplitFractionCalculator.setTransferWeightDistributionProvider(i -> ((YoDouble)this.transferWeightDistributions.get(i)).getDoubleValue());
        this.positionSplitFractionCalculator.setFinalTransferSplitFractionConsumer(arg_0 -> ((YoDouble)this.finalTransferSplitFraction).set(arg_0));
        this.positionSplitFractionCalculator.setFinalTransferWeightDistributionConsumer(arg_0 -> ((YoDouble)this.finalTransferWeightDistribution).set(arg_0));
        this.positionSplitFractionCalculator.setTransferWeightDistributionConsumer((i, d) -> ((YoDouble)this.transferWeightDistributions.get(i)).set(d));
        this.positionSplitFractionCalculator.setTransferSplitFractionConsumer((i, d) -> ((YoDouble)this.transferSplitFractions.get(i)).set(d));
        this.positionSplitFractionCalculator.setFirstSupportPoseProvider(() -> {
            RobotSide stanceSide = state.getFootstep(0).getRobotSide().getOppositeSide();
            return state.getFootPose(stanceSide);
        });
        this.positionSplitFractionCalculator.setStepPoseGetter(i -> state.getFootstep(i).getFootstepPose());
        this.areaSplitFractionCalculator.setNumberOfStepsProvider(state::getNumberOfFootstep);
        this.areaSplitFractionCalculator.setFinalTransferSplitFractionProvider(() -> ((YoDouble)this.finalTransferSplitFraction).getDoubleValue());
        this.areaSplitFractionCalculator.setFinalTransferWeightDistributionProvider(() -> ((YoDouble)this.finalTransferWeightDistribution).getDoubleValue());
        this.areaSplitFractionCalculator.setTransferSplitFractionProvider(i -> ((YoDouble)this.transferSplitFractions.get(i)).getDoubleValue());
        this.areaSplitFractionCalculator.setTransferWeightDistributionProvider(i -> ((YoDouble)this.transferWeightDistributions.get(i)).getDoubleValue());
        this.areaSplitFractionCalculator.setFinalTransferSplitFractionConsumer(arg_0 -> ((YoDouble)this.finalTransferSplitFraction).set(arg_0));
        this.areaSplitFractionCalculator.setFinalTransferWeightDistributionConsumer(arg_0 -> ((YoDouble)this.finalTransferWeightDistribution).set(arg_0));
        this.areaSplitFractionCalculator.setTransferWeightDistributionConsumer((i, d) -> ((YoDouble)this.transferWeightDistributions.get(i)).set(d));
        this.areaSplitFractionCalculator.setTransferSplitFractionConsumer((i, d) -> ((YoDouble)this.transferSplitFractions.get(i)).set(d));
        this.areaSplitFractionCalculator.setFirstSupportPolygonProvider(() -> {
            RobotSide stanceSide = state.getFootstep(0).getRobotSide().getOppositeSide();
            return state.getFootPolygonInSole(stanceSide).getPolygonVerticesView();
        });
        this.areaSplitFractionCalculator.setStepSideProvider(i -> state.getFootstep(i).getRobotSide());
        this.areaSplitFractionCalculator.setStepPolygonGetter(i -> state.getFootstep(i).getPredictedContactPoints());
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public void setWaypointViewer(CoPPointViewer viewer) {
        this.viewer = viewer;
    }

    public void clear() {
        this.contactStateProviders.clear();
    }

    private void reset(CoPTrajectoryGeneratorState state) {
        this.contactStateProviders.clear();
        for (RobotSide robotSide : RobotSide.values) {
            ((RecyclingArrayList)this.stepFrames.get((Enum)robotSide)).clear();
        }
        if (!this.holdSplitFractionParameters) {
            int i;
            this.finalTransferSplitFraction.set(this.parameters.getDefaultFinalTransferSplitFraction());
            this.finalTransferWeightDistribution.set(this.parameters.getDefaultFinalTransferWeightDistribution());
            for (i = 0; i < this.transferSplitFractions.size(); ++i) {
                ((YoDouble)this.transferSplitFractions.get(i)).setToNaN();
                ((YoDouble)this.transferWeightDistributions.get(i)).setToNaN();
            }
            this.transferSplitFractions.clear();
            this.transferWeightDistributions.clear();
            for (i = 0; i < state.getNumberOfFootstep(); ++i) {
                ((YoDouble)this.transferSplitFractions.add()).set(this.parameters.getDefaultTransferSplitFraction());
                ((YoDouble)this.transferWeightDistributions.add()).set(this.parameters.getDefaultTransferWeightDistribution());
            }
        }
    }

    public void setHoldSplitFractions(boolean hold) {
        this.holdSplitFractionParameters = hold;
    }

    public void compute(CoPTrajectoryGeneratorState state) {
        int numberOfUpcomingFootsteps = Math.min(this.parameters.getNumberOfStepsToConsider(), state.getNumberOfFootstep());
        this.reset(state);
        for (RobotSide robotSide : RobotSide.values) {
            PoseReferenceFrame stepFrame = (PoseReferenceFrame)((RecyclingArrayList)this.stepFrames.get((Enum)robotSide)).add();
            this.tempPose.setIncludingFrame(state.getFootPose(robotSide));
            this.tempPose.changeFrame(stepFrame.getParent());
            stepFrame.setPoseAndUpdate((FramePose3DReadOnly)this.tempPose);
            ((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)robotSide)).setIncludingFrame((FrameVertex2DSupplier)state.getFootPolygonInSole(robotSide));
            ((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)robotSide)).changeFrameAndProjectToXYPlane((ReferenceFrame)stepFrame);
        }
        this.positionSplitFractionCalculator.computeSplitFractionsFromPosition();
        this.areaSplitFractionCalculator.computeSplitFractionsFromArea();
        SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartTime(0.0);
        contactStateProvider.setStartECMPPosition(state.getInitialCoP());
        if (numberOfUpcomingFootsteps == 0) {
            this.computeCoPPointsForStanding(state);
        } else {
            for (int footstepIndex = 0; footstepIndex < numberOfUpcomingFootsteps; ++footstepIndex) {
                DynamicPlanningFootstep footstep = state.getFootstep(footstepIndex);
                PlanningTiming timings = state.getTiming(footstepIndex);
                RobotSide swingSide = footstep.getRobotSide();
                RobotSide supportSide = swingSide.getOppositeSide();
                FrameConvexPolygon2DReadOnly previousPolygon = (FrameConvexPolygon2DReadOnly)this.movingPolygonsInSole.get((Enum)swingSide);
                FrameConvexPolygon2DReadOnly currentPolygon = (FrameConvexPolygon2DReadOnly)this.movingPolygonsInSole.get((Enum)swingSide.getOppositeSide());
                ReferenceFrame stepFrame = this.extractStepFrame(footstep);
                this.extractSupportPolygon(footstep, stepFrame, this.nextPolygon, (ConvexPolygon2DReadOnly)this.defaultSupportPolygon);
                this.computeCoPPointsForFootstepTransfer(timings.getTransferTime(), ((YoDouble)this.transferSplitFractions.get(footstepIndex)).getDoubleValue(), ((YoDouble)this.transferWeightDistributions.get(footstepIndex)).getDoubleValue(), previousPolygon, currentPolygon, supportSide, footstepIndex == 0);
                this.computeCoPPointsForFootstepSwing(Math.min(timings.getSwingTime(), 10.0), this.parameters.getDefaultSwingDurationShiftFraction(), this.parameters.getDefaultSwingSplitFraction(), currentPolygon, (FrameConvexPolygon2DReadOnly)this.nextPolygon, supportSide);
                ((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)swingSide)).setIncludingFrame((FrameVertex2DSupplier)this.nextPolygon);
            }
            this.computeCoPPointsForFinalTransfer(state.getFootstep(numberOfUpcomingFootsteps - 1).getRobotSide().getOppositeSide(), state.getFinalTransferDuration(), this.finalTransferWeightDistribution.getDoubleValue());
            RobotSide lastStepSide = state.getFootstep(numberOfUpcomingFootsteps - 1).getRobotSide().getOppositeSide();
            if (lastStepSide == RobotSide.RIGHT) {
                state.setPercentageStandingWeightDistributionOnLeftFoot(1.0 - this.finalTransferWeightDistribution.getDoubleValue());
            } else {
                state.setPercentageStandingWeightDistributionOnLeftFoot(this.finalTransferWeightDistribution.getDoubleValue());
            }
        }
        if (this.viewer != null) {
            this.viewer.updateWaypoints((List<? extends ContactStateProvider>)this.contactStateProviders);
        }
    }

    public void update(double time, FixedFramePoint3DBasics desiredCoP) {
        for (int i = 0; i < this.contactStateProviders.size(); ++i) {
            ContactStateProvider contactStateProvider = (ContactStateProvider)this.contactStateProviders.get(i);
            if (!contactStateProvider.getTimeInterval().intervalContains(time)) continue;
            double alpha = (time - contactStateProvider.getTimeInterval().getStartTime()) / contactStateProvider.getTimeInterval().getDuration();
            desiredCoP.interpolate((FrameTuple3DReadOnly)contactStateProvider.getECMPStartPosition(), (FrameTuple3DReadOnly)contactStateProvider.getECMPEndPosition(), alpha);
            break;
        }
    }

    @Override
    public RecyclingArrayList<SettableContactStateProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }

    private ReferenceFrame extractStepFrame(DynamicPlanningFootstep footstep) {
        PoseReferenceFrame stepFrame = (PoseReferenceFrame)((RecyclingArrayList)this.stepFrames.get((Enum)footstep.getRobotSide())).add();
        stepFrame.setPoseAndUpdate(footstep.getFootstepPose());
        return stepFrame;
    }

    private void extractSupportPolygon(DynamicPlanningFootstep footstep, ReferenceFrame stepFrame, FrameConvexPolygon2DBasics footSupportPolygonToPack, ConvexPolygon2DReadOnly defaultSupportPolygon) {
        if (footstep.hasPredictedContactPoints()) {
            List<? extends Point2DReadOnly> predictedContactPoints = footstep.getPredictedContactPoints();
            footSupportPolygonToPack.clear(stepFrame);
            for (int i = 0; i < predictedContactPoints.size(); ++i) {
                footSupportPolygonToPack.addVertex(predictedContactPoints.get(i));
            }
            footSupportPolygonToPack.update();
        } else {
            footSupportPolygonToPack.setIncludingFrame(stepFrame, (Vertex2DSupplier)defaultSupportPolygon);
        }
    }

    private void computeCoPPointsForStanding(CoPTrajectoryGeneratorState state) {
        this.computeCoPPointsForFinalTransfer(RobotSide.LEFT, state.getFinalTransferDuration(), state.getPercentageStandingWeightDistributionOnLeftFoot());
        SettableContactStateProvider previousContactState = (SettableContactStateProvider)this.contactStateProviders.getLast();
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition(previousContactState.getECMPStartPosition());
        contactState.setDuration(Double.POSITIVE_INFINITY);
        contactState.setLinearECMPVelocity();
    }

    private void computeCoPPointsForFinalTransfer(RobotSide lastFootstepSide, double finalTransferDuration, double finalTransferWeightDistribution) {
        SettableContactStateProvider previousContactState = (SettableContactStateProvider)this.contactStateProviders.getLast();
        this.tempPointForCoPCalculation.setIncludingFrame((FrameTuple2DReadOnly)((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)lastFootstepSide)).getCentroid(), 0.0);
        this.tempPointForCoPCalculation.changeFrame(worldFrame);
        this.tempFramePoint1.setIncludingFrame((FrameTuple2DReadOnly)((FrameConvexPolygon2D)this.movingPolygonsInSole.get((Enum)lastFootstepSide.getOppositeSide())).getCentroid(), 0.0);
        this.tempFramePoint1.changeFrame(worldFrame);
        this.tempPointForCoPCalculation.interpolate((FrameTuple3DReadOnly)this.tempFramePoint1, finalTransferWeightDistribution);
        double segmentDuration = this.finalTransferSplitFraction.getDoubleValue() * finalTransferDuration;
        previousContactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        previousContactState.setDuration(segmentDuration);
        previousContactState.setLinearECMPVelocity();
        segmentDuration = (1.0 - this.finalTransferSplitFraction.getValue()) * finalTransferDuration;
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.setStartFromEnd(previousContactState);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactState.setDuration(segmentDuration);
        contactState.setLinearECMPVelocity();
    }

    private void computeCoPPointsForFootstepTransfer(double duration, double splitFraction, double weightDistribution, FrameConvexPolygon2DReadOnly previousPolygon, FrameConvexPolygon2DReadOnly nextPolygon, RobotSide supportSide, boolean setupForContinuityMaintaining) {
        SettableContactStateProvider previousContactState = (SettableContactStateProvider)this.contactStateProviders.getLast();
        this.previousCoPPosition.setIncludingFrame((FrameTuple3DReadOnly)previousContactState.getECMPStartPosition());
        this.previousCoPPosition.changeFrame(previousPolygon.getReferenceFrame());
        if (!previousPolygon.isPointInside(this.previousCoPPosition.getX(), this.previousCoPPosition.getY())) {
            this.computeExitCoPLocation((FramePoint3DBasics)this.previousCoPPosition, previousPolygon, nextPolygon, supportSide.getOppositeSide());
        }
        this.previousCoPPosition.changeFrame(worldFrame);
        this.computeEntryCoPPointLocation((FramePoint3DBasics)this.tempPointForCoPCalculation, previousPolygon, nextPolygon, supportSide);
        this.midfootCoP.interpolate((FrameTuple3DReadOnly)this.previousCoPPosition, (FrameTuple3DReadOnly)this.tempPointForCoPCalculation, weightDistribution);
        double firstSegmentDuration = splitFraction * duration;
        if (setupForContinuityMaintaining) {
            firstSegmentDuration = Math.min(firstSegmentDuration, this.parameters.getDurationForContinuityMaintenanceSegment());
        }
        previousContactState.setDuration(firstSegmentDuration);
        previousContactState.setEndECMPPosition((FramePoint3DReadOnly)this.midfootCoP);
        previousContactState.setLinearECMPVelocity();
        double secondSegmentDuration = duration - firstSegmentDuration;
        SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartFromEnd(previousContactState);
        contactStateProvider.setDuration(secondSegmentDuration);
        contactStateProvider.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactStateProvider.setLinearECMPVelocity();
    }

    private void computeCoPPointsForFootstepSwing(double duration, double shiftFraction, double splitFraction, FrameConvexPolygon2DReadOnly supportPolygon, FrameConvexPolygon2DReadOnly nextPolygon, RobotSide supportSide) {
        this.computeBallCoPLocation((FramePoint3DBasics)this.tempPointForCoPCalculation, supportPolygon, nextPolygon, supportSide);
        SettableContactStateProvider previousContactState = (SettableContactStateProvider)this.contactStateProviders.getLast();
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.setStartFromEnd(previousContactState);
        contactState.setDuration(shiftFraction * splitFraction * duration);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactState.setLinearECMPVelocity();
        previousContactState = contactState;
        this.computeExitCoPLocation((FramePoint3DBasics)this.tempPointForCoPCalculation, supportPolygon, nextPolygon, supportSide);
        contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.setStartFromEnd(previousContactState);
        contactState.setDuration(shiftFraction * (1.0 - splitFraction) * duration);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactState.setLinearECMPVelocity();
        previousContactState = contactState;
        contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.setStartFromEnd(previousContactState);
        contactState.setDuration((1.0 - shiftFraction) * duration);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.tempPointForCoPCalculation);
        contactState.setLinearECMPVelocity();
        ((SettableContactStateProvider)this.contactStateProviders.add()).setStartFromEnd(contactState);
    }

    private void computeEntryCoPPointLocation(FramePoint3DBasics copLocationToPack, FrameConvexPolygon2DReadOnly previousFootPolygon, FrameConvexPolygon2DReadOnly footPolygon, RobotSide supportSide) {
        this.computeCoPLocation(copLocationToPack, this.parameters.getEntryCMPLengthOffsetFactor(), this.parameters.getEntryCMPOffset(), this.parameters.getEntryCMPMinX(), this.parameters.getEntryCMPMaxX(), footPolygon, previousFootPolygon, supportSide);
    }

    private void computeBallCoPLocation(FramePoint3DBasics copLocationToPack, FrameConvexPolygon2DReadOnly footPolygon, FrameConvexPolygon2DReadOnly nextFootPolygon, RobotSide supportSide) {
        this.computeCoPLocation(copLocationToPack, this.parameters.getBallCMPLengthOffsetFactor(), this.parameters.getBallCMPOffset(), this.parameters.getBallCMPMinX(), this.parameters.getBallCMPMaxX(), footPolygon, nextFootPolygon, supportSide);
    }

    private void computeExitCoPLocation(FramePoint3DBasics copLocationToPack, FrameConvexPolygon2DReadOnly footPolygon, FrameConvexPolygon2DReadOnly nextFootPolygon, RobotSide supportSide) {
        this.tempFramePoint1.setIncludingFrame((FrameTuple2DReadOnly)nextFootPolygon.getCentroid(), 0.0);
        this.tempFramePoint1.changeFrame(footPolygon.getReferenceFrame());
        this.tempFramePoint2.setIncludingFrame((FrameTuple2DReadOnly)footPolygon.getCentroid(), 0.0);
        double supportToSwingStepLength = this.tempFramePoint1.getX() - this.tempFramePoint2.getX();
        double supportToSwingStepHeight = this.tempFramePoint1.getZ() - this.tempFramePoint2.getZ();
        if (this.setExitCoPIfSupportIsEmpty(copLocationToPack, footPolygon, supportSide)) {
            return;
        }
        double lengthOffsetFactor = this.parameters.getExitCMPLengthOffsetFactor();
        if (supportToSwingStepHeight < this.parameters.getStepHeightToPutExitCoPOnToesSteppingDown()) {
            lengthOffsetFactor *= this.parameters.getStepDownLengthOffsetScaleFactor();
        }
        this.computeCoPLocation(copLocationToPack, lengthOffsetFactor, this.parameters.getExitCMPOffset(), this.parameters.getExitCMPMinX(), this.parameters.getExitCMPMaxX(), footPolygon, nextFootPolygon, supportSide);
        this.setExitCoPUnderSpecialCases(copLocationToPack, footPolygon, supportSide, supportToSwingStepHeight);
    }

    private void computeCoPLocation(FramePoint3DBasics copLocationToPack, double lengthOffsetFactor, Vector2DReadOnly copOffset, double minXOffset, double maxXOffset, FrameConvexPolygon2DReadOnly basePolygon, FrameConvexPolygon2DReadOnly otherPolygon, RobotSide supportSide) {
        this.copInFootFrame.setIncludingFrame((FrameTuple2DReadOnly)basePolygon.getCentroid());
        double copXOffset = MathTools.clamp((double)(copOffset.getX() + lengthOffsetFactor * this.getStepLength(otherPolygon, basePolygon)), (double)minXOffset, (double)maxXOffset);
        this.copInFootFrame.add(copXOffset, supportSide.negateIfLeftSide(copOffset.getY()));
        this.constrainToPolygon((FramePoint2DBasics)this.copInFootFrame, basePolygon, this.parameters.getMinimumDistanceInsidePolygon());
        copLocationToPack.setMatchingFrame((FrameTuple2DReadOnly)this.copInFootFrame, 0.0);
        copLocationToPack.changeFrame(worldFrame);
    }

    private boolean setExitCoPIfSupportIsEmpty(FramePoint3DBasics framePointToPack, FrameConvexPolygon2DReadOnly supportFootPolygon, RobotSide supportSide) {
        if (supportFootPolygon.getArea() == 0.0) {
            if (supportFootPolygon.getNumberOfVertices() == 2) {
                this.copInFootFrame.setToZero(supportFootPolygon.getReferenceFrame());
                this.copInFootFrame.interpolate((FrameTuple2DReadOnly)supportFootPolygon.getVertex(0), (FrameTuple2DReadOnly)supportFootPolygon.getVertex(1), 0.5);
                this.copInFootFrame.addY(supportSide.negateIfLeftSide(this.parameters.getExitCMPOffset().getY()));
                supportFootPolygon.orthogonalProjection((FramePoint2DBasics)this.copInFootFrame);
            } else {
                this.copInFootFrame.setIncludingFrame(supportFootPolygon.getReferenceFrame(), (Tuple2DReadOnly)supportFootPolygon.getVertex(0));
            }
            this.copInFootFrame.changeFrameAndProjectToXYPlane(worldFrame);
            framePointToPack.setIncludingFrame((FrameTuple2DReadOnly)this.copInFootFrame, 0.0);
            framePointToPack.changeFrame(worldFrame);
            return true;
        }
        return false;
    }

    private void setExitCoPUnderSpecialCases(FramePoint3DBasics framePointToPack, FrameConvexPolygon2DReadOnly supportFootPolygon, RobotSide supportSide, double stepHeight) {
        framePointToPack.changeFrame(supportFootPolygon.getReferenceFrame());
        if (this.parameters.getPlanForToeOffCalculator().shouldPutCMPOnToes(stepHeight, (FramePoint3DReadOnly)framePointToPack, supportFootPolygon)) {
            this.copInFootFrame.changeFrame(supportFootPolygon.getReferenceFrame());
            this.copInFootFrame.setIncludingFrame((FrameTuple2DReadOnly)supportFootPolygon.getCentroid());
            this.copInFootFrame.add(supportFootPolygon.getMaxX() - this.parameters.getExitCoPForwardSafetyMarginOnToes(), supportSide.negateIfLeftSide(this.parameters.getExitCMPOffset().getY()));
            this.constrainToPolygon((FramePoint2DBasics)this.copInFootFrame, supportFootPolygon, this.parameters.getExitCoPForwardSafetyMarginOnToes());
            framePointToPack.setIncludingFrame((FrameTuple2DReadOnly)this.copInFootFrame, 0.0);
        }
        framePointToPack.changeFrame(worldFrame);
    }

    private double getStepLength(FrameConvexPolygon2DReadOnly otherPolygon, FrameConvexPolygon2DReadOnly basePolygon) {
        this.mostForwardPointOnOtherPolygon.setIncludingFrame((FrameTuple2DReadOnly)otherPolygon.getVertex(EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)otherPolygon, (boolean)true, (Bound)Bound.MAX, (Bound)Bound.MAX)));
        this.mostForwardPointOnOtherPolygon.changeFrameAndProjectToXYPlane(basePolygon.getReferenceFrame());
        return this.mostForwardPointOnOtherPolygon.getX() - basePolygon.getMaxX();
    }

    private void constrainToPolygon(FramePoint2DBasics copPointToConstrain, FrameConvexPolygon2DReadOnly constraintPolygon, double safeDistanceFromSupportPolygonEdges) {
        if (constraintPolygon.signedDistance((FramePoint2DReadOnly)copPointToConstrain) <= -safeDistanceFromSupportPolygonEdges) {
            return;
        }
        this.polygonScaler.scaleConvexPolygon(constraintPolygon, safeDistanceFromSupportPolygonEdges, this.tempPolygon);
        copPointToConstrain.changeFrame(constraintPolygon.getReferenceFrame());
        this.tempPolygon.orthogonalProjection(copPointToConstrain);
    }
}

