/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.array.TDoubleArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.math3.util.Precision;
import us.ihmc.commonWalkingControlModules.bipedSupportPolygons.BipedSupportPolygons;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPolygon;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.humanoidRobotics.footstep.FootstepTiming;
import us.ihmc.robotics.EuclidCoreMissingTools;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameConvexPolygon2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SupportSequence {
    private static final int INITIAL_CAPACITY = 50;
    private static final double UNSET_TIME = -1.0;
    private static final double stepLengthToDoToeOff = 0.05;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<? extends ReferenceFrame> soleFrames;
    private final SideDependentList<? extends ReferenceFrame> soleZUpFrames;
    private final RecyclingArrayList<ConvexPolygon2D> supportPolygons = new RecyclingArrayList(50, ConvexPolygon2D.class);
    private final TDoubleArrayList supportInitialTimes = new TDoubleArrayList(50, -1.0);
    private final ConvexPolygon2D defaultSupportPolygon = new ConvexPolygon2D();
    private final SideDependentList<ConvexPolygon2D> footPolygonsInSole = new SideDependentList((Object)new ConvexPolygon2D(), (Object)new ConvexPolygon2D());
    private final SideDependentList<FramePose3D> footPoses = new SideDependentList((Object)new FramePose3D(), (Object)new FramePose3D());
    private final BipedSupportPolygons bipedSupportPolygons;
    private final FramePose3D tempPose = new FramePose3D();
    private final SideDependentList<ConvexPolygon2D> movingPolygonsInSole = new SideDependentList((Object)new ConvexPolygon2D(), (Object)new ConvexPolygon2D());
    private final SideDependentList<RecyclingArrayList<FrameConvexPolygon2DBasics>> footSupportSequences = new SideDependentList();
    private final SideDependentList<TDoubleArrayList> footSupportInitialTimes = new SideDependentList();
    private final List<YoDouble> polygonStartTimes = new ArrayList<YoDouble>();
    private final List<ConvexPolygon2DBasics> vizPolygons = new ArrayList<ConvexPolygon2DBasics>();
    private final SideDependentList<RecyclingArrayList<PoseReferenceFrame>> stepFrames = new SideDependentList();
    private final FrameConvexPolygon2D framePolygonA = new FrameConvexPolygon2D();
    private final FrameConvexPolygon2D framePolygonB = new FrameConvexPolygon2D();
    private final Quaternion orientationError = new Quaternion();
    private final Quaternion rotation = new Quaternion();
    private final Vector3DReadOnly zAxis = new Vector3D(0.0, 0.0, 1.0);
    private final FramePoint3D stepLocation = new FramePoint3D();

    public SupportSequence(ConvexPolygon2DReadOnly defaultSupportPolygon, SideDependentList<? extends ReferenceFrame> soleFrames, SideDependentList<? extends ReferenceFrame> soleZUpFrames) {
        this(defaultSupportPolygon, soleFrames, soleZUpFrames, null, null, null);
    }

    public SupportSequence(ConvexPolygon2DReadOnly defaultSupportPolygon, SideDependentList<? extends ReferenceFrame> soleFrames, SideDependentList<? extends ReferenceFrame> soleZUpFrames, BipedSupportPolygons bipedSupportPolygons, YoRegistry parentRegistry, YoGraphicsListRegistry graphicRegistry) {
        if (graphicRegistry != null) {
            for (int i = 0; i < 10; ++i) {
                YoFrameConvexPolygon2D yoPolygon = new YoFrameConvexPolygon2D("SupportPolygon" + i, ReferenceFrame.getWorldFrame(), 10, this.registry);
                graphicRegistry.registerArtifact(this.getClass().getSimpleName(), (Artifact)new YoArtifactPolygon("SupportPolygon" + i, yoPolygon, Color.GRAY, false));
                this.vizPolygons.add((ConvexPolygon2DBasics)yoPolygon);
                this.polygonStartTimes.add(new YoDouble("SupportPolygonStartTime" + i, this.registry));
            }
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
        for (final RobotSide robotSide : RobotSide.values) {
            this.footSupportSequences.put((Enum)robotSide, (Object)new RecyclingArrayList(50, FrameConvexPolygon2D::new));
            this.footSupportInitialTimes.put((Enum)robotSide, (Object)new TDoubleArrayList(50, -1.0));
            this.stepFrames.put((Enum)robotSide, (Object)new RecyclingArrayList(3, (Supplier)new Supplier<PoseReferenceFrame>(){
                private int frameIndexCounter = 0;

                @Override
                public PoseReferenceFrame get() {
                    return new PoseReferenceFrame(robotSide.getLowerCaseName() + "StepFrame" + this.frameIndexCounter++, ReferenceFrame.getWorldFrame());
                }
            }));
        }
        this.defaultSupportPolygon.set((Vertex2DSupplier)defaultSupportPolygon);
        this.bipedSupportPolygons = bipedSupportPolygons;
        this.soleFrames = soleFrames;
        this.soleZUpFrames = soleZUpFrames;
    }

    public List<? extends ConvexPolygon2DReadOnly> getSupportPolygons() {
        return this.supportPolygons;
    }

    public TDoubleList getSupportTimes() {
        return this.supportInitialTimes;
    }

    public void initializeStance() {
        for (RobotSide robotSide : RobotSide.values) {
            this.initializeStance(robotSide);
        }
    }

    public void initializeStance(RobotSide robotSide) {
        if (this.bipedSupportPolygons == null) {
            ((ConvexPolygon2D)this.footPolygonsInSole.get((Enum)robotSide)).set(this.defaultSupportPolygon);
        } else {
            ((ConvexPolygon2D)this.footPolygonsInSole.get((Enum)robotSide)).set((Vertex2DSupplier)this.bipedSupportPolygons.getFootPolygonInSoleFrame(robotSide));
        }
        ((FramePose3D)this.footPoses.get((Enum)robotSide)).setToZero((ReferenceFrame)this.soleFrames.get((Enum)robotSide));
        ((FramePose3D)this.footPoses.get((Enum)robotSide)).changeFrame((ReferenceFrame)this.soleZUpFrames.get((Enum)robotSide));
    }

    public void changeFootFrame(RobotSide robotSide, ReferenceFrame referenceFrame) {
        ((FramePose3D)this.footPoses.get((Enum)robotSide)).changeFrame(referenceFrame);
    }

    public void update() {
        this.update(Collections.emptyList(), Collections.emptyList());
    }

    public void update(List<Footstep> footsteps, List<FootstepTiming> footstepTimings) {
        this.reset();
        for (RobotSide robotSide : RobotSide.values) {
            PoseReferenceFrame stepFrame = (PoseReferenceFrame)((RecyclingArrayList)this.stepFrames.get((Enum)robotSide)).add();
            this.tempPose.setIncludingFrame((FramePose3DReadOnly)this.footPoses.get((Enum)robotSide));
            this.tempPose.changeFrame(stepFrame.getParent());
            stepFrame.setPoseAndUpdate((FramePose3DReadOnly)this.tempPose);
            ((ConvexPolygon2D)this.movingPolygonsInSole.get((Enum)robotSide)).set((ConvexPolygon2D)this.footPolygonsInSole.get((Enum)robotSide));
            FrameConvexPolygon2DBasics initialFootSupport = (FrameConvexPolygon2DBasics)((RecyclingArrayList)this.footSupportSequences.get((Enum)robotSide)).add();
            initialFootSupport.setIncludingFrame((ReferenceFrame)stepFrame, (Vertex2DSupplier)this.movingPolygonsInSole.get((Enum)robotSide));
            ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)robotSide)).add(0.0);
        }
        double stepStartTime = 0.0;
        for (int stepIndex = 0; stepIndex < footsteps.size(); ++stepIndex) {
            FootstepTiming footstepTiming = footstepTimings.get(stepIndex);
            Footstep footstep = footsteps.get(stepIndex);
            RobotSide stepSide = footstep.getRobotSide();
            this.addToeOffPolygon(footstep, footstepTiming, stepStartTime);
            ((FrameConvexPolygon2DBasics)((RecyclingArrayList)this.footSupportSequences.get((Enum)stepSide)).add()).clearAndUpdate();
            ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)stepSide)).add(stepStartTime + footstepTiming.getTransferTime());
            SupportSequence.extractSupportPolygon(footstep, (ConvexPolygon2DBasics)this.movingPolygonsInSole.get((Enum)stepSide), (ConvexPolygon2DReadOnly)this.defaultSupportPolygon);
            this.addTouchdownPolygon(footstep, footstepTiming, stepStartTime);
            stepStartTime += footstepTiming.getStepTime();
        }
        int lIndex = 0;
        int rIndex = 0;
        FrameConvexPolygon2DReadOnly lPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.LEFT)).get(lIndex);
        FrameConvexPolygon2DReadOnly rPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.RIGHT)).get(rIndex);
        this.combinePolygons((ConvexPolygon2DBasics)this.supportPolygons.add(), lPolygon, rPolygon);
        this.supportInitialTimes.add(0.0);
        while (true) {
            double lNextTime = ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.LEFT)).size() == lIndex + 1 ? Double.POSITIVE_INFINITY : ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.LEFT)).get(lIndex + 1);
            double rNextTime = ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.RIGHT)).size() == rIndex + 1 ? Double.POSITIVE_INFINITY : ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.RIGHT)).get(rIndex + 1);
            if (Double.isInfinite(rNextTime) && Double.isInfinite(lNextTime)) break;
            if (Precision.equals((double)lNextTime, (double)rNextTime)) {
                rPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.RIGHT)).get(++rIndex);
                lPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.LEFT)).get(++lIndex);
                this.supportInitialTimes.add(((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.LEFT)).get(lIndex));
            } else if (lNextTime > rNextTime) {
                rPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.RIGHT)).get(++rIndex);
                this.supportInitialTimes.add(((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.RIGHT)).get(rIndex));
            } else {
                lPolygon = (FrameConvexPolygon2DReadOnly)((RecyclingArrayList)this.footSupportSequences.get((Enum)RobotSide.LEFT)).get(++lIndex);
                this.supportInitialTimes.add(((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)RobotSide.LEFT)).get(lIndex));
            }
            this.combinePolygons((ConvexPolygon2DBasics)this.supportPolygons.add(), lPolygon, rPolygon);
        }
        this.updateViz();
    }

    private void addTouchdownPolygon(Footstep footstep, FootstepTiming footstepTiming, double stepStartTime) {
        RobotSide stepSide = footstep.getRobotSide();
        TDoubleArrayList footInitialTimes = (TDoubleArrayList)this.footSupportInitialTimes.get((Enum)stepSide);
        RecyclingArrayList footSupports = (RecyclingArrayList)this.footSupportSequences.get((Enum)stepSide);
        PoseReferenceFrame stepFrame = (PoseReferenceFrame)((RecyclingArrayList)this.stepFrames.get((Enum)stepSide)).add();
        stepFrame.setPoseAndUpdate((FramePose3DReadOnly)footstep.getFootstepPose());
        FrameConvexPolygon2DBasics touchdownPolygon = (FrameConvexPolygon2DBasics)footSupports.add();
        touchdownPolygon.setIncludingFrame((ReferenceFrame)stepFrame, (Vertex2DSupplier)this.movingPolygonsInSole.get((Enum)stepSide));
        footInitialTimes.add(stepStartTime + footstepTiming.getStepTime());
    }

    private void addToeOffPolygon(Footstep footstep, FootstepTiming footstepTiming, double stepStartTime) {
        RobotSide stepSide = footstep.getRobotSide();
        PoseReferenceFrame stepFrame = (PoseReferenceFrame)SupportSequence.last((List)this.stepFrames.get((Enum)stepSide));
        if (this.shouldDoToeOff((ReferenceFrame)SupportSequence.last((List)this.stepFrames.get((Enum)stepSide.getOppositeSide())), (ReferenceFrame)stepFrame)) {
            FrameConvexPolygon2DBasics liftoffPolygon = (FrameConvexPolygon2DBasics)((RecyclingArrayList)this.footSupportSequences.get((Enum)stepSide)).add();
            this.computeToePolygon(liftoffPolygon, (ConvexPolygon2DReadOnly)this.movingPolygonsInSole.get((Enum)stepSide), (ReferenceFrame)stepFrame);
            ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)stepSide)).add(stepStartTime + footstepTiming.getTransferTime() / 2.0);
        }
    }

    private FrameConvexPolygon2DBasics insertAt(RobotSide robotSide, double initialTime) {
        TDoubleArrayList initialTimes = (TDoubleArrayList)this.footSupportInitialTimes.get((Enum)robotSide);
        RecyclingArrayList polygons = (RecyclingArrayList)this.footSupportSequences.get((Enum)robotSide);
        if (initialTime > SupportSequence.last((TDoubleList)initialTimes)) {
            initialTimes.add(initialTime);
            return (FrameConvexPolygon2DBasics)polygons.add();
        }
        if (Precision.equals((double)initialTime, (double)SupportSequence.last((TDoubleList)initialTimes))) {
            return (FrameConvexPolygon2DBasics)SupportSequence.last(polygons);
        }
        if (initialTime <= 0.0) {
            return (FrameConvexPolygon2DBasics)polygons.get(0);
        }
        System.out.println(initialTimes);
        throw new RuntimeException("Tried to add " + initialTime);
    }

    private void combinePolygons(ConvexPolygon2DBasics result, FrameConvexPolygon2DReadOnly polygonA, FrameConvexPolygon2DReadOnly polygonB) {
        this.framePolygonA.setIncludingFrame((FrameVertex2DSupplier)polygonA);
        this.framePolygonA.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        this.framePolygonB.setIncludingFrame((FrameVertex2DSupplier)polygonB);
        this.framePolygonB.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        result.clear();
        result.addVertices((Vertex2DSupplier)this.framePolygonA);
        result.addVertices((Vertex2DSupplier)this.framePolygonB);
        result.update();
    }

    private void computeToePolygon(FrameConvexPolygon2DBasics toePolygon, ConvexPolygon2DReadOnly fullPolygonInSole, ReferenceFrame soleFrame) {
        int i;
        double maxX = Double.NEGATIVE_INFINITY;
        for (i = 0; i < fullPolygonInSole.getNumberOfVertices(); ++i) {
            double x = fullPolygonInSole.getVertex(i).getX();
            maxX = Math.max(maxX, x);
        }
        toePolygon.clear(soleFrame);
        for (i = 0; i < fullPolygonInSole.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = fullPolygonInSole.getVertex(i);
            if (!Precision.equals((double)vertex.getX(), (double)maxX, (double)0.01)) continue;
            toePolygon.addVertex(vertex);
        }
        toePolygon.update();
    }

    private void computeHeelPolygon(FrameConvexPolygon2DBasics heelPolygon, ConvexPolygon2DReadOnly fullPolygonInSole, ReferenceFrame soleFrame) {
        int i;
        double minX = Double.POSITIVE_INFINITY;
        for (i = 0; i < fullPolygonInSole.getNumberOfVertices(); ++i) {
            double x = fullPolygonInSole.getVertex(i).getX();
            minX = Math.min(minX, x);
        }
        heelPolygon.clear(soleFrame);
        for (i = 0; i < fullPolygonInSole.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = fullPolygonInSole.getVertex(i);
            if (!Precision.equals((double)vertex.getX(), (double)minX, (double)0.01)) continue;
            heelPolygon.addVertex(vertex);
        }
        heelPolygon.update();
    }

    private void computeAdjustedSole(FixedFramePose3DBasics solePose, FramePose3DReadOnly footholdPose, Tuple2DReadOnly soleToHeel) {
        solePose.checkReferenceFrameMatch((ReferenceFrameHolder)footholdPose);
        this.orientationError.set((QuaternionReadOnly)solePose.getOrientation());
        this.orientationError.multiplyConjugateThis((QuaternionReadOnly)footholdPose.getOrientation());
        EuclidCoreMissingTools.projectRotationOnAxis((QuaternionReadOnly)this.orientationError, (Vector3DReadOnly)this.zAxis, (QuaternionBasics)this.rotation);
        this.rotation.conjugate();
        solePose.appendTranslation(soleToHeel.getX(), soleToHeel.getY(), 0.0);
        solePose.appendRotation((Orientation3DReadOnly)this.orientationError);
        solePose.appendRotation((Orientation3DReadOnly)this.rotation);
        solePose.appendTranslation(-soleToHeel.getX(), -soleToHeel.getY(), 0.0);
    }

    private boolean shouldDoToeOff(ReferenceFrame stanceFrame, ReferenceFrame swingFootStartFrame) {
        this.stepLocation.setToZero(swingFootStartFrame);
        this.stepLocation.changeFrame(stanceFrame);
        return this.stepLocation.getX() < -0.05;
    }

    private void reset() {
        this.supportPolygons.clear();
        this.supportInitialTimes.reset();
        for (RobotSide robotSide : RobotSide.values) {
            ((RecyclingArrayList)this.footSupportSequences.get((Enum)robotSide)).clear();
            ((TDoubleArrayList)this.footSupportInitialTimes.get((Enum)robotSide)).reset();
            ((RecyclingArrayList)this.stepFrames.get((Enum)robotSide)).clear();
        }
    }

    private void updateViz() {
        int i;
        int max = Math.min(this.vizPolygons.size(), this.supportPolygons.size());
        for (i = 0; i < max; ++i) {
            this.vizPolygons.get(i).set((Vertex2DSupplier)this.supportPolygons.get(i));
            this.polygonStartTimes.get(i).set(this.supportInitialTimes.get(i));
        }
        for (i = max; i < this.vizPolygons.size(); ++i) {
            this.vizPolygons.get(i).setToNaN();
            this.polygonStartTimes.get(i).set(-1.0);
        }
    }

    private static void extractSupportPolygon(Footstep footstep, ConvexPolygon2DBasics footSupportPolygonToPack, ConvexPolygon2DReadOnly defaultSupportPolygon) {
        List predictedContactPoints = footstep.getPredictedContactPoints();
        if (predictedContactPoints != null && !predictedContactPoints.isEmpty()) {
            footSupportPolygonToPack.clear();
            for (int i = 0; i < predictedContactPoints.size(); ++i) {
                footSupportPolygonToPack.addVertex((Point2DReadOnly)predictedContactPoints.get(i));
            }
            footSupportPolygonToPack.update();
        } else {
            footSupportPolygonToPack.set((Vertex2DSupplier)defaultSupportPolygon);
        }
    }

    private static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    private static double last(TDoubleList list) {
        return list.get(list.size() - 1);
    }
}

