/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.DynamicPlanningFootstep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PushRecoveryState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.tools.saveableModule.YoSaveableModule;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PushRecoveryCoPTrajectoryGenerator
extends YoSaveableModule<PushRecoveryState> {
    private static final double continuityDuration = 0.1;
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(SettableContactStateProvider::new);
    private final SideDependentList<FrameConvexPolygon2D> movingPolygonsInSole = new SideDependentList((Object)new FrameConvexPolygon2D(), (Object)new FrameConvexPolygon2D());
    private final PoseReferenceFrame stepFrame = new PoseReferenceFrame("StepFrame", ReferenceFrame.getWorldFrame());
    private final PoseReferenceFrame stanceFrame = new PoseReferenceFrame("StanceFrame", ReferenceFrame.getWorldFrame());
    private final ConvexPolygon2D defaultSupportPolygon = new ConvexPolygon2D();
    private final FrameConvexPolygon2DBasics nextPolygon = new FrameConvexPolygon2D();
    private final FrameLine2D intersectionLine = new FrameLine2D();
    private final FramePoint2D firstIntersection = new FramePoint2D();
    private final FramePoint2D secondIntersection = new FramePoint2D();
    private final FramePoint2D stanceCMP = new FramePoint2D();
    private final FramePoint3D nextCMP = new FramePoint3D();
    private final FramePoint2D startICP = new FramePoint2D();

    public PushRecoveryCoPTrajectoryGenerator(ConvexPolygon2DReadOnly defaultSupportPolygon, YoRegistry parentRegistry) {
        super(PushRecoveryCoPTrajectoryGenerator.class, parentRegistry);
        this.defaultSupportPolygon.set((Vertex2DSupplier)defaultSupportPolygon);
    }

    public void clear() {
        this.contactStateProviders.clear();
    }

    public List<SettableContactStateProvider> getContactStateProviders() {
        return this.contactStateProviders;
    }

    public void compute(PushRecoveryState state) {
        this.contactStateProviders.clear();
        DynamicPlanningFootstep recoveryFootstep = state.getFootstep(0);
        RobotSide swingSide = recoveryFootstep.getRobotSide();
        RobotSide stanceSide = swingSide.getOppositeSide();
        FrameConvexPolygon2DBasics swingPolygon = (FrameConvexPolygon2DBasics)this.movingPolygonsInSole.get((Enum)swingSide);
        FrameConvexPolygon2DBasics stancePolygon = (FrameConvexPolygon2DBasics)this.movingPolygonsInSole.get((Enum)stanceSide);
        this.stanceFrame.setPoseAndUpdate(state.getFootPose(stanceSide));
        this.stepFrame.setPoseAndUpdate(recoveryFootstep.getFootstepPose());
        PushRecoveryCoPTrajectoryGenerator.extractSupportPolygon(recoveryFootstep, (ReferenceFrame)this.stepFrame, this.nextPolygon, (ConvexPolygon2DReadOnly)this.defaultSupportPolygon);
        swingPolygon.setIncludingFrame((FrameVertex2DSupplier)this.nextPolygon);
        swingPolygon.changeFrameAndProjectToXYPlane(ReferenceFrame.getWorldFrame());
        stancePolygon.setIncludingFrame((FrameVertex2DSupplier)state.getFootPolygonInSole(stanceSide));
        stancePolygon.changeFrameAndProjectToXYPlane((ReferenceFrame)this.stanceFrame);
        this.stanceCMP.setToZero((ReferenceFrame)this.stanceFrame);
        this.intersectionLine.setIncludingFrame(swingPolygon.getCentroid(), state.getIcpAtStartOfState());
        this.intersectionLine.changeFrame((ReferenceFrame)this.stanceFrame);
        int intersections = stancePolygon.intersectionWithRay((FrameLine2DReadOnly)this.intersectionLine, (FramePoint2DBasics)this.firstIntersection, (FramePoint2DBasics)this.secondIntersection);
        if (intersections == 0) {
            stancePolygon.getClosestVertex((FrameLine2DReadOnly)this.intersectionLine, (FramePoint2DBasics)this.stanceCMP);
        } else if (intersections == 1) {
            this.stanceCMP.setIncludingFrame((FrameTuple2DReadOnly)this.firstIntersection);
        } else {
            this.startICP.setIncludingFrame((FrameTuple2DReadOnly)state.getIcpAtStartOfState());
            this.startICP.changeFrameAndProjectToXYPlane((ReferenceFrame)this.stanceFrame);
            if (this.firstIntersection.distanceSquared((FramePoint2DReadOnly)this.startICP) < this.secondIntersection.distanceSquared((FramePoint2DReadOnly)this.startICP)) {
                this.stanceCMP.set(this.firstIntersection);
            } else {
                this.stanceCMP.set(this.secondIntersection);
            }
        }
        this.nextCMP.setIncludingFrame((FrameTuple2DReadOnly)this.stanceCMP, 0.0);
        this.nextCMP.changeFrame(ReferenceFrame.getWorldFrame());
        double currentTime = 0.0;
        SettableContactStateProvider swingContactState = (SettableContactStateProvider)this.contactStateProviders.add();
        swingContactState.reset();
        swingContactState.setContactState(ContactState.IN_CONTACT);
        swingContactState.getTimeInterval().setInterval(currentTime, currentTime + 0.1);
        swingContactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        swingContactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        swingContactState.setLinearECMPVelocity();
        swingContactState = (SettableContactStateProvider)this.contactStateProviders.add();
        swingContactState.reset();
        swingContactState.setContactState(ContactState.IN_CONTACT);
        swingContactState.getTimeInterval().setInterval(currentTime + 0.1, currentTime + state.getTiming(0).getSwingTime());
        swingContactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        swingContactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        swingContactState.setLinearECMPVelocity();
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setContactState(ContactState.IN_CONTACT);
        contactState.getTimeInterval().setInterval(currentTime += state.getTiming(0).getSwingTime(), currentTime + state.getTiming(0).getTransferTime());
        contactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        this.nextCMP.setIncludingFrame((FrameTuple3DReadOnly)recoveryFootstep.getFootstepPose().getPosition());
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        contactState.setLinearECMPVelocity();
        currentTime += state.getTiming(0).getTransferTime();
        for (int i = 1; i < state.getNumberOfFootsteps(); ++i) {
            recoveryFootstep = state.getFootstep(i);
            contactState = (SettableContactStateProvider)this.contactStateProviders.add();
            contactState.reset();
            contactState.setContactState(ContactState.IN_CONTACT);
            contactState.getTimeInterval().setInterval(currentTime, currentTime + state.getTiming(i).getSwingTime());
            contactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
            contactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
            contactState.setLinearECMPVelocity();
            contactState = (SettableContactStateProvider)this.contactStateProviders.add();
            contactState.reset();
            contactState.setContactState(ContactState.IN_CONTACT);
            contactState.getTimeInterval().setInterval(currentTime += state.getTiming(i).getSwingTime(), currentTime + state.getTiming(i).getTransferTime());
            contactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
            this.nextCMP.setIncludingFrame((FrameTuple3DReadOnly)recoveryFootstep.getFootstepPose().getPosition());
            contactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
            contactState.setLinearECMPVelocity();
            currentTime += state.getTiming(i).getTransferTime();
        }
        contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.reset();
        contactState.setContactState(ContactState.IN_CONTACT);
        contactState.getTimeInterval().setInterval(currentTime, currentTime + state.getFinalTransferDuration());
        contactState.setStartECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        contactState.setEndECMPPosition((FramePoint3DReadOnly)this.nextCMP);
        contactState.setLinearECMPVelocity();
    }

    private static void extractSupportPolygon(DynamicPlanningFootstep footstep, ReferenceFrame stepFrame, FrameConvexPolygon2DBasics footSupportPolygonToPack, ConvexPolygon2DReadOnly defaultSupportPolygon) {
        if (footstep.hasPredictedContactPoints()) {
            List<? extends Point2DReadOnly> predictedContactPoints = footstep.getPredictedContactPoints();
            footSupportPolygonToPack.clear(stepFrame);
            for (int i = 0; i < predictedContactPoints.size(); ++i) {
                footSupportPolygonToPack.addVertex(predictedContactPoints.get(i));
            }
            footSupportPolygonToPack.update();
        } else {
            footSupportPolygonToPack.setIncludingFrame(stepFrame, (Vertex2DSupplier)defaultSupportPolygon);
        }
    }
}

