/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.DynamicPlanningFootstep;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.PlanningTiming;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingGoalVariable;
import us.ihmc.commons.InterpolationTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.trajectorypoints.SE3TrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.interfaces.EuclideanTrajectoryPointBasics;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootTrajectoryPredictor {
    private static final double defaultSwingHeight = 0.15;
    private static final double defaultPredictorWaypointProportion = 0.25;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final MultipleWaypointsPositionTrajectoryGenerator leftFootTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("leftFootPredictedTrajectory", ReferenceFrame.getWorldFrame(), this.registry);
    private final MultipleWaypointsPositionTrajectoryGenerator rightFootTrajectory = new MultipleWaypointsPositionTrajectoryGenerator("rightFootPredictedTrajectory", ReferenceFrame.getWorldFrame(), this.registry);
    private final SideDependentList<MultipleWaypointsPositionTrajectoryGenerator> footTrajectories = new SideDependentList((Object)this.leftFootTrajectory, (Object)this.rightFootTrajectory);
    private final DoubleProvider predictorSwingHeight = new DoubleParameter("predictorSwingHeight", this.registry, 0.15);
    private final DoubleProvider predictorWaypointProportion = new DoubleParameter("predictorWaypointProportion", this.registry, 0.25);
    private final SideDependentList<RecyclingArrayList<SE3TrajectoryPoint>> swingWaypoints = new SideDependentList((Object)new RecyclingArrayList(SE3TrajectoryPoint::new), (Object)new RecyclingArrayList(SE3TrajectoryPoint::new));
    private final FramePose3D midFootPosition = new FramePose3D();
    private final FramePose3D midstancePose = new FramePose3D();
    private final PoseReferenceFrame midstanceFrame = new PoseReferenceFrame("midstanceFrame", ReferenceFrame.getWorldFrame());
    private final ZUpFrame midstanceZUpFrame = new ZUpFrame(ReferenceFrame.getWorldFrame(), (ReferenceFrame)this.midstanceFrame, "midstanceZUpFrame");
    private final FramePose3D goalPose = new FramePose3D();
    private final PoseReferenceFrame goalPoseFrame = new PoseReferenceFrame("goalPoseFrame", ReferenceFrame.getWorldFrame());
    private final FramePoint3D footGoalPosition = new FramePoint3D();
    private final FrameVector3DReadOnly zeroVector = new FrameVector3D();
    private final FramePoint3D midpoint1 = new FramePoint3D();
    private final FramePoint3D midpoint2 = new FramePoint3D();
    private final FrameVector3D velocityVector1 = new FrameVector3D();
    private final FrameVector3D velocityVector2 = new FrameVector3D();

    public FootTrajectoryPredictor(YoRegistry parentRegistry) {
        parentRegistry.addChild(this.registry);
    }

    public void setSwingTrajectory(RobotSide swingSide, MultipleWaypointsPoseTrajectoryGenerator swingTrajectory) {
        if (swingTrajectory == null) {
            return;
        }
        RecyclingArrayList swingWaypointsToUse = (RecyclingArrayList)this.swingWaypoints.get((Enum)swingSide);
        swingWaypointsToUse.clear();
        for (int i = 0; i < swingTrajectory.getPositionTrajectory().getCurrentNumberOfWaypoints(); ++i) {
            ((SE3TrajectoryPoint)swingWaypointsToUse.add()).set((EuclideanTrajectoryPointBasics)swingTrajectory.getPositionTrajectory().getWaypoint(i));
        }
    }

    public void clearSwingTrajectory() {
        for (RobotSide robotSide : RobotSide.values) {
            ((RecyclingArrayList)this.swingWaypoints.get((Enum)robotSide)).clear();
        }
    }

    public void compute(CoPTrajectoryGeneratorState state) {
        if (state.getNumberOfFootstep() > 0) {
            this.computeWalking(state);
        } else {
            this.computeStanding(state);
        }
    }

    public void compute(JumpingCoPTrajectoryGeneratorState state) {
        if (Double.isNaN(state.getJumpingGoal().getGoalLength())) {
            this.computeJumpingStanding(state);
        } else {
            this.computeJumping(state);
        }
    }

    private void computeStanding(CoPTrajectoryGeneratorState state) {
        this.clearSwingTrajectory();
        for (RobotSide robotSide : RobotSide.values) {
            MultipleWaypointsPositionTrajectoryGenerator footTrajectory = (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide);
            footTrajectory.clear();
            footTrajectory.appendWaypoint(0.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.appendWaypoint(10.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.initialize();
        }
    }

    private void computeJumpingStanding(JumpingCoPTrajectoryGeneratorState state) {
        this.clearSwingTrajectory();
        for (RobotSide robotSide : RobotSide.values) {
            MultipleWaypointsPositionTrajectoryGenerator footTrajectory = (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide);
            footTrajectory.clear();
            footTrajectory.appendWaypoint(0.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.appendWaypoint(10.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.initialize();
        }
    }

    private void computeWalking(CoPTrajectoryGeneratorState state) {
        PlanningTiming timing = state.getTiming(0);
        DynamicPlanningFootstep footstep = state.getFootstep(0);
        double transferDuration = Math.min(timing.getTransferTime(), 10.0);
        double swingDuration = Math.min(timing.getSwingTime(), 10.0);
        for (RobotSide robotSide : RobotSide.values) {
            MultipleWaypointsPositionTrajectoryGenerator footTrajectory = (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide);
            footTrajectory.clear();
            footTrajectory.appendWaypoint(0.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.appendWaypoint(transferDuration, state.getFootPose(robotSide).getPosition(), this.zeroVector);
        }
        RobotSide swingSide = footstep.getRobotSide();
        RobotSide stanceSide = swingSide.getOppositeSide();
        RecyclingArrayList swingWaypointsToUse = (RecyclingArrayList)this.swingWaypoints.get((Enum)stanceSide.getOppositeSide());
        ((MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)stanceSide)).appendWaypoint(transferDuration + swingDuration, state.getFootPose(stanceSide).getPosition(), this.zeroVector);
        if (swingWaypointsToUse.isEmpty()) {
            this.predictSwingFootTrajectory(transferDuration, transferDuration + swingDuration, this.predictorSwingHeight.getValue(), state.getFootPose(swingSide).getPosition(), footstep.getFootstepPose().getPosition(), (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)swingSide));
        } else {
            FootTrajectoryPredictor.setSwingFootTrajectory((List<SE3TrajectoryPoint>)swingWaypointsToUse, (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)swingSide));
        }
        this.leftFootTrajectory.initialize();
        this.rightFootTrajectory.initialize();
    }

    private void computeJumping(JumpingCoPTrajectoryGeneratorState state) {
        JumpingGoalVariable jumpingGoal = state.getJumpingGoal();
        double supportDuration = Math.min(jumpingGoal.getSupportDuration(), 10.0);
        double flightDuration = Math.min(jumpingGoal.getFlightDuration(), 10.0);
        for (RobotSide robotSide : RobotSide.values) {
            MultipleWaypointsPositionTrajectoryGenerator footTrajectory = (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide);
            footTrajectory.clear();
            footTrajectory.appendWaypoint(0.0, state.getFootPose(robotSide).getPosition(), this.zeroVector);
            footTrajectory.appendWaypoint(supportDuration, state.getFootPose(robotSide).getPosition(), this.zeroVector);
        }
        this.midstancePose.interpolate(state.getFootPose(RobotSide.LEFT), state.getFootPose(RobotSide.RIGHT), 0.5);
        this.midstanceFrame.setPoseAndUpdate((FramePose3DReadOnly)this.midstancePose);
        this.midstanceZUpFrame.update();
        this.midFootPosition.setToZero((ReferenceFrame)this.midstanceZUpFrame);
        this.goalPose.setIncludingFrame((FramePose3DReadOnly)this.midFootPosition);
        this.goalPose.setX(jumpingGoal.getGoalLength());
        if (!Double.isNaN(state.getJumpingGoal().getGoalHeight())) {
            this.goalPose.setZ(state.getJumpingGoal().getGoalHeight());
        }
        if (!Double.isNaN(state.getJumpingGoal().getGoalRotation())) {
            this.goalPose.getOrientation().setToYawOrientation(state.getJumpingGoal().getGoalRotation());
        }
        this.goalPose.changeFrame(ReferenceFrame.getWorldFrame());
        this.goalPoseFrame.setPoseAndUpdate((FramePose3DReadOnly)this.goalPose);
        for (RobotSide robotSide : RobotSide.values) {
            RecyclingArrayList swingWaypointsToUse = (RecyclingArrayList)this.swingWaypoints.get((Enum)robotSide);
            if (swingWaypointsToUse.isEmpty()) {
                this.footGoalPosition.setToZero((ReferenceFrame)this.goalPoseFrame);
                double width = !Double.isNaN(state.getJumpingGoal().getGoalFootWidth()) ? 0.5 * state.getJumpingGoal().getGoalFootWidth() : 0.15;
                width = robotSide.negateIfRightSide(width);
                this.footGoalPosition.setY(width);
                this.footGoalPosition.changeFrame(ReferenceFrame.getWorldFrame());
                this.predictSwingFootTrajectory(supportDuration, supportDuration + flightDuration, this.predictorSwingHeight.getValue(), state.getFootPose(robotSide).getPosition(), (FramePoint3DReadOnly)this.footGoalPosition, (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide));
                continue;
            }
            FootTrajectoryPredictor.setSwingFootTrajectory((List<SE3TrajectoryPoint>)swingWaypointsToUse, (MultipleWaypointsPositionTrajectoryGenerator)this.footTrajectories.get((Enum)robotSide));
        }
        this.leftFootTrajectory.initialize();
        this.rightFootTrajectory.initialize();
    }

    public MultipleWaypointsPositionTrajectoryGenerator getPredictedLeftFootTrajectories() {
        return this.leftFootTrajectory;
    }

    public MultipleWaypointsPositionTrajectoryGenerator getPredictedRightFootTrajectories() {
        return this.rightFootTrajectory;
    }

    void predictSwingFootTrajectory(double startTime, double endTime, double swingHeight, FramePoint3DReadOnly startPosition, FramePoint3DReadOnly endPosition, MultipleWaypointsPositionTrajectoryGenerator trajectoryToPack) {
        double time1 = InterpolationTools.linearInterpolate((double)startTime, (double)endTime, (double)this.predictorWaypointProportion.getValue());
        this.midpoint1.interpolate((FrameTuple3DReadOnly)startPosition, (FrameTuple3DReadOnly)endPosition, this.predictorWaypointProportion.getValue());
        this.midpoint1.addZ(swingHeight);
        double time2 = InterpolationTools.linearInterpolate((double)endTime, (double)startTime, (double)this.predictorWaypointProportion.getValue());
        this.midpoint2.interpolate((FrameTuple3DReadOnly)endPosition, (FrameTuple3DReadOnly)startPosition, this.predictorWaypointProportion.getValue());
        this.midpoint2.addZ(swingHeight);
        this.velocityVector1.sub((FrameTuple3DReadOnly)this.midpoint2, (FrameTuple3DReadOnly)startPosition);
        this.velocityVector1.scale(1.0 / (time2 - startTime));
        this.velocityVector2.sub((FrameTuple3DReadOnly)endPosition, (FrameTuple3DReadOnly)this.midpoint1);
        this.velocityVector2.scale(1.0 / (endTime - time1));
        trajectoryToPack.appendWaypoint(time1, (FramePoint3DReadOnly)this.midpoint1, (FrameVector3DReadOnly)this.velocityVector1);
        trajectoryToPack.appendWaypoint(time2, (FramePoint3DReadOnly)this.midpoint2, (FrameVector3DReadOnly)this.velocityVector2);
        trajectoryToPack.appendWaypoint(endTime, endPosition, this.zeroVector);
    }

    private static void setSwingFootTrajectory(List<SE3TrajectoryPoint> swingWaypoints, MultipleWaypointsPositionTrajectoryGenerator trajectoriesToPack) {
        double timeShift = trajectoriesToPack.getLastWaypointTime() - swingWaypoints.get(0).getTime();
        for (int waypointIdx = 0; waypointIdx < swingWaypoints.size(); ++waypointIdx) {
            SE3TrajectoryPoint waypoint = swingWaypoints.get(waypointIdx);
            trajectoriesToPack.appendWaypoint(waypoint.getTime() + timeShift, waypoint.getPosition(), waypoint.getLinearVelocity());
        }
    }
}

