/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateBasics;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ECMPTrajectoryCalculator<T extends ContactStateBasics<T>> {
    private static final boolean debug = false;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final RecyclingArrayList<T> contactStateProviders;
    private final double weight;
    private static final int maxPoints = 20;
    private final List<YoFrameVector2D> ecmpStartOffsets = new ArrayList<YoFrameVector2D>();
    private final List<YoFrameVector2D> ecmpEndOffsets = new ArrayList<YoFrameVector2D>();
    private final FramePoint3D ecmpPosition = new FramePoint3D();
    private final FrameVector3D ecmpVelocity = new FrameVector3D();
    private final FrameVector2D offset = new FrameVector2D();

    public ECMPTrajectoryCalculator(double mass, double gravity, Supplier<T> contactStateSupplier, YoRegistry parentRegistry) {
        gravity = Math.abs(gravity);
        this.contactStateProviders = new RecyclingArrayList(contactStateSupplier);
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        for (int i = 0; i < 20; ++i) {
            YoFrameVector2D ecmpStartOffset = new YoFrameVector2D("ecmpStartOffset" + i, worldFrame, registry);
            YoFrameVector2D ecmpEndOffset = new YoFrameVector2D("ecmpEndOffset" + i, worldFrame, registry);
            ecmpStartOffset.setToNaN();
            ecmpEndOffset.setToNaN();
            this.ecmpStartOffsets.add(ecmpStartOffset);
            this.ecmpEndOffsets.add(ecmpEndOffset);
        }
        parentRegistry.addChild(registry);
        this.weight = mass * gravity;
    }

    public List<T> computeECMPTrajectory(List<T> copTrajectories, MultipleSegmentPositionTrajectoryGenerator<?> desiredAngularMomentumTrajectories) {
        int i;
        this.contactStateProviders.clear();
        int length = copTrajectories.size();
        for (i = 0; i < length; ++i) {
            ((ContactStateBasics)this.contactStateProviders.add()).set((ContactStateBasics)copTrajectories.get(i));
        }
        for (i = 0; i < length - 1; ++i) {
            ContactStateBasics copTrajectory = (ContactStateBasics)copTrajectories.get(i);
            double startTime = Math.min(copTrajectory.getTimeInterval().getStartTime(), 10.0);
            double endTime = Math.min(copTrajectory.getTimeInterval().getEndTime(), 10.0);
            if (startTime > desiredAngularMomentumTrajectories.getEndTime() || endTime > desiredAngularMomentumTrajectories.getEndTime()) {
                if (i >= this.ecmpStartOffsets.size()) break;
                this.ecmpStartOffsets.get(i).setToNaN();
                this.ecmpEndOffsets.get(i).setToNaN();
                break;
            }
            ContactStateBasics eCMPTrajectory = (ContactStateBasics)this.contactStateProviders.get(i);
            if (!eCMPTrajectory.getContactState().isLoadBearing()) continue;
            desiredAngularMomentumTrajectories.compute(startTime + 1.0E-8);
            this.computeECMPOffset(desiredAngularMomentumTrajectories.getVelocity(), (FixedFrameVector2DBasics)this.offset);
            this.computeECMPVelocity(copTrajectory.getECMPStartVelocity(), desiredAngularMomentumTrajectories.getAcceleration(), (FixedFrameVector3DBasics)this.ecmpVelocity);
            this.ecmpPosition.set((FrameTuple3DReadOnly)copTrajectory.getECMPStartPosition());
            this.ecmpPosition.add(this.offset.getX(), this.offset.getY(), 0.0);
            if (i < this.ecmpStartOffsets.size()) {
                this.ecmpStartOffsets.get(i).set((FrameTuple2DReadOnly)this.offset);
            }
            eCMPTrajectory.setStartECMPPosition((FramePoint3DReadOnly)this.ecmpPosition);
            eCMPTrajectory.setStartECMPVelocity((FrameVector3DReadOnly)this.ecmpVelocity);
            desiredAngularMomentumTrajectories.compute(endTime - 1.0E-8);
            this.computeECMPOffset(desiredAngularMomentumTrajectories.getVelocity(), (FixedFrameVector2DBasics)this.offset);
            this.computeECMPVelocity(copTrajectory.getECMPEndVelocity(), desiredAngularMomentumTrajectories.getAcceleration(), (FixedFrameVector3DBasics)this.ecmpVelocity);
            this.ecmpPosition.set((FrameTuple3DReadOnly)copTrajectory.getECMPEndPosition());
            this.ecmpPosition.add(this.offset.getX(), this.offset.getY(), 0.0);
            if (i < this.ecmpEndOffsets.size()) {
                this.ecmpEndOffsets.get(i).set((FrameTuple2DReadOnly)this.offset);
            }
            eCMPTrajectory.setEndECMPPosition((FramePoint3DReadOnly)this.ecmpPosition);
            eCMPTrajectory.setEndECMPVelocity((FrameVector3DReadOnly)this.ecmpVelocity);
        }
        while (i < 20) {
            this.ecmpStartOffsets.get(i).setToNaN();
            this.ecmpEndOffsets.get(i).setToNaN();
            ++i;
        }
        return this.contactStateProviders;
    }

    public void computeCoPPosition(FramePoint3DReadOnly desiredECMPPosition, FrameVector3DReadOnly desiredAngularMomentumRate, FixedFramePoint3DBasics copPositionToPack) {
        copPositionToPack.setX(desiredAngularMomentumRate.getY());
        copPositionToPack.setY(-desiredAngularMomentumRate.getX());
        copPositionToPack.scale(-1.0 / this.weight);
        copPositionToPack.add((FrameTuple3DReadOnly)desiredECMPPosition);
    }

    public void computeECMPOffset(FrameVector3DReadOnly desiredAngularMomentumRate, FixedFrameVector2DBasics ecmpOffsetToPack) {
        ecmpOffsetToPack.setX(desiredAngularMomentumRate.getY());
        ecmpOffsetToPack.setY(-desiredAngularMomentumRate.getX());
        ecmpOffsetToPack.scale(1.0 / this.weight);
    }

    public void computeECMPVelocity(FrameVector3DReadOnly desiredCopVelocity, FrameVector3DReadOnly desiredAngularMomentumAcceleration, FixedFrameVector3DBasics ecmpVelocityToPack) {
        ecmpVelocityToPack.setX(desiredAngularMomentumAcceleration.getY());
        ecmpVelocityToPack.setY(-desiredAngularMomentumAcceleration.getX());
        ecmpVelocityToPack.scale(1.0 / this.weight);
        ecmpVelocityToPack.add((FrameTuple3DReadOnly)desiredCopVelocity);
    }

    public RecyclingArrayList<T> getContactStateProviders() {
        return this.contactStateProviders;
    }
}

