/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import gnu.trove.list.TDoubleList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.SupportSequence;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.SettableContactStateProvider;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.graphicsDescription.yoGraphics.plotting.YoArtifactPosition;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CopTrajectory {
    private final RecyclingArrayList<SettableContactStateProvider> contactStateProviders = new RecyclingArrayList(50, SettableContactStateProvider::new);
    private final List<YoFramePoint2D> yoWaypoints = new ArrayList<YoFramePoint2D>();
    private final LineSegment2D tempLine = new LineSegment2D();
    private final Point2D waypoint = new Point2D();

    public CopTrajectory() {
        this(null, null);
    }

    public CopTrajectory(YoRegistry parentRegistry, YoGraphicsListRegistry graphicsRegistry) {
        int i;
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        for (i = 0; i < 10; ++i) {
            this.yoWaypoints.add(new YoFramePoint2D("CopWaypoint" + i, ReferenceFrame.getWorldFrame(), registry));
        }
        if (graphicsRegistry != null) {
            for (i = 0; i < this.yoWaypoints.size(); ++i) {
                YoArtifactPosition artifact = new YoArtifactPosition("CopWaypoint" + i, this.yoWaypoints.get(i), YoGraphicPosition.GraphicType.DIAMOND, Color.GREEN, 0.002);
                graphicsRegistry.registerArtifact("CopWaypoints", (Artifact)artifact);
            }
        }
        if (parentRegistry != null) {
            parentRegistry.addChild(registry);
        }
    }

    public void set(Point2DReadOnly constantCop) {
        this.clear();
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        contactState.getTimeInterval().setInterval(0.0, Double.POSITIVE_INFINITY);
        contactState.setStartECMPPosition(constantCop, 0.0);
        contactState.setEndECMPPosition(constantCop, 0.0);
        this.updateViz();
    }

    public void set(List<ConvexPolygon2D> supportPolygons, TDoubleList supportTimes, double finalTransferDuration) {
        this.update(supportPolygons, supportTimes, finalTransferDuration);
    }

    public void update(SupportSequence supportSeqence, double finalTransferDuration) {
        this.update(supportSeqence.getSupportPolygons(), supportSeqence.getSupportTimes(), finalTransferDuration);
    }

    public void update(List<? extends ConvexPolygon2DReadOnly> supportPolygons, TDoubleList supportTimes, double finalTransferDuration) {
        this.clear();
        Point2DReadOnly centroid = supportPolygons.get(0).getCentroid();
        SettableContactStateProvider contactStateProvider = (SettableContactStateProvider)this.contactStateProviders.add();
        contactStateProvider.setStartECMPPosition(centroid, 0.0);
        contactStateProvider.getTimeInterval().setStartTime(0.0);
        for (int i = 1; i < supportPolygons.size(); ++i) {
            this.addPolygon(supportPolygons, supportTimes, i);
        }
        ((SettableContactStateProvider)this.contactStateProviders.getLast()).setEndECMPPosition(supportPolygons.get(supportPolygons.size() - 1).getCentroid(), 0.0);
        ((SettableContactStateProvider)this.contactStateProviders.getLast()).getTimeInterval().setEndTime(supportTimes.get(supportTimes.size() - 1) + finalTransferDuration);
        this.updateViz();
    }

    private void addPolygon(List<? extends ConvexPolygon2DReadOnly> supportPolygons, TDoubleList supportTimes, int i) {
        ConvexPolygon2DReadOnly previousPolygon = supportPolygons.get(i - 1);
        ConvexPolygon2DReadOnly polygon = supportPolygons.get(i);
        Point2DReadOnly centroid = polygon.getCentroid();
        SettableContactStateProvider previousContactState = (SettableContactStateProvider)this.contactStateProviders.getLast();
        SettableContactStateProvider contactState = (SettableContactStateProvider)this.contactStateProviders.add();
        previousContactState.getTimeInterval().setEndTime(supportTimes.get(i));
        contactState.getTimeInterval().setStartTime(supportTimes.get(i));
        this.waypoint.set((Tuple2DReadOnly)centroid);
        if (!previousPolygon.isPointInside((Point2DReadOnly)this.waypoint)) {
            this.tempLine.set(previousPolygon.getCentroid(), centroid);
            previousPolygon.intersectionWith((LineSegment2DReadOnly)this.tempLine, (Point2DBasics)this.waypoint, (Point2DBasics)this.waypoint);
        }
        previousContactState.setEndECMPPosition((Point2DReadOnly)this.waypoint, 0.0);
        contactState.setStartECMPPosition((Point2DReadOnly)this.waypoint, 0.0);
    }

    public List<? extends ContactStateProvider> getContactStates() {
        return this.contactStateProviders;
    }

    private void updateViz() {
        int i;
        int max = Math.min(this.yoWaypoints.size(), this.contactStateProviders.size());
        for (i = 0; i < max; ++i) {
            this.yoWaypoints.get(i).set((FrameTuple3DReadOnly)((SettableContactStateProvider)this.contactStateProviders.get(i)).getECMPStartPosition());
        }
        for (i = max; i < this.yoWaypoints.size(); ++i) {
            this.yoWaypoints.get(i).setToNaN();
        }
    }

    private void clear() {
        this.contactStateProviders.clear();
    }
}

