/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateProvider;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class CoPPointViewer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double size = 0.0075;
    private static final int maxPoints = 20;
    private final List<YoFramePoint3D> copStartPoints = new ArrayList<YoFramePoint3D>();
    private final List<YoFramePoint3D> copEndPoints = new ArrayList<YoFramePoint3D>();
    private static final String name = "Corner Points";

    public CoPPointViewer(YoRegistry registry, YoGraphicsListRegistry yoGraphicsListRegistry) {
        for (int i = 0; i < 20; ++i) {
            YoFramePoint3D copStartPoint = new YoFramePoint3D("copStartPoint" + i, worldFrame, registry);
            YoFramePoint3D copEndPoint = new YoFramePoint3D("copEndPoint" + i, worldFrame, registry);
            copStartPoint.setToNaN();
            copEndPoint.setToNaN();
            this.copStartPoints.add(copStartPoint);
            this.copEndPoints.add(copEndPoint);
            YoGraphicPosition copStartPointGraphic = new YoGraphicPosition("copStartPoint" + i, copStartPoint, 0.0075, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.CROSS);
            YoGraphicPosition copEndPointGraphic = new YoGraphicPosition("copEndPoint" + i, copEndPoint, 0.0075, YoAppearance.DarkRed(), YoGraphicPosition.GraphicType.ROTATED_CROSS);
            yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)copStartPointGraphic);
            yoGraphicsListRegistry.registerYoGraphic(name, (YoGraphic)copEndPointGraphic);
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)copStartPointGraphic.createArtifact());
            yoGraphicsListRegistry.registerArtifact(name, (Artifact)copEndPointGraphic.createArtifact());
        }
    }

    public void updateWaypoints(List<? extends ContactStateProvider> vrpSegments) {
        int i;
        for (i = 0; i < Math.min(vrpSegments.size(), 20); ++i) {
            this.copStartPoints.get(i).set((FrameTuple3DReadOnly)vrpSegments.get(i).getECMPStartPosition());
            this.copEndPoints.get(i).set((FrameTuple3DReadOnly)vrpSegments.get(i).getECMPEndPosition());
        }
        while (i < 20) {
            this.copStartPoints.get(i).setToNaN();
            this.copEndPoints.get(i).setToNaN();
            ++i;
        }
    }
}

