/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;

public class BipedStep {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private RobotSide robotSide = RobotSide.LEFT;
    private FixedFramePose3DBasics goalPose = new FramePose3D(worldFrame);
    private final RecyclingArrayList<Point2D> predictedContactPoints = new RecyclingArrayList(6, Point2D.class);
    private double swingHeight = 0.0;

    public BipedStep() {
        this.predictedContactPoints.clear();
    }

    public BipedStep(RobotSide robotSide, FramePose3D goalPose, double groundClearance) {
        this(robotSide, goalPose, groundClearance, null);
    }

    public BipedStep(RobotSide robotSide, FramePose3D goalPose, double groundClearance, List<Point2D> predictedContactPoints) {
        this.setRobotSide(robotSide);
        this.setGoalPose((FramePose3DReadOnly)goalPose);
        this.setSwingHeight(groundClearance);
        this.setPredictedContactPoints(predictedContactPoints);
    }

    public RobotSide getRobotSide() {
        return this.robotSide;
    }

    public FramePose3DReadOnly getGoalPose() {
        return this.goalPose;
    }

    public double getSwingHeight() {
        return this.swingHeight;
    }

    public List<Point2D> getPredictedContactPoints() {
        if (this.predictedContactPoints.isEmpty()) {
            return null;
        }
        return this.predictedContactPoints;
    }

    public void set(BipedStep other) {
        this.setRobotSide(other.getRobotSide());
        this.setGoalPose(other.getGoalPose());
        this.setSwingHeight(other.getSwingHeight());
        this.setPredictedContactPoints(other.getPredictedContactPoints());
    }

    public void setRobotSide(RobotSide robotSide) {
        this.robotSide = robotSide;
    }

    public void setGoalPose(FramePose3DReadOnly goalPose) {
        this.goalPose.setMatchingFrame(goalPose);
    }

    public void setGoalPose(FramePoint3DReadOnly goalPosition, FrameOrientation3DReadOnly goalOrientation) {
        this.goalPose.set((FrameTuple3DReadOnly)goalPosition, goalOrientation);
    }

    public void setSwingHeight(double swingHeight) {
        this.swingHeight = swingHeight;
    }

    public void setPredictedContactPoints(List<? extends Point2DReadOnly> contactPointList) {
        this.predictedContactPoints.clear();
        if (contactPointList == null) {
            return;
        }
        for (int i = 0; i < contactPointList.size(); ++i) {
            Point2DReadOnly point = contactPointList.get(i);
            ((Point2D)this.predictedContactPoints.add()).set((Tuple2DReadOnly)point);
        }
    }

    public String toString() {
        String string = super.toString();
        string = string + "\nrobotSide: " + this.getRobotSide();
        string = string + "\ngoalPose:" + this.getGoalPose();
        string = string + "\nswingHeight: " + this.getSwingHeight();
        List<Point2D> predictedContacts = this.getPredictedContactPoints();
        if (predictedContacts != null) {
            string = string + "\npredictedContacts: " + predictedContacts;
        }
        return string;
    }
}

