/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning;

import java.util.List;
import java.util.function.Supplier;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.CoPTrajectoryGeneratorState;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.ECMPTrajectoryCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.bipedPlanning.ThreePotatoAngularMomentumCalculator;
import us.ihmc.commonWalkingControlModules.dynamicPlanning.comPlanning.ContactStateBasics;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.jumpingController.JumpingCoPTrajectoryGeneratorState;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.mecano.algorithms.CenterOfMassJacobian;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotics.math.trajectories.FixedFramePolynomialEstimator3D;
import us.ihmc.robotics.math.trajectories.generators.MultipleSegmentPositionTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.generators.MultipleWaypointsPoseTrajectoryGenerator;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotics.time.TimeIntervalProvider;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AngularMomentumHandler<T extends ContactStateBasics<T>> {
    private final ECMPTrajectoryCalculator<T> ecmpTrajectoryCalculator;
    private final ThreePotatoAngularMomentumCalculator angularMomentumCalculator;
    private final YoFrameVector2D desiredECMPOffset;

    public AngularMomentumHandler(double totalMass, double gravity, CenterOfMassJacobian centerOfMassJacobian, SideDependentList<MovingReferenceFrame> soleFrames, Supplier<T> contactSupplier, YoRegistry parentRegistry, YoGraphicsListRegistry graphicsListRegistry) {
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        DoubleParameter potatoMassFraction = new DoubleParameter("potatoMassFraction", registry, 0.05);
        this.desiredECMPOffset = new YoFrameVector2D("desiredCMPOffset", ReferenceFrame.getWorldFrame(), registry);
        this.ecmpTrajectoryCalculator = new ECMPTrajectoryCalculator<T>(totalMass, gravity, contactSupplier, registry);
        this.angularMomentumCalculator = new ThreePotatoAngularMomentumCalculator(totalMass, (DoubleProvider)potatoMassFraction, gravity, centerOfMassJacobian, soleFrames, registry, graphicsListRegistry);
        parentRegistry.addChild(registry);
    }

    public void setSwingFootTrajectory(RobotSide swingSide, MultipleWaypointsPoseTrajectoryGenerator swingFootTrajectory) {
        this.angularMomentumCalculator.setSwingTrajectory(swingSide, swingFootTrajectory);
    }

    public void clearSwingFootTrajectory() {
        this.angularMomentumCalculator.clearSwingTrajectory();
    }

    public void resetAngularMomentum() {
        this.angularMomentumCalculator.reset();
    }

    public void computeAngularMomentum(double time) {
        this.angularMomentumCalculator.computeAngularMomentum(time);
        FrameVector3DReadOnly desiredAngularMomentumRate = this.angularMomentumCalculator.useHeightScaledAngularMomentum() ? this.angularMomentumCalculator.getDesiredHeightScaledAngularMomentumRate() : this.angularMomentumCalculator.getDesiredAngularMomentumRate();
        this.ecmpTrajectoryCalculator.computeECMPOffset(desiredAngularMomentumRate, (FixedFrameVector2DBasics)this.desiredECMPOffset);
    }

    public void solveForAngularMomentumTrajectory(CoPTrajectoryGeneratorState state, List<? extends TimeIntervalProvider> timeIntervals, MultipleSegmentPositionTrajectoryGenerator<?> comTrajectory) {
        this.angularMomentumCalculator.predictFootTrajectories(state);
        this.angularMomentumCalculator.computeAngularMomentumTrajectories(timeIntervals, comTrajectory);
    }

    public void solveForAngularMomentumTrajectory(JumpingCoPTrajectoryGeneratorState state, List<? extends TimeIntervalProvider> timeIntervals, MultipleSegmentPositionTrajectoryGenerator<?> comTrajectory) {
        this.angularMomentumCalculator.predictFootTrajectories(state);
        this.angularMomentumCalculator.computeAngularMomentumTrajectories(timeIntervals, comTrajectory);
    }

    public List<T> computeECMPTrajectory(List<T> copTrajectories) {
        MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> trajectory = this.angularMomentumCalculator.useHeightScaledAngularMomentum() ? this.angularMomentumCalculator.getHeightScaledAngularMomentumTrajectories() : this.angularMomentumCalculator.getAngularMomentumTrajectories();
        return this.ecmpTrajectoryCalculator.computeECMPTrajectory(copTrajectories, trajectory);
    }

    public void computeCoPPosition(FramePoint3DReadOnly desiredECMPPosition, FixedFramePoint3DBasics copPositionToPack) {
        copPositionToPack.set((FrameTuple3DReadOnly)desiredECMPPosition);
        copPositionToPack.subX(this.desiredECMPOffset.getX());
        copPositionToPack.subY(this.desiredECMPOffset.getY());
    }

    public MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> getAngularMomentumTrajectories() {
        return this.angularMomentumCalculator.getAngularMomentumTrajectories();
    }

    public MultipleSegmentPositionTrajectoryGenerator<FixedFramePolynomialEstimator3D> getHeightScaledAngularMomentumTrajectories() {
        return this.angularMomentumCalculator.getHeightScaledAngularMomentumTrajectories();
    }

    public FrameVector3DReadOnly getDesiredAngularMomentum() {
        return this.angularMomentumCalculator.getDesiredAngularMomentum();
    }

    public FrameVector3DReadOnly getHeightScaledDesiredAngularMomentum() {
        return this.angularMomentumCalculator.getDesiredHeightScaledAngularMomentum();
    }

    public FrameVector3DReadOnly getDesiredAngularMomentumRate() {
        return this.angularMomentumCalculator.getDesiredAngularMomentumRate();
    }

    public FrameVector3DReadOnly getDesiredHeightScaledAngularMomentumRate() {
        return this.angularMomentumCalculator.getDesiredHeightScaledAngularMomentumRate();
    }
}

