/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator;

import controller_msgs.msg.dds.FootstepDataListMessage;
import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableObject;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.commonWalkingControlModules.desiredFootStep.FootstepVisualizer;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.AlternateStepChooser;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredTurningVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.DesiredVelocityProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootPoseProvider;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepAdjustment;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepMessenger;
import us.ihmc.commonWalkingControlModules.desiredFootStep.footstepGenerator.FootstepValidityIndicator;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.robotics.contactable.ContactableBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector2D;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class ContinuousStepGenerator
implements Updatable {
    private static final int MAX_NUMBER_OF_FOOTSTEP_TO_VISUALIZE_PER_SIDE = 3;
    public static final Color defaultLeftColor = new Color(28, 134, 238);
    public static final Color defaultRightColor = new Color(205, 133, 0);
    public static final SideDependentList<Color> defaultFeetColors = new SideDependentList((Object)defaultLeftColor, (Object)defaultRightColor);
    private static final Vector2DReadOnly zero2D = new Vector2D();
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final String variableNameSuffix = "CSG";
    private final YoBoolean walk = new YoBoolean("walkCSG", this.registry);
    private final YoBoolean walkPreviousValue = new YoBoolean("walkPreviousValueCSG", this.registry);
    private final YoEnum<RobotSide> currentSupportSide = new YoEnum("currentSupportSideCSG", this.registry, RobotSide.class);
    private final YoFramePose3D currentSupportFootPose = new YoFramePose3D("currentSupportFootPoseCSG", worldFrame, this.registry);
    private final YoInteger numberOfFootstepsToPlan = new YoInteger("numberOfFootstepsToPlanCSG", this.registry);
    private final YoDouble inPlaceWidth = new YoDouble("inPlaceWidthCSG", this.registry);
    private final YoDouble minStepWidth = new YoDouble("minStepWidthCSG", this.registry);
    private final YoDouble maxStepWidth = new YoDouble("maxStepWidthCSG", this.registry);
    private final YoDouble maxStepLength = new YoDouble("maxStepLengthCSG", this.registry);
    private final YoDouble maxAngleTurnOutwards = new YoDouble("maxAngleTurnOutwardsCSG", this.registry);
    private final YoDouble maxAngleTurnInwards = new YoDouble("maxAngleTurnInwardsCSG", this.registry);
    private final YoDouble swingTime = new YoDouble("swingTimeCSG", this.registry);
    private final YoDouble transferTime = new YoDouble("transferTimeCSG", this.registry);
    private final DoubleProvider stepTime = () -> this.swingTime.getDoubleValue() + this.transferTime.getDoubleValue();
    private final YoInteger numberOfTicksBeforeSubmittingFootsteps = new YoInteger("numberOfTicksBeforeSubmittingFootstepsCSG", this.registry);
    private FootPoseProvider footPoseProvider;
    private DesiredVelocityProvider desiredVelocityProvider = () -> zero2D;
    private DesiredTurningVelocityProvider desiredTurningVelocityProvider = () -> 0.0;
    private FootstepMessenger footstepMessenger;
    private FootstepAdjustment footstepAdjustment;
    private List<FootstepValidityIndicator> footstepValidityIndicators = new ArrayList<FootstepValidityIndicator>();
    private AlternateStepChooser alternateStepChooser = this::calculateSquareUpStep;
    private final FootstepDataListMessage footstepDataListMessage = new FootstepDataListMessage();
    private final RecyclingArrayList<FootstepDataMessage> footsteps = this.footstepDataListMessage.getFootstepDataList();
    private final FootstepDataMessage firstFootstep = new FootstepDataMessage();
    private final SideDependentList<List<FootstepVisualizer>> footstepSideDependentVisualizers = new SideDependentList(new ArrayList(), new ArrayList());
    private final MutableObject<FootstepStatus> latestStatusReceived = new MutableObject(null);
    private final MutableObject<RobotSide> footstepCompletionSide = new MutableObject(null);
    private final FramePose2D footstepPose2D = new FramePose2D();
    private final FramePose2D nextFootstepPose2D = new FramePose2D();
    private final FramePose3D nextFootstepPose3D = new FramePose3D();
    private final FramePose3D previousFootstepPose = new FramePose3D();
    private final FramePose3D nextFootstepPose3DViz = new FramePose3D();
    private boolean updateFirstFootstep = true;
    private int counter = 0;
    private final FramePose2D alternateStepPose2D = new FramePose2D();

    public ContinuousStepGenerator() {
        this(null);
    }

    public ContinuousStepGenerator(YoRegistry parentRegistry) {
        if (parentRegistry != null) {
            parentRegistry.addChild(this.registry);
        }
        this.numberOfFootstepsToPlan.set(4);
        this.minStepWidth.set(0.0);
        this.maxStepWidth.set(Double.POSITIVE_INFINITY);
        this.maxStepLength.set(Double.POSITIVE_INFINITY);
        this.maxAngleTurnOutwards.set(1.5707963267948966);
        this.maxAngleTurnInwards.set(-1.5707963267948966);
        this.numberOfTicksBeforeSubmittingFootsteps.set(2);
        this.setSupportFootBasedFootstepAdjustment(true);
    }

    @Override
    public void update(double time) {
        RobotSide swingSide;
        int startIndex;
        FootstepStatus statusToProcess;
        if (!this.walk.getValue()) {
            this.updateFirstFootstep = true;
            this.walkPreviousValue.set(false);
            return;
        }
        if (this.walk.getValue() != this.walkPreviousValue.getValue()) {
            this.currentSupportFootPose.setMatchingFrame(this.footPoseProvider.getCurrentFootPose((RobotSide)this.currentSupportSide.getEnumValue()));
            this.counter = this.numberOfTicksBeforeSubmittingFootsteps.getValue();
        }
        if ((statusToProcess = (FootstepStatus)this.latestStatusReceived.getValue()) != null) {
            if (statusToProcess == FootstepStatus.STARTED) {
                if (!this.footsteps.isEmpty()) {
                    this.footsteps.remove(0);
                }
                if (!this.footsteps.isEmpty()) {
                    this.firstFootstep.set((FootstepDataMessage)this.footsteps.get(0));
                }
            } else if (statusToProcess == FootstepStatus.COMPLETED) {
                this.updateFirstFootstep = true;
                this.currentSupportSide.set((Enum)((RobotSide)this.footstepCompletionSide.getValue()));
                this.currentSupportFootPose.setMatchingFrame(this.footPoseProvider.getCurrentFootPose((RobotSide)this.currentSupportSide.getEnumValue()));
            }
        }
        this.latestStatusReceived.setValue(null);
        this.footstepCompletionSide.setValue(null);
        this.footstepDataListMessage.setDefaultSwingDuration(this.swingTime.getValue());
        this.footstepDataListMessage.setDefaultTransferDuration(this.transferTime.getValue());
        this.footstepDataListMessage.setFinalTransferDuration(this.transferTime.getValue());
        int n = startIndex = this.updateFirstFootstep ? 0 : 1;
        if (this.updateFirstFootstep) {
            this.footsteps.clear();
            this.footstepPose2D.set((FramePose3DReadOnly)this.currentSupportFootPose);
            swingSide = ((RobotSide)this.currentSupportSide.getEnumValue()).getOppositeSide();
            this.previousFootstepPose.set((FramePose3DReadOnly)this.currentSupportFootPose);
        } else {
            while (this.footsteps.size() > 1) {
                this.footsteps.fastRemove(this.footsteps.size() - 1);
            }
            this.footstepPose2D.getPosition().set((Tuple3DReadOnly)this.firstFootstep.getLocation());
            this.footstepPose2D.getOrientation().set((Orientation3DReadOnly)this.firstFootstep.getOrientation());
            swingSide = RobotSide.fromByte((byte)this.firstFootstep.getRobotSide()).getOppositeSide();
            this.previousFootstepPose.set((Tuple3DReadOnly)this.firstFootstep.getLocation(), (Orientation3DReadOnly)this.firstFootstep.getOrientation());
        }
        for (int i = startIndex; i < this.numberOfFootstepsToPlan.getValue(); ++i) {
            List footstepVisualizers;
            int vizualizerIndex;
            Vector2DReadOnly desiredVelocity = this.desiredVelocityProvider.getDesiredVelocity();
            double xDisplacement = MathTools.clamp((double)(this.stepTime.getValue() * desiredVelocity.getX()), (double)this.maxStepLength.getValue());
            double yDisplacement = this.stepTime.getValue() * desiredVelocity.getY() + swingSide.negateIfRightSide(this.inPlaceWidth.getValue());
            double headingDisplacement = this.stepTime.getValue() * this.desiredTurningVelocityProvider.getTurningVelocity();
            if (swingSide == RobotSide.LEFT) {
                yDisplacement = MathTools.clamp((double)yDisplacement, (double)this.minStepWidth.getValue(), (double)this.maxStepWidth.getValue());
                headingDisplacement = MathTools.clamp((double)headingDisplacement, (double)this.maxAngleTurnInwards.getValue(), (double)this.maxAngleTurnOutwards.getValue());
            } else {
                yDisplacement = MathTools.clamp((double)yDisplacement, (double)(-this.maxStepWidth.getValue()), (double)(-this.minStepWidth.getValue()));
                headingDisplacement = MathTools.clamp((double)headingDisplacement, (double)(-this.maxAngleTurnOutwards.getValue()), (double)(-this.maxAngleTurnInwards.getValue()));
            }
            double halfInPlaceWidth = 0.5 * swingSide.negateIfRightSide(this.inPlaceWidth.getValue());
            this.nextFootstepPose2D.set(this.footstepPose2D);
            this.nextFootstepPose2D.appendTranslation(0.0, halfInPlaceWidth);
            this.nextFootstepPose2D.appendRotation(headingDisplacement);
            this.nextFootstepPose2D.appendTranslation(0.0, -halfInPlaceWidth);
            this.nextFootstepPose2D.appendTranslation(xDisplacement, yDisplacement);
            this.nextFootstepPose3D.set(this.footstepAdjustment.adjustFootstep((FramePose2DReadOnly)this.nextFootstepPose2D, swingSide));
            if (!this.isStepValid((FramePose3DReadOnly)this.nextFootstepPose3D, (FramePose3DReadOnly)this.previousFootstepPose, swingSide)) {
                this.alternateStepChooser.computeStep((FramePose2DReadOnly)this.footstepPose2D, (FramePose2DReadOnly)this.nextFootstepPose2D, swingSide, this.nextFootstepPose3D);
                this.nextFootstepPose2D.set((FramePose3DReadOnly)this.nextFootstepPose3D);
            }
            if ((vizualizerIndex = i / 2) < (footstepVisualizers = (List)this.footstepSideDependentVisualizers.get((Enum)swingSide)).size()) {
                FootstepVisualizer footstepVisualizer = (FootstepVisualizer)footstepVisualizers.get(vizualizerIndex);
                this.nextFootstepPose3DViz.setIncludingFrame((FramePose3DReadOnly)this.nextFootstepPose3D);
                this.nextFootstepPose3DViz.appendTranslation(0.0, 0.0, -0.005);
                footstepVisualizer.update((FramePose3DReadOnly)this.nextFootstepPose3DViz);
            }
            FootstepDataMessage footstep = (FootstepDataMessage)this.footsteps.add();
            footstep.setRobotSide(swingSide.toByte());
            footstep.getLocation().set((Tuple3DReadOnly)this.nextFootstepPose3D.getPosition());
            footstep.getOrientation().set((QuaternionReadOnly)this.nextFootstepPose3D.getOrientation());
            this.footstepPose2D.set(this.nextFootstepPose2D);
            swingSide = swingSide.getOppositeSide();
            this.previousFootstepPose.set(this.nextFootstepPose3D);
        }
        if (this.updateFirstFootstep) {
            this.firstFootstep.set((FootstepDataMessage)this.footsteps.get(0));
            this.updateFirstFootstep = false;
        }
        if (this.footstepMessenger != null) {
            if (this.counter >= this.numberOfTicksBeforeSubmittingFootsteps.getValue()) {
                this.footstepMessenger.submitFootsteps(this.footstepDataListMessage);
                this.counter = 0;
            } else {
                ++this.counter;
            }
        }
        this.walkPreviousValue.set(this.walk.getValue());
    }

    public void setNumberOfFootstepsToPlan(int number) {
        this.numberOfFootstepsToPlan.set(number);
    }

    public void setNumberOfTicksBeforeSubmittingFootsteps(int numberOfTicks) {
        this.numberOfTicksBeforeSubmittingFootsteps.set(numberOfTicks);
    }

    public void setFootstepTiming(double swingTime, double transferTime) {
        this.swingTime.set(swingTime);
        this.transferTime.set(transferTime);
    }

    public void setDesiredTurningVelocityProvider(DesiredTurningVelocityProvider desiredTurningVelocityProvider) {
        this.desiredTurningVelocityProvider = desiredTurningVelocityProvider;
    }

    public void setDesiredVelocityProvider(DesiredVelocityProvider desiredVelocityProvider) {
        this.desiredVelocityProvider = desiredVelocityProvider;
    }

    public void setYoComponentProviders() {
        DoubleParameter desiredTurningVelocity = new DoubleParameter("desiredTurningVelocityCSG", this.registry, 0.0);
        YoFrameVector2D desiredVelocity = new YoFrameVector2D("desiredVelocityCSG", worldFrame, this.registry);
        this.setDesiredTurningVelocityProvider(() -> desiredTurningVelocity.getValue());
        this.setDesiredVelocityProvider(() -> desiredVelocity);
    }

    public void setFootPoseProvider(FootPoseProvider footPoseProvider) {
        this.footPoseProvider = footPoseProvider;
    }

    public void setFrameBasedFootPoseProvider(final SideDependentList<? extends ReferenceFrame> soleFrames) {
        this.setFootPoseProvider(new FootPoseProvider(){
            private final FramePose3D currentFootPose = new FramePose3D();

            @Override
            public FramePose3DReadOnly getCurrentFootPose(RobotSide robotSide) {
                this.currentFootPose.setFromReferenceFrame((ReferenceFrame)soleFrames.get((Enum)robotSide));
                return this.currentFootPose;
            }
        });
    }

    public void notifyFootstepCompleted(RobotSide robotSide) {
        this.latestStatusReceived.setValue((Object)FootstepStatus.COMPLETED);
        this.footstepCompletionSide.setValue((Object)robotSide);
    }

    public void notifyFootstepStarted() {
        this.latestStatusReceived.setValue((Object)FootstepStatus.STARTED);
        this.footstepCompletionSide.setValue(null);
    }

    public void setFootstepStatusListener(StatusMessageOutputManager statusMessageOutputManager) {
        statusMessageOutputManager.attachStatusMessageListener(FootstepStatusMessage.class, this::consumeFootstepStatus);
    }

    public void consumeFootstepStatus(FootstepStatusMessage statusMessage) {
        FootstepStatus status = FootstepStatus.fromByte((byte)statusMessage.getFootstepStatus());
        if (status == FootstepStatus.COMPLETED) {
            this.notifyFootstepCompleted(RobotSide.fromByte((byte)statusMessage.getRobotSide()));
        } else if (status == FootstepStatus.STARTED) {
            this.notifyFootstepStarted();
        }
    }

    public void configureWith(WalkingControllerParameters walkingControllerParameters) {
        this.setFootstepTiming(walkingControllerParameters.getDefaultSwingTime(), walkingControllerParameters.getDefaultFinalTransferTime());
        SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
        this.setStepWidths(steppingParameters.getInPlaceWidth(), steppingParameters.getMinStepWidth(), steppingParameters.getMaxStepWidth());
        this.setMaxStepLength(steppingParameters.getMaxStepLength());
        this.setStepTurningLimits(steppingParameters.getMaxAngleTurnInwards(), steppingParameters.getMaxAngleTurnOutwards());
    }

    public void setStepWidths(double inPlace, double min, double max) {
        this.inPlaceWidth.set(inPlace);
        this.minStepWidth.set(min);
        this.maxStepWidth.set(max);
    }

    public void setMaxStepLength(double max) {
        this.maxStepLength.set(max);
    }

    public void setStepTurningLimits(double maxInwards, double maxOutwards) {
        this.maxAngleTurnInwards.set(maxInwards);
        this.maxAngleTurnOutwards.set(maxOutwards);
    }

    public void setFootstepMessenger(FootstepMessenger footstepMessenger) {
        this.footstepMessenger = footstepMessenger;
    }

    public void setFootstepAdjustment(FootstepAdjustment footstepAdjustment) {
        this.footstepAdjustment = footstepAdjustment;
    }

    public void addFootstepValidityIndicator(FootstepValidityIndicator footstepValidityIndicator) {
        this.footstepValidityIndicators.add(footstepValidityIndicator);
    }

    public void setAlternateStepChooser(AlternateStepChooser alternateStepChooser) {
        this.alternateStepChooser = alternateStepChooser;
    }

    public void setSupportFootBasedFootstepAdjustment(final boolean adjustPitchAndRoll) {
        this.setFootstepAdjustment(new FootstepAdjustment(){
            private final YawPitchRoll yawPitchRoll = new YawPitchRoll();
            private final FramePose3D adjustedPose = new FramePose3D();

            @Override
            public FramePose3DReadOnly adjustFootstep(FramePose2DReadOnly footstepPose, RobotSide footSide) {
                this.adjustedPose.getPosition().set((FrameTuple2DReadOnly)footstepPose.getPosition());
                this.adjustedPose.setZ(ContinuousStepGenerator.this.currentSupportFootPose.getZ());
                if (adjustPitchAndRoll) {
                    this.yawPitchRoll.set((Orientation3DReadOnly)ContinuousStepGenerator.this.currentSupportFootPose.getOrientation());
                    this.yawPitchRoll.setYaw(footstepPose.getYaw());
                    this.adjustedPose.getOrientation().set((Orientation3DReadOnly)this.yawPitchRoll);
                } else {
                    this.adjustedPose.getOrientation().set(footstepPose.getOrientation());
                }
                return this.adjustedPose;
            }
        });
    }

    public void setHeightMapBasedFootstepAdjustment(final HeightMap heightMap) {
        this.setFootstepAdjustment(new FootstepAdjustment(){
            private final YawPitchRoll yawPitchRoll = new YawPitchRoll();
            private final FramePose3D adjustedPose = new FramePose3D();

            @Override
            public FramePose3DReadOnly adjustFootstep(FramePose2DReadOnly footstepPose, RobotSide footSide) {
                this.adjustedPose.getPosition().set((FrameTuple2DReadOnly)footstepPose.getPosition());
                this.adjustedPose.setZ(heightMap.heightAt(footstepPose.getX(), footstepPose.getY(), 0.0));
                this.yawPitchRoll.set((Orientation3DReadOnly)ContinuousStepGenerator.this.currentSupportFootPose.getOrientation());
                this.yawPitchRoll.setYaw(footstepPose.getYaw());
                this.adjustedPose.getOrientation().set((Orientation3DReadOnly)this.yawPitchRoll);
                return this.adjustedPose;
            }
        });
    }

    public void toggleWalking() {
        this.walk.set(!this.walk.getValue());
    }

    public void startWalking() {
        this.walk.set(true);
    }

    public void stopWalking() {
        this.walk.set(false);
    }

    public boolean isWalking() {
        return this.walk.getBooleanValue();
    }

    public void setupVisualization(YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.setupVisualization(FootstepVisualizer.createTrapezoidalFootPolygon(0.12, 0.15, 0.25), yoGraphicsListRegistry);
    }

    public void setupVisualization(List<? extends Point2DReadOnly> footPolygon, YoGraphicsListRegistry yoGraphicsListRegistry) {
        this.setupVisualization(footPolygon, footPolygon, yoGraphicsListRegistry);
    }

    public void setupVisualization(SideDependentList<? extends ContactableBody> contactableFeet, YoGraphicsListRegistry yoGraphicsListRegistry) {
        List leftFoot = ((ContactableBody)contactableFeet.get((Enum)RobotSide.LEFT)).getContactPointsCopy().stream().map(Point2D::new).collect(Collectors.toList());
        List rightFoot = ((ContactableBody)contactableFeet.get((Enum)RobotSide.RIGHT)).getContactPointsCopy().stream().map(Point2D::new).collect(Collectors.toList());
        this.setupVisualization(leftFoot, rightFoot, yoGraphicsListRegistry);
    }

    public void setupVisualization(List<? extends Point2DReadOnly> leftFootPolygon, List<? extends Point2DReadOnly> rightFootPolygon, YoGraphicsListRegistry yoGraphicsListRegistry) {
        String graphicListName = "FootstepGenerator";
        SideDependentList footPolygons = new SideDependentList(leftFootPolygon, rightFootPolygon);
        for (RobotSide robotSide : RobotSide.values) {
            ArrayList<FootstepVisualizer> visualizers = new ArrayList<FootstepVisualizer>();
            for (int i = 0; i < 3; ++i) {
                String name = robotSide.getCamelCaseNameForStartOfExpression() + "PlannedFootstep" + i;
                YoAppearanceRGBColor footstepColor = new YoAppearanceRGBColor((Color)defaultFeetColors.get((Enum)robotSide), 0.0);
                visualizers.add(new FootstepVisualizer(name, graphicListName, robotSide, (List)footPolygons.get((Enum)robotSide), (AppearanceDefinition)footstepColor, yoGraphicsListRegistry, this.registry));
            }
            this.footstepSideDependentVisualizers.put((Enum)robotSide, visualizers);
        }
    }

    public FramePose3DReadOnly getCurrentSupportFootPose() {
        return this.currentSupportFootPose;
    }

    public RobotSide getCurrentSupportSide() {
        return (RobotSide)this.currentSupportSide.getEnumValue();
    }

    private boolean isStepValid(FramePose3DReadOnly touchdownPose, FramePose3DReadOnly stancePose, RobotSide swingSide) {
        for (int i = 0; i < this.footstepValidityIndicators.size(); ++i) {
            if (this.footstepValidityIndicators.get(i).isFootstepValid(touchdownPose, stancePose, swingSide)) continue;
            return false;
        }
        return true;
    }

    private void calculateSquareUpStep(FramePose2DReadOnly stanceFootPose, FramePose2DReadOnly defaultTouchdownPose, RobotSide swingSide, FramePose3D touchdownPoseToPack) {
        this.alternateStepPose2D.set(stanceFootPose);
        this.alternateStepPose2D.appendTranslation(0.0, swingSide.negateIfRightSide(this.inPlaceWidth.getValue()));
        touchdownPoseToPack.set(this.footstepAdjustment.adjustFootstep((FramePose2DReadOnly)this.alternateStepPose2D, swingSide));
    }
}

