/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep;

import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.WalkingStatusMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commonWalkingControlModules.controllers.Updatable;
import us.ihmc.communication.controllerAPI.CommandInputManager;
import us.ihmc.communication.controllerAPI.StatusMessageOutputManager;
import us.ihmc.communication.controllerAPI.command.Command;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.ChestTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.FootstepDataListCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.HandTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisHeightTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.controllerAPI.command.PelvisTrajectoryCommand;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.humanoidRobotics.communication.packets.walking.WalkingStatus;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.model.RobotMotionStatus;
import us.ihmc.sensorProcessing.model.RobotMotionStatusChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;

public class QueuedControllerCommandGenerator
implements Updatable,
RobotMotionStatusChangedListener {
    private static final boolean DEBUG = false;
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private boolean waitingForWalkingStatusToComplete = false;
    private final CommandInputManager commandInputManager;
    private final StatusMessageOutputManager statusOutputManager;
    private final List<Updatable> updatables = new ArrayList<Updatable>();
    private final ConcurrentLinkedQueue<Command<?, ?>> controllerCommands;
    private boolean robotReady = false;

    public QueuedControllerCommandGenerator(ConcurrentLinkedQueue<Command<?, ?>> controllerCommands, CommandInputManager commandInputManager, StatusMessageOutputManager statusOutputManager, WalkingControllerParameters walkingControllerParameters, CommonHumanoidReferenceFrames referenceFrames, SideDependentList<? extends ContactablePlaneBody> bipedFeet, double controlDT, boolean useHeadingAndVelocityScript, YoRegistry parentRegistry) {
        this.controllerCommands = controllerCommands;
        this.commandInputManager = commandInputManager;
        this.statusOutputManager = statusOutputManager;
        this.createFootstepStatusListener();
        parentRegistry.addChild(this.registry);
        this.updatables.add(this);
    }

    private void pollAndSubmitNextCommandIfReady() {
        if (!this.robotReady) {
            return;
        }
        if (this.waitingForWalkingStatusToComplete) {
            return;
        }
        if (this.controllerCommands.isEmpty()) {
            this.waitingForWalkingStatusToComplete = false;
            return;
        }
        Command<?, ?> controllerCommand = this.controllerCommands.poll();
        if (controllerCommand == null) {
            this.waitingForWalkingStatusToComplete = false;
            return;
        }
        if (controllerCommand instanceof FootstepDataListCommand) {
            FootstepDataListCommand footstepDataListControllerCommand = (FootstepDataListCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)footstepDataListControllerCommand);
            this.waitingForWalkingStatusToComplete = true;
        } else if (controllerCommand instanceof ChestTrajectoryCommand) {
            ChestTrajectoryCommand chestTrajectoryControllerCommand = (ChestTrajectoryCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)chestTrajectoryControllerCommand);
        } else if (controllerCommand instanceof FootTrajectoryCommand) {
            FootTrajectoryCommand footTrajectoryControllerCommand = (FootTrajectoryCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)footTrajectoryControllerCommand);
        } else if (controllerCommand instanceof HandTrajectoryCommand) {
            HandTrajectoryCommand handTrajectoryControllerCommand = (HandTrajectoryCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)handTrajectoryControllerCommand);
        } else if (controllerCommand instanceof PelvisHeightTrajectoryCommand) {
            PelvisHeightTrajectoryCommand pelvisHeightTrajectoryControllerCommand = (PelvisHeightTrajectoryCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)pelvisHeightTrajectoryControllerCommand);
        } else if (controllerCommand instanceof PelvisTrajectoryCommand) {
            PelvisTrajectoryCommand pelvisTrajectoryControllerCommand = (PelvisTrajectoryCommand)controllerCommand;
            this.commandInputManager.submitCommand((Command)pelvisTrajectoryControllerCommand);
        } else {
            System.err.println("QueuedControllerCommandGenerator: No plan for how to deal with commands of type " + controllerCommand.getClass().getSimpleName());
        }
    }

    public void addControllerCommand(Command<?, ?> controllerCommand) {
        this.controllerCommands.add(controllerCommand);
    }

    private void createFootstepStatusListener() {
        StatusMessageOutputManager.StatusMessageListener<FootstepStatusMessage> footstepStatusListener = new StatusMessageOutputManager.StatusMessageListener<FootstepStatusMessage>(){

            public void receivedNewMessageStatus(FootstepStatusMessage footstepStatus) {
                switch (FootstepStatus.fromByte((byte)footstepStatus.getFootstepStatus())) {
                    case COMPLETED: {
                        QueuedControllerCommandGenerator.this.pollAndSubmitNextCommandIfReady();
                    }
                }
            }
        };
        this.statusOutputManager.attachStatusMessageListener(FootstepStatusMessage.class, (StatusMessageOutputManager.StatusMessageListener)footstepStatusListener);
        StatusMessageOutputManager.StatusMessageListener<WalkingStatusMessage> walkingStatusListener = new StatusMessageOutputManager.StatusMessageListener<WalkingStatusMessage>(){

            public void receivedNewMessageStatus(WalkingStatusMessage walkingStatusListener) {
                switch (WalkingStatus.fromByte((byte)walkingStatusListener.getWalkingStatus())) {
                    case COMPLETED: {
                        QueuedControllerCommandGenerator.this.waitingForWalkingStatusToComplete = false;
                    }
                }
            }
        };
        this.statusOutputManager.attachStatusMessageListener(WalkingStatusMessage.class, (StatusMessageOutputManager.StatusMessageListener)walkingStatusListener);
    }

    public List<Updatable> getModulesToUpdate() {
        return this.updatables;
    }

    @Override
    public void update(double time) {
        if (!this.waitingForWalkingStatusToComplete) {
            this.pollAndSubmitNextCommandIfReady();
        }
    }

    public void robotMotionStatusHasChanged(RobotMotionStatus newStatus, double time) {
        if (newStatus == RobotMotionStatus.STANDING) {
            this.robotReady = true;
        }
    }
}

