/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.desiredFootStep;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;
import us.ihmc.commonWalkingControlModules.desiredFootStep.FootstepVisualizer;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceRGBColor;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.footstep.Footstep;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FootstepListVisualizer {
    private static final int maxNumberOfFootstepsToVisualizePerSide = 2;
    public static final Color defaultLeftColor = new Color(0.85f, 0.35f, 0.65f, 1.0f);
    public static final Color defaultRightColor = new Color(0.15f, 0.8f, 0.15f, 1.0f);
    public static final SideDependentList<Color> defaultFeetColors = new SideDependentList((Object)defaultLeftColor, (Object)defaultRightColor);
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SideDependentList<List<FootstepVisualizer>> footstepVisualizers = new SideDependentList();
    private final SideDependentList<MutableInt> counters = new SideDependentList((Object)new MutableInt(0), (Object)new MutableInt(0));

    public FootstepListVisualizer(SideDependentList<? extends ContactablePlaneBody> contactableFeet, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        String graphicListName = "FootstepVisualizer";
        for (RobotSide robotSide : RobotSide.values) {
            ContactablePlaneBody contactableFoot = (ContactablePlaneBody)contactableFeet.get((Enum)robotSide);
            this.footstepVisualizers.put((Enum)robotSide, new ArrayList());
            for (int i = 0; i < 2; ++i) {
                String name = robotSide.getCamelCaseNameForStartOfExpression() + "Footstep" + i;
                YoAppearanceRGBColor footstepColor = new YoAppearanceRGBColor(((Color)defaultFeetColors.get((Enum)robotSide)).darker(), 0.0);
                FootstepVisualizer footstepVisualizer = new FootstepVisualizer(name, graphicListName, robotSide, contactableFoot, (AppearanceDefinition)footstepColor, yoGraphicsListRegistry, this.registry);
                ((List)this.footstepVisualizers.get((Enum)robotSide)).add(footstepVisualizer);
            }
        }
        parentRegistry.addChild(this.registry);
    }

    public void updateFirstFootstep(Footstep firstFootstep) {
        RobotSide robotSide = firstFootstep.getRobotSide();
        if (((MutableInt)this.counters.get((Enum)robotSide)).intValue() < 1) {
            return;
        }
        ((FootstepVisualizer)((List)this.footstepVisualizers.get((Enum)robotSide)).get(0)).update(firstFootstep);
    }

    public void update(List<Footstep> footsteps) {
        for (RobotSide robotSide : RobotSide.values) {
            ((MutableInt)this.counters.get((Enum)robotSide)).setValue(0);
        }
        for (int i = 0; i < footsteps.size(); ++i) {
            Footstep footstep = footsteps.get(i);
            RobotSide robotSide = footstep.getRobotSide();
            MutableInt counter = (MutableInt)this.counters.get((Enum)robotSide);
            if (counter.intValue() >= 2) continue;
            FootstepVisualizer footstepVisualizer = (FootstepVisualizer)((List)this.footstepVisualizers.get((Enum)robotSide)).get(counter.intValue());
            footstepVisualizer.update(footstep);
            counter.increment();
        }
        for (RobotSide robotside : RobotSide.values) {
            for (int i = ((MutableInt)this.counters.get((Enum)robotside)).intValue(); i < 2; ++i) {
                ((FootstepVisualizer)((List)this.footstepVisualizers.get((Enum)robotside)).get(i)).hide();
            }
        }
    }
}

