/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualEffortCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class VirtualWrenchCommand
implements VirtualEffortCommand<VirtualWrenchCommand> {
    private int commandId;
    private final FramePose3D controlFramePose = new FramePose3D();
    private final Vector3D desiredLinearForce = new Vector3D();
    private final Vector3D desiredAngularTorque = new Vector3D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private RigidBodyBasics base;
    private RigidBodyBasics endEffector;

    public void set(VirtualWrenchCommand other) {
        this.commandId = other.commandId;
        this.controlFramePose.setIncludingFrame((FramePose3DReadOnly)other.controlFramePose);
        this.desiredLinearForce.set(other.desiredLinearForce);
        this.desiredAngularTorque.set(other.desiredAngularTorque);
        this.selectionMatrix.set(other.selectionMatrix);
        this.base = other.getBase();
        this.endEffector = other.getEndEffector();
    }

    public void setProperties(SpatialAccelerationCommand command) {
        this.commandId = command.getCommandId();
        command.getSelectionMatrix(this.selectionMatrix);
        this.base = command.getBase();
        this.endEffector = command.getEndEffector();
        command.getControlFramePoseIncludingFrame((FramePose3DBasics)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.base = base;
        this.endEffector = endEffector;
    }

    public void setWrenchToZero(ReferenceFrame controlFrame) {
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.setToZero();
        this.desiredLinearForce.setToZero();
    }

    public void setWrench(ReferenceFrame controlFrame, WrenchReadOnly desiredWrench) {
        desiredWrench.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        desiredWrench.getReferenceFrame().checkReferenceFrameMatch(controlFrame);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.set((Tuple3DReadOnly)desiredWrench.getAngularPart());
        this.desiredLinearForce.set((Tuple3DReadOnly)desiredWrench.getLinearPart());
    }

    public void setWrench(ReferenceFrame controlFrame, FrameVector3D desiredAngularTorque, FrameVector3D desiredLinearForce) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularTorque);
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearForce);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.set((Tuple3DReadOnly)desiredAngularTorque);
        this.desiredLinearForce.set((Tuple3DReadOnly)desiredLinearForce);
    }

    public void setAngularTorque(ReferenceFrame controlFrame, FrameVector3D desiredAngularTorque) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularTorque);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.set((Tuple3DReadOnly)desiredAngularTorque);
        this.desiredLinearForce.setToZero();
    }

    public void setLinearForce(ReferenceFrame controlFrame, FrameVector3D desiredLinearForce) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearForce);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredLinearForce.set((Tuple3DReadOnly)desiredLinearForce);
        this.desiredAngularTorque.setToZero();
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixForLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
    }

    public void setSelectionMatrixForLinearControl(SelectionMatrix3D linearSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setLinearPart(linearSelectionMatrix);
    }

    public void setSelectionMatrixForAngularControl() {
        this.selectionMatrix.setToAngularSelectionOnly();
    }

    public void setSelectionMatrixForAngularControl(SelectionMatrix3D angularSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setAngularPart(angularSelectionMatrix);
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public Vector3DBasics getDesiredLinearForce() {
        return this.desiredLinearForce;
    }

    public Vector3DBasics getDesiredAngularTorque() {
        return this.desiredAngularTorque;
    }

    public void getDesiredWrench(PoseReferenceFrame controlFrameToPack, Wrench desiredWrenchToPack) {
        this.getControlFrame(controlFrameToPack);
        desiredWrenchToPack.setToZero((ReferenceFrame)this.endEffector.getBodyFixedFrame(), (ReferenceFrame)controlFrameToPack);
        desiredWrenchToPack.getLinearPart().set((Tuple3DReadOnly)this.desiredLinearForce);
        desiredWrenchToPack.getAngularPart().set((Tuple3DReadOnly)this.desiredAngularTorque);
    }

    public void getDesiredWrench(DMatrixRMaj desiredWrenchToPack) {
        desiredWrenchToPack.reshape(6, 1);
        this.desiredAngularTorque.get(0, (DMatrix)desiredWrenchToPack);
        this.desiredLinearForce.get(3, (DMatrix)desiredWrenchToPack);
    }

    @Override
    public void getDesiredEffort(DMatrixRMaj desiredWrenchToPack) {
        this.getDesiredWrench(desiredWrenchToPack);
    }

    public FramePose3DBasics getControlFramePose() {
        return this.controlFramePose;
    }

    @Override
    public void getControlFrame(PoseReferenceFrame controlFrameToPack) {
        this.controlFramePose.changeFrame(controlFrameToPack.getParent());
        controlFrameToPack.setPoseAndUpdate((FramePose3DReadOnly)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void getControlFramePoseIncludingFrame(FramePose3D controlFramePoseToPack) {
        controlFramePoseToPack.setIncludingFrame((FramePose3DReadOnly)this.controlFramePose);
    }

    public void getControlFramePoseIncludingFrame(FramePoint3D positionToPack, FrameQuaternion orientationToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.controlFramePose.getPosition());
        orientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.controlFramePose.getOrientation());
    }

    @Override
    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    @Override
    public RigidBodyBasics getBase() {
        return this.base;
    }

    @Override
    public RigidBodyBasics getEndEffector() {
        return this.endEffector;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.VIRTUAL_WRENCH;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof VirtualWrenchCommand) {
            VirtualWrenchCommand other = (VirtualWrenchCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!this.controlFramePose.equals((FramePose3DReadOnly)other.controlFramePose)) {
                return false;
            }
            if (!this.desiredLinearForce.equals((Tuple3DReadOnly)other.desiredLinearForce)) {
                return false;
            }
            if (!this.desiredAngularTorque.equals((Tuple3DReadOnly)other.desiredAngularTorque)) {
                return false;
            }
            if (!this.selectionMatrix.equals((Object)other.selectionMatrix)) {
                return false;
            }
            if (this.base != other.base) {
                return false;
            }
            return this.endEffector == other.endEffector;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": base = " + this.base + ", endEffector = " + this.endEffector + ", linear = " + this.desiredLinearForce + ", angular = " + this.desiredAngularTorque;
    }
}

