/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualEffortCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;

public class VirtualTorqueCommand
implements VirtualEffortCommand<VirtualTorqueCommand> {
    private int commandId;
    private final FramePose3D controlFramePose = new FramePose3D();
    private final Vector3D desiredAngularTorque = new Vector3D();
    private final SelectionMatrix3D selectionMatrix = new SelectionMatrix3D();
    private RigidBodyBasics base;
    private RigidBodyBasics endEffector;

    public void set(VirtualTorqueCommand other) {
        this.commandId = other.commandId;
        this.controlFramePose.setIncludingFrame((FramePose3DReadOnly)other.controlFramePose);
        this.desiredAngularTorque.set(other.desiredAngularTorque);
        this.selectionMatrix.set(other.selectionMatrix);
        this.base = other.getBase();
        this.endEffector = other.getEndEffector();
    }

    public void setProperties(SpatialAccelerationCommand command) {
        this.commandId = command.getCommandId();
        command.getAngularSelectionMatrix(this.selectionMatrix);
        this.base = command.getBase();
        this.endEffector = command.getEndEffector();
        command.getControlFramePoseIncludingFrame((FramePose3DBasics)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.base = base;
        this.endEffector = endEffector;
    }

    public void setAngularTorqueToZero(ReferenceFrame controlFrame) {
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.setToZero();
    }

    public void setAngularTorque(ReferenceFrame controlFrame, WrenchReadOnly desiredWrench) {
        desiredWrench.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        desiredWrench.getReferenceFrame().checkReferenceFrameMatch(controlFrame);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.set((Tuple3DReadOnly)desiredWrench.getAngularPart());
    }

    public void setAngularTorque(ReferenceFrame controlFrame, FrameVector3D desiredAngularTorque) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularTorque);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularTorque.set((Tuple3DReadOnly)desiredAngularTorque);
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixToIdentity(SelectionMatrix3D angularSelectionMatrix) {
        this.selectionMatrix.set(angularSelectionMatrix);
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public Vector3DBasics getDesiredAngularTorque() {
        return this.desiredAngularTorque;
    }

    public void getDesiredAngularTorque(PoseReferenceFrame controlFrameToPack, FrameVector3D desiredAngularTorqueToPack) {
        this.getControlFrame(controlFrameToPack);
        desiredAngularTorqueToPack.setIncludingFrame((ReferenceFrame)controlFrameToPack, (Tuple3DReadOnly)this.desiredAngularTorque);
    }

    public void getDesiredAngularTorque(DMatrixRMaj desiredAngularTorqueToPack) {
        desiredAngularTorqueToPack.reshape(6, 1);
        desiredAngularTorqueToPack.zero();
        this.desiredAngularTorque.get(0, (DMatrix)desiredAngularTorqueToPack);
    }

    public void getDesiredWrench(PoseReferenceFrame controlFrameToPack, Wrench desiredWrenchToPack) {
        this.getControlFrame(controlFrameToPack);
        desiredWrenchToPack.setToZero((ReferenceFrame)this.endEffector.getBodyFixedFrame(), (ReferenceFrame)controlFrameToPack);
        desiredWrenchToPack.getAngularPart().set((Tuple3DReadOnly)this.desiredAngularTorque);
    }

    @Override
    public void getDesiredEffort(DMatrixRMaj desiredEffortToPack) {
        this.getDesiredAngularTorque(desiredEffortToPack);
    }

    public FramePose3DBasics getControlFramePose() {
        return this.controlFramePose;
    }

    @Override
    public void getControlFrame(PoseReferenceFrame controlFrameToPack) {
        this.controlFramePose.changeFrame(controlFrameToPack.getParent());
        controlFrameToPack.setPoseAndUpdate((FramePose3DReadOnly)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void getControlFramePoseIncludingFrame(FramePose3D controlFramePoseToPack) {
        controlFramePoseToPack.setIncludingFrame((FramePose3DReadOnly)this.controlFramePose);
    }

    public void getControlFramePoseIncludingFrame(FramePoint3D positionToPack, FrameQuaternion orientationToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.controlFramePose.getPosition());
        orientationToPack.setIncludingFrame((FrameQuaternionReadOnly)this.controlFramePose.getOrientation());
    }

    public SelectionMatrix3D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    @Override
    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        selectionMatrixToPack.reshape(3, 6);
        selectionMatrixToPack.zero();
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, 0, 0, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.clearSelection();
        selectionMatrixToPack.setAngularPart(this.selectionMatrix);
    }

    @Override
    public RigidBodyBasics getBase() {
        return this.base;
    }

    @Override
    public RigidBodyBasics getEndEffector() {
        return this.endEffector;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.VIRTUAL_TORQUE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof VirtualTorqueCommand) {
            VirtualTorqueCommand other = (VirtualTorqueCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!this.controlFramePose.equals((FramePose3DReadOnly)other.controlFramePose)) {
                return false;
            }
            if (!this.desiredAngularTorque.equals((Tuple3DReadOnly)other.desiredAngularTorque)) {
                return false;
            }
            if (!this.selectionMatrix.equals((Object)other.selectionMatrix)) {
                return false;
            }
            if (this.base != other.base) {
                return false;
            }
            return this.endEffector == other.endEffector;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": base = " + this.base + ", endEffector = " + this.endEffector + ", angular = " + this.desiredAngularTorque;
    }
}

