/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class VirtualModelControlOptimizationSettingsCommand
implements VirtualModelControlCommand<VirtualModelControlOptimizationSettingsCommand> {
    private int commandId;
    private double rhoMin = Double.NaN;
    private double rhoWeight = Double.NaN;
    private double rhoRateWeight = Double.NaN;
    private final Vector2D centerOfPressureWeight = new Vector2D(Double.NaN, Double.NaN);
    private final Vector2D centerOfPressureRateWeight = new Vector2D(Double.NaN, Double.NaN);
    private double momentumRateWeight = Double.NaN;
    private double momentumAccelerationWeight = Double.NaN;

    public void setRhoMin(double rhoMin) {
        this.rhoMin = rhoMin;
    }

    public void setRhoWeight(double rhoWeight) {
        this.rhoWeight = rhoWeight;
    }

    public void setRhoRateWeight(double rhoRateWeight) {
        this.rhoRateWeight = rhoRateWeight;
    }

    public void setCenterOfPressureWeight(Tuple2DReadOnly centerOfPressureWeight) {
        this.centerOfPressureWeight.set(centerOfPressureWeight);
    }

    public void setCenterOfPressureRateWeight(Tuple2DReadOnly centerOfPressureRateWeight) {
        this.centerOfPressureRateWeight.set(centerOfPressureRateWeight);
    }

    public void setMomentumRateWeight(double momentumRateWeight) {
        this.momentumRateWeight = momentumRateWeight;
    }

    public void setMomentumAccelerationWeight(double momentumAccelerationWeight) {
        this.momentumAccelerationWeight = momentumAccelerationWeight;
    }

    public boolean hasRhoMin() {
        return !Double.isNaN(this.rhoMin);
    }

    public boolean hasRhoWeight() {
        return !Double.isNaN(this.rhoWeight);
    }

    public boolean hasRhoRateWeight() {
        return !Double.isNaN(this.rhoRateWeight);
    }

    public boolean hasCenterOfPressureWeight() {
        return !this.centerOfPressureWeight.containsNaN();
    }

    public boolean hasCenterOfPressureRateWeight() {
        return !this.centerOfPressureRateWeight.containsNaN();
    }

    public boolean hasMomentumRateWeight() {
        return !Double.isNaN(this.momentumRateWeight);
    }

    public boolean hasMomentumAccelerationWeight() {
        return !Double.isNaN(this.momentumAccelerationWeight);
    }

    public double getRhoMin() {
        return this.rhoMin;
    }

    public double getRhoWeight() {
        return this.rhoWeight;
    }

    public double getRhoRateWeight() {
        return this.rhoRateWeight;
    }

    public Vector2D getCenterOfPressureWeight() {
        return this.centerOfPressureWeight;
    }

    public Vector2D getCenterOfPressureRateWeight() {
        return this.centerOfPressureRateWeight;
    }

    public double getMomentumRateWeight() {
        return this.momentumRateWeight;
    }

    public double getMomentumAccelerationWeight() {
        return this.momentumAccelerationWeight;
    }

    public void set(VirtualModelControlOptimizationSettingsCommand other) {
        this.commandId = other.commandId;
        this.rhoMin = other.rhoMin;
        this.rhoWeight = other.rhoWeight;
        this.rhoRateWeight = other.rhoRateWeight;
        this.centerOfPressureWeight.set(other.centerOfPressureWeight);
        this.centerOfPressureRateWeight.set(other.centerOfPressureRateWeight);
        this.momentumRateWeight = other.momentumRateWeight;
        this.momentumAccelerationWeight = other.momentumAccelerationWeight;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.OPTIMIZATION_SETTINGS;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof VirtualModelControlOptimizationSettingsCommand) {
            VirtualModelControlOptimizationSettingsCommand other = (VirtualModelControlOptimizationSettingsCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (Double.compare(this.rhoMin, other.rhoMin) != 0) {
                return false;
            }
            if (Double.compare(this.rhoWeight, other.rhoWeight) != 0) {
                return false;
            }
            if (Double.compare(this.rhoRateWeight, other.rhoRateWeight) != 0) {
                return false;
            }
            if (this.centerOfPressureWeight.containsNaN() ^ other.centerOfPressureWeight.containsNaN()) {
                return false;
            }
            if (!this.centerOfPressureWeight.containsNaN() && !this.centerOfPressureWeight.equals((Tuple2DReadOnly)other.centerOfPressureWeight)) {
                return false;
            }
            if (this.centerOfPressureRateWeight.containsNaN() ^ other.centerOfPressureRateWeight.containsNaN()) {
                return false;
            }
            if (!this.centerOfPressureRateWeight.containsNaN() && !this.centerOfPressureRateWeight.equals((Tuple2DReadOnly)other.centerOfPressureRateWeight)) {
                return false;
            }
            if (Double.compare(this.momentumRateWeight, other.momentumRateWeight) != 0) {
                return false;
            }
            return Double.compare(this.momentumAccelerationWeight, other.momentumAccelerationWeight) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": rho min: " + this.rhoMin + ", rho weight: " + this.rhoWeight + ", rho rate weight: " + this.rhoRateWeight + ", CoP weight: " + this.centerOfPressureWeight + ", CoP rate weight: " + this.centerOfPressureRateWeight + ", momentum rate weight: " + this.momentumRateWeight + ", momentum acceleration weight: " + this.momentumAccelerationWeight;
    }
}

