/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel;

import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredLoadMode;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

public class YoJointDesiredOutput
implements JointDesiredOutputBasics {
    private final YoEnum<JointDesiredControlMode> controlMode;
    private final YoEnum<JointDesiredLoadMode> loadMode;
    private final YoDouble desiredTorque;
    private final YoDouble desiredPosition;
    private final YoDouble desiredVelocity;
    private final YoDouble desiredAcceleration;
    private final YoBoolean resetIntegrators;
    private final YoDouble stiffness;
    private final YoDouble damping;
    private final YoDouble masterGain;
    private final YoDouble velocityScaling;
    private final YoDouble velocityIntegrationBreakFrequency;
    private final YoDouble positionIntegrationBreakFrequency;
    private final YoDouble positionIntegrationMaxError;
    private final YoDouble velocityIntegrationMaxError;
    private final YoDouble positionFeedbackMaxError;
    private final YoDouble velocityFeedbackMaxError;

    public YoJointDesiredOutput(String namePrefix, YoRegistry registry, String suffixString) {
        namePrefix = namePrefix + "LowLevel";
        this.controlMode = new YoEnum(namePrefix + "ControlMode" + suffixString, registry, JointDesiredControlMode.class, true);
        this.loadMode = new YoEnum(namePrefix + "LoadMode" + suffixString, registry, JointDesiredLoadMode.class, true);
        this.desiredTorque = new YoDouble(namePrefix + "DesiredTorque" + suffixString, registry);
        this.desiredPosition = new YoDouble(namePrefix + "DesiredPosition" + suffixString, registry);
        this.desiredVelocity = new YoDouble(namePrefix + "DesiredVelocity" + suffixString, registry);
        this.desiredAcceleration = new YoDouble(namePrefix + "DesiredAcceleration" + suffixString, registry);
        this.resetIntegrators = new YoBoolean(namePrefix + "ResetIntegrators" + suffixString, registry);
        this.stiffness = new YoDouble(namePrefix + "Stiffness" + suffixString, registry);
        this.damping = new YoDouble(namePrefix + "Damping" + suffixString, registry);
        this.masterGain = new YoDouble(namePrefix + "MasterGain" + suffixString, registry);
        this.velocityScaling = new YoDouble(namePrefix + "VelocityScaling" + suffixString, registry);
        this.velocityIntegrationBreakFrequency = new YoDouble(namePrefix + "VelocityIntegrationBreakFrequency" + suffixString, registry);
        this.positionIntegrationBreakFrequency = new YoDouble(namePrefix + "PositionIntegrationBreakFrequency" + suffixString, registry);
        this.positionIntegrationMaxError = new YoDouble(namePrefix + "PositionIntegrationMaxError" + suffixString, registry);
        this.velocityIntegrationMaxError = new YoDouble(namePrefix + "VelocityIntegrationMaxError" + suffixString, registry);
        this.positionFeedbackMaxError = new YoDouble(namePrefix + "PositionFeedbackMaxError" + suffixString, registry);
        this.velocityFeedbackMaxError = new YoDouble(namePrefix + "VelocityFeedbackMaxError" + suffixString, registry);
        this.clear();
    }

    public void clear() {
        this.controlMode.set(null);
        this.loadMode.set(null);
        this.desiredTorque.set(Double.NaN);
        this.desiredPosition.set(Double.NaN);
        this.desiredVelocity.set(Double.NaN);
        this.desiredAcceleration.set(Double.NaN);
        this.stiffness.set(Double.NaN);
        this.damping.set(Double.NaN);
        this.masterGain.set(Double.NaN);
        this.velocityScaling.set(Double.NaN);
        this.velocityIntegrationBreakFrequency.set(Double.NaN);
        this.positionIntegrationBreakFrequency.set(Double.NaN);
        this.positionIntegrationMaxError.set(Double.NaN);
        this.velocityIntegrationMaxError.set(Double.NaN);
        this.positionFeedbackMaxError.set(Double.NaN);
        this.velocityFeedbackMaxError.set(Double.NaN);
        this.resetIntegrators.set(false);
    }

    public void setControlMode(JointDesiredControlMode controlMode) {
        this.controlMode.set((Enum)controlMode);
    }

    public void setLoadMode(JointDesiredLoadMode loadMode) {
        this.loadMode.set((Enum)loadMode);
    }

    public void setDesiredTorque(double tau) {
        this.desiredTorque.set(tau);
    }

    public void setDesiredPosition(double q) {
        this.desiredPosition.set(q);
    }

    public void setDesiredVelocity(double qd) {
        this.desiredVelocity.set(qd);
    }

    public void setDesiredAcceleration(double qdd) {
        this.desiredAcceleration.set(qdd);
    }

    public void setResetIntegrators(boolean reset) {
        this.resetIntegrators.set(reset);
    }

    public JointDesiredControlMode getControlMode() {
        return (JointDesiredControlMode)this.controlMode.getEnumValue();
    }

    public JointDesiredLoadMode getLoadMode() {
        return (JointDesiredLoadMode)this.loadMode.getValue();
    }

    public double getDesiredTorque() {
        return this.desiredTorque.getDoubleValue();
    }

    public double getDesiredPosition() {
        return this.desiredPosition.getDoubleValue();
    }

    public double getDesiredVelocity() {
        return this.desiredVelocity.getDoubleValue();
    }

    public double getDesiredAcceleration() {
        return this.desiredAcceleration.getDoubleValue();
    }

    public boolean pollResetIntegratorsRequest() {
        boolean request = this.resetIntegrators.getBooleanValue();
        this.resetIntegrators.set(false);
        return request;
    }

    public boolean peekResetIntegratorsRequest() {
        return this.resetIntegrators.getBooleanValue();
    }

    public double getStiffness() {
        return this.stiffness.getValue();
    }

    public double getDamping() {
        return this.damping.getValue();
    }

    public void setStiffness(double stiffness) {
        this.stiffness.set(stiffness);
    }

    public void setDamping(double damping) {
        this.damping.set(damping);
    }

    public double getMasterGain() {
        return this.masterGain.getDoubleValue();
    }

    public void setMasterGain(double masterGain) {
        this.masterGain.set(masterGain);
    }

    public double getVelocityScaling() {
        return this.velocityScaling.getDoubleValue();
    }

    public void setVelocityScaling(double velocityScaling) {
        this.velocityScaling.set(velocityScaling);
    }

    public double getVelocityIntegrationBreakFrequency() {
        return this.velocityIntegrationBreakFrequency.getDoubleValue();
    }

    public void setVelocityIntegrationBreakFrequency(double velocityIntegrationBreakFrequency) {
        this.velocityIntegrationBreakFrequency.set(velocityIntegrationBreakFrequency);
    }

    public double getPositionIntegrationBreakFrequency() {
        return this.positionIntegrationBreakFrequency.getDoubleValue();
    }

    public void setPositionIntegrationBreakFrequency(double positionIntegrationBreakFrequency) {
        this.positionIntegrationBreakFrequency.set(positionIntegrationBreakFrequency);
    }

    public double getPositionIntegrationMaxError() {
        return this.positionIntegrationMaxError.getDoubleValue();
    }

    public void setPositionIntegrationMaxError(double maxPositionError) {
        this.positionIntegrationMaxError.set(maxPositionError);
    }

    public double getVelocityIntegrationMaxError() {
        return this.velocityIntegrationMaxError.getDoubleValue();
    }

    public void setVelocityIntegrationMaxError(double maxVelocityError) {
        this.velocityIntegrationMaxError.set(maxVelocityError);
    }

    public double getPositionFeedbackMaxError() {
        return this.positionFeedbackMaxError.getValue();
    }

    public void setPositionFeedbackMaxError(double positionFeedbackMaxError) {
        this.positionFeedbackMaxError.set(positionFeedbackMaxError);
    }

    public double getVelocityFeedbackMaxError() {
        return this.velocityFeedbackMaxError.getValue();
    }

    public void setVelocityFeedbackMaxError(double velocityFeedbackMaxError) {
        this.velocityFeedbackMaxError.set(velocityFeedbackMaxError);
    }

    public boolean equals(Object object) {
        if (object instanceof JointDesiredOutputReadOnly) {
            return super.equals((JointDesiredOutputReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.getRepresentativeString();
    }
}

