/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutput;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputReadOnly;

public class LowLevelOneDoFJointDesiredDataHolder
implements JointDesiredOutputListBasics {
    private final List<OneDoFJointReadOnly> joints = new ArrayList<OneDoFJointReadOnly>();
    private final List<JointDesiredOutput> jointOutputs = new ArrayList<JointDesiredOutput>();
    private final transient TLongObjectHashMap<JointDesiredOutput> lowLevelJointDataMap;

    public LowLevelOneDoFJointDesiredDataHolder() {
        this(50);
    }

    public LowLevelOneDoFJointDesiredDataHolder(OneDoFJointReadOnly[] joints) {
        this(joints.length);
        this.registerJointsWithEmptyData(joints);
    }

    public LowLevelOneDoFJointDesiredDataHolder(int initialCapacity) {
        float disableAutoCompaction = 0.0f;
        this.lowLevelJointDataMap = new TLongObjectHashMap(initialCapacity);
        this.lowLevelJointDataMap.setAutoCompactionFactor(disableAutoCompaction);
    }

    public void clear() {
        this.joints.clear();
        this.jointOutputs.clear();
    }

    public void registerJointsWithEmptyData(OneDoFJointReadOnly[] joints) {
        for (OneDoFJointReadOnly joint : joints) {
            this.registerJointWithEmptyData(joint);
        }
    }

    public JointDesiredOutput registerJointWithEmptyData(OneDoFJointReadOnly joint) {
        if (this.joints.contains(joint)) {
            JointDesiredOutputListBasics.throwJointAlreadyRegisteredException((OneDoFJointReadOnly)joint);
        }
        return this.registerJointWithEmptyDataUnsafe(joint);
    }

    private void registerLowLevelJointDataUnsafe(OneDoFJointReadOnly joint, JointDesiredOutputReadOnly jointDataToRegister) {
        JointDesiredOutput jointData = this.registerJointWithEmptyDataUnsafe(joint);
        jointData.set(jointDataToRegister);
    }

    private JointDesiredOutput registerJointWithEmptyDataUnsafe(OneDoFJointReadOnly joint) {
        JointDesiredOutput jointData = (JointDesiredOutput)this.lowLevelJointDataMap.get((long)joint.hashCode());
        if (jointData == null) {
            jointData = new JointDesiredOutput();
            this.lowLevelJointDataMap.put((long)joint.hashCode(), (Object)jointData);
        }
        this.joints.add(joint);
        this.jointOutputs.add(jointData);
        return jointData;
    }

    public boolean hasDataForJoint(OneDoFJointReadOnly joint) {
        return this.joints.contains(joint);
    }

    public OneDoFJointReadOnly getOneDoFJoint(int index) {
        return this.joints.get(index);
    }

    public int getNumberOfJointsWithDesiredOutput() {
        return this.joints.size();
    }

    public JointDesiredOutputBasics getJointDesiredOutputFromHash(int jointHashCode) {
        return (JointDesiredOutputBasics)this.lowLevelJointDataMap.get((long)jointHashCode);
    }

    public JointDesiredOutputBasics getJointDesiredOutput(int index) {
        return (JointDesiredOutputBasics)this.jointOutputs.get(index);
    }

    public void completeWith(JointDesiredOutputListReadOnly other) {
        if (other == null) {
            return;
        }
        for (int i = 0; i < other.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly joint = other.getOneDoFJoint(i);
            JointDesiredOutputReadOnly otherLowLevelJointData = other.getJointDesiredOutput(i);
            if (this.hasDataForJoint(joint)) {
                this.getJointDesiredOutput(joint).completeWith(otherLowLevelJointData);
                continue;
            }
            this.registerLowLevelJointDataUnsafe(joint, otherLowLevelJointData);
        }
    }

    public void overwriteWith(JointDesiredOutputListReadOnly other) {
        this.clear();
        if (other == null) {
            return;
        }
        for (int i = 0; i < other.getNumberOfJointsWithDesiredOutput(); ++i) {
            OneDoFJointReadOnly joint = other.getOneDoFJoint(i);
            this.registerLowLevelJointDataUnsafe(joint, other.getJointDesiredOutput(i));
        }
    }

    public void set(LowLevelOneDoFJointDesiredDataHolder other) {
        this.overwriteWith((JointDesiredOutputListReadOnly)other);
    }

    public boolean equals(Object object) {
        if (object instanceof JointDesiredOutputListReadOnly) {
            return super.equals((JointDesiredOutputListReadOnly)object);
        }
        return false;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this.joints.size(); ++i) {
            OneDoFJointReadOnly joint = this.joints.get(i);
            JointDesiredOutput output = this.jointOutputs.get(i);
            if (i > 0) {
                ret.append("\n");
            }
            ret.append(joint.getName()).append(", ").append(output.getShortRepresentativeString());
        }
        return ret.toString();
    }
}

