/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class PrivilegedJointSpaceCommand
implements InverseKinematicsCommand<PrivilegedJointSpaceCommand>,
InverseDynamicsCommand<PrivilegedJointSpaceCommand> {
    private static final int initialCapacity = 40;
    private int commandId;
    private boolean enable = false;
    private final List<OneDoFJointBasics> joints = new ArrayList<OneDoFJointBasics>(40);
    private final TDoubleArrayList privilegedOneDoFJointCommands = new TDoubleArrayList(40);
    private final TDoubleArrayList weights = new TDoubleArrayList(40);

    public PrivilegedJointSpaceCommand() {
        this.clear();
    }

    public void clear() {
        this.commandId = 0;
        this.enable = false;
        this.joints.clear();
        this.privilegedOneDoFJointCommands.reset();
        this.weights.reset();
    }

    public void disable() {
        this.enable = false;
    }

    public void enable() {
        this.enable = true;
    }

    public void setWeight(int jointIndex, double weight) {
        this.weights.set(jointIndex, weight);
    }

    public void addJoint(OneDoFJointBasics joint, double privilegedAcceleration) {
        this.enable();
        this.joints.add(joint);
        this.privilegedOneDoFJointCommands.add(privilegedAcceleration);
        this.weights.add(Double.NaN);
    }

    public void setOneDoFJoint(int jointIndex, double privilegedAcceleration) {
        this.enable();
        this.privilegedOneDoFJointCommands.set(jointIndex, privilegedAcceleration);
    }

    public void set(PrivilegedJointSpaceCommand other) {
        this.clear();
        this.commandId = other.commandId;
        this.enable = other.enable;
        for (int jointIndex = 0; jointIndex < other.getNumberOfJoints(); ++jointIndex) {
            OneDoFJointBasics joint = other.joints.get(jointIndex);
            this.joints.add(joint);
            this.privilegedOneDoFJointCommands.add(other.privilegedOneDoFJointCommands.get(jointIndex));
            this.weights.add(other.weights.get(jointIndex));
        }
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public boolean hasWeight(int jointIndex) {
        return !Double.isNaN(this.getWeight(jointIndex));
    }

    public double getWeight(int jointIndex) {
        return this.weights.get(jointIndex);
    }

    public boolean hasNewPrivilegedCommand(int jointIndex) {
        return !Double.isNaN(this.privilegedOneDoFJointCommands.get(jointIndex));
    }

    public double getPrivilegedCommand(int jointIndex) {
        return this.privilegedOneDoFJointCommands.get(jointIndex);
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public OneDoFJointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.PRIVILEGED_JOINTSPACE_COMMAND;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PrivilegedJointSpaceCommand) {
            PrivilegedJointSpaceCommand other = (PrivilegedJointSpaceCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) != other.joints.get(jointIndex)) {
                    return false;
                }
                if (Double.compare(this.weights.get(jointIndex), other.weights.get(jointIndex)) == 0) continue;
                return false;
            }
            return this.privilegedOneDoFJointCommands.equals((Object)other.privilegedOneDoFJointCommands);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": enabled: " + this.enable;
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ret = ret + "\nJoint: " + this.joints.get(jointIndex).getName();
            if (this.hasNewPrivilegedCommand(jointIndex)) {
                ret = ret + ", command: " + this.getPrivilegedCommand(jointIndex);
            }
            if (!this.hasWeight(jointIndex)) continue;
            ret = ret + ", weight: " + this.getWeight(jointIndex);
        }
        return ret;
    }
}

