/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class MomentumCommand
implements InverseKinematicsCommand<MomentumCommand> {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private int commandId;
    private final DMatrixRMaj momentum = new DMatrixRMaj(6, 1);
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();

    public MomentumCommand() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public void set(MomentumCommand other) {
        this.commandId = other.commandId;
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
        this.momentum.set((DMatrixD1)other.momentum);
    }

    public void setProperties(MomentumRateCommand command) {
        this.commandId = command.getCommandId();
        this.weightMatrix.set(command.getWeightMatrix());
        command.getSelectionMatrix(this.selectionMatrix);
    }

    public void setMomentumToZero() {
        this.momentum.zero();
    }

    public void setMomentum(DMatrixRMaj momentum) {
        this.momentum.set((DMatrixD1)momentum);
    }

    public void setMomentum(FrameVector3DReadOnly angularMomentum, FrameVector3DReadOnly linearMomentum) {
        angularMomentum.checkReferenceFrameMatch(worldFrame);
        linearMomentum.checkReferenceFrameMatch(worldFrame);
        angularMomentum.get(0, (DMatrix)this.momentum);
        linearMomentum.get(3, (DMatrix)this.momentum);
    }

    public void setAngularMomentum(FrameVector3DReadOnly angularMomentum) {
        angularMomentum.checkReferenceFrameMatch(worldFrame);
        this.momentum.zero();
        angularMomentum.get(0, (DMatrix)this.momentum);
    }

    public void setLinearMomentum(FrameVector3DReadOnly linearMomentum) {
        linearMomentum.checkReferenceFrameMatch(worldFrame);
        this.momentum.zero();
        linearMomentum.get(3, (DMatrix)this.momentum);
    }

    public void setLinearMomentumXY(FrameVector2DReadOnly linearMomentum) {
        linearMomentum.checkReferenceFrameMatch(worldFrame);
        this.momentum.zero();
        linearMomentum.get(3, (DMatrix)this.momentum);
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixForLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
    }

    public void setSelectionMatrixForLinearXYControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
        this.selectionMatrix.selectLinearZ(false);
    }

    public void setSelectionMatrixForAngularControl() {
        this.selectionMatrix.setToAngularSelectionOnly();
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public void setAsHardConstraint() {
        this.setWeight(Double.POSITIVE_INFINITY);
    }

    public void setWeight(double weight) {
        this.weightMatrix.setLinearWeights(weight, weight, weight);
        this.weightMatrix.setAngularWeights(weight, weight, weight);
    }

    public void setWeight(double angular, double linear) {
        this.weightMatrix.setLinearWeights(linear, linear, linear);
        this.weightMatrix.setAngularWeights(angular, angular, angular);
    }

    public void setWeights(double angularX, double angularY, double angularZ, double linearX, double linearY, double linearZ) {
        this.weightMatrix.setLinearWeights(linearX, linearY, linearZ);
        this.weightMatrix.setAngularWeights(angularX, angularY, angularZ);
    }

    public void setWeights(WeightMatrix6D weightMatrix) {
        this.weightMatrix.set(weightMatrix);
    }

    public void setAngularWeights(Tuple3DReadOnly angular) {
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
    }

    public void setLinearWeights(Tuple3DReadOnly linear) {
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
    }

    public void setWeights(Tuple3DReadOnly angular, Tuple3DReadOnly linear) {
        this.setLinearWeights(linear);
        this.setAngularWeights(angular);
    }

    public void setAngularWeightsToZero() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
    }

    public void setLinearWeightsToZero() {
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public boolean isHardConstraint() {
        return this.weightMatrix.containsHardConstraint();
    }

    public void getWeightMatrix(DMatrixRMaj weightMatrixToPack) {
        weightMatrixToPack.reshape(6, 6);
        this.weightMatrix.getFullWeightMatrixInFrame(worldFrame, weightMatrixToPack);
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public DMatrixRMaj getMomentum() {
        return this.momentum;
    }

    public void getMomentumRate(FrameVector3DBasics angularPartToPack, FrameVector3DBasics linearPartToPack) {
        angularPartToPack.setIncludingFrame(worldFrame, 0, (DMatrix)this.momentum);
        linearPartToPack.setIncludingFrame(worldFrame, 3, (DMatrix)this.momentum);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.MOMENTUM;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MomentumCommand) {
            MomentumCommand other = (MomentumCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!MatrixFeatures_DDRM.isEquals((DMatrixD1)this.momentum, (DMatrixD1)other.momentum)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            return this.selectionMatrix.equals((Object)other.selectionMatrix);
        }
        return false;
    }

    public String toString() {
        String stringOfMomentum = EuclidCoreIOTools.getStringOf((String)"(", (String)")", (String)",", (double[])this.momentum.getData());
        return this.getClass().getSimpleName() + ": momentum: " + stringOfMomentum + ", selection matrix = " + this.selectionMatrix;
    }
}

