/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commons.MathTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.lists.DenseMatrixArrayList;

public class JointspaceVelocityCommand
implements InverseKinematicsCommand<JointspaceVelocityCommand> {
    private static final int initialCapacity = 15;
    private int commandId;
    private final List<JointBasics> joints = new ArrayList<JointBasics>(15);
    private final DenseMatrixArrayList desiredVelocities = new DenseMatrixArrayList(15);
    private final TDoubleArrayList weights = new TDoubleArrayList(15);

    public JointspaceVelocityCommand() {
        this.clear();
    }

    public void set(JointspaceVelocityCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJoints(); ++i) {
            this.joints.add(other.joints.get(i));
            this.weights.add(other.getWeight(i));
        }
        this.desiredVelocities.set(other.desiredVelocities);
    }

    public void clear() {
        this.commandId = 0;
        this.joints.clear();
        this.desiredVelocities.clear();
        this.weights.reset();
    }

    public void addJoint(OneDoFJointBasics joint, double desiredVelocity) {
        this.addJoint(joint, desiredVelocity, Double.POSITIVE_INFINITY);
    }

    public void addJoint(OneDoFJointBasics joint, double desiredVelocity, double weight) {
        this.joints.add((JointBasics)joint);
        this.weights.add(weight);
        DMatrixRMaj jointDesiredVelocity = (DMatrixRMaj)this.desiredVelocities.add();
        jointDesiredVelocity.reshape(1, 1);
        jointDesiredVelocity.set(0, 0, desiredVelocity);
    }

    public void addJoint(JointBasics joint, DMatrixRMaj desiredVelocity) {
        this.checkConsistency(joint, desiredVelocity);
        this.joints.add(joint);
        ((DMatrixRMaj)this.desiredVelocities.add()).set((DMatrixD1)desiredVelocity);
    }

    public void addJoint(JointBasics joint, DMatrixRMaj desiredVelocity, double weight) {
        this.checkConsistency(joint, desiredVelocity);
        this.joints.add(joint);
        this.weights.add(weight);
        ((DMatrixRMaj)this.desiredVelocities.add()).set((DMatrixD1)desiredVelocity);
    }

    public void setOneDoFJointDesiredVelocity(int jointIndex, double desiredVelocity) {
        MathTools.checkEquals((int)this.joints.get(jointIndex).getDegreesOfFreedom(), (int)1);
        ((DMatrixRMaj)this.desiredVelocities.get(jointIndex)).reshape(1, 1);
        ((DMatrixRMaj)this.desiredVelocities.get(jointIndex)).set(0, 0, desiredVelocity);
    }

    public void setDesiredVelocity(int jointIndex, DMatrixRMaj desiredVelocity) {
        this.checkConsistency(this.joints.get(jointIndex), desiredVelocity);
        ((DMatrixRMaj)this.desiredVelocities.get(jointIndex)).set((DMatrixD1)desiredVelocity);
    }

    public void setAsHardConstraint() {
        for (int jointIdx = 0; jointIdx < this.joints.size(); ++jointIdx) {
            this.setWeight(jointIdx, Double.POSITIVE_INFINITY);
        }
    }

    public void setWeight(int jointIndex, double weight) {
        this.weights.set(jointIndex, weight);
    }

    public void setWeight(double weight) {
        for (int jointIdx = 0; jointIdx < this.joints.size(); ++jointIdx) {
            this.weights.set(jointIdx, weight);
        }
    }

    private void checkConsistency(JointBasics joint, DMatrixRMaj desiredVelocity) {
        MathTools.checkEquals((int)joint.getDegreesOfFreedom(), (int)desiredVelocity.getNumRows());
    }

    public boolean isHardConstraint() {
        boolean isHardConstraint;
        if (this.getNumberOfJoints() == 0) {
            return true;
        }
        boolean bl = isHardConstraint = this.getWeight(0) == Double.POSITIVE_INFINITY;
        if (this.getNumberOfJoints() == 1) {
            return isHardConstraint;
        }
        for (int jointIdx = 1; jointIdx < this.joints.size(); ++jointIdx) {
            boolean isJointHardConstraint;
            boolean bl2 = isJointHardConstraint = this.getWeight(jointIdx) == Double.POSITIVE_INFINITY;
            if (isJointHardConstraint == isHardConstraint) continue;
            throw new RuntimeException("Inconsistent weights in " + this.getClass().getSimpleName() + ": some joint velocity desireds have weights, others are hard constraints. This is not supported in a single message.");
        }
        return isHardConstraint;
    }

    public double getWeight(int jointIndex) {
        return this.weights.get(jointIndex);
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public List<JointBasics> getJoints() {
        return this.joints;
    }

    public JointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public DMatrixRMaj getDesiredVelocity(int jointIndex) {
        return (DMatrixRMaj)this.desiredVelocities.get(jointIndex);
    }

    public DenseMatrixArrayList getDesiredVelocities() {
        return this.desiredVelocities;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINTSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointspaceVelocityCommand) {
            JointspaceVelocityCommand other = (JointspaceVelocityCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.joints.get(jointIndex) == other.joints.get(jointIndex)) continue;
                return false;
            }
            if (!this.desiredVelocities.equals((Object)other.desiredVelocities)) {
                return false;
            }
            return this.weights.equals((Object)other.weights);
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        for (int i = 0; i < this.joints.size(); ++i) {
            ret = ret + this.joints.get(i).getName();
            ret = i < this.joints.size() - 1 ? ret + ", " : ret + ".";
        }
        return ret;
    }
}

