/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class SpatialAccelerationCommand
implements InverseDynamicsCommand<SpatialAccelerationCommand> {
    private int commandId;
    private final FramePose3D controlFramePose = new FramePose3D();
    private final Vector3D desiredLinearAcceleration = new Vector3D();
    private final Vector3D desiredAngularAcceleration = new Vector3D();
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();
    private RigidBodyBasics base;
    private RigidBodyBasics endEffector;
    private RigidBodyBasics optionalPrimaryBase;
    private boolean scaleSecondaryTaskJointWeight = false;
    private double secondaryTaskJointWeightScale = 1.0;

    public SpatialAccelerationCommand() {
        this.setAsHardConstraint();
    }

    public void set(SpatialAccelerationCommand other) {
        this.commandId = other.commandId;
        this.controlFramePose.setIncludingFrame((FramePose3DReadOnly)other.controlFramePose);
        this.desiredLinearAcceleration.set(other.desiredLinearAcceleration);
        this.desiredAngularAcceleration.set(other.desiredAngularAcceleration);
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
        this.base = other.getBase();
        this.endEffector = other.getEndEffector();
        this.optionalPrimaryBase = other.optionalPrimaryBase;
        this.scaleSecondaryTaskJointWeight = other.scaleSecondaryTaskJointWeight;
        this.secondaryTaskJointWeightScale = other.secondaryTaskJointWeightScale;
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.base = base;
        this.endEffector = endEffector;
    }

    public void setPrimaryBase(RigidBodyBasics primaryBase) {
        this.optionalPrimaryBase = primaryBase;
    }

    public void setScaleSecondaryTaskJointWeight(boolean scaleSecondaryTaskJointWeight, double secondaryTaskJointWeightScale) {
        this.scaleSecondaryTaskJointWeight = scaleSecondaryTaskJointWeight;
        this.secondaryTaskJointWeightScale = secondaryTaskJointWeightScale;
    }

    public void setSpatialAccelerationToZero(ReferenceFrame controlFrame) {
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularAcceleration.setToZero();
        this.desiredLinearAcceleration.setToZero();
    }

    public void setSpatialAcceleration(ReferenceFrame controlFrame, SpatialAccelerationReadOnly desiredSpatialAcceleration) {
        desiredSpatialAcceleration.getBodyFrame().checkReferenceFrameMatch((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        desiredSpatialAcceleration.getBaseFrame().checkReferenceFrameMatch((ReferenceFrame)this.base.getBodyFixedFrame());
        desiredSpatialAcceleration.getReferenceFrame().checkReferenceFrameMatch(controlFrame);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularAcceleration.set((Tuple3DReadOnly)desiredSpatialAcceleration.getAngularPart());
        this.desiredLinearAcceleration.set((Tuple3DReadOnly)desiredSpatialAcceleration.getLinearPart());
    }

    public void setSpatialAcceleration(ReferenceFrame controlFrame, FrameVector3DReadOnly desiredAngularAcceleration, FrameVector3DReadOnly desiredLinearAcceleration) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularAcceleration);
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearAcceleration);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularAcceleration.set((Tuple3DReadOnly)desiredAngularAcceleration);
        this.desiredLinearAcceleration.set((Tuple3DReadOnly)desiredLinearAcceleration);
    }

    public void setAngularAcceleration(ReferenceFrame controlFrame, FrameVector3DReadOnly desiredAngularAcceleration) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredAngularAcceleration);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredAngularAcceleration.set((Tuple3DReadOnly)desiredAngularAcceleration);
        this.desiredLinearAcceleration.setToZero();
    }

    public void setLinearAcceleration(ReferenceFrame controlFrame, FrameVector3DReadOnly desiredLinearAcceleration) {
        controlFrame.checkReferenceFrameMatch((ReferenceFrameHolder)desiredLinearAcceleration);
        this.controlFramePose.setToZero(controlFrame);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
        this.desiredLinearAcceleration.set((Tuple3DReadOnly)desiredLinearAcceleration);
        this.desiredAngularAcceleration.setToZero();
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
    }

    public void setSelectionMatrixForLinearControl() {
        this.selectionMatrix.setToLinearSelectionOnly();
    }

    public void setSelectionMatrixForLinearControl(SelectionMatrix3D linearSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setLinearPart(linearSelectionMatrix);
    }

    public void setSelectionMatrixForAngularControl() {
        this.selectionMatrix.setToAngularSelectionOnly();
    }

    public void setSelectionMatrixForAngularControl(SelectionMatrix3D angularSelectionMatrix) {
        this.selectionMatrix.clearSelection();
        this.selectionMatrix.setAngularPart(angularSelectionMatrix);
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public void setAsHardConstraint() {
        this.setWeight(Double.POSITIVE_INFINITY);
    }

    public void setWeight(double weight) {
        this.weightMatrix.setLinearWeights(weight, weight, weight);
        this.weightMatrix.setAngularWeights(weight, weight, weight);
    }

    public void setWeight(double angular, double linear) {
        this.weightMatrix.setLinearWeights(linear, linear, linear);
        this.weightMatrix.setAngularWeights(angular, angular, angular);
    }

    public void setWeights(double angularX, double angularY, double angularZ, double linearX, double linearY, double linearZ) {
        this.weightMatrix.setLinearWeights(linearX, linearY, linearZ);
        this.weightMatrix.setAngularWeights(angularX, angularY, angularZ);
    }

    public void setWeightMatrix(WeightMatrix6D weightMatrix) {
        this.weightMatrix.set(weightMatrix);
    }

    public void setLinearPartOfWeightMatrix(WeightMatrix3D linearWeightMatrix) {
        this.weightMatrix.setLinearPart(linearWeightMatrix);
    }

    public void setAngularPartOfWeightMatrix(WeightMatrix3D angularWeightMatrix) {
        this.weightMatrix.setAngularPart(angularWeightMatrix);
    }

    public void setAngularWeights(Tuple3DReadOnly angular) {
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
    }

    public void setLinearWeights(Tuple3DReadOnly linear) {
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
    }

    public void setWeights(Tuple3DReadOnly angular, Tuple3DReadOnly linear) {
        this.weightMatrix.setLinearWeights(linear.getX(), linear.getY(), linear.getZ());
        this.weightMatrix.setAngularWeights(angular.getX(), angular.getY(), angular.getZ());
    }

    public void setAngularWeightsToZero() {
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
    }

    public void setLinearWeightsToZero() {
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
    }

    public boolean isHardConstraint() {
        return this.weightMatrix.containsHardConstraint();
    }

    public void getWeightMatrix(ReferenceFrame destinationFrame, DMatrixRMaj weightMatrixToPack) {
        this.weightMatrix.getFullWeightMatrixInFrame(destinationFrame, weightMatrixToPack);
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public void getWeightMatrix(WeightMatrix6D weightMatrixToPack) {
        weightMatrixToPack.set(this.weightMatrix);
    }

    public Vector3DBasics getDesiredLinearAcceleration() {
        return this.desiredLinearAcceleration;
    }

    public Vector3DBasics getDesiredAngularAcceleration() {
        return this.desiredAngularAcceleration;
    }

    public void getDesiredSpatialAcceleration(PoseReferenceFrame controlFrameToPack, SpatialAcceleration desiredSpatialAccelerationToPack) {
        this.getControlFrame(controlFrameToPack);
        desiredSpatialAccelerationToPack.setIncludingFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame(), (ReferenceFrame)this.base.getBodyFixedFrame(), (ReferenceFrame)controlFrameToPack, (Vector3DReadOnly)this.desiredAngularAcceleration, (Vector3DReadOnly)this.desiredLinearAcceleration);
    }

    public void getDesiredSpatialAcceleration(DMatrixRMaj desiredSpatialAccelerationToPack) {
        desiredSpatialAccelerationToPack.reshape(6, 1);
        this.desiredAngularAcceleration.get(0, (DMatrix)desiredSpatialAccelerationToPack);
        this.desiredLinearAcceleration.get(3, (DMatrix)desiredSpatialAccelerationToPack);
    }

    public void getControlFrame(PoseReferenceFrame controlFrameToPack) {
        this.controlFramePose.changeFrame(controlFrameToPack.getParent());
        controlFrameToPack.setPoseAndUpdate((FramePose3DReadOnly)this.controlFramePose);
        this.controlFramePose.changeFrame((ReferenceFrame)this.endEffector.getBodyFixedFrame());
    }

    public void getControlFramePoseIncludingFrame(FramePose3DBasics controlFramePoseToPack) {
        controlFramePoseToPack.setIncludingFrame((FramePose3DReadOnly)this.controlFramePose);
    }

    public FramePose3DBasics getControlFramePose() {
        return this.controlFramePose;
    }

    public void getControlFramePoseIncludingFrame(FramePoint3DBasics positionToPack, FrameOrientation3DBasics orientationToPack) {
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)this.controlFramePose.getPosition());
        orientationToPack.setIncludingFrame((FrameOrientation3DReadOnly)this.controlFramePose.getOrientation());
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    public void getLinearSelectionMatrix(SelectionMatrix3D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix.getLinearPart());
    }

    public void getAngularSelectionMatrix(SelectionMatrix3D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix.getAngularPart());
    }

    public RigidBodyBasics getBase() {
        return this.base;
    }

    public RigidBodyBasics getEndEffector() {
        return this.endEffector;
    }

    public RigidBodyBasics getPrimaryBase() {
        return this.optionalPrimaryBase;
    }

    public boolean scaleSecondaryTaskJointWeight() {
        return this.scaleSecondaryTaskJointWeight;
    }

    public double getSecondaryTaskJointWeightScale() {
        return this.secondaryTaskJointWeightScale;
    }

    public void resetSecondaryTaskJointWeightScale() {
        this.secondaryTaskJointWeightScale = 1.0;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.TASKSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialAccelerationCommand) {
            SpatialAccelerationCommand other = (SpatialAccelerationCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!this.controlFramePose.equals((FramePose3DReadOnly)other.controlFramePose)) {
                return false;
            }
            if (!this.desiredLinearAcceleration.equals((Tuple3DReadOnly)other.desiredLinearAcceleration)) {
                return false;
            }
            if (!this.desiredAngularAcceleration.equals((Tuple3DReadOnly)other.desiredAngularAcceleration)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            if (!this.selectionMatrix.equals((Object)other.selectionMatrix)) {
                return false;
            }
            if (this.base != other.base) {
                return false;
            }
            if (this.endEffector != other.endEffector) {
                return false;
            }
            if (this.optionalPrimaryBase != other.optionalPrimaryBase) {
                return false;
            }
            if (this.scaleSecondaryTaskJointWeight != other.scaleSecondaryTaskJointWeight) {
                return false;
            }
            return this.secondaryTaskJointWeightScale == other.secondaryTaskJointWeightScale;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": base = " + this.base + ", endEffector = " + this.endEffector + ", linear = " + this.desiredLinearAcceleration + ", angular = " + this.desiredAngularAcceleration;
    }
}

