/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.lists.FrameTupleArrayList;

public class PlaneContactStateCommand
implements InverseDynamicsCommand<PlaneContactStateCommand>,
VirtualModelControlCommand<PlaneContactStateCommand> {
    private static final int initialSize = 8;
    private int commandId;
    private RigidBodyBasics rigidBody;
    private double coefficientOfFriction = Double.NaN;
    private final FrameTupleArrayList<FramePoint3D> contactPoints = FrameTupleArrayList.createFramePointArrayList((int)8);
    private final FrameVector3D contactNormal = new FrameVector3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 1.0);
    private boolean useHighCoPDamping = false;
    private boolean hasContactStateChanged;
    private boolean hasMaxContactPointNormalForce = false;
    private final TDoubleArrayList maxContactPointNormalForces = new TDoubleArrayList(8);
    private final TDoubleArrayList rhoWeights = new TDoubleArrayList(8);
    private final RigidBodyTransform contactFramePoseInBodyFixedFrame = new RigidBodyTransform();

    public PlaneContactStateCommand() {
        this.clearContactPoints();
    }

    public void set(PlaneContactStateCommand other) {
        this.commandId = other.commandId;
        this.rigidBody = other.rigidBody;
        this.coefficientOfFriction = other.coefficientOfFriction;
        this.contactPoints.set(other.contactPoints);
        this.contactNormal.setIncludingFrame((FrameTuple3DReadOnly)other.contactNormal);
        this.useHighCoPDamping = other.useHighCoPDamping;
        this.hasContactStateChanged = other.hasContactStateChanged;
        this.hasMaxContactPointNormalForce = other.hasMaxContactPointNormalForce;
        this.maxContactPointNormalForces.reset();
        this.rhoWeights.reset();
        for (int i = 0; i < other.contactPoints.size(); ++i) {
            this.maxContactPointNormalForces.add(other.maxContactPointNormalForces.get(i));
            this.rhoWeights.add(other.rhoWeights.get(i));
        }
        this.contactFramePoseInBodyFixedFrame.set(other.contactFramePoseInBodyFixedFrame);
    }

    public void setHasContactStateChanged(boolean hasContactStateChanged) {
        this.hasContactStateChanged = hasContactStateChanged;
    }

    public void setContactingRigidBody(RigidBodyBasics rigidBody) {
        this.rigidBody = rigidBody;
    }

    public void setCoefficientOfFriction(double coefficientOfFriction) {
        this.coefficientOfFriction = coefficientOfFriction;
    }

    public void clearContactPoints() {
        this.contactPoints.clear();
        this.maxContactPointNormalForces.reset();
        this.rhoWeights.reset();
        this.contactFramePoseInBodyFixedFrame.setToNaN();
    }

    public void setContactFramePose(ReferenceFrame contactFrame) {
        contactFrame.getTransformToDesiredFrame(this.contactFramePoseInBodyFixedFrame, (ReferenceFrame)this.rigidBody.getBodyFixedFrame());
    }

    public FramePoint3DBasics addPointInContact() {
        this.maxContactPointNormalForces.add(Double.POSITIVE_INFINITY);
        this.rhoWeights.add(Double.NaN);
        return (FramePoint3DBasics)this.contactPoints.add();
    }

    public void addPointInContact(FramePoint3DReadOnly newPointInContact) {
        this.addPointInContact().setIncludingFrame((FrameTuple3DReadOnly)newPointInContact);
    }

    public void addPointInContact(FramePoint2DReadOnly newPointInContact) {
        this.addPointInContact().setIncludingFrame((FrameTuple2DReadOnly)newPointInContact, 0.0);
    }

    public void setPointsInContact(List<? extends FramePoint3DReadOnly> newPointsInContact) {
        this.clearContactPoints();
        for (int i = 0; i < newPointsInContact.size(); ++i) {
            this.addPointInContact().setIncludingFrame((FrameTuple3DReadOnly)newPointsInContact.get(i));
        }
    }

    public void setPoint2dsInContact(ReferenceFrame contactFrame, List<? extends Point2DReadOnly> newPointsInContact) {
        this.clearContactPoints();
        for (int i = 0; i < newPointsInContact.size(); ++i) {
            this.addPointInContact().setIncludingFrame(contactFrame, (Tuple2DReadOnly)newPointsInContact.get(i), 0.0);
        }
    }

    public void setMaxContactPointNormalForce(int contactPointIndex, double maxNormalForce) {
        this.hasMaxContactPointNormalForce |= Double.isFinite(maxNormalForce);
        this.maxContactPointNormalForces.set(contactPointIndex, maxNormalForce);
    }

    public void setContactNormal(FrameVector3DReadOnly contactNormal) {
        this.contactNormal.setIncludingFrame((FrameTuple3DReadOnly)contactNormal);
    }

    public void setUseHighCoPDamping(boolean useHighCoPDamping) {
        this.useHighCoPDamping = useHighCoPDamping;
    }

    public boolean isEmpty() {
        return this.contactPoints.isEmpty();
    }

    public int getNumberOfContactPoints() {
        return this.contactPoints.size();
    }

    public double getCoefficientOfFriction() {
        return this.coefficientOfFriction;
    }

    public RigidBodyBasics getContactingRigidBody() {
        return this.rigidBody;
    }

    public FramePoint3DBasics getContactPoint(int index) {
        return (FramePoint3DBasics)this.contactPoints.get(index);
    }

    public FrameVector3DBasics getContactNormal() {
        return this.contactNormal;
    }

    public void setRhoWeight(int pointIndex, double rhoWeight) {
        this.rhoWeights.set(pointIndex, rhoWeight);
    }

    public double getRhoWeight(int pointIndex) {
        return this.rhoWeights.get(pointIndex);
    }

    public boolean isUseHighCoPDamping() {
        return this.useHighCoPDamping;
    }

    public boolean hasMaxContactPointNormalForce() {
        return this.hasMaxContactPointNormalForce;
    }

    public boolean getHasContactStateChanged() {
        return this.hasContactStateChanged;
    }

    public double getMaxContactPointNormalForce(int pointIndex) {
        return this.maxContactPointNormalForces.get(pointIndex);
    }

    public RigidBodyTransform getContactFramePoseInBodyFixedFrame() {
        return this.contactFramePoseInBodyFixedFrame;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.PLANE_CONTACT_STATE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PlaneContactStateCommand) {
            PlaneContactStateCommand other = (PlaneContactStateCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.rigidBody != other.rigidBody) {
                return false;
            }
            if (Double.compare(this.coefficientOfFriction, other.coefficientOfFriction) != 0) {
                return false;
            }
            if (this.getNumberOfContactPoints() != other.getNumberOfContactPoints()) {
                return false;
            }
            if (!this.contactPoints.equals(other.contactPoints)) {
                return false;
            }
            if (!this.contactNormal.equals((FrameTuple3DReadOnly)other.contactNormal)) {
                return false;
            }
            if (this.useHighCoPDamping != other.useHighCoPDamping) {
                return false;
            }
            if (this.hasContactStateChanged != other.hasContactStateChanged) {
                return false;
            }
            if (this.hasMaxContactPointNormalForce != other.hasMaxContactPointNormalForce) {
                return false;
            }
            if (!this.maxContactPointNormalForces.equals((Object)other.maxContactPointNormalForces)) {
                return false;
            }
            for (int contactPointIndex = 0; contactPointIndex < this.getNumberOfContactPoints(); ++contactPointIndex) {
                if (Double.compare(this.rhoWeights.get(contactPointIndex), other.rhoWeights.get(contactPointIndex)) == 0) continue;
                return false;
            }
            return !(this.contactFramePoseInBodyFixedFrame.containsNaN() ? !other.contactFramePoseInBodyFixedFrame.containsNaN() : !this.contactFramePoseInBodyFixedFrame.equals(other.contactFramePoseInBodyFixedFrame));
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": contacting rigid body = " + this.rigidBody + ", number of contact points = " + this.getNumberOfContactPoints();
    }
}

