/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.MatrixFeatures_DDRM;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class LinearMomentumRateCostCommand
implements InverseDynamicsCommand<LinearMomentumRateCostCommand> {
    private int commandId;
    private final DMatrixRMaj momentumRateHessian = new DMatrixRMaj(6, 6);
    private final DMatrixRMaj momentumRateGradient = new DMatrixRMaj(1, 6);
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();

    public LinearMomentumRateCostCommand() {
        this.weightMatrix.setLinearWeights(0.0, 0.0, 0.0);
        this.weightMatrix.setAngularWeights(0.0, 0.0, 0.0);
        this.selectionMatrix.clearAngularSelection();
    }

    public void set(LinearMomentumRateCostCommand other) {
        this.commandId = other.commandId;
        this.momentumRateHessian.set((DMatrixD1)other.momentumRateHessian);
        this.momentumRateGradient.set((DMatrixD1)other.momentumRateGradient);
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
    }

    public void setSelectionMatrixToIdentity() {
        this.selectionMatrix.resetSelection();
        this.selectionMatrix.clearAngularSelection();
    }

    public void setSelectionMatrixForLinearXYControl() {
        this.selectionMatrix.resetSelection();
        this.selectionMatrix.clearAngularSelection();
        this.selectionMatrix.selectLinearZ(false);
    }

    public void setWeight(double weight) {
        this.weightMatrix.getLinearPart().setWeights(weight, weight, weight);
    }

    public void setWeights(double linearX, double linearY, double linearZ) {
        this.weightMatrix.getLinearPart().setWeights(linearX, linearY, linearZ);
    }

    public void setWeights(Tuple3DReadOnly linear) {
        this.weightMatrix.getLinearPart().setWeights(linear.getX(), linear.getY(), linear.getZ());
    }

    public void setWeightMatrix(WeightMatrix6D weightMatrix) {
        this.weightMatrix.set(weightMatrix);
    }

    public void getWeightMatrix(DMatrixRMaj weightMatrixToPack) {
        weightMatrixToPack.reshape(6, 6);
        this.weightMatrix.getFullWeightMatrixInFrame(ReferenceFrame.getWorldFrame(), weightMatrixToPack);
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public void getSelectionMatrix(ReferenceFrame destinationFrame, DMatrixRMaj selectionMatrixToPack) {
        this.selectionMatrix.getCompactSelectionMatrixInFrame(destinationFrame, selectionMatrixToPack);
    }

    public void getSelectionMatrix(SelectionMatrix6D selectionMatrixToPack) {
        selectionMatrixToPack.set(this.selectionMatrix);
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.selectionMatrix.set(selectionMatrix);
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void setMomentumRateHessian(DMatrixRMaj momentumRateHessian) {
        this.momentumRateHessian.set((DMatrixD1)momentumRateHessian);
    }

    public void setMomentumRateGradient(DMatrixRMaj momentumRateGradient) {
        this.momentumRateGradient.set((DMatrixD1)momentumRateGradient);
    }

    public void setLinearMomentumRateHessian(DMatrixRMaj linearMomentumRateHessian) {
        MatrixTools.setMatrixBlock((DMatrix)this.momentumRateHessian, (int)3, (int)3, (DMatrix)linearMomentumRateHessian, (int)0, (int)0, (int)3, (int)3, (double)1.0);
    }

    public void setLinearMomentumRateGradient(DMatrixRMaj linearMomentumRateGradient) {
        MatrixTools.setMatrixBlock((DMatrix)this.momentumRateGradient, (int)0, (int)3, (DMatrix)linearMomentumRateGradient, (int)0, (int)0, (int)1, (int)3, (double)1.0);
    }

    public DMatrixRMaj getMomentumRateHessian() {
        return this.momentumRateHessian;
    }

    public DMatrixRMaj getMomentumRateGradient() {
        return this.momentumRateGradient;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.MOMENTUM_COST;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LinearMomentumRateCostCommand) {
            LinearMomentumRateCostCommand other = (LinearMomentumRateCostCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (!MatrixFeatures_DDRM.isEquals((DMatrixD1)this.momentumRateHessian, (DMatrixD1)other.momentumRateHessian)) {
                return false;
            }
            if (!MatrixFeatures_DDRM.isEquals((DMatrixD1)this.momentumRateGradient, (DMatrixD1)other.momentumRateGradient)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            return this.selectionMatrix.equals((Object)other.selectionMatrix);
        }
        return false;
    }
}

