/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitEnforcement;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;

public class JointLimitEnforcementMethodCommand
implements InverseKinematicsCommand<JointLimitEnforcementMethodCommand>,
InverseDynamicsCommand<JointLimitEnforcementMethodCommand> {
    private int commandId;
    private static final int initialCapacity = 40;
    private final List<OneDoFJointBasics> joints = new ArrayList<OneDoFJointBasics>(40);
    private final List<JointLimitEnforcement> methods = new ArrayList<JointLimitEnforcement>(40);
    private final List<JointLimitParameters> parameters = new ArrayList<JointLimitParameters>(40);

    public void clear() {
        this.commandId = 0;
        this.joints.clear();
        this.methods.clear();
        this.parameters.clear();
    }

    public void addLimitEnforcementMethod(OneDoFJointBasics joint, JointLimitEnforcement method, JointLimitParameters limitParameters) {
        this.joints.add(joint);
        this.methods.add(method);
        this.parameters.add(limitParameters);
    }

    public JointLimitEnforcement getJointLimitReductionFactor(int jointIndex) {
        return this.methods.get(jointIndex);
    }

    public JointLimitParameters getJointLimitParameters(int jointIndex) {
        return this.parameters.get(jointIndex);
    }

    public int getNumberOfJoints() {
        return this.joints.size();
    }

    public OneDoFJointBasics getJoint(int jointIndex) {
        return this.joints.get(jointIndex);
    }

    public void set(JointLimitEnforcementMethodCommand other) {
        this.clear();
        this.commandId = other.commandId;
        for (int i = 0; i < other.getNumberOfJoints(); ++i) {
            this.joints.add(other.joints.get(i));
            this.methods.add(other.methods.get(i));
            this.parameters.add(other.parameters.get(i));
        }
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINT_LIMIT_ENFORCEMENT;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointLimitEnforcementMethodCommand) {
            JointLimitEnforcementMethodCommand other = (JointLimitEnforcementMethodCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (this.getJoint(jointIndex) != other.getJoint(jointIndex)) {
                    return false;
                }
                if (this.getJointLimitReductionFactor(jointIndex) != other.getJointLimitReductionFactor(jointIndex)) {
                    return false;
                }
                if (this.getJointLimitParameters(jointIndex).equals(other.getJointLimitParameters(jointIndex))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ":";
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ret = ret + "\nJoint: " + this.getJoint(jointIndex).getName() + ", method: " + (Object)((Object)this.getJointLimitReductionFactor(jointIndex)) + ", " + this.getJointLimitParameters(jointIndex).toString();
        }
        return ret;
    }
}

