/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;

public class InverseDynamicsOptimizationSettingsCommand
implements InverseDynamicsCommand<InverseDynamicsOptimizationSettingsCommand> {
    private int commandId;
    private double rhoMin = Double.NaN;
    private double jointAccelerationMax = Double.NaN;
    private double rhoWeight = Double.NaN;
    private double rhoRateWeight = Double.NaN;
    private final Vector2D centerOfPressureWeight = new Vector2D(Double.NaN, Double.NaN);
    private final Vector2D centerOfPressureRateWeight = new Vector2D(Double.NaN, Double.NaN);
    private double jointAccelerationWeight = Double.NaN;
    private double jointJerkWeight = Double.NaN;
    private double jointTorqueWeight = Double.NaN;

    public void setRhoMin(double rhoMin) {
        this.rhoMin = rhoMin;
    }

    public void setJointAccelerationMax(double jointAccelerationMax) {
        MathTools.checkPositive((double)jointAccelerationMax);
        this.jointAccelerationMax = jointAccelerationMax;
    }

    public void setRhoWeight(double rhoWeight) {
        this.rhoWeight = rhoWeight;
    }

    public void setRhoRateWeight(double rhoRateWeight) {
        this.rhoRateWeight = rhoRateWeight;
    }

    public void setCenterOfPressureWeight(Tuple2DReadOnly centerOfPressureWeight) {
        this.centerOfPressureWeight.set(centerOfPressureWeight);
    }

    public void setCenterOfPressureRateWeight(Tuple2DReadOnly centerOfPressureRateWeight) {
        this.centerOfPressureRateWeight.set(centerOfPressureRateWeight);
    }

    public void setJointAccelerationWeight(double jointAccelerationWeight) {
        this.jointAccelerationWeight = jointAccelerationWeight;
    }

    public void setJointJerkWeight(double jointJerkWeight) {
        this.jointJerkWeight = jointJerkWeight;
    }

    public void setJointTorqueWeight(double jointTorqueWeight) {
        this.jointTorqueWeight = jointTorqueWeight;
    }

    public boolean hasRhoMin() {
        return !Double.isNaN(this.rhoMin);
    }

    public boolean hasJointAccelerationMax() {
        return !Double.isNaN(this.jointAccelerationMax);
    }

    public boolean hasRhoWeight() {
        return !Double.isNaN(this.rhoWeight);
    }

    public boolean hasRhoRateWeight() {
        return !Double.isNaN(this.rhoRateWeight);
    }

    public boolean hasCenterOfPressureWeight() {
        return !this.centerOfPressureWeight.containsNaN();
    }

    public boolean hasCenterOfPressureRateWeight() {
        return !this.centerOfPressureRateWeight.containsNaN();
    }

    public boolean hasJointAccelerationWeight() {
        return !Double.isNaN(this.jointAccelerationWeight);
    }

    public boolean hasJointJerkWeight() {
        return !Double.isNaN(this.jointJerkWeight);
    }

    public boolean hasJointTorqueWeight() {
        return !Double.isNaN(this.jointTorqueWeight);
    }

    public double getRhoMin() {
        return this.rhoMin;
    }

    public double getJointAccelerationMax() {
        return this.jointAccelerationMax;
    }

    public double getRhoWeight() {
        return this.rhoWeight;
    }

    public double getRhoRateWeight() {
        return this.rhoRateWeight;
    }

    public Vector2D getCenterOfPressureWeight() {
        return this.centerOfPressureWeight;
    }

    public Vector2D getCenterOfPressureRateWeight() {
        return this.centerOfPressureRateWeight;
    }

    public double getJointAccelerationWeight() {
        return this.jointAccelerationWeight;
    }

    public double getJointJerkWeight() {
        return this.jointJerkWeight;
    }

    public double getJointTorqueWeight() {
        return this.jointTorqueWeight;
    }

    public void set(InverseDynamicsOptimizationSettingsCommand other) {
        this.commandId = other.commandId;
        this.rhoMin = other.rhoMin;
        this.jointAccelerationMax = other.jointAccelerationMax;
        this.rhoWeight = other.rhoWeight;
        this.rhoRateWeight = other.rhoRateWeight;
        this.centerOfPressureWeight.set(other.centerOfPressureWeight);
        this.centerOfPressureRateWeight.set(other.centerOfPressureRateWeight);
        this.jointAccelerationWeight = other.jointAccelerationWeight;
        this.jointJerkWeight = other.jointJerkWeight;
        this.jointTorqueWeight = other.jointTorqueWeight;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.OPTIMIZATION_SETTINGS;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof InverseDynamicsOptimizationSettingsCommand) {
            InverseDynamicsOptimizationSettingsCommand other = (InverseDynamicsOptimizationSettingsCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (Double.compare(this.rhoMin, other.rhoMin) != 0) {
                return false;
            }
            if (Double.compare(this.jointAccelerationMax, other.jointAccelerationMax) != 0) {
                return false;
            }
            if (Double.compare(this.rhoWeight, other.rhoWeight) != 0) {
                return false;
            }
            if (Double.compare(this.rhoRateWeight, other.rhoRateWeight) != 0) {
                return false;
            }
            if (this.centerOfPressureWeight.containsNaN() ^ other.centerOfPressureWeight.containsNaN()) {
                return false;
            }
            if (!this.centerOfPressureWeight.containsNaN() && !this.centerOfPressureWeight.equals((Tuple2DReadOnly)other.centerOfPressureWeight)) {
                return false;
            }
            if (this.centerOfPressureRateWeight.containsNaN() ^ other.centerOfPressureRateWeight.containsNaN()) {
                return false;
            }
            if (!this.centerOfPressureRateWeight.containsNaN() && !this.centerOfPressureRateWeight.equals((Tuple2DReadOnly)other.centerOfPressureRateWeight)) {
                return false;
            }
            if (Double.compare(this.jointAccelerationWeight, other.jointAccelerationWeight) != 0) {
                return false;
            }
            if (Double.compare(this.jointJerkWeight, other.jointJerkWeight) != 0) {
                return false;
            }
            return Double.compare(this.jointTorqueWeight, other.jointTorqueWeight) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": rho min: " + this.rhoMin + ", qdd max: " + this.jointAccelerationMax + ", rho weight: " + this.rhoWeight + ", rho rate weight: " + this.rhoRateWeight + ", CoP weight: " + this.centerOfPressureWeight + ", CoP rate weight: " + this.centerOfPressureRateWeight + ", qdd weight: " + this.jointAccelerationWeight + ", qddd weight: " + this.jointJerkWeight + ", tau weight: " + this.jointTorqueWeight;
    }
}

