/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class ContactWrenchCommand
implements InverseDynamicsCommand<ContactWrenchCommand>,
VirtualModelControlCommand<ContactWrenchCommand> {
    private int commandId;
    private ConstraintType constraintType;
    private RigidBodyBasics rigidBody;
    private final Wrench wrench = new Wrench();
    private final WeightMatrix6D weightMatrix = new WeightMatrix6D();
    private final SelectionMatrix6D selectionMatrix = new SelectionMatrix6D();

    public ContactWrenchCommand() {
    }

    public ContactWrenchCommand(ConstraintType constraintType) {
        this.setConstraintType(constraintType);
    }

    public void setRigidBody(RigidBodyBasics rigidBody) {
        this.rigidBody = rigidBody;
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public RigidBodyBasics getRigidBody() {
        return this.rigidBody;
    }

    public Wrench getWrench() {
        return this.wrench;
    }

    public WeightMatrix6D getWeightMatrix() {
        return this.weightMatrix;
    }

    public SelectionMatrix6D getSelectionMatrix() {
        return this.selectionMatrix;
    }

    public void set(ContactWrenchCommand other) {
        this.commandId = other.commandId;
        this.constraintType = other.constraintType;
        this.rigidBody = other.rigidBody;
        this.wrench.setIncludingFrame((WrenchReadOnly)other.wrench);
        this.weightMatrix.set(other.weightMatrix);
        this.selectionMatrix.set(other.selectionMatrix);
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.CONTACT_WRENCH;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ContactWrenchCommand) {
            ContactWrenchCommand other = (ContactWrenchCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (this.rigidBody != other.rigidBody) {
                return false;
            }
            if (!this.wrench.equals((WrenchReadOnly)other.wrench)) {
                return false;
            }
            if (!this.weightMatrix.equals((Object)other.weightMatrix)) {
                return false;
            }
            return this.selectionMatrix.equals((Object)other.selectionMatrix);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": constraint: " + (Object)((Object)this.constraintType) + ", body: " + this.rigidBody + ", wrench: " + this.wrench + ", weight: " + this.weightMatrix + ", selection: " + this.selectionMatrix;
    }
}

