/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ConstraintType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector2DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class CenterOfPressureCommand
implements InverseDynamicsCommand<CenterOfPressureCommand>,
VirtualModelControlCommand<CenterOfPressureCommand> {
    private int commandId;
    private ConstraintType constraintType = ConstraintType.OBJECTIVE;
    private RigidBodyBasics contactingRigidBody;
    private final FrameVector2D weight = new FrameVector2D();
    private final FramePoint2D desiredCoP = new FramePoint2D();

    public void set(CenterOfPressureCommand other) {
        this.commandId = other.commandId;
        this.constraintType = other.constraintType;
        this.contactingRigidBody = other.contactingRigidBody;
        this.weight.setIncludingFrame((FrameTuple2DReadOnly)other.weight);
        this.desiredCoP.setIncludingFrame((FrameTuple2DReadOnly)other.desiredCoP);
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    public ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public void setContactingRigidBody(RigidBodyBasics contactingRigidBody) {
        this.contactingRigidBody = contactingRigidBody;
    }

    public void setWeight(FrameVector2DReadOnly weightInSoleFrame) {
        this.weight.setIncludingFrame((FrameTuple2DReadOnly)weightInSoleFrame);
    }

    public void setWeight(ReferenceFrame referenceFrame, double weightX, double weightY) {
        this.weight.setIncludingFrame(referenceFrame, weightX, weightY);
    }

    public void setDesiredCoP(FramePoint2DReadOnly desiredCoPInSoleFrame) {
        this.desiredCoP.setIncludingFrame((FrameTuple2DReadOnly)desiredCoPInSoleFrame);
    }

    public FramePoint2DBasics getDesiredCoP() {
        return this.desiredCoP;
    }

    public FrameVector2DBasics getWeight() {
        return this.weight;
    }

    public RigidBodyBasics getContactingRigidBody() {
        return this.contactingRigidBody;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.CENTER_OF_PRESSURE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CenterOfPressureCommand) {
            CenterOfPressureCommand other = (CenterOfPressureCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.constraintType != other.constraintType) {
                return false;
            }
            if (this.contactingRigidBody != other.contactingRigidBody) {
                return false;
            }
            if (!this.weight.equals((FrameTuple2DReadOnly)other.weight)) {
                return false;
            }
            return this.desiredCoP.equals((FrameTuple2DReadOnly)other.desiredCoP);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": constraint " + (Object)((Object)this.constraintType) + ", contacting body: " + this.contactingRigidBody + ", weight: " + this.weight + ", desired CoP: " + this.desiredCoP;
    }
}

