/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3Gains;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ZeroablePIDSE3Gains;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;

public class SpatialFeedbackControlCommand
implements FeedbackControlCommand<SpatialFeedbackControlCommand> {
    private final FramePose3D controlFramePoseInEndEffectorFrame = new FramePose3D();
    private WholeBodyControllerCoreMode controlMode = null;
    private final FrameQuaternion referenceOrientation = new FrameQuaternion();
    private final FramePoint3D referencePosition = new FramePoint3D();
    private final FrameVector3D referenceAngularVelocity = new FrameVector3D();
    private final FrameVector3D referenceLinearVelocity = new FrameVector3D();
    private final FrameVector3D referenceAngularAcceleration = new FrameVector3D();
    private final FrameVector3D referenceLinearAcceleration = new FrameVector3D();
    private final FrameVector3D referenceTorque = new FrameVector3D();
    private final FrameVector3D referenceForce = new FrameVector3D();
    private final ZeroablePIDSE3Gains gains = new ZeroablePIDSE3Gains();
    private ReferenceFrame angularGainsFrame = null;
    private ReferenceFrame linearGainsFrame = null;
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private ReferenceFrame controlBaseFrame = null;

    public SpatialFeedbackControlCommand() {
        this.spatialAccelerationCommand.setSelectionMatrixToIdentity();
    }

    public void set(SpatialFeedbackControlCommand other) {
        this.controlFramePoseInEndEffectorFrame.setIncludingFrame((FramePose3DReadOnly)other.controlFramePoseInEndEffectorFrame);
        this.controlMode = other.controlMode;
        this.referenceOrientation.setIncludingFrame((FrameQuaternionReadOnly)other.referenceOrientation);
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)other.referencePosition);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)other.referenceAngularVelocity);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearVelocity);
        this.referenceAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)other.referenceAngularAcceleration);
        this.referenceLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearAcceleration);
        this.referenceTorque.setIncludingFrame((FrameTuple3DReadOnly)other.referenceTorque);
        this.referenceForce.setIncludingFrame((FrameTuple3DReadOnly)other.referenceForce);
        this.gains.set(other.gains);
        this.angularGainsFrame = other.angularGainsFrame;
        this.linearGainsFrame = other.linearGainsFrame;
        this.spatialAccelerationCommand.set(other.spatialAccelerationCommand);
        this.controlBaseFrame = other.controlBaseFrame;
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.spatialAccelerationCommand.set(base, endEffector);
        this.resetControlFrame();
    }

    public void setPrimaryBase(RigidBodyBasics primaryBase) {
        this.spatialAccelerationCommand.setPrimaryBase(primaryBase);
    }

    public void setControlBaseFrame(ReferenceFrame controlBaseFrame) {
        if (controlBaseFrame == this.getBase().getBodyFixedFrame()) {
            this.controlBaseFrame = null;
        } else if (controlBaseFrame.isAStationaryFrame() || controlBaseFrame instanceof MovingReferenceFrame) {
            this.controlBaseFrame = controlBaseFrame;
        } else {
            throw new IllegalArgumentException("The control base frame has to either be a stationary frame or a MovingReferenceFrame.");
        }
    }

    public void resetControlBaseFrame() {
        this.controlBaseFrame = null;
    }

    public void setScaleSecondaryTaskJointWeight(boolean scaleSecondaryTaskJointWeight, double secondaryTaskJointWeightScale) {
        this.spatialAccelerationCommand.setScaleSecondaryTaskJointWeight(scaleSecondaryTaskJointWeight, secondaryTaskJointWeightScale);
    }

    public void resetSecondaryTaskJointWeightScale() {
        this.spatialAccelerationCommand.resetSecondaryTaskJointWeightScale();
    }

    public void setGains(PIDSE3GainsReadOnly gains) {
        this.gains.set(gains);
    }

    public void setOrientationGains(PID3DGainsReadOnly orientationGains) {
        this.gains.setOrientationGains(orientationGains);
    }

    public void setPositionGains(PID3DGainsReadOnly positionGains) {
        this.gains.setPositionGains(positionGains);
    }

    public void setGainsFrames(ReferenceFrame angularGainsFrame, ReferenceFrame linearGainsFrame) {
        this.angularGainsFrame = angularGainsFrame;
        this.linearGainsFrame = linearGainsFrame;
    }

    public void setControlMode(WholeBodyControllerCoreMode controlMode) {
        this.controlMode = controlMode;
    }

    public void setInverseKinematics(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly feedForwardAngularVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setToZero(trajectoryFrame);
        this.referenceTorque.setToZero(trajectoryFrame);
    }

    public void setInverseKinematics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly feedForwardLinearVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setToZero(trajectoryFrame);
        this.referenceForce.setToZero(trajectoryFrame);
    }

    public void setInverseKinematics(FrameQuaternionReadOnly desiredOrientation, FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly feedForwardAngularVelocity, FrameVector3DReadOnly feedForwardLinearVelocity) {
        this.setInverseKinematics(desiredOrientation, feedForwardAngularVelocity);
        this.setInverseKinematics(desiredPosition, feedForwardLinearVelocity);
    }

    public void setInverseKinematics(FramePose3DReadOnly desiredPose, SpatialVectorReadOnly feedForwardVelocity) {
        this.setInverseKinematics(desiredPose.getOrientation(), feedForwardVelocity.getAngularPart());
        this.setInverseKinematics(desiredPose.getPosition(), feedForwardVelocity.getLinearPart());
    }

    public void setInverseDynamics(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly feedForwardAngularAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAngularAcceleration);
        this.referenceAngularAcceleration.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceTorque.setToZero(trajectoryFrame);
    }

    public void setInverseDynamics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardLinearAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearAcceleration);
        this.referenceLinearAcceleration.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceForce.setToZero(trajectoryFrame);
    }

    public void setInverseDynamics(FrameQuaternionReadOnly desiredOrientation, FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardAngularAcceleration, FrameVector3DReadOnly feedForwardLinearAcceleration) {
        this.setInverseDynamics(desiredOrientation, desiredAngularVelocity, feedForwardAngularAcceleration);
        this.setInverseDynamics(desiredPosition, desiredLinearVelocity, feedForwardLinearAcceleration);
    }

    public void setInverseDynamics(FramePose3DReadOnly desiredPose, SpatialVectorReadOnly desiredVelocity, SpatialVectorReadOnly feedForwardAcceleration) {
        this.setInverseDynamics(desiredPose.getOrientation(), desiredVelocity.getAngularPart(), feedForwardAcceleration.getAngularPart());
        this.setInverseDynamics(desiredPose.getPosition(), desiredVelocity.getLinearPart(), feedForwardAcceleration.getLinearPart());
    }

    public void setVirtualModelControl(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly feedForwardTorque) {
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceTorque.setIncludingFrame((FrameTuple3DReadOnly)feedForwardTorque);
        this.referenceTorque.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setToZero(trajectoryFrame);
    }

    public void setVirtualModelControl(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardForce) {
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
        ReferenceFrame trajectoryFrame = desiredPosition.getReferenceFrame();
        this.referencePosition.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referenceLinearVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredLinearVelocity);
        this.referenceLinearVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceForce.setIncludingFrame((FrameTuple3DReadOnly)feedForwardForce);
        this.referenceForce.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceLinearAcceleration.setToZero(trajectoryFrame);
    }

    public void setVirtualModelControl(FrameQuaternionReadOnly desiredOrientation, FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardTorque, FrameVector3DReadOnly feedForwardForce) {
        this.setVirtualModelControl(desiredOrientation, desiredAngularVelocity, feedForwardTorque);
        this.setVirtualModelControl(desiredPosition, desiredLinearVelocity, feedForwardForce);
    }

    public void setVirtualModelControl(FramePose3DReadOnly desiredPose, SpatialVectorReadOnly desiredVelocity, SpatialVectorReadOnly feedForwardEffort) {
        this.setVirtualModelControl(desiredPose.getOrientation(), desiredVelocity.getAngularPart(), feedForwardEffort.getAngularPart());
        this.setVirtualModelControl(desiredPose.getPosition(), desiredVelocity.getLinearPart(), feedForwardEffort.getLinearPart());
    }

    public void resetControlFrame() {
        this.controlFramePoseInEndEffectorFrame.setToZero((ReferenceFrame)this.getEndEffector().getBodyFixedFrame());
    }

    public void setControlFrameFixedInEndEffector(FramePoint3DReadOnly position) {
        RigidBodyBasics endEffector = this.spatialAccelerationCommand.getEndEffector();
        position.checkReferenceFrameMatch((ReferenceFrame)endEffector.getBodyFixedFrame());
        this.controlFramePoseInEndEffectorFrame.setToZero((ReferenceFrame)endEffector.getBodyFixedFrame());
        this.controlFramePoseInEndEffectorFrame.getPosition().set((FrameTuple3DReadOnly)position);
    }

    public void setControlFrameFixedInEndEffector(FramePoint3DReadOnly position, FrameQuaternionReadOnly orientation) {
        RigidBodyBasics endEffector = this.spatialAccelerationCommand.getEndEffector();
        position.checkReferenceFrameMatch((ReferenceFrame)endEffector.getBodyFixedFrame());
        orientation.checkReferenceFrameMatch((ReferenceFrame)endEffector.getBodyFixedFrame());
        this.controlFramePoseInEndEffectorFrame.setIncludingFrame((FrameTuple3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
    }

    public void setControlFrameFixedInEndEffector(FramePose3DReadOnly pose) {
        RigidBodyBasics endEffector = this.spatialAccelerationCommand.getEndEffector();
        pose.checkReferenceFrameMatch((ReferenceFrame)endEffector.getBodyFixedFrame());
        this.controlFramePoseInEndEffectorFrame.setIncludingFrame(pose);
    }

    public void setControlFrameFixedInEndEffector(RigidBodyTransform poseInBodyFrame) {
        this.controlFramePoseInEndEffectorFrame.setIncludingFrame((ReferenceFrame)this.getEndEffector().getBodyFixedFrame(), (RigidBodyTransformReadOnly)poseInBodyFrame);
    }

    public void setSelectionMatrixToIdentity() {
        this.spatialAccelerationCommand.setSelectionMatrixToIdentity();
    }

    public void setSelectionMatrixForLinearControl() {
        this.spatialAccelerationCommand.setSelectionMatrixForLinearControl();
    }

    public void setSelectionMatrixForLinearControl(SelectionMatrix3D linearSelectionMatrix) {
        this.spatialAccelerationCommand.setSelectionMatrixForLinearControl(linearSelectionMatrix);
    }

    public void setSelectionMatrixForAngularControl() {
        this.spatialAccelerationCommand.setSelectionMatrixForAngularControl();
    }

    public void setSelectionMatrixForAngularControl(SelectionMatrix3D angularSelectionMatrix) {
        this.spatialAccelerationCommand.setSelectionMatrixForAngularControl(angularSelectionMatrix);
    }

    public void setSelectionMatrix(SelectionMatrix6D selectionMatrix) {
        this.spatialAccelerationCommand.setSelectionMatrix(selectionMatrix);
    }

    public void setWeightForSolver(double weight) {
        this.spatialAccelerationCommand.setWeight(weight);
    }

    public void setWeightsForSolver(double angularWeight, double linearWeight) {
        this.spatialAccelerationCommand.setWeight(angularWeight, linearWeight);
    }

    public void setWeightMatrixForSolver(WeightMatrix6D weightMatrix) {
        this.spatialAccelerationCommand.setWeightMatrix(weightMatrix);
    }

    public void setWeightsForSolver(Vector3DReadOnly angular, Vector3DReadOnly linear) {
        this.spatialAccelerationCommand.setWeights((Tuple3DReadOnly)angular, (Tuple3DReadOnly)linear);
    }

    public void setLinearWeightsForSolver(Vector3DReadOnly linear) {
        this.spatialAccelerationCommand.setLinearWeights((Tuple3DReadOnly)linear);
    }

    public void setAngularWeightsForSolver(Vector3DReadOnly angular) {
        this.spatialAccelerationCommand.setAngularWeights((Tuple3DReadOnly)angular);
    }

    public FramePose3DBasics getControlFramePose() {
        return this.controlFramePoseInEndEffectorFrame;
    }

    public void getControlFramePoseIncludingFrame(FramePoint3DBasics position, FrameQuaternionBasics orientation) {
        position.setIncludingFrame((FrameTuple3DReadOnly)this.controlFramePoseInEndEffectorFrame.getPosition());
        orientation.setIncludingFrame((FrameQuaternionReadOnly)this.controlFramePoseInEndEffectorFrame.getOrientation());
    }

    public WholeBodyControllerCoreMode getControlMode() {
        return this.controlMode;
    }

    public FrameQuaternionBasics getReferenceOrientation() {
        return this.referenceOrientation;
    }

    public FramePoint3DBasics getReferencePosition() {
        return this.referencePosition;
    }

    public FrameVector3DBasics getReferenceAngularVelocity() {
        return this.referenceAngularVelocity;
    }

    public FrameVector3DBasics getReferenceLinearVelocity() {
        return this.referenceLinearVelocity;
    }

    public FrameVector3DBasics getReferenceAngularAcceleration() {
        return this.referenceAngularAcceleration;
    }

    public FrameVector3DBasics getReferenceLinearAcceleration() {
        return this.referenceLinearAcceleration;
    }

    public FrameVector3DBasics getReferenceTorque() {
        return this.referenceTorque;
    }

    public FrameVector3D getReferenceForce() {
        return this.referenceForce;
    }

    public RigidBodyBasics getBase() {
        return this.spatialAccelerationCommand.getBase();
    }

    public RigidBodyBasics getEndEffector() {
        return this.spatialAccelerationCommand.getEndEffector();
    }

    public ReferenceFrame getControlBaseFrame() {
        if (this.controlBaseFrame != null) {
            return this.controlBaseFrame;
        }
        return this.spatialAccelerationCommand.getBase().getBodyFixedFrame();
    }

    public SpatialAccelerationCommand getSpatialAccelerationCommand() {
        return this.spatialAccelerationCommand;
    }

    public PIDSE3Gains getGains() {
        return this.gains;
    }

    public ReferenceFrame getAngularGainsFrame() {
        return this.angularGainsFrame;
    }

    public ReferenceFrame getLinearGainsFrame() {
        return this.linearGainsFrame;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.TASKSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.spatialAccelerationCommand.setCommandId(id);
    }

    @Override
    public int getCommandId() {
        return this.spatialAccelerationCommand.getCommandId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SpatialFeedbackControlCommand) {
            SpatialFeedbackControlCommand other = (SpatialFeedbackControlCommand)object;
            if (this.controlMode != other.controlMode) {
                return false;
            }
            if (!this.controlFramePoseInEndEffectorFrame.equals((FramePose3DReadOnly)other.controlFramePoseInEndEffectorFrame)) {
                return false;
            }
            if (!this.referenceOrientation.equals((FrameTuple4DReadOnly)other.referenceOrientation)) {
                return false;
            }
            if (!this.referencePosition.equals((FrameTuple3DReadOnly)other.referencePosition)) {
                return false;
            }
            if (!this.referenceAngularVelocity.equals((FrameTuple3DReadOnly)other.referenceAngularVelocity)) {
                return false;
            }
            if (!this.referenceLinearVelocity.equals((FrameTuple3DReadOnly)other.referenceLinearVelocity)) {
                return false;
            }
            if (!this.referenceAngularAcceleration.equals((FrameTuple3DReadOnly)other.referenceAngularAcceleration)) {
                return false;
            }
            if (!this.referenceLinearAcceleration.equals((FrameTuple3DReadOnly)other.referenceLinearAcceleration)) {
                return false;
            }
            if (!this.referenceTorque.equals((FrameTuple3DReadOnly)other.referenceTorque)) {
                return false;
            }
            if (!this.referenceForce.equals((FrameTuple3DReadOnly)other.referenceForce)) {
                return false;
            }
            if (!this.gains.equals((PIDSE3GainsReadOnly)other.gains)) {
                return false;
            }
            if (this.linearGainsFrame != other.linearGainsFrame) {
                return false;
            }
            if (this.angularGainsFrame != other.angularGainsFrame) {
                return false;
            }
            if (!this.spatialAccelerationCommand.equals(other.spatialAccelerationCommand)) {
                return false;
            }
            return this.controlBaseFrame == other.controlBaseFrame;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        ret = ret + "base = " + this.spatialAccelerationCommand.getBase() + ", ";
        ret = ret + "endEffector = " + this.spatialAccelerationCommand.getEndEffector() + ", ";
        ret = ret + "position = " + this.referencePosition + ", orientation = " + this.referenceOrientation.toStringAsYawPitchRoll();
        return ret;
    }
}

