/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple4DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ZeroablePID3DGains;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;

public class OrientationFeedbackControlCommand
implements FeedbackControlCommand<OrientationFeedbackControlCommand> {
    private final FrameQuaternion bodyFixedOrientationInEndEffectorFrame = new FrameQuaternion();
    private WholeBodyControllerCoreMode controlMode = null;
    private final FrameQuaternion referenceOrientation = new FrameQuaternion();
    private final FrameVector3D referenceAngularVelocity = new FrameVector3D();
    private final FrameVector3D referenceAngularAcceleration = new FrameVector3D();
    private final FrameVector3D referenceTorque = new FrameVector3D();
    private final ZeroablePID3DGains gains = new ZeroablePID3DGains();
    private ReferenceFrame angularGainsFrame = null;
    private final SpatialAccelerationCommand spatialAccelerationCommand = new SpatialAccelerationCommand();
    private ReferenceFrame controlBaseFrame = null;

    public OrientationFeedbackControlCommand() {
        this.spatialAccelerationCommand.setSelectionMatrixForAngularControl();
    }

    public void set(OrientationFeedbackControlCommand other) {
        this.bodyFixedOrientationInEndEffectorFrame.setIncludingFrame((FrameQuaternionReadOnly)other.bodyFixedOrientationInEndEffectorFrame);
        this.controlMode = other.controlMode;
        this.referenceOrientation.setIncludingFrame((FrameQuaternionReadOnly)other.referenceOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)other.referenceAngularVelocity);
        this.referenceAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)other.referenceAngularAcceleration);
        this.referenceTorque.setIncludingFrame((FrameTuple3DReadOnly)other.referenceTorque);
        this.gains.set(other.gains);
        this.angularGainsFrame = other.angularGainsFrame;
        this.spatialAccelerationCommand.set(other.spatialAccelerationCommand);
        this.controlBaseFrame = other.controlBaseFrame;
    }

    public void set(RigidBodyBasics base, RigidBodyBasics endEffector) {
        this.spatialAccelerationCommand.set(base, endEffector);
        this.resetBodyFixedOrientation();
    }

    public void setPrimaryBase(RigidBodyBasics primaryBase) {
        this.spatialAccelerationCommand.setPrimaryBase(primaryBase);
    }

    public void setControlBaseFrame(ReferenceFrame controlBaseFrame) {
        if (controlBaseFrame == this.getBase().getBodyFixedFrame()) {
            this.controlBaseFrame = null;
        } else if (controlBaseFrame.isAStationaryFrame() || controlBaseFrame instanceof MovingReferenceFrame) {
            this.controlBaseFrame = controlBaseFrame;
        } else {
            throw new IllegalArgumentException("The control base frame has to either be a stationary frame or a MovingReferenceFrame.");
        }
    }

    public void setGains(PID3DGainsReadOnly gains) {
        this.gains.set(gains);
    }

    public void resetControlBaseFrame() {
        this.controlBaseFrame = null;
    }

    public void setGainsFrame(ReferenceFrame angularGainsFrame) {
        this.angularGainsFrame = angularGainsFrame;
    }

    public void setControlMode(WholeBodyControllerCoreMode controlMode) {
        this.controlMode = controlMode;
    }

    public void setInverseKinematics(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly feedForwardAngularVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setToZero(trajectoryFrame);
        this.referenceTorque.setToZero(trajectoryFrame);
    }

    public void setInverseDynamics(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly feedForwardAngularAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setIncludingFrame((FrameTuple3DReadOnly)feedForwardAngularAcceleration);
        this.referenceAngularAcceleration.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceTorque.setToZero(trajectoryFrame);
    }

    public void setVirtualModelControl(FrameQuaternionReadOnly desiredOrientation, FrameVector3DReadOnly desiredAngularVelocity, FrameVector3DReadOnly feedForwardTorque) {
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
        ReferenceFrame trajectoryFrame = desiredOrientation.getReferenceFrame();
        this.referenceOrientation.setIncludingFrame(desiredOrientation);
        this.referenceAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)desiredAngularVelocity);
        this.referenceAngularVelocity.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceTorque.setIncludingFrame((FrameTuple3DReadOnly)feedForwardTorque);
        this.referenceTorque.checkReferenceFrameMatch(trajectoryFrame);
        this.referenceAngularAcceleration.setToZero(trajectoryFrame);
    }

    public void resetBodyFixedOrientation() {
        this.bodyFixedOrientationInEndEffectorFrame.setToZero((ReferenceFrame)this.getEndEffector().getBodyFixedFrame());
    }

    public void setBodyFixedOrientationToControl(FrameQuaternionReadOnly bodyFixedOrientationInEndEffectorFrame) {
        bodyFixedOrientationInEndEffectorFrame.checkReferenceFrameMatch((ReferenceFrame)this.getEndEffector().getBodyFixedFrame());
        this.bodyFixedOrientationInEndEffectorFrame.set(bodyFixedOrientationInEndEffectorFrame);
    }

    public void setSelectionMatrixToIdentity() {
        this.spatialAccelerationCommand.setSelectionMatrixForAngularControl();
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.spatialAccelerationCommand.setSelectionMatrixForAngularControl(selectionMatrix);
    }

    public void setWeightForSolver(double weight) {
        this.spatialAccelerationCommand.setWeight(weight);
    }

    public void setWeightMatrix(WeightMatrix3D angularWeightMatrix) {
        this.spatialAccelerationCommand.setAngularPartOfWeightMatrix(angularWeightMatrix);
        this.spatialAccelerationCommand.setLinearWeightsToZero();
    }

    public void setWeightsForSolver(Vector3DReadOnly angular) {
        this.spatialAccelerationCommand.setAngularWeights((Tuple3DReadOnly)angular);
        this.spatialAccelerationCommand.setLinearWeightsToZero();
    }

    public void getBodyFixedOrientationIncludingFrame(FrameQuaternion bodyFixedOrientationToControlToPack) {
        bodyFixedOrientationToControlToPack.setIncludingFrame((FrameQuaternionReadOnly)this.bodyFixedOrientationInEndEffectorFrame);
    }

    public FrameQuaternionBasics getBodyFixedOrientationToControl() {
        return this.bodyFixedOrientationInEndEffectorFrame;
    }

    public WholeBodyControllerCoreMode getControlMode() {
        return this.controlMode;
    }

    public FrameQuaternionBasics getReferenceOrientation() {
        return this.referenceOrientation;
    }

    public FrameVector3DBasics getReferenceAngularVelocity() {
        return this.referenceAngularVelocity;
    }

    public FrameVector3DBasics getReferenceAngularAcceleration() {
        return this.referenceAngularAcceleration;
    }

    public FrameVector3DBasics getReferenceTorque() {
        return this.referenceTorque;
    }

    public RigidBodyBasics getBase() {
        return this.spatialAccelerationCommand.getBase();
    }

    public RigidBodyBasics getEndEffector() {
        return this.spatialAccelerationCommand.getEndEffector();
    }

    public ReferenceFrame getControlBaseFrame() {
        if (this.controlBaseFrame != null) {
            return this.controlBaseFrame;
        }
        return this.spatialAccelerationCommand.getBase().getBodyFixedFrame();
    }

    public SpatialAccelerationCommand getSpatialAccelerationCommand() {
        return this.spatialAccelerationCommand;
    }

    public PID3DGains getGains() {
        return this.gains;
    }

    public ReferenceFrame getAngularGainsFrame() {
        return this.angularGainsFrame;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.ORIENTATION;
    }

    @Override
    public void setCommandId(int id) {
        this.spatialAccelerationCommand.setCommandId(id);
    }

    @Override
    public int getCommandId() {
        return this.spatialAccelerationCommand.getCommandId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OrientationFeedbackControlCommand) {
            OrientationFeedbackControlCommand other = (OrientationFeedbackControlCommand)object;
            if (this.controlMode != other.controlMode) {
                return false;
            }
            if (!this.bodyFixedOrientationInEndEffectorFrame.equals((FrameTuple4DReadOnly)other.bodyFixedOrientationInEndEffectorFrame)) {
                return false;
            }
            if (!this.referenceOrientation.equals((FrameTuple4DReadOnly)other.referenceOrientation)) {
                return false;
            }
            if (!this.referenceAngularVelocity.equals((FrameTuple3DReadOnly)other.referenceAngularVelocity)) {
                return false;
            }
            if (!this.referenceAngularAcceleration.equals((FrameTuple3DReadOnly)other.referenceAngularAcceleration)) {
                return false;
            }
            if (!this.referenceTorque.equals((FrameTuple3DReadOnly)other.referenceTorque)) {
                return false;
            }
            if (!this.gains.equals((PID3DGainsReadOnly)other.gains)) {
                return false;
            }
            if (this.angularGainsFrame != other.angularGainsFrame) {
                return false;
            }
            if (!this.spatialAccelerationCommand.equals(other.spatialAccelerationCommand)) {
                return false;
            }
            return this.controlBaseFrame == other.controlBaseFrame;
        }
        return false;
    }

    public String toString() {
        String ret = this.getClass().getSimpleName() + ": ";
        ret = ret + "base = " + this.spatialAccelerationCommand.getBase() + ", ";
        ret = ret + "endEffector = " + this.spatialAccelerationCommand.getEndEffector() + ", ";
        ret = ret + "orientation = " + this.referenceOrientation.toStringAsYawPitchRoll();
        return ret;
    }
}

