/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.PDGains;

public class OneDoFJointFeedbackControlCommand
implements FeedbackControlCommand<OneDoFJointFeedbackControlCommand> {
    private int commandId;
    private OneDoFJointBasics joint;
    private WholeBodyControllerCoreMode controlMode = null;
    private double referencePosition = 0.0;
    private double referenceVelocity = 0.0;
    private double referenceAcceleration = 0.0;
    private double referenceEffort = 0.0;
    private double weightForSolver = Double.POSITIVE_INFINITY;
    private final PDGains gains = new PDGains();

    public void clear() {
        this.commandId = 0;
        this.controlMode = null;
        this.joint = null;
        this.referencePosition = 0.0;
        this.referenceVelocity = 0.0;
        this.referenceAcceleration = 0.0;
        this.referenceEffort = 0.0;
        this.weightForSolver = Double.POSITIVE_INFINITY;
        this.gains.set(0.0, 0.0, 0.0, 0.0);
    }

    public void set(OneDoFJointFeedbackControlCommand other) {
        this.commandId = other.commandId;
        this.controlMode = other.controlMode;
        this.joint = other.joint;
        this.referencePosition = other.referencePosition;
        this.referenceVelocity = other.referenceVelocity;
        this.referenceAcceleration = other.referenceAcceleration;
        this.referenceEffort = other.referenceEffort;
        this.weightForSolver = other.weightForSolver;
        this.gains.set(other.gains);
    }

    public void setJoint(OneDoFJointBasics joint) {
        this.joint = joint;
    }

    public void setControlMode(WholeBodyControllerCoreMode controlMode) {
        this.controlMode = controlMode;
    }

    public void setGains(PDGainsReadOnly gains) {
        this.gains.set(gains);
    }

    public void setWeightForSolver(double weight) {
        this.weightForSolver = weight;
    }

    public void setInverseKinematics(double desiredPosition, double feedForwardVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        this.referencePosition = desiredPosition;
        this.referenceVelocity = feedForwardVelocity;
        this.referenceAcceleration = 0.0;
        this.referenceEffort = 0.0;
    }

    public void setInverseDynamics(double desiredPosition, double desiredVelocity, double feedForwardAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        this.referencePosition = desiredPosition;
        this.referenceVelocity = desiredVelocity;
        this.referenceAcceleration = feedForwardAcceleration;
        this.referenceEffort = 0.0;
    }

    public void setVirtualModelControl(double desiredPosition, double desiredVelocity, double feedForwardEffort) {
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
        this.referencePosition = desiredPosition;
        this.referenceVelocity = desiredVelocity;
        this.referenceAcceleration = 0.0;
        this.referenceEffort = feedForwardEffort;
    }

    public void setReferencePosition(double referencePosition) {
        this.referencePosition = referencePosition;
    }

    public void setReferenceVelocity(double referenceVelocity) {
        this.referenceVelocity = referenceVelocity;
    }

    public void setReferenceAcceleration(double referenceAcceleration) {
        this.referenceAcceleration = referenceAcceleration;
    }

    public void setReferenceEffort(double referenceEffort) {
        this.referenceEffort = referenceEffort;
    }

    public WholeBodyControllerCoreMode getControlMode() {
        return this.controlMode;
    }

    public OneDoFJointBasics getJoint() {
        return this.joint;
    }

    public double getReferencePosition() {
        return this.referencePosition;
    }

    public double getReferenceVelocity() {
        return this.referenceVelocity;
    }

    public double getReferenceAcceleration() {
        return this.referenceAcceleration;
    }

    public double getReferenceEffort() {
        return this.referenceEffort;
    }

    public double getWeightForSolver() {
        return this.weightForSolver;
    }

    public PDGains getGains() {
        return this.gains;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.JOINTSPACE;
    }

    @Override
    public void setCommandId(int id) {
        this.commandId = id;
    }

    @Override
    public int getCommandId() {
        return this.commandId;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OneDoFJointFeedbackControlCommand) {
            OneDoFJointFeedbackControlCommand other = (OneDoFJointFeedbackControlCommand)object;
            if (this.commandId != other.commandId) {
                return false;
            }
            if (this.controlMode != other.controlMode) {
                return false;
            }
            if (this.joint != other.joint) {
                return false;
            }
            if (Double.compare(this.referencePosition, other.referencePosition) != 0) {
                return false;
            }
            if (Double.compare(this.referenceVelocity, other.referenceVelocity) != 0) {
                return false;
            }
            if (Double.compare(this.referenceAcceleration, other.referenceAcceleration) != 0) {
                return false;
            }
            if (Double.compare(this.referenceEffort, other.referenceEffort) != 0) {
                return false;
            }
            if (Double.compare(this.weightForSolver, other.weightForSolver) != 0) {
                return false;
            }
            return this.gains.equals((PDGainsReadOnly)other.gains);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": control mode: " + (Object)((Object)this.controlMode) + ", q: " + this.referencePosition + ", qd: " + this.referenceVelocity + ", qdd: " + this.referenceAcceleration + ", tau: " + this.referenceEffort;
    }
}

