/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.robotics.controllers.pidGains.PDGainsReadOnly;

public class JointspaceFeedbackControlCommand
extends FeedbackControlCommandList {
    private static final int initialCapacity = 15;
    private final RecyclingArrayList<OneDoFJointFeedbackControlCommand> jointCommands = new RecyclingArrayList(15, OneDoFJointFeedbackControlCommand.class);

    public JointspaceFeedbackControlCommand() {
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.jointCommands.clear();
    }

    @Override
    public void addCommand(FeedbackControlCommand<?> command) {
        if (!(command instanceof OneDoFJointFeedbackControlCommand)) {
            throw new IllegalArgumentException("Cannot add a " + command.getClass().getSimpleName() + " to a " + this.getClass().getSimpleName());
        }
        this.addCommand((OneDoFJointFeedbackControlCommand)command);
    }

    public void addCommand(OneDoFJointFeedbackControlCommand command) {
        this.addEmptyCommand().set(command);
    }

    @Override
    public FeedbackControlCommand<?> pollCommand() {
        throw new UnsupportedOperationException();
    }

    public void setGains(PDGainsReadOnly gains) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ((OneDoFJointFeedbackControlCommand)this.jointCommands.get(jointIndex)).setGains(gains);
        }
    }

    public void setWeightForSolver(double weight) {
        for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
            ((OneDoFJointFeedbackControlCommand)this.jointCommands.get(jointIndex)).setWeightForSolver(weight);
        }
    }

    public OneDoFJointFeedbackControlCommand addEmptyCommand() {
        OneDoFJointFeedbackControlCommand command = (OneDoFJointFeedbackControlCommand)this.jointCommands.add();
        command.clear();
        super.addCommand(command);
        return command;
    }

    public OneDoFJointFeedbackControlCommand addJointCommand(OneDoFJointBasics joint) {
        OneDoFJointFeedbackControlCommand jointCommand = this.addEmptyCommand();
        jointCommand.setJoint(joint);
        return jointCommand;
    }

    @Override
    public void set(FeedbackControlCommandList other) {
        if (!(other instanceof JointspaceFeedbackControlCommand)) {
            throw new IllegalArgumentException("Cannot set a " + this.getClass().getSimpleName() + " from a " + other.getClass().getSimpleName());
        }
        this.set((JointspaceFeedbackControlCommand)other);
    }

    public void set(JointspaceFeedbackControlCommand other) {
        this.clear();
        this.setCommandId(other.getCommandId());
        for (int jointIndex = 0; jointIndex < other.getNumberOfCommands(); ++jointIndex) {
            this.addCommand((OneDoFJointFeedbackControlCommand)other.jointCommands.get(jointIndex));
        }
    }

    public int getNumberOfJoints() {
        return this.getNumberOfCommands();
    }

    public OneDoFJointBasics getJoint(int jointIndex) {
        return ((OneDoFJointFeedbackControlCommand)this.jointCommands.get(jointIndex)).getJoint();
    }

    public OneDoFJointFeedbackControlCommand getJointCommand(int jointIndex) {
        return (OneDoFJointFeedbackControlCommand)this.jointCommands.get(jointIndex);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof JointspaceFeedbackControlCommand) {
            JointspaceFeedbackControlCommand other = (JointspaceFeedbackControlCommand)object;
            if (this.getCommandId() != other.getCommandId()) {
                return false;
            }
            if (this.getNumberOfJoints() != other.getNumberOfJoints()) {
                return false;
            }
            for (int jointIndex = 0; jointIndex < this.getNumberOfJoints(); ++jointIndex) {
                if (((OneDoFJointFeedbackControlCommand)this.jointCommands.get(jointIndex)).equals(other.jointCommands.get(jointIndex))) continue;
                return false;
            }
            return super.equals(object);
        }
        return false;
    }
}

