/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController;

import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.implementations.ZeroablePID3DGains;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;

public class CenterOfMassFeedbackControlCommand
implements FeedbackControlCommand<CenterOfMassFeedbackControlCommand> {
    private WholeBodyControllerCoreMode controlMode = null;
    private final FramePoint3D referencePositionInRootFrame = new FramePoint3D();
    private final FrameVector3D referenceLinearVelocityInRootFrame = new FrameVector3D();
    private final FrameVector3D referenceLinearAccelerationInRootFrame = new FrameVector3D();
    private final ZeroablePID3DGains gains = new ZeroablePID3DGains();
    private final MomentumRateCommand momentumRateCommand = new MomentumRateCommand();

    public CenterOfMassFeedbackControlCommand() {
        this.momentumRateCommand.setSelectionMatrixForLinearControl();
    }

    public void set(CenterOfMassFeedbackControlCommand other) {
        this.controlMode = other.controlMode;
        this.referencePositionInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)other.referencePositionInRootFrame);
        this.referenceLinearVelocityInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearVelocityInRootFrame);
        this.referenceLinearAccelerationInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)other.referenceLinearAccelerationInRootFrame);
        this.setGains((PID3DGains)other.gains);
        this.momentumRateCommand.set(other.momentumRateCommand);
    }

    public void setGains(PID3DGains gains) {
        this.gains.set((PID3DGainsReadOnly)gains);
    }

    public void setControlMode(WholeBodyControllerCoreMode controlMode) {
        this.controlMode = controlMode;
    }

    public void setInverseKinematics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly feedForwardLinearVelocity) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_KINEMATICS);
        ReferenceFrame rootFrame = desiredPosition.getReferenceFrame().getRootFrame();
        this.referencePositionInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referencePositionInRootFrame.changeFrame(rootFrame);
        this.referenceLinearVelocityInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearVelocity);
        this.referenceLinearVelocityInRootFrame.changeFrame(rootFrame);
        this.referenceLinearAccelerationInRootFrame.setToZero(rootFrame);
    }

    public void setInverseDynamics(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardLinearAcceleration) {
        this.setControlMode(WholeBodyControllerCoreMode.INVERSE_DYNAMICS);
        ReferenceFrame rootFrame = desiredPosition.getReferenceFrame().getRootFrame();
        this.referencePositionInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)desiredPosition);
        this.referencePositionInRootFrame.changeFrame(rootFrame);
        this.referenceLinearVelocityInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)desiredLinearVelocity);
        this.referenceLinearVelocityInRootFrame.changeFrame(rootFrame);
        this.referenceLinearAccelerationInRootFrame.setIncludingFrame((FrameTuple3DReadOnly)feedForwardLinearAcceleration);
        this.referenceLinearAccelerationInRootFrame.changeFrame(rootFrame);
    }

    public void setVirtualModelControl(FramePoint3DReadOnly desiredPosition, FrameVector3DReadOnly desiredLinearVelocity, FrameVector3DReadOnly feedForwardLinearAcceleration) {
        this.setInverseDynamics(desiredPosition, desiredLinearVelocity, feedForwardLinearAcceleration);
        this.setControlMode(WholeBodyControllerCoreMode.VIRTUAL_MODEL);
    }

    public void setSelectionMatrixToIdentity() {
        this.momentumRateCommand.setSelectionMatrixForLinearControl();
    }

    public void setSelectionMatrixForLinearXYControl() {
        this.momentumRateCommand.setSelectionMatrixForLinearXYControl();
    }

    public void setSelectionMatrix(SelectionMatrix3D selectionMatrix) {
        this.momentumRateCommand.setSelectionMatrixForLinearControl(selectionMatrix);
    }

    public void setWeightForSolver(double weight) {
        this.momentumRateCommand.setWeight(weight);
    }

    public void setWeightsForSolver(DMatrixRMaj weightVector) {
        if (weightVector.getNumRows() != 3) {
            throw new RuntimeException("Unexpected number of rows for the given weight vector. Expected 3 but was: " + weightVector.getNumRows());
        }
        this.momentumRateCommand.setWeights(0.0, 0.0, 0.0, weightVector.get(0, 0), weightVector.get(1, 0), weightVector.get(2, 0));
    }

    public void setWeightsForSolver(Vector3DReadOnly weight) {
        this.momentumRateCommand.setLinearWeights((Tuple3DReadOnly)weight);
        this.momentumRateCommand.setAngularWeightsToZero();
    }

    public WholeBodyControllerCoreMode getControlMode() {
        return this.controlMode;
    }

    public FramePoint3DBasics getReferencePosition() {
        return this.referencePositionInRootFrame;
    }

    public FrameVector3DBasics getReferenceLinearVelocity() {
        return this.referenceLinearVelocityInRootFrame;
    }

    public FrameVector3DBasics getReferenceLinearAcceleration() {
        return this.referenceLinearAccelerationInRootFrame;
    }

    public MomentumRateCommand getMomentumRateCommand() {
        return this.momentumRateCommand;
    }

    public PID3DGains getGains() {
        return this.gains;
    }

    @Override
    public ControllerCoreCommandType getCommandType() {
        return ControllerCoreCommandType.MOMENTUM;
    }

    @Override
    public void setCommandId(int id) {
        this.momentumRateCommand.setCommandId(id);
    }

    @Override
    public int getCommandId() {
        return this.momentumRateCommand.getCommandId();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CenterOfMassFeedbackControlCommand) {
            CenterOfMassFeedbackControlCommand other = (CenterOfMassFeedbackControlCommand)object;
            if (this.controlMode != other.controlMode) {
                return false;
            }
            if (!this.referencePositionInRootFrame.equals((FrameTuple3DReadOnly)other.referencePositionInRootFrame)) {
                return false;
            }
            if (!this.referenceLinearVelocityInRootFrame.equals((FrameTuple3DReadOnly)other.referenceLinearVelocityInRootFrame)) {
                return false;
            }
            if (!this.referenceLinearAccelerationInRootFrame.equals((FrameTuple3DReadOnly)other.referenceLinearAccelerationInRootFrame)) {
                return false;
            }
            if (!this.gains.equals((PID3DGainsReadOnly)other.gains)) {
                return false;
            }
            return this.momentumRateCommand.equals(other.momentumRateCommand);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": control mode: " + (Object)((Object)this.controlMode) + ", reference position: " + this.referencePositionInRootFrame + ", reference velocity: " + this.referenceLinearVelocityInRootFrame + ", reference acceleration: " + this.referenceLinearAccelerationInRootFrame;
    }
}

