/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command;

import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.robotSide.RobotSide;

public class DesiredExternalWrenchHolder
implements Settable<DesiredExternalWrenchHolder> {
    private final List<RigidBodyBasics> bodiesWithExternalWrench = new ArrayList<RigidBodyBasics>();
    private final RecyclingArrayList<Wrench> desiredExternalWrenches = new RecyclingArrayList(Wrench::new);
    private final transient TLongObjectMap<Wrench> desiredExternalWrenchMap = new TLongObjectHashMap();

    public DesiredExternalWrenchHolder() {
    }

    public DesiredExternalWrenchHolder(Collection<RigidBodyBasics> rigidBodies) {
        rigidBodies.forEach(rigidBody -> this.registerRigidBody((RigidBodyBasics)rigidBody));
    }

    public DesiredExternalWrenchHolder(FullHumanoidRobotModel fullRobotModel) {
        for (RobotSide robotSide : RobotSide.values) {
            this.registerRigidBody(fullRobotModel.getFoot((Enum)robotSide));
        }
    }

    public void clear() {
        this.bodiesWithExternalWrench.clear();
        this.desiredExternalWrenches.clear();
        this.desiredExternalWrenchMap.clear();
    }

    public void registerRigidBody(RigidBodyBasics rigidBody) {
        if (this.bodiesWithExternalWrench.contains(rigidBody)) {
            throw new RuntimeException("The body: " + rigidBody.getName() + " has already been registered.");
        }
        Wrench wrench = (Wrench)this.desiredExternalWrenches.add();
        wrench.setToNaN((ReferenceFrame)rigidBody.getBodyFixedFrame(), (ReferenceFrame)rigidBody.getBodyFixedFrame());
        this.bodiesWithExternalWrench.add(rigidBody);
        this.desiredExternalWrenchMap.put((long)rigidBody.hashCode(), (Object)wrench);
    }

    public void registerRigidBody(RigidBodyBasics rigidBody, WrenchReadOnly desiredExternalWrench) {
        if (this.bodiesWithExternalWrench.contains(rigidBody)) {
            throw new RuntimeException("The body: " + rigidBody.getName() + " has already been registered.");
        }
        Wrench wrench = (Wrench)this.desiredExternalWrenches.add();
        wrench.setIncludingFrame(desiredExternalWrench);
        wrench.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
        this.bodiesWithExternalWrench.add(rigidBody);
        this.desiredExternalWrenchMap.put((long)rigidBody.hashCode(), (Object)wrench);
    }

    public int getNumberOfBodiesWithDesiredExternalWrench() {
        return this.bodiesWithExternalWrench.size();
    }

    public RigidBodyBasics getRigidBody(int bodyIndex) {
        return this.bodiesWithExternalWrench.get(bodyIndex);
    }

    public void setDesiredExternalWrench(WrenchReadOnly desiredExternalWrench, RigidBodyBasics rigidBody) {
        Wrench wrench = (Wrench)this.desiredExternalWrenchMap.get((long)rigidBody.hashCode());
        wrench.setIncludingFrame(desiredExternalWrench);
        wrench.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
    }

    public void setDesiredExternalWrench(ReferenceFrame referenceFrame, Vector3DReadOnly torque, Vector3DReadOnly force, RigidBodyBasics rigidBody) {
        Wrench wrench = (Wrench)this.desiredExternalWrenchMap.get((long)rigidBody.hashCode());
        if (torque != null) {
            wrench.getAngularPart().set((Tuple3DReadOnly)torque);
        } else {
            wrench.getAngularPart().setToZero();
        }
        if (force != null) {
            wrench.getLinearPart().set((Tuple3DReadOnly)force);
        } else {
            wrench.getLinearPart().setToZero();
        }
        wrench.setReferenceFrame(referenceFrame);
        wrench.setBodyFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
        wrench.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
    }

    public void setDesiredExternalWrench(ReferenceFrame referenceFrame, Vector3DReadOnly torque, Vector3DReadOnly force, int bodyIndex) {
        RigidBodyBasics rigidBody = this.getRigidBody(bodyIndex);
        Wrench wrench = (Wrench)this.desiredExternalWrenches.get(bodyIndex);
        if (torque != null) {
            wrench.getAngularPart().set((Tuple3DReadOnly)torque);
        } else {
            wrench.getAngularPart().setToZero();
        }
        if (force != null) {
            wrench.getLinearPart().set((Tuple3DReadOnly)force);
        } else {
            wrench.getLinearPart().setToZero();
        }
        wrench.setReferenceFrame(referenceFrame);
        wrench.setBodyFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
        wrench.changeFrame((ReferenceFrame)rigidBody.getBodyFixedFrame());
    }

    public boolean getDesiredExternalWrench(WrenchBasics desiredExternalWrenchToPack, RigidBodyBasics rigidBody) {
        Wrench wrench = (Wrench)this.desiredExternalWrenchMap.get((long)rigidBody.hashCode());
        if (wrench != null) {
            desiredExternalWrenchToPack.setIncludingFrame((WrenchReadOnly)wrench);
            return true;
        }
        return false;
    }

    public Wrench getDesiredExternalWrench(RigidBodyBasics rigidBody) {
        return (Wrench)this.desiredExternalWrenchMap.get((long)rigidBody.hashCode());
    }

    public Wrench getDesiredExternalWrench(int bodyIndex) {
        return (Wrench)this.desiredExternalWrenches.get(bodyIndex);
    }

    public void set(DesiredExternalWrenchHolder other) {
        this.clear();
        for (int i = 0; i < other.getNumberOfBodiesWithDesiredExternalWrench(); ++i) {
            RigidBodyBasics rigidBody = other.getRigidBody(i);
            this.registerRigidBody(rigidBody, (WrenchReadOnly)other.getDesiredExternalWrench(i));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DesiredExternalWrenchHolder) {
            DesiredExternalWrenchHolder other = (DesiredExternalWrenchHolder)obj;
            if (this.getNumberOfBodiesWithDesiredExternalWrench() != other.getNumberOfBodiesWithDesiredExternalWrench()) {
                return false;
            }
            for (int i = 0; i < this.getNumberOfBodiesWithDesiredExternalWrench(); ++i) {
                RigidBodyBasics rigidBody = this.getRigidBody(i);
                if (this.getDesiredExternalWrench(i).equals((WrenchReadOnly)other.getDesiredExternalWrench(rigidBody))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

