/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command;

import us.ihmc.commonWalkingControlModules.barrierScheduler.context.AtlasHumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextData;
import us.ihmc.commonWalkingControlModules.barrierScheduler.context.HumanoidRobotContextJointData;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleInput;
import us.ihmc.commonWalkingControlModules.capturePoint.LinearMomentumRateControlModuleOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutput;
import us.ihmc.commonWalkingControlModules.controllerCore.command.DesiredExternalWrenchHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.CenterOfMassFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.JointspaceFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.CenterOfPressureCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ContactWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.ExternalWrenchCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointAccelerationIntegrationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointspaceAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.LinearMomentumRateCostCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.MomentumRateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.PlaneContactStateCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.SpatialAccelerationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointLimitEnforcementCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.JointTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualForceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandBuffer;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualTorqueCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualWrenchCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitEnforcement;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointLimitParameters;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.footstep.SimpleFootstep;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.JointHashCodeResolver;
import us.ihmc.robotModels.RigidBodyHashCodeResolver;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;
import us.ihmc.robotics.controllers.pidGains.PIDSE3GainsReadOnly;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.screwTheory.SelectionMatrix3D;
import us.ihmc.robotics.screwTheory.SelectionMatrix6D;
import us.ihmc.robotics.sensors.ForceSensorData;
import us.ihmc.robotics.sensors.ForceSensorDataHolder;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.weightMatrices.WeightMatrix3D;
import us.ihmc.robotics.weightMatrices.WeightMatrix6D;
import us.ihmc.sensorProcessing.frames.ReferenceFrameHashCodeResolver;
import us.ihmc.sensorProcessing.model.RobotMotionStatusHolder;
import us.ihmc.sensorProcessing.outputData.ImuData;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;
import us.ihmc.sensorProcessing.sensors.RawJointSensorDataHolder;
import us.ihmc.sensorProcessing.sensors.RawJointSensorDataHolderMap;
import us.ihmc.sensorProcessing.simulatedSensors.SensorDataContext;

public class CrossRobotCommandResolver {
    private final ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver;
    private final RigidBodyHashCodeResolver rigidBodyHashCodeResolver;
    private final JointHashCodeResolver jointHashCodeResolver;

    public CrossRobotCommandResolver(FullHumanoidRobotModel fullRobotModel) {
        this.referenceFrameHashCodeResolver = new ReferenceFrameHashCodeResolver();
        this.referenceFrameHashCodeResolver.putAllChildren((ReferenceFrame)fullRobotModel.getRootJoint().getFrameAfterJoint());
        this.rigidBodyHashCodeResolver = new RigidBodyHashCodeResolver((FullRobotModel)fullRobotModel);
        this.jointHashCodeResolver = new JointHashCodeResolver((FullRobotModel)fullRobotModel);
    }

    public CrossRobotCommandResolver(ReferenceFrameHashCodeResolver referenceFrameHashCodeResolver, RigidBodyHashCodeResolver rigidBodyHashCodeResolver, JointHashCodeResolver jointHashCodeResolver) {
        this.referenceFrameHashCodeResolver = referenceFrameHashCodeResolver;
        this.rigidBodyHashCodeResolver = rigidBodyHashCodeResolver;
        this.jointHashCodeResolver = jointHashCodeResolver;
    }

    public void resolveControllerCoreCommand(ControllerCoreCommandInterface in, ControllerCoreCommandBuffer out) {
        out.clear();
        out.setControllerCoreMode(in.getControllerCoreMode());
        if (in.isReinitializationRequested()) {
            out.requestReinitialization();
        }
        this.resolveInverseDynamicsCommandList(in.getInverseDynamicsCommandList(), out.getInverseDynamicsCommandList());
        this.resolveInverseKinematicsCommandList(in.getInverseKinematicsCommandList(), out.getInverseKinematicsCommandList());
        this.resolveVirtualModelControlCommandList(in.getVirtualModelControlCommandList(), out.getVirtualModelControlCommandList());
        this.resolveFeedbackControlCommandList(in.getFeedbackControlCommandList(), out.getFeedbackControlCommandList());
        this.resolveLowLevelOneDoFJointDesiredDataHolder(in.getLowLevelOneDoFJointDesiredDataHolder(), out.getLowLevelOneDoFJointDesiredDataHolder());
    }

    public void resolveControllerCoreOutput(ControllerCoreOutput in, ControllerCoreOutput out) {
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getLinearMomentumRate(), (FrameTuple3DBasics)out.getLinearMomentumRate());
        this.resolveCenterOfPressureDataHolder(in.getCenterOfPressureData(), out.getCenterOfPressureData());
        this.resolveDesiredExternalWrenchHolder(in.getDesiredExternalWrenchData(), out.getDesiredExternalWrenchData());
        out.setRootJointDesiredConfigurationData(in.getRootJointDesiredConfigurationData());
        this.resolveLowLevelOneDoFJointDesiredDataHolder((JointDesiredOutputListReadOnly)in.getLowLevelOneDoFJointDesiredDataHolderPreferred(), out.getLowLevelOneDoFJointDesiredDataHolderPreferred());
    }

    public void resolveCenterOfPressureDataHolder(CenterOfPressureDataHolder in, CenterOfPressureDataHolder out) {
        out.clear();
        for (int i = 0; i < in.getNumberOfBodiesWithCenterOfPressure(); ++i) {
            out.registerRigidBody(this.resolveRigidBody(in.getRigidBody(i)));
            this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getCenterOfPressure(i), (FrameTuple2DBasics)out.getCenterOfPressure(i));
        }
    }

    public void resolveDesiredExternalWrenchHolder(DesiredExternalWrenchHolder in, DesiredExternalWrenchHolder out) {
        out.clear();
        for (int i = 0; i < in.getNumberOfBodiesWithDesiredExternalWrench(); ++i) {
            out.registerRigidBody(this.resolveRigidBody(in.getRigidBody(i)));
            this.resolveWrench((WrenchReadOnly)in.getDesiredExternalWrench(i), (WrenchBasics)out.getDesiredExternalWrench(i));
        }
    }

    public void resolveForceSensorDataHolder(ForceSensorDataHolder in, ForceSensorDataHolder out) {
        out.clear();
        for (int i = 0; i < in.getNumberOfForceSensors(); ++i) {
            ForceSensorDefinition inDefinition = (ForceSensorDefinition)in.getForceSensorDefinitions().get(i);
            ForceSensorData inData = in.get(inDefinition);
            out.registerForceSensor(inDefinition);
            ForceSensorDefinition outDefinition = (ForceSensorDefinition)out.getForceSensorDefinitions().get(i);
            ForceSensorData outData = out.get(outDefinition);
            this.resolveForceSensorDefinition(inDefinition, outDefinition);
            this.resolveForceSensorData(inData, outData);
        }
    }

    public void resolveForceSensorData(ForceSensorData in, ForceSensorData out) {
        out.set(in);
        out.setDefinition(in.getSensorName(), this.resolveReferenceFrame(in.getMeasurementFrame()), this.resolveRigidBody(in.getMeasurementLink()));
    }

    public void resolveForceSensorDefinition(ForceSensorDefinition in, ForceSensorDefinition out) {
        out.set(in.getSensorName(), this.resolveRigidBody(in.getRigidBody()), this.resolveReferenceFrame(in.getSensorFrame()));
    }

    public void resolveHumanoidRobotContextData(HumanoidRobotContextData in, HumanoidRobotContextData out) {
        this.resolveHumanoidRobotContextDataScheduler(in, out);
        this.resolveHumanoidRobotContextDataController(in, out);
        this.resolveHumanoidRobotContextDataEstimator(in, out);
    }

    public void resolveHumanoidRobotContextDataScheduler(HumanoidRobotContextData in, HumanoidRobotContextData out) {
        this.resolveSensorDataContext(in.getSensorDataContext(), out.getSensorDataContext());
        out.setTimestamp(in.getTimestamp());
        out.setSchedulerTick(in.getSchedulerTick());
    }

    public void resolveHumanoidRobotContextDataController(HumanoidRobotContextData in, HumanoidRobotContextData out) {
        this.resolveCenterOfPressureDataHolder(in.getCenterOfPressureDataHolder(), out.getCenterOfPressureDataHolder());
        this.resolveRobotMotionStatusHolder(in.getRobotMotionStatusHolder(), out.getRobotMotionStatusHolder());
        this.resolveLowLevelOneDoFJointDesiredDataHolder((JointDesiredOutputListReadOnly)in.getJointDesiredOutputList(), out.getJointDesiredOutputList());
        out.setControllerRan(in.getControllerRan());
    }

    public void resolveHumanoidRobotContextDataEstimator(HumanoidRobotContextData in, HumanoidRobotContextData out) {
        this.resolveHumanoidRobotContextJointData(in.getProcessedJointData(), out.getProcessedJointData());
        this.resolveForceSensorDataHolder(in.getForceSensorDataHolder(), out.getForceSensorDataHolder());
        out.setEstimatorRan(in.getEstimatorRan());
        if (in instanceof AtlasHumanoidRobotContextData && out instanceof AtlasHumanoidRobotContextData) {
            this.resolveRawJointSensorDataHolderMap(((AtlasHumanoidRobotContextData)in).getRawJointSensorDataHolderMap(), ((AtlasHumanoidRobotContextData)out).getRawJointSensorDataHolderMap());
        }
    }

    public void resolveAtlasHumanoidRobotContextData(AtlasHumanoidRobotContextData in, AtlasHumanoidRobotContextData out) {
        this.resolveHumanoidRobotContextData(in, out);
    }

    public void resolveSensorDataContext(SensorDataContext in, SensorDataContext out) {
        out.set(in);
    }

    public void resolveImuData(ImuData in, ImuData out) {
        out.set(in);
    }

    public void resolveRawJointSensorDataHolderMap(RawJointSensorDataHolderMap in, RawJointSensorDataHolderMap out) {
        out.clear();
        for (int i = 0; i < in.getNumberOfJoints(); ++i) {
            out.registerJoint(this.resolveJoint(in.getJoint(i)));
            this.resolveRawJointSensorDataHolder(in.get(i), out.get(i));
        }
    }

    public void resolveRawJointSensorDataHolder(RawJointSensorDataHolder in, RawJointSensorDataHolder out) {
        out.set(in);
    }

    public void resolveInverseDynamicsCommandList(InverseDynamicsCommandList in, InverseDynamicsCommandBuffer out) {
        out.clear();
        this.resolveInverseDynamicsCommandListInternal(in, out);
    }

    public void resolveInverseKinematicsCommandList(InverseKinematicsCommandList in, InverseKinematicsCommandBuffer out) {
        out.clear();
        this.resolveInverseKinematicsCommandListInternal(in, out);
    }

    public void resolveVirtualModelControlCommandList(VirtualModelControlCommandList in, VirtualModelControlCommandBuffer out) {
        out.clear();
        this.resolveVirtualModelControlCommandListInternal(in, out);
    }

    public void resolveFeedbackControlCommandList(FeedbackControlCommandList in, FeedbackControlCommandBuffer out) {
        out.clear();
        this.resolveFeedbackControlCommandListInternal(in, out);
    }

    private void resolveInverseDynamicsCommandListInternal(InverseDynamicsCommandList in, InverseDynamicsCommandBuffer out) {
        out.setCommandId(in.getCommandId());
        block17: for (int commandIndex = 0; commandIndex < in.getNumberOfCommands(); ++commandIndex) {
            InverseDynamicsCommand<?> commandToResolve = in.getCommand(commandIndex);
            switch (commandToResolve.getCommandType()) {
                case CENTER_OF_PRESSURE: {
                    this.resolveCenterOfPressureCommand((CenterOfPressureCommand)commandToResolve, out.addCenterOfPressureCommand());
                    continue block17;
                }
                case CONTACT_WRENCH: {
                    this.resolveContactWrenchCommand((ContactWrenchCommand)commandToResolve, out.addContactWrenchCommand());
                    continue block17;
                }
                case EXTERNAL_WRENCH: {
                    this.resolveExternalWrenchCommand((ExternalWrenchCommand)commandToResolve, out.addExternalWrenchCommand());
                    continue block17;
                }
                case OPTIMIZATION_SETTINGS: {
                    this.resolveInverseDynamicsOptimizationSettingsCommand((InverseDynamicsOptimizationSettingsCommand)commandToResolve, out.addInverseDynamicsOptimizationSettingsCommand());
                    continue block17;
                }
                case JOINT_ACCELERATION_INTEGRATION: {
                    this.resolveJointAccelerationIntegrationCommand((JointAccelerationIntegrationCommand)commandToResolve, out.addJointAccelerationIntegrationCommand());
                    continue block17;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.resolveJointLimitEnforcementMethodCommand((JointLimitEnforcementMethodCommand)commandToResolve, out.addJointLimitEnforcementMethodCommand());
                    continue block17;
                }
                case JOINTSPACE: {
                    this.resolveJointspaceAccelerationCommand((JointspaceAccelerationCommand)commandToResolve, out.addJointspaceAccelerationCommand());
                    continue block17;
                }
                case MOMENTUM: {
                    this.resolveMomentumRateCommand((MomentumRateCommand)commandToResolve, out.addMomentumRateCommand());
                    continue block17;
                }
                case MOMENTUM_COST: {
                    this.resolveLinearMomentumRateCostCommand((LinearMomentumRateCostCommand)commandToResolve, out.addLinearMomentumRateCostCommand());
                    continue block17;
                }
                case PLANE_CONTACT_STATE: {
                    this.resolvePlaneContactStateCommand((PlaneContactStateCommand)commandToResolve, out.addPlaneContactStateCommand());
                    continue block17;
                }
                case TASKSPACE: {
                    this.resolveSpatialAccelerationCommand((SpatialAccelerationCommand)commandToResolve, out.addSpatialAccelerationCommand());
                    continue block17;
                }
                case COMMAND_LIST: {
                    this.resolveInverseDynamicsCommandListInternal((InverseDynamicsCommandList)commandToResolve, out);
                    continue block17;
                }
                case PRIVILEGED_CONFIGURATION: {
                    this.resolvePrivilegedConfigurationCommand((PrivilegedConfigurationCommand)commandToResolve, out.addPrivilegedConfigurationCommand());
                    continue block17;
                }
                case PRIVILEGED_JOINTSPACE_COMMAND: {
                    this.resolvePrivilegedJointSpaceCommand((PrivilegedJointSpaceCommand)commandToResolve, out.addPrivilegedJointSpaceCommand());
                    continue block17;
                }
                case LIMIT_REDUCTION: {
                    this.resolveJointLimitReductionCommand((JointLimitReductionCommand)commandToResolve, out.addJointLimitReductionCommand());
                    continue block17;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)commandToResolve.getCommandType()) + " is not handled.");
                }
            }
        }
    }

    private void resolveInverseKinematicsCommandListInternal(InverseKinematicsCommandList in, InverseKinematicsCommandBuffer out) {
        out.setCommandId(in.getCommandId());
        block12: for (int commandIndex = 0; commandIndex < in.getNumberOfCommands(); ++commandIndex) {
            InverseKinematicsCommand<?> commandToResolve = in.getCommand(commandIndex);
            switch (commandToResolve.getCommandType()) {
                case OPTIMIZATION_SETTINGS: {
                    this.resolveInverseKinematicsOptimizationSettingsCommand((InverseKinematicsOptimizationSettingsCommand)commandToResolve, out.addInverseKinematicsOptimizationSettingsCommand());
                    continue block12;
                }
                case LIMIT_REDUCTION: {
                    this.resolveJointLimitReductionCommand((JointLimitReductionCommand)commandToResolve, out.addJointLimitReductionCommand());
                    continue block12;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.resolveJointLimitEnforcementMethodCommand((JointLimitEnforcementMethodCommand)commandToResolve, out.addJointLimitEnforcementMethodCommand());
                    continue block12;
                }
                case JOINTSPACE: {
                    this.resolveJointspaceVelocityCommand((JointspaceVelocityCommand)commandToResolve, out.addJointspaceVelocityCommand());
                    continue block12;
                }
                case MOMENTUM: {
                    this.resolveMomentumCommand((MomentumCommand)commandToResolve, out.addMomentumCommand());
                    continue block12;
                }
                case MOMENTUM_CONVEX_CONSTRAINT: {
                    this.resolveLinearMomentumConvexConstraint2DCommand((LinearMomentumConvexConstraint2DCommand)commandToResolve, out.addLinearMomentumConvexConstraint2DCommand());
                    continue block12;
                }
                case PRIVILEGED_CONFIGURATION: {
                    this.resolvePrivilegedConfigurationCommand((PrivilegedConfigurationCommand)commandToResolve, out.addPrivilegedConfigurationCommand());
                    continue block12;
                }
                case PRIVILEGED_JOINTSPACE_COMMAND: {
                    this.resolvePrivilegedJointSpaceCommand((PrivilegedJointSpaceCommand)commandToResolve, out.addPrivilegedJointSpaceCommand());
                    continue block12;
                }
                case TASKSPACE: {
                    this.resolveSpatialVelocityCommand((SpatialVelocityCommand)commandToResolve, out.addSpatialVelocityCommand());
                    continue block12;
                }
                case COMMAND_LIST: {
                    this.resolveInverseKinematicsCommandListInternal((InverseKinematicsCommandList)commandToResolve, out);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)commandToResolve.getCommandType()) + " is not handled.");
                }
            }
        }
    }

    private void resolveVirtualModelControlCommandListInternal(VirtualModelControlCommandList in, VirtualModelControlCommandBuffer out) {
        out.setCommandId(in.getCommandId());
        block15: for (int commandIndex = 0; commandIndex < in.getNumberOfCommands(); ++commandIndex) {
            VirtualModelControlCommand<?> commandToResolve = in.getCommand(commandIndex);
            switch (commandToResolve.getCommandType()) {
                case CENTER_OF_PRESSURE: {
                    this.resolveCenterOfPressureCommand((CenterOfPressureCommand)commandToResolve, out.addCenterOfPressureCommand());
                    continue block15;
                }
                case CONTACT_WRENCH: {
                    this.resolveContactWrenchCommand((ContactWrenchCommand)commandToResolve, out.addContactWrenchCommand());
                    continue block15;
                }
                case EXTERNAL_WRENCH: {
                    this.resolveExternalWrenchCommand((ExternalWrenchCommand)commandToResolve, out.addExternalWrenchCommand());
                    continue block15;
                }
                case OPTIMIZATION_SETTINGS: {
                    this.resolveVirtualModelControlOptimizationSettingsCommand((VirtualModelControlOptimizationSettingsCommand)commandToResolve, out.addVirtualModelControlOptimizationSettingsCommand());
                    continue block15;
                }
                case JOINT_ACCELERATION_INTEGRATION: {
                    this.resolveJointAccelerationIntegrationCommand((JointAccelerationIntegrationCommand)commandToResolve, out.addJointAccelerationIntegrationCommand());
                    continue block15;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.resolveJointLimitEnforcementCommand((JointLimitEnforcementCommand)commandToResolve, out.addJointLimitEnforcementCommand());
                    continue block15;
                }
                case JOINTSPACE: {
                    this.resolveJointTorqueCommand((JointTorqueCommand)commandToResolve, out.addJointTorqueCommand());
                    continue block15;
                }
                case MOMENTUM: {
                    this.resolveMomentumRateCommand((MomentumRateCommand)commandToResolve, out.addMomentumRateCommand());
                    continue block15;
                }
                case PLANE_CONTACT_STATE: {
                    this.resolvePlaneContactStateCommand((PlaneContactStateCommand)commandToResolve, out.addPlaneContactStateCommand());
                    continue block15;
                }
                case COMMAND_LIST: {
                    this.resolveVirtualModelControlCommandListInternal((VirtualModelControlCommandList)commandToResolve, out);
                    continue block15;
                }
                case VIRTUAL_FORCE: {
                    this.resolveVirtualForceCommand((VirtualForceCommand)commandToResolve, out.addVirtualForceCommand());
                    continue block15;
                }
                case VIRTUAL_TORQUE: {
                    this.resolveVirtualTorqueCommand((VirtualTorqueCommand)commandToResolve, out.addVirtualTorqueCommand());
                    continue block15;
                }
                case VIRTUAL_WRENCH: {
                    this.resolveVirtualWrenchCommand((VirtualWrenchCommand)commandToResolve, out.addVirtualWrenchCommand());
                    continue block15;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)commandToResolve.getCommandType()) + " is not handled.");
                }
            }
        }
    }

    private void resolveFeedbackControlCommandListInternal(FeedbackControlCommandList in, FeedbackControlCommandBuffer out) {
        out.setCommandId(in.getCommandId());
        block8: for (int commandIndex = 0; commandIndex < in.getNumberOfCommands(); ++commandIndex) {
            FeedbackControlCommand<?> commandToResolve = in.getCommand(commandIndex);
            switch (commandToResolve.getCommandType()) {
                case JOINTSPACE: {
                    this.resolveOneDoFJointFeedbackControlCommand((OneDoFJointFeedbackControlCommand)commandToResolve, out.addOneDoFJointFeedbackControlCommand());
                    continue block8;
                }
                case ORIENTATION: {
                    this.resolveOrientationFeedbackControlCommand((OrientationFeedbackControlCommand)commandToResolve, out.addOrientationFeedbackControlCommand());
                    continue block8;
                }
                case POINT: {
                    this.resolvePointFeedbackControlCommand((PointFeedbackControlCommand)commandToResolve, out.addPointFeedbackControlCommand());
                    continue block8;
                }
                case TASKSPACE: {
                    this.resolveSpatialFeedbackControlCommand((SpatialFeedbackControlCommand)commandToResolve, out.addSpatialFeedbackControlCommand());
                    continue block8;
                }
                case MOMENTUM: {
                    this.resolveCenterOfMassFeedbackControlCommand((CenterOfMassFeedbackControlCommand)commandToResolve, out.addCenterOfMassFeedbackControlCommand());
                    continue block8;
                }
                case COMMAND_LIST: {
                    this.resolveFeedbackControlCommandListInternal((FeedbackControlCommandList)commandToResolve, out);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)commandToResolve.getCommandType()) + " is not handled.");
                }
            }
        }
    }

    public void resolveLowLevelOneDoFJointDesiredDataHolder(JointDesiredOutputListReadOnly in, LowLevelOneDoFJointDesiredDataHolder out) {
        out.clear();
        for (int jointIndex = 0; jointIndex < in.getNumberOfJointsWithDesiredOutput(); ++jointIndex) {
            out.registerJointWithEmptyData(this.resolveJoint(in.getOneDoFJoint(jointIndex))).set(in.getJointDesiredOutput(jointIndex));
        }
    }

    public void resolveCenterOfPressureCommand(CenterOfPressureCommand in, CenterOfPressureCommand out) {
        out.setCommandId(in.getCommandId());
        out.setConstraintType(in.getConstraintType());
        out.setContactingRigidBody(this.resolveRigidBody(in.getContactingRigidBody()));
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getWeight(), (FrameTuple2DBasics)out.getWeight());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getDesiredCoP(), (FrameTuple2DBasics)out.getDesiredCoP());
    }

    public void resolveContactWrenchCommand(ContactWrenchCommand in, ContactWrenchCommand out) {
        out.setCommandId(in.getCommandId());
        out.setConstraintType(in.getConstraintType());
        out.setRigidBody(this.resolveRigidBody(in.getRigidBody()));
        this.resolveWrench((WrenchReadOnly)in.getWrench(), (WrenchBasics)out.getWrench());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveExternalWrenchCommand(ExternalWrenchCommand in, ExternalWrenchCommand out) {
        out.setCommandId(in.getCommandId());
        out.setRigidBody(this.resolveRigidBody(in.getRigidBody()));
        this.resolveWrench((WrenchReadOnly)in.getExternalWrench(), out.getExternalWrench());
    }

    public void resolveInverseDynamicsOptimizationSettingsCommand(InverseDynamicsOptimizationSettingsCommand in, InverseDynamicsOptimizationSettingsCommand out) {
        out.set(in);
    }

    public void resolveJointAccelerationIntegrationCommand(JointAccelerationIntegrationCommand in, JointAccelerationIntegrationCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJointsToComputeDesiredPositionFor(); ++jointIndex) {
            out.addJointToComputeDesiredPositionFor(this.resolveJoint(in.getJointToComputeDesiredPositionFor(jointIndex)));
            out.setJointParameters(jointIndex, in.getJointParameters(jointIndex));
        }
    }

    public void resolveJointLimitEnforcementMethodCommand(JointLimitEnforcementMethodCommand in, JointLimitEnforcementMethodCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            OneDoFJointBasics joint = this.resolveJoint(in.getJoint(jointIndex));
            JointLimitParameters parameters = in.getJointLimitParameters(jointIndex);
            JointLimitEnforcement method = in.getJointLimitReductionFactor(jointIndex);
            out.addLimitEnforcementMethod(joint, method, parameters);
        }
    }

    public void resolveJointspaceAccelerationCommand(JointspaceAccelerationCommand in, JointspaceAccelerationCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getDesiredAcceleration(jointIndex), in.getWeight(jointIndex));
        }
    }

    public void resolveMomentumRateCommand(MomentumRateCommand in, MomentumRateCommand out) {
        out.setCommandId(in.getCommandId());
        out.setMomentumRate(in.getMomentumRate());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveLinearMomentumRateCostCommand(LinearMomentumRateCostCommand in, LinearMomentumRateCostCommand out) {
        out.setCommandId(in.getCommandId());
        out.setMomentumRateHessian(in.getMomentumRateHessian());
        out.setMomentumRateGradient(in.getMomentumRateGradient());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolvePlaneContactStateCommand(PlaneContactStateCommand in, PlaneContactStateCommand out) {
        out.setCommandId(in.getCommandId());
        out.clearContactPoints();
        out.setContactingRigidBody(this.resolveRigidBody(in.getContactingRigidBody()));
        out.setCoefficientOfFriction(in.getCoefficientOfFriction());
        out.setUseHighCoPDamping(in.isUseHighCoPDamping());
        out.setHasContactStateChanged(in.getHasContactStateChanged());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getContactNormal(), (FrameTuple3DBasics)out.getContactNormal());
        out.getContactFramePoseInBodyFixedFrame().set(in.getContactFramePoseInBodyFixedFrame());
        for (int contactPointIndex = 0; contactPointIndex < in.getNumberOfContactPoints(); ++contactPointIndex) {
            this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getContactPoint(contactPointIndex), (FrameTuple3DBasics)out.addPointInContact());
            out.setMaxContactPointNormalForce(contactPointIndex, in.getMaxContactPointNormalForce(contactPointIndex));
            out.setRhoWeight(contactPointIndex, in.getRhoWeight(contactPointIndex));
        }
    }

    public void resolveSpatialAccelerationCommand(SpatialAccelerationCommand in, SpatialAccelerationCommand out) {
        out.setCommandId(in.getCommandId());
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        out.getDesiredLinearAcceleration().set((Tuple3DReadOnly)in.getDesiredLinearAcceleration());
        out.getDesiredAngularAcceleration().set((Tuple3DReadOnly)in.getDesiredAngularAcceleration());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
        out.set(this.resolveRigidBody(in.getBase()), this.resolveRigidBody(in.getEndEffector()));
        out.setPrimaryBase(this.resolveRigidBody(in.getPrimaryBase()));
        out.setScaleSecondaryTaskJointWeight(in.scaleSecondaryTaskJointWeight(), in.getSecondaryTaskJointWeightScale());
    }

    public void resolveInverseKinematicsOptimizationSettingsCommand(InverseKinematicsOptimizationSettingsCommand in, InverseKinematicsOptimizationSettingsCommand out) {
        out.set(in);
    }

    public void resolveJointLimitReductionCommand(JointLimitReductionCommand in, JointLimitReductionCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addReductionFactor(this.resolveJoint(in.getJoint(jointIndex)), in.getJointLimitReductionFactor(jointIndex));
        }
    }

    public void resolveJointspaceVelocityCommand(JointspaceVelocityCommand in, JointspaceVelocityCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getDesiredVelocity(jointIndex), in.getWeight(jointIndex));
        }
    }

    public void resolveMomentumCommand(MomentumCommand in, MomentumCommand out) {
        out.setCommandId(in.getCommandId());
        out.setMomentum(in.getMomentum());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveLinearMomentumConvexConstraint2DCommand(LinearMomentumConvexConstraint2DCommand in, LinearMomentumConvexConstraint2DCommand out) {
        out.set(in);
    }

    public void resolvePrivilegedConfigurationCommand(PrivilegedConfigurationCommand in, PrivilegedConfigurationCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        out.setDefaultParameters(in.getDefaultParameters());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getJointSpecificParameters(jointIndex));
        }
        if (in.isEnabled()) {
            out.enable();
        } else {
            out.disable();
        }
    }

    public void resolvePrivilegedJointSpaceCommand(PrivilegedJointSpaceCommand in, PrivilegedJointSpaceCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getPrivilegedCommand(jointIndex));
            out.setWeight(jointIndex, in.getWeight(jointIndex));
        }
        if (in.isEnabled()) {
            out.enable();
        } else {
            out.disable();
        }
    }

    public void resolveJointLimitEnforcementCommand(JointLimitEnforcementCommand in, JointLimitEnforcementCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getJointLimitData(jointIndex));
        }
    }

    public void resolveSpatialVelocityCommand(SpatialVelocityCommand in, SpatialVelocityCommand out) {
        out.setCommandId(in.getCommandId());
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        out.getDesiredLinearVelocity().set((Tuple3DReadOnly)in.getDesiredLinearVelocity());
        out.getDesiredAngularVelocity().set((Tuple3DReadOnly)in.getDesiredAngularVelocity());
        out.setConstraintType(in.getConstraintType());
        this.resolveWeightMatrix6D(in.getWeightMatrix(), out.getWeightMatrix());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
        out.set(this.resolveRigidBody(in.getBase()), this.resolveRigidBody(in.getEndEffector()));
        out.setPrimaryBase(this.resolveRigidBody(in.getPrimaryBase()));
        out.setScaleSecondaryTaskJointWeight(in.scaleSecondaryTaskJointWeight(), in.getSecondaryTaskJointWeightScale());
    }

    public void resolveJointTorqueCommand(JointTorqueCommand in, JointTorqueCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            out.addJoint(this.resolveJoint(in.getJoint(jointIndex)), in.getDesiredTorque(jointIndex));
        }
    }

    public void resolveVirtualForceCommand(VirtualForceCommand in, VirtualForceCommand out) {
        out.setCommandId(in.getCommandId());
        out.set(this.resolveRigidBody(in.getBase()), this.resolveRigidBody(in.getEndEffector()));
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        out.getDesiredLinearForce().set((Tuple3DReadOnly)in.getDesiredLinearForce());
        this.resolveSelectionMatrix3D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveVirtualModelControlOptimizationSettingsCommand(VirtualModelControlOptimizationSettingsCommand in, VirtualModelControlOptimizationSettingsCommand out) {
        out.set(in);
    }

    public void resolveVirtualTorqueCommand(VirtualTorqueCommand in, VirtualTorqueCommand out) {
        out.setCommandId(in.getCommandId());
        out.set(this.resolveRigidBody(in.getBase()), this.resolveRigidBody(in.getEndEffector()));
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        out.getDesiredAngularTorque().set((Tuple3DReadOnly)in.getDesiredAngularTorque());
        this.resolveSelectionMatrix3D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveVirtualWrenchCommand(VirtualWrenchCommand in, VirtualWrenchCommand out) {
        out.setCommandId(in.getCommandId());
        out.set(this.resolveRigidBody(in.getBase()), this.resolveRigidBody(in.getEndEffector()));
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        out.getDesiredLinearForce().set((Tuple3DReadOnly)in.getDesiredLinearForce());
        out.getDesiredAngularTorque().set((Tuple3DReadOnly)in.getDesiredAngularTorque());
        this.resolveSelectionMatrix6D(in.getSelectionMatrix(), out.getSelectionMatrix());
    }

    public void resolveCenterOfMassFeedbackControlCommand(CenterOfMassFeedbackControlCommand in, CenterOfMassFeedbackControlCommand out) {
        out.setCommandId(in.getCommandId());
        out.setControlMode(in.getControlMode());
        out.getReferencePosition().set((FrameTuple3DReadOnly)in.getReferencePosition());
        out.getReferenceLinearVelocity().set((FrameTuple3DReadOnly)in.getReferenceLinearVelocity());
        out.getReferenceLinearAcceleration().set((FrameTuple3DReadOnly)in.getReferenceLinearAcceleration());
        out.setGains(in.getGains());
        this.resolveMomentumRateCommand(in.getMomentumRateCommand(), out.getMomentumRateCommand());
    }

    public void resolveJointspaceFeedbackControlCommand(JointspaceFeedbackControlCommand in, JointspaceFeedbackControlCommand out) {
        out.clear();
        out.setCommandId(in.getCommandId());
        for (int jointIndex = 0; jointIndex < in.getNumberOfJoints(); ++jointIndex) {
            this.resolveOneDoFJointFeedbackControlCommand(in.getJointCommand(jointIndex), out.addEmptyCommand());
        }
    }

    public void resolveOneDoFJointFeedbackControlCommand(OneDoFJointFeedbackControlCommand in, OneDoFJointFeedbackControlCommand out) {
        out.set(in);
        out.setJoint(this.resolveJoint(in.getJoint()));
    }

    public void resolveOrientationFeedbackControlCommand(OrientationFeedbackControlCommand in, OrientationFeedbackControlCommand out) {
        this.resolveSpatialAccelerationCommand(in.getSpatialAccelerationCommand(), out.getSpatialAccelerationCommand());
        out.setControlMode(in.getControlMode());
        this.resolveFrameQuaternion((FrameQuaternionReadOnly)in.getBodyFixedOrientationToControl(), out.getBodyFixedOrientationToControl());
        this.resolveFrameQuaternion((FrameQuaternionReadOnly)in.getReferenceOrientation(), out.getReferenceOrientation());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceAngularVelocity(), (FrameTuple3DBasics)out.getReferenceAngularVelocity());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceAngularAcceleration(), (FrameTuple3DBasics)out.getReferenceAngularAcceleration());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceTorque(), (FrameTuple3DBasics)out.getReferenceTorque());
        out.getGains().set((PID3DGainsReadOnly)in.getGains());
        out.setGainsFrame(this.resolveReferenceFrame(in.getAngularGainsFrame()));
        out.setControlBaseFrame(this.resolveReferenceFrame(in.getControlBaseFrame()));
    }

    public void resolvePointFeedbackControlCommand(PointFeedbackControlCommand in, PointFeedbackControlCommand out) {
        this.resolveSpatialAccelerationCommand(in.getSpatialAccelerationCommand(), out.getSpatialAccelerationCommand());
        out.setControlMode(in.getControlMode());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getBodyFixedPointToControl(), (FrameTuple3DBasics)out.getBodyFixedPointToControl());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferencePosition(), (FrameTuple3DBasics)out.getReferencePosition());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceLinearVelocity(), (FrameTuple3DBasics)out.getReferenceLinearVelocity());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceLinearAcceleration(), (FrameTuple3DBasics)out.getReferenceLinearAcceleration());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceForce(), (FrameTuple3DBasics)out.getReferenceForce());
        out.getGains().set((PID3DGainsReadOnly)in.getGains());
        out.setGainsFrame(this.resolveReferenceFrame(in.getLinearGainsFrame()));
        out.setControlBaseFrame(this.resolveReferenceFrame(in.getControlBaseFrame()));
    }

    public void resolveSpatialFeedbackControlCommand(SpatialFeedbackControlCommand in, SpatialFeedbackControlCommand out) {
        this.resolveSpatialAccelerationCommand(in.getSpatialAccelerationCommand(), out.getSpatialAccelerationCommand());
        out.setControlMode(in.getControlMode());
        this.resolveFramePose3D((FramePose3DReadOnly)in.getControlFramePose(), out.getControlFramePose());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferencePosition(), (FrameTuple3DBasics)out.getReferencePosition());
        this.resolveFrameQuaternion((FrameQuaternionReadOnly)in.getReferenceOrientation(), out.getReferenceOrientation());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceLinearVelocity(), (FrameTuple3DBasics)out.getReferenceLinearVelocity());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceAngularVelocity(), (FrameTuple3DBasics)out.getReferenceAngularVelocity());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceLinearAcceleration(), (FrameTuple3DBasics)out.getReferenceLinearAcceleration());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceAngularAcceleration(), (FrameTuple3DBasics)out.getReferenceAngularAcceleration());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceForce(), (FrameTuple3DBasics)out.getReferenceForce());
        this.resolveFrameTuple3D((FrameTuple3DReadOnly)in.getReferenceTorque(), (FrameTuple3DBasics)out.getReferenceTorque());
        out.getGains().set((PIDSE3GainsReadOnly)in.getGains());
        out.setGainsFrames(this.resolveReferenceFrame(in.getAngularGainsFrame()), this.resolveReferenceFrame(in.getLinearGainsFrame()));
        out.setControlBaseFrame(this.resolveReferenceFrame(in.getControlBaseFrame()));
    }

    public void resolveLinearMomentumRateControlModuleInput(LinearMomentumRateControlModuleInput in, LinearMomentumRateControlModuleInput out) {
        out.setOmega0(in.getOmega0());
        out.setUseMomentumRecoveryMode(in.getUseMomentumRecoveryMode());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getDesiredCapturePoint(), (FrameTuple2DBasics)out.getDesiredCapturePoint());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getDesiredCapturePointVelocity(), (FrameTuple2DBasics)out.getDesiredCapturePointVelocity());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getPerfectCMP(), (FrameTuple2DBasics)out.getPerfectCMP());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getPerfectCoP(), (FrameTuple2DBasics)out.getPerfectCoP());
        out.setControlHeightWithMomentum(in.getControlHeightWithMomentum());
        out.setUsePelvisHeightCommand(in.getUsePelvisHeightCommand());
        this.resolvePointFeedbackControlCommand(in.getPelvisHeightControlCommand(), out.getPelvisHeightControlCommand());
        this.resolveCenterOfMassFeedbackControlCommand(in.getCenterOfMassHeightControlCommand(), out.getCenterOfMassHeightControlCommand());
        out.setInitializeOnStateChange(in.getInitializeOnStateChange());
        out.setKeepCoPInsideSupportPolygon(in.getKeepCoPInsideSupportPolygon());
        out.setMinimizeAngularMomentumRateZ(in.getMinimizeAngularMomentumRateZ());
        for (RobotSide robotSide : RobotSide.values) {
            this.resolvePlaneContactStateCommand((PlaneContactStateCommand)in.getContactStateCommands().get((Enum)robotSide), (PlaneContactStateCommand)out.getContactStateCommands().get((Enum)robotSide));
        }
    }

    public void resolveLinearMomentumRateControlModuleOutput(LinearMomentumRateControlModuleOutput in, LinearMomentumRateControlModuleOutput out) {
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getDesiredCMP(), (FrameTuple2DBasics)out.getDesiredCMP());
        this.resolveFrameTuple2D((FrameTuple2DReadOnly)in.getResidualICPErrorForStepAdjustment(), (FrameTuple2DBasics)out.getResidualICPErrorForStepAdjustment());
    }

    public void resolveSimpleAdjustableFootstep(SimpleFootstep in, SimpleFootstep out) {
        out.setIsAdjustable(in.getIsAdjustable());
        out.setRobotSide(in.getRobotSide());
        this.resolveFramePose3D((FramePose3DReadOnly)in.getSoleFramePose(), (FramePose3DBasics)out.getSoleFramePose());
        out.setFoothold(in.getFoothold());
    }

    public void resolveHumanoidRobotContextJointData(HumanoidRobotContextJointData in, HumanoidRobotContextJointData out) {
        out.set(in);
    }

    public void resolveRobotMotionStatusHolder(RobotMotionStatusHolder in, RobotMotionStatusHolder out) {
        out.set(in);
    }

    public void resolveWrench(WrenchReadOnly in, WrenchBasics out) {
        out.setIncludingFrame(in);
        out.setReferenceFrame(this.resolveReferenceFrame(in.getReferenceFrame()));
        out.setBodyFrame(this.resolveReferenceFrame(in.getBodyFrame()));
    }

    public void resolveSelectionMatrix3D(SelectionMatrix3D in, SelectionMatrix3D out) {
        out.set(in);
        out.setSelectionFrame(this.resolveReferenceFrame(in.getSelectionFrame()));
    }

    public void resolveSelectionMatrix6D(SelectionMatrix6D in, SelectionMatrix6D out) {
        this.resolveSelectionMatrix3D(in.getAngularPart(), out.getAngularPart());
        this.resolveSelectionMatrix3D(in.getLinearPart(), out.getLinearPart());
    }

    public void resolveWeightMatrix3D(WeightMatrix3D in, WeightMatrix3D out) {
        out.set(in);
        out.setWeightFrame(this.resolveReferenceFrame(in.getWeightFrame()));
    }

    public void resolveWeightMatrix6D(WeightMatrix6D in, WeightMatrix6D out) {
        this.resolveWeightMatrix3D(in.getAngularPart(), out.getAngularPart());
        this.resolveWeightMatrix3D(in.getLinearPart(), out.getLinearPart());
    }

    public void resolveFrameTuple2D(FrameTuple2DReadOnly in, FrameTuple2DBasics out) {
        out.setIncludingFrame(this.resolveReferenceFrame(in.getReferenceFrame()), (Tuple2DReadOnly)in);
    }

    public void resolveFrameTuple3D(FrameTuple3DReadOnly in, FrameTuple3DBasics out) {
        out.setIncludingFrame(this.resolveReferenceFrame(in.getReferenceFrame()), (Tuple3DReadOnly)in);
    }

    public void resolveFrameQuaternion(FrameQuaternionReadOnly in, FrameQuaternionBasics out) {
        out.setIncludingFrame(this.resolveReferenceFrame(in.getReferenceFrame()), (QuaternionReadOnly)in);
    }

    public void resolveFramePose3D(FramePose3DReadOnly in, FramePose3DBasics out) {
        out.setIncludingFrame(this.resolveReferenceFrame(in.getReferenceFrame()), (Pose3DReadOnly)in);
    }

    private ReferenceFrame resolveReferenceFrame(ReferenceFrame in) {
        if (in == null) {
            return null;
        }
        return this.referenceFrameHashCodeResolver.getReferenceFrame((long)in.hashCode());
    }

    private <B extends RigidBodyReadOnly> B resolveRigidBody(B in) {
        if (in == null) {
            return null;
        }
        return (B)this.rigidBodyHashCodeResolver.castAndGetRigidBody((long)in.hashCode());
    }

    private <J extends JointReadOnly> J resolveJoint(J in) {
        if (in == null) {
            return null;
        }
        return (J)this.jointHashCodeResolver.castAndGetJoint((long)in.hashCode());
    }
}

