/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command;

import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreOutputReadOnly;
import us.ihmc.commonWalkingControlModules.controllerCore.command.DesiredExternalWrenchHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListBasics;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;

public class ControllerCoreOutput
implements ControllerCoreOutputReadOnly {
    private final CenterOfPressureDataHolder centerOfPressureDataHolder;
    private final DesiredExternalWrenchHolder desiredExternalWrenchHolder;
    private final FrameVector3D linearMomentumRate = new FrameVector3D();
    private final RootJointDesiredConfigurationData rootJointDesiredConfigurationData = new RootJointDesiredConfigurationData();
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder;
    @Deprecated
    private final transient JointDesiredOutputListBasics jointDesiredOutputList;

    @Deprecated
    public ControllerCoreOutput(CenterOfPressureDataHolder centerOfPressureDataHolder, DesiredExternalWrenchHolder desiredExternalWrenchHolder, OneDoFJointBasics[] controlledOneDoFJoints, JointDesiredOutputList lowLevelControllerOutput) {
        this.centerOfPressureDataHolder = centerOfPressureDataHolder;
        this.desiredExternalWrenchHolder = desiredExternalWrenchHolder;
        this.linearMomentumRate.setToNaN(ReferenceFrame.getWorldFrame());
        this.jointDesiredOutputList = lowLevelControllerOutput != null ? lowLevelControllerOutput : new JointDesiredOutputList((OneDoFJointReadOnly[])controlledOneDoFJoints);
        this.lowLevelOneDoFJointDesiredDataHolder = null;
    }

    public ControllerCoreOutput() {
        this.centerOfPressureDataHolder = new CenterOfPressureDataHolder();
        this.desiredExternalWrenchHolder = new DesiredExternalWrenchHolder();
        this.lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
        this.jointDesiredOutputList = this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public void setCenterOfPressureData(CenterOfPressureDataHolder centerOfPressureDataHolder) {
        this.centerOfPressureDataHolder.set(centerOfPressureDataHolder);
    }

    public CenterOfPressureDataHolder getCenterOfPressureData() {
        return this.centerOfPressureDataHolder;
    }

    public void setDesiredExternalWrenchData(DesiredExternalWrenchHolder desiredExternalWrenchHolder) {
        this.desiredExternalWrenchHolder.set(desiredExternalWrenchHolder);
    }

    public DesiredExternalWrenchHolder getDesiredExternalWrenchData() {
        return this.desiredExternalWrenchHolder;
    }

    public void setDesiredCenterOfPressure(FramePoint2DReadOnly cop, RigidBodyBasics rigidBody) {
        this.centerOfPressureDataHolder.setCenterOfPressure(cop, rigidBody);
    }

    @Override
    public void getDesiredCenterOfPressure(FramePoint2DBasics copToPack, RigidBodyBasics rigidBody) {
        this.centerOfPressureDataHolder.getCenterOfPressure(copToPack, rigidBody);
    }

    public void setDesiredExternalWrench(WrenchReadOnly desiredExternalWrench, RigidBodyBasics rigidBody) {
        this.desiredExternalWrenchHolder.setDesiredExternalWrench(desiredExternalWrench, rigidBody);
    }

    @Override
    public void getDesiredExternalWrench(WrenchBasics desiredExternalWrenchToPack, RigidBodyBasics rigidBody) {
        this.desiredExternalWrenchHolder.getDesiredExternalWrench(desiredExternalWrenchToPack, rigidBody);
    }

    public void setLinearMomentumRate(FrameVector3DReadOnly linearMomentumRate) {
        this.linearMomentumRate.setIncludingFrame((FrameTuple3DReadOnly)linearMomentumRate);
    }

    @Override
    public void getLinearMomentumRate(FrameVector3DBasics linearMomentumRateToPack) {
        linearMomentumRateToPack.setIncludingFrame((FrameTuple3DReadOnly)this.linearMomentumRate);
    }

    public FrameVector3D getLinearMomentumRate() {
        return this.linearMomentumRate;
    }

    public void setRootJointDesiredConfigurationData(RootJointDesiredConfigurationDataReadOnly rootJointDesiredConfigurationData) {
        this.rootJointDesiredConfigurationData.set(rootJointDesiredConfigurationData);
    }

    @Override
    public RootJointDesiredConfigurationDataReadOnly getRootJointDesiredConfigurationData() {
        return this.rootJointDesiredConfigurationData;
    }

    public void setLowLevelOneDoFJointDesiredDataHolder(JointDesiredOutputListReadOnly lowLevelOneDoFJointDesiredDataHolder) {
        this.jointDesiredOutputList.overwriteWith(lowLevelOneDoFJointDesiredDataHolder);
    }

    @Deprecated
    public JointDesiredOutputListBasics getLowLevelOneDoFJointDesiredDataHolder() {
        return this.jointDesiredOutputList;
    }

    public LowLevelOneDoFJointDesiredDataHolder getLowLevelOneDoFJointDesiredDataHolderPreferred() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public void set(ControllerCoreOutput other) {
        if (this.lowLevelOneDoFJointDesiredDataHolder == null) {
            throw new RuntimeException("You used the deprecated constructor set is not supported in that case.");
        }
        this.centerOfPressureDataHolder.set(other.centerOfPressureDataHolder);
        this.desiredExternalWrenchHolder.set(other.desiredExternalWrenchHolder);
        this.linearMomentumRate.setIncludingFrame((FrameTuple3DReadOnly)other.linearMomentumRate);
        this.rootJointDesiredConfigurationData.set(other.rootJointDesiredConfigurationData);
        this.lowLevelOneDoFJointDesiredDataHolder.set(other.lowLevelOneDoFJointDesiredDataHolder);
    }

    public boolean equals(Object obj) {
        if (this.lowLevelOneDoFJointDesiredDataHolder == null) {
            throw new RuntimeException("You used the deprecated constructor equals is not supported in that case.");
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ControllerCoreOutput) {
            ControllerCoreOutput other = (ControllerCoreOutput)obj;
            if (!this.centerOfPressureDataHolder.equals((Object)other.centerOfPressureDataHolder)) {
                return false;
            }
            if (!this.desiredExternalWrenchHolder.equals(other.desiredExternalWrenchHolder)) {
                return false;
            }
            if (!this.linearMomentumRate.equals((FrameTuple3DReadOnly)other.linearMomentumRate)) {
                return false;
            }
            if (!this.rootJointDesiredConfigurationData.equals(other.rootJointDesiredConfigurationData)) {
                return false;
            }
            return this.lowLevelOneDoFJointDesiredDataHolder.equals((JointDesiredOutputListReadOnly)other.lowLevelOneDoFJointDesiredDataHolder);
        }
        return false;
    }
}

