/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command;

public enum ControllerCoreCommandType {
    TASKSPACE,
    POINT,
    ORIENTATION,
    JOINTSPACE,
    MOMENTUM,
    MOMENTUM_COST,
    MOMENTUM_CONVEX_CONSTRAINT,
    PRIVILEGED_CONFIGURATION,
    PRIVILEGED_JOINTSPACE_COMMAND,
    LIMIT_REDUCTION,
    JOINT_LIMIT_ENFORCEMENT,
    EXTERNAL_WRENCH,
    PLANE_CONTACT_STATE,
    CENTER_OF_PRESSURE,
    JOINT_ACCELERATION_INTEGRATION,
    COMMAND_LIST,
    VIRTUAL_WRENCH,
    VIRTUAL_FORCE,
    VIRTUAL_TORQUE,
    CONTACT_WRENCH,
    OPTIMIZATION_SETTINGS;

    private static final ControllerCoreCommandType[] inverseKinematicsCommands;
    private static final ControllerCoreCommandType[] inverseDynamicsCommands;
    private static final ControllerCoreCommandType[] virtualModelControlCommands;
    private static final ControllerCoreCommandType[] feedbackControlCommands;

    public static ControllerCoreCommandType[] getInverseKinematicsCommands() {
        return inverseKinematicsCommands;
    }

    public static ControllerCoreCommandType[] getInverseDynamicsCommands() {
        return inverseDynamicsCommands;
    }

    public static ControllerCoreCommandType[] getVirtualModelControlCommands() {
        return virtualModelControlCommands;
    }

    public static ControllerCoreCommandType[] getFeedbackControlCommands() {
        return feedbackControlCommands;
    }

    public static boolean isInverseKinematicsCommand(ControllerCoreCommandType commandType) {
        for (ControllerCoreCommandType commandPossibility : ControllerCoreCommandType.getInverseKinematicsCommands()) {
            if (!commandType.equals((Object)commandPossibility)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInverseDynamicsCommand(ControllerCoreCommandType commandType) {
        for (ControllerCoreCommandType commandPossibility : ControllerCoreCommandType.getInverseDynamicsCommands()) {
            if (!commandType.equals((Object)commandPossibility)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVirtualModelControlCommand(ControllerCoreCommandType commandType) {
        for (ControllerCoreCommandType commandPossibility : ControllerCoreCommandType.getVirtualModelControlCommands()) {
            if (!commandType.equals((Object)commandPossibility)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFeedbackControlCommand(ControllerCoreCommandType commandType) {
        for (ControllerCoreCommandType commandPossibility : ControllerCoreCommandType.getFeedbackControlCommands()) {
            if (!commandType.equals((Object)commandPossibility)) continue;
            return true;
        }
        return false;
    }

    static {
        inverseKinematicsCommands = new ControllerCoreCommandType[]{TASKSPACE, JOINTSPACE, MOMENTUM, MOMENTUM_CONVEX_CONSTRAINT, PRIVILEGED_CONFIGURATION, PRIVILEGED_JOINTSPACE_COMMAND, LIMIT_REDUCTION, COMMAND_LIST};
        inverseDynamicsCommands = new ControllerCoreCommandType[]{TASKSPACE, JOINTSPACE, MOMENTUM, PRIVILEGED_CONFIGURATION, PRIVILEGED_JOINTSPACE_COMMAND, LIMIT_REDUCTION, JOINT_LIMIT_ENFORCEMENT, EXTERNAL_WRENCH, PLANE_CONTACT_STATE, CENTER_OF_PRESSURE, JOINT_ACCELERATION_INTEGRATION, CONTACT_WRENCH, COMMAND_LIST, OPTIMIZATION_SETTINGS};
        virtualModelControlCommands = new ControllerCoreCommandType[]{MOMENTUM, EXTERNAL_WRENCH, PLANE_CONTACT_STATE, VIRTUAL_WRENCH, VIRTUAL_FORCE, VIRTUAL_TORQUE, JOINTSPACE, JOINT_LIMIT_ENFORCEMENT, COMMAND_LIST};
        feedbackControlCommands = new ControllerCoreCommandType[]{TASKSPACE, POINT, ORIENTATION, JOINTSPACE, MOMENTUM, COMMAND_LIST};
    }
}

