/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore.command;

import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControllerCoreMode;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandInterface;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.InverseDynamicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.virtualModelControl.VirtualModelControlCommandList;
import us.ihmc.sensorProcessing.outputData.JointDesiredOutputListReadOnly;

public class ControllerCoreCommand
implements ControllerCoreCommandInterface {
    private final InverseDynamicsCommandList inverseDynamicsCommandList;
    private final InverseKinematicsCommandList inverseKinematicsCommandList;
    private final VirtualModelControlCommandList virtualModelControlCommandList;
    private final FeedbackControlCommandList feedbackControlCommandList;
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder;
    private WholeBodyControllerCoreMode controllerCoreMode;
    private boolean reinitialize = false;

    public ControllerCoreCommand(WholeBodyControllerCoreMode controllerCoreMode) {
        this.controllerCoreMode = controllerCoreMode;
        this.inverseDynamicsCommandList = new InverseDynamicsCommandList();
        this.virtualModelControlCommandList = new VirtualModelControlCommandList();
        this.feedbackControlCommandList = new FeedbackControlCommandList();
        this.inverseKinematicsCommandList = new InverseKinematicsCommandList();
        this.lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    }

    public ControllerCoreCommand() {
        this.inverseDynamicsCommandList = new InverseDynamicsCommandList();
        this.virtualModelControlCommandList = new VirtualModelControlCommandList();
        this.feedbackControlCommandList = new FeedbackControlCommandList();
        this.inverseKinematicsCommandList = new InverseKinematicsCommandList();
        this.lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    }

    @Override
    public void clear() {
        this.inverseDynamicsCommandList.clear();
        this.feedbackControlCommandList.clear();
        this.inverseKinematicsCommandList.clear();
        this.lowLevelOneDoFJointDesiredDataHolder.clear();
        this.reinitialize = false;
    }

    public void addInverseDynamicsCommand(InverseDynamicsCommand<?> inverseDynamicsCommand) {
        if (inverseDynamicsCommand != null) {
            this.inverseDynamicsCommandList.addCommand(inverseDynamicsCommand);
        }
    }

    public void addVirtualModelControlCommand(VirtualModelControlCommand<?> inverseDynamicsCommand) {
        if (inverseDynamicsCommand != null) {
            this.virtualModelControlCommandList.addCommand(inverseDynamicsCommand);
        }
    }

    public void addFeedbackControlCommand(FeedbackControlCommand<?> feedbackControlCommand) {
        if (feedbackControlCommand != null) {
            this.feedbackControlCommandList.addCommand(feedbackControlCommand);
        }
    }

    public void addInverseKinematicsCommand(InverseKinematicsCommand<?> inverseKinematicsCommand) {
        if (inverseKinematicsCommand != null) {
            this.inverseKinematicsCommandList.addCommand(inverseKinematicsCommand);
        }
    }

    public void completeLowLevelJointData(JointDesiredOutputListReadOnly lowLevelJointData) {
        if (lowLevelJointData != null) {
            this.lowLevelOneDoFJointDesiredDataHolder.completeWith(lowLevelJointData);
        }
    }

    public void requestReinitialization() {
        this.reinitialize = true;
    }

    public void setControllerCoreMode(WholeBodyControllerCoreMode controllerCoreMode) {
        if (this.controllerCoreMode != controllerCoreMode) {
            this.clear();
            this.controllerCoreMode = controllerCoreMode;
        }
    }

    @Override
    public InverseDynamicsCommandList getInverseDynamicsCommandList() {
        return this.inverseDynamicsCommandList;
    }

    @Override
    public VirtualModelControlCommandList getVirtualModelControlCommandList() {
        return this.virtualModelControlCommandList;
    }

    @Override
    public FeedbackControlCommandList getFeedbackControlCommandList() {
        return this.feedbackControlCommandList;
    }

    @Override
    public InverseKinematicsCommandList getInverseKinematicsCommandList() {
        return this.inverseKinematicsCommandList;
    }

    public LowLevelOneDoFJointDesiredDataHolder getLowLevelOneDoFJointDesiredDataHolder() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public void set(ControllerCoreCommand other) {
        this.controllerCoreMode = other.controllerCoreMode;
        this.inverseDynamicsCommandList.set(other.inverseDynamicsCommandList);
        this.feedbackControlCommandList.set(other.feedbackControlCommandList);
        this.inverseKinematicsCommandList.set(other.inverseKinematicsCommandList);
        this.virtualModelControlCommandList.set(other.virtualModelControlCommandList);
        this.lowLevelOneDoFJointDesiredDataHolder.set(other.lowLevelOneDoFJointDesiredDataHolder);
        this.reinitialize = other.reinitialize;
    }

    @Override
    public boolean isReinitializationRequested() {
        return this.reinitialize;
    }

    @Override
    public WholeBodyControllerCoreMode getControllerCoreMode() {
        return this.controllerCoreMode;
    }

    public boolean equals(Object object) {
        if (object instanceof ControllerCoreCommandInterface) {
            return ControllerCoreCommandInterface.super.equals((ControllerCoreCommandInterface)object);
        }
        return false;
    }

    public String toString() {
        String ret = "Request control mode: " + (Object)((Object)this.controllerCoreMode) + "\n";
        ret = ret + "ID commands: " + this.inverseDynamicsCommandList + "\n";
        ret = ret + "IK commands: " + this.inverseKinematicsCommandList + "\n";
        ret = ret + "VMC commands: " + this.virtualModelControlCommandList + "\n";
        ret = ret + "Feedback commands: " + this.feedbackControlCommandList + "\n";
        ret = ret + "Low-level command: " + this.lowLevelOneDoFJointDesiredDataHolder;
        return ret;
    }
}

