/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.commonWalkingControlModules.controllerCore.WholeBodyControlCoreToolbox;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseDynamics.JointLimitEnforcementMethodCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsOptimizationSettingsCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.InverseKinematicsSolution;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointLimitReductionCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.JointspaceVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.LinearMomentumConvexConstraint2DCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.MomentumCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedConfigurationCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.PrivilegedJointSpaceCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.inverseKinematics.SpatialVelocityCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.LowLevelOneDoFJointDesiredDataHolder;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationData;
import us.ihmc.commonWalkingControlModules.controllerCore.command.lowLevel.RootJointDesiredConfigurationDataReadOnly;
import us.ihmc.commonWalkingControlModules.inverseKinematics.InverseKinematicsOptimizationControlModule;
import us.ihmc.commonWalkingControlModules.inverseKinematics.InverseKinematicsOptimizationException;
import us.ihmc.commonWalkingControlModules.inverseKinematics.RobotJointVelocityAccelerationIntegrator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.spatial.interfaces.MomentumReadOnly;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class WholeBodyInverseKinematicsSolver {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final InverseKinematicsOptimizationControlModule optimizationControlModule;
    private final RobotJointVelocityAccelerationIntegrator integrator;
    private final RootJointDesiredConfigurationData rootJointDesiredConfiguration = new RootJointDesiredConfigurationData();
    private final LowLevelOneDoFJointDesiredDataHolder lowLevelOneDoFJointDesiredDataHolder = new LowLevelOneDoFJointDesiredDataHolder();
    private final Map<OneDoFJointBasics, YoDouble> jointVelocitiesSolution = new HashMap<OneDoFJointBasics, YoDouble>();
    private final Map<OneDoFJointBasics, YoDouble> jointPositionsSolution = new HashMap<OneDoFJointBasics, YoDouble>();
    private final FloatingJointBasics rootJoint;
    private final OneDoFJointBasics[] controlledOneDoFJoints;
    private final JointBasics[] jointsToOptimizeFor;
    private final List<KinematicLoopFunction> kinematicLoopFunctions;
    private final JointIndexHandler jointIndexHandler;
    private final YoFrameVector3D yoDesiredMomentumLinear;
    private final YoFrameVector3D yoDesiredMomentumAngular;
    private final YoFrameVector3D yoAchievedMomentumLinear;
    private final YoFrameVector3D yoAchievedMomentumAngular;
    private final DMatrixRMaj kinematicLoopJointConfiguration = new DMatrixRMaj(4, 1);

    public WholeBodyInverseKinematicsSolver(WholeBodyControlCoreToolbox toolbox, YoRegistry parentRegistry) {
        this.rootJoint = toolbox.getRootJoint();
        this.jointIndexHandler = toolbox.getJointIndexHandler();
        this.jointsToOptimizeFor = this.jointIndexHandler.getIndexedJoints();
        this.controlledOneDoFJoints = this.jointIndexHandler.getIndexedOneDoFJoints();
        this.kinematicLoopFunctions = toolbox.getKinematicLoopFunctions();
        this.lowLevelOneDoFJointDesiredDataHolder.registerJointsWithEmptyData((OneDoFJointReadOnly[])this.controlledOneDoFJoints);
        this.lowLevelOneDoFJointDesiredDataHolder.setJointsControlMode((OneDoFJointReadOnly[])this.controlledOneDoFJoints, JointDesiredControlMode.EFFORT);
        this.optimizationControlModule = new InverseKinematicsOptimizationControlModule(toolbox, this.registry);
        this.integrator = new RobotJointVelocityAccelerationIntegrator(toolbox.getControlDT());
        this.yoDesiredMomentumLinear = toolbox.getYoDesiredMomentumLinear();
        this.yoDesiredMomentumAngular = toolbox.getYoDesiredMomentumAngular();
        this.yoAchievedMomentumLinear = toolbox.getYoAchievedMomentumLinear();
        this.yoAchievedMomentumAngular = toolbox.getYoAchievedMomentumAngular();
        for (int i = 0; i < this.controlledOneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.controlledOneDoFJoints[i];
            YoDouble jointVelocitySolution = new YoDouble("qd_qp_" + joint.getName(), this.registry);
            YoDouble jointPositionSolution = new YoDouble("q_qp_" + joint.getName(), this.registry);
            jointVelocitySolution.set(Double.NaN);
            jointPositionSolution.set(Double.NaN);
            this.jointVelocitiesSolution.put(joint, jointVelocitySolution);
            this.jointPositionsSolution.put(joint, jointPositionSolution);
        }
        parentRegistry.addChild(this.registry);
    }

    public void reset() {
        this.optimizationControlModule.initialize();
    }

    public void compute() {
        InverseKinematicsSolution inverseKinematicsSolution;
        try {
            inverseKinematicsSolution = this.optimizationControlModule.compute();
        }
        catch (InverseKinematicsOptimizationException inverseKinematicsOptimizationException) {
            inverseKinematicsSolution = inverseKinematicsOptimizationException.getSolution();
        }
        DMatrixRMaj jointVelocities = inverseKinematicsSolution.getJointVelocities();
        this.integrator.integrateJointVelocities(this.jointsToOptimizeFor, jointVelocities);
        MomentumReadOnly centroidalMomentumSolution = inverseKinematicsSolution.getCentroidalMomentumSolution();
        this.yoAchievedMomentumLinear.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumSolution.getLinearPart());
        this.yoAchievedMomentumAngular.setMatchingFrame((FrameTuple3DReadOnly)centroidalMomentumSolution.getAngularPart());
        DMatrixRMaj jointConfigurations = this.integrator.getJointConfigurations();
        jointVelocities = this.integrator.getJointVelocities();
        if (this.rootJoint != null) {
            int[] rootJointIndices = this.jointIndexHandler.getJointIndices((JointReadOnly)this.rootJoint);
            this.rootJointDesiredConfiguration.setDesiredConfiguration(jointConfigurations, rootJointIndices[0]);
            this.rootJointDesiredConfiguration.setDesiredVelocity(jointVelocities, rootJointIndices[0]);
        }
        for (int i = 0; i < this.controlledOneDoFJoints.length; ++i) {
            OneDoFJointBasics joint = this.controlledOneDoFJoints[i];
            int jointIndex = this.jointIndexHandler.getOneDoFJointIndex((OneDoFJointReadOnly)joint);
            double desiredVelocity = jointVelocities.get(jointIndex, 0);
            this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointVelocity((OneDoFJointReadOnly)joint, desiredVelocity);
            this.jointVelocitiesSolution.get(joint).set(desiredVelocity);
            if (this.rootJoint != null) {
                ++jointIndex;
            }
            double desiredPosition = jointConfigurations.get(jointIndex, 0);
            this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointPosition((OneDoFJointReadOnly)joint, desiredPosition);
            this.jointPositionsSolution.get(joint).set(desiredPosition);
        }
        this.updateKinematicLoopJointConfigurations();
    }

    private void updateKinematicLoopJointConfigurations() {
        for (int i = 0; i < this.kinematicLoopFunctions.size(); ++i) {
            OneDoFJointReadOnly loopJoint;
            int j;
            KinematicLoopFunction kinematicLoopFunction = this.kinematicLoopFunctions.get(i);
            List loopJoints = kinematicLoopFunction.getLoopJoints();
            this.kinematicLoopJointConfiguration.reshape(loopJoints.size(), 1);
            for (j = 0; j < loopJoints.size(); ++j) {
                loopJoint = (OneDoFJointReadOnly)loopJoints.get(j);
                double position = this.lowLevelOneDoFJointDesiredDataHolder.getDesiredJointPosition((OneDoFJointReadOnly)((OneDoFJointBasics)loopJoint));
                this.kinematicLoopJointConfiguration.set(j, position);
            }
            kinematicLoopFunction.adjustConfiguration(this.kinematicLoopJointConfiguration);
            for (j = 0; j < loopJoints.size(); ++j) {
                loopJoint = (OneDoFJointReadOnly)loopJoints.get(j);
                this.lowLevelOneDoFJointDesiredDataHolder.setDesiredJointPosition((OneDoFJointReadOnly)((OneDoFJointBasics)loopJoint), this.kinematicLoopJointConfiguration.get(j));
                this.jointPositionsSolution.get(loopJoint).set(this.kinematicLoopJointConfiguration.get(j));
            }
        }
    }

    public void submitInverseKinematicsCommandList(InverseKinematicsCommandList inverseKinematicsCommandList) {
        block12: for (int commandIndex = 0; commandIndex < inverseKinematicsCommandList.getNumberOfCommands(); ++commandIndex) {
            InverseKinematicsCommand<?> command = inverseKinematicsCommandList.getCommand(commandIndex);
            switch (command.getCommandType()) {
                case TASKSPACE: {
                    this.optimizationControlModule.submitSpatialVelocityCommand((SpatialVelocityCommand)command);
                    continue block12;
                }
                case JOINTSPACE: {
                    this.optimizationControlModule.submitJointspaceVelocityCommand((JointspaceVelocityCommand)command);
                    continue block12;
                }
                case MOMENTUM: {
                    this.optimizationControlModule.submitMomentumCommand((MomentumCommand)command);
                    this.recordMomentumRate((MomentumCommand)command);
                    continue block12;
                }
                case MOMENTUM_CONVEX_CONSTRAINT: {
                    this.optimizationControlModule.submitLinearMomentumConvexConstraint2DCommand((LinearMomentumConvexConstraint2DCommand)command);
                    continue block12;
                }
                case PRIVILEGED_CONFIGURATION: {
                    this.optimizationControlModule.submitPrivilegedConfigurationCommand((PrivilegedConfigurationCommand)command);
                    continue block12;
                }
                case PRIVILEGED_JOINTSPACE_COMMAND: {
                    this.optimizationControlModule.submitPrivilegedVelocityCommand((PrivilegedJointSpaceCommand)command);
                    continue block12;
                }
                case LIMIT_REDUCTION: {
                    this.optimizationControlModule.submitJointLimitReductionCommand((JointLimitReductionCommand)command);
                    continue block12;
                }
                case JOINT_LIMIT_ENFORCEMENT: {
                    this.optimizationControlModule.submitJointLimitEnforcementMethodCommand((JointLimitEnforcementMethodCommand)command);
                    continue block12;
                }
                case COMMAND_LIST: {
                    this.submitInverseKinematicsCommandList((InverseKinematicsCommandList)command);
                    continue block12;
                }
                case OPTIMIZATION_SETTINGS: {
                    this.optimizationControlModule.submitOptimizationSettingsCommand((InverseKinematicsOptimizationSettingsCommand)command);
                    continue block12;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)command.getCommandType()) + " is not handled.");
                }
            }
        }
        inverseKinematicsCommandList.clear();
    }

    private void recordMomentumRate(MomentumCommand command) {
        DMatrixRMaj momentumRate = command.getMomentum();
        this.yoDesiredMomentumAngular.set(0, (DMatrix)momentumRate);
        this.yoDesiredMomentumLinear.set(3, (DMatrix)momentumRate);
    }

    public LowLevelOneDoFJointDesiredDataHolder getOutput() {
        return this.lowLevelOneDoFJointDesiredDataHolder;
    }

    public RootJointDesiredConfigurationDataReadOnly getOutputForRootJoint() {
        return this.rootJointDesiredConfiguration;
    }
}

