/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import us.ihmc.commonWalkingControlModules.configurations.JointPrivilegedConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controllerCore.command.DesiredExternalWrenchHolder;
import us.ihmc.commonWalkingControlModules.momentumBasedController.PlaneContactWrenchProcessor;
import us.ihmc.commonWalkingControlModules.momentumBasedController.WholeBodyControllerBoundCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ContactWrenchMatrixCalculator;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.ControllerCoreOptimizationSettings;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.JointIndexHandler;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MotionQPInputCalculator;
import us.ihmc.commonWalkingControlModules.visualizer.WrenchVisualizer;
import us.ihmc.commonWalkingControlModules.wrenchDistribution.WrenchMatrixCalculator;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.humanoidRobotics.model.CenterOfPressureDataHolder;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.algorithms.CentroidalMomentumRateCalculator;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.algorithms.InverseDynamicsCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.robotics.contactable.ContactablePlaneBody;
import us.ihmc.robotics.screwTheory.GravityCoriolisExternalWrenchMatrixCalculator;
import us.ihmc.robotics.screwTheory.KinematicLoopFunction;
import us.ihmc.robotics.screwTheory.TotalMassCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class WholeBodyControlCoreToolbox {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final double controlDT;
    private final double gravityZ;
    private final FloatingJointBasics rootJoint;
    private final MultiBodySystemBasics multiBodySystemInput;
    private final List<KinematicLoopFunction> kinematicLoopFunctions = new ArrayList<KinematicLoopFunction>();
    private final ReferenceFrame centerOfMassFrame;
    private final ControllerCoreOptimizationSettings optimizationSettings;
    private FeedbackControllerSettings feedbackControllerSettings = FeedbackControllerSettings.getDefault();
    private final YoGraphicsListRegistry yoGraphicsListRegistry;
    private final JointIndexHandler jointIndexHandler;
    private final double totalRobotMass;
    private CentroidalMomentumCalculator centroidalMomentumCalculator;
    private CentroidalMomentumRateCalculator centroidalMomentumRateCalculator;
    private CompositeRigidBodyMassMatrixCalculator massMatrixCalculator;
    private final InverseDynamicsCalculator inverseDynamicsCalculator;
    private final RigidBodyAccelerationProvider rigidBodyAccelerationProvider;
    private GravityCoriolisExternalWrenchMatrixCalculator gravityCoriolisExternalWrenchMatrixCalculator;
    private ContactWrenchMatrixCalculator contactWrenchMatrixCalculator;
    private RigidBodyBasics vmcMainBody;
    private List<? extends ContactablePlaneBody> contactablePlaneBodies;
    private JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters;
    private PlaneContactWrenchProcessor planeContactWrenchProcessor;
    private WrenchVisualizer wrenchVisualizer;
    private YoFrameVector3D yoDesiredMomentumRateLinear;
    private YoFrameVector3D yoAchievedMomentumRateLinear;
    private YoFrameVector3D yoDesiredMomentumRateAngular;
    private YoFrameVector3D yoAchievedMomentumRateAngular;
    private YoFrameVector3D yoDesiredMomentumLinear;
    private YoFrameVector3D yoDesiredMomentumAngular;
    private YoFrameVector3D yoAchievedMomentumLinear;
    private YoFrameVector3D yoAchievedMomentumAngular;
    private YoFrameVector3D yoResidualRootJointForce;
    private YoFrameVector3D yoResidualRootJointTorque;
    private MotionQPInputCalculator motionQPInputCalculator;
    private WholeBodyControllerBoundCalculator qpBoundCalculator;
    private WrenchMatrixCalculator wrenchMatrixCalculator;
    private boolean enableInverseDynamicsModule = false;
    private boolean enableInverseKinematicsModule = false;
    private boolean enableVirtualModelControlModule = false;

    public WholeBodyControlCoreToolbox(double controlDT, double gravityZ, FloatingJointBasics rootJoint, JointBasics[] controlledJoints, ReferenceFrame centerOfMassFrame, ControllerCoreOptimizationSettings controllerCoreOptimizationSettings, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        this.controlDT = controlDT;
        this.gravityZ = gravityZ;
        this.rootJoint = rootJoint;
        this.optimizationSettings = controllerCoreOptimizationSettings;
        this.yoGraphicsListRegistry = yoGraphicsListRegistry;
        if (rootJoint != null && Stream.of(controlledJoints).noneMatch(joint -> joint == rootJoint)) {
            JointBasics[] controlledJointsWithRoot = new JointBasics[controlledJoints.length + 1];
            System.arraycopy(controlledJoints, 0, controlledJointsWithRoot, 1, controlledJoints.length);
            controlledJointsWithRoot[0] = rootJoint;
            controlledJoints = controlledJointsWithRoot;
        }
        this.multiBodySystemInput = MultiBodySystemBasics.toMultiBodySystemBasics((JointBasics[])controlledJoints);
        if (centerOfMassFrame == null) {
            centerOfMassFrame = new CenterOfMassReferenceFrame("centerOfMassFrame", this.multiBodySystemInput.getInertialFrame(), (RigidBodyReadOnly)this.multiBodySystemInput.getRootBody());
        }
        this.centerOfMassFrame = centerOfMassFrame;
        this.jointIndexHandler = new JointIndexHandler(controlledJoints);
        this.totalRobotMass = TotalMassCalculator.computeSubTreeMass((RigidBodyBasics)this.multiBodySystemInput.getRootBody());
        this.inverseDynamicsCalculator = new InverseDynamicsCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput);
        this.inverseDynamicsCalculator.setGravitionalAcceleration(-gravityZ);
        this.rigidBodyAccelerationProvider = this.inverseDynamicsCalculator.getAccelerationProvider();
        parentRegistry.addChild(this.registry);
    }

    public void addKinematicLoopFunction(KinematicLoopFunction function) {
        this.kinematicLoopFunctions.add(function);
    }

    public void setJointPrivilegedConfigurationParameters(JointPrivilegedConfigurationParameters jointPrivilegedConfigurationParameters) {
        this.jointPrivilegedConfigurationParameters = jointPrivilegedConfigurationParameters;
    }

    public void setFeedbackControllerSettings(FeedbackControllerSettings feedbackControllerSettings) {
        if (feedbackControllerSettings != null) {
            this.feedbackControllerSettings = feedbackControllerSettings;
        }
    }

    public void setupForInverseDynamicsSolver(List<? extends ContactablePlaneBody> contactablePlaneBodies) {
        this.enableInverseDynamicsModule = true;
        this.contactablePlaneBodies = contactablePlaneBodies;
        if (this.centroidalMomentumCalculator != null) {
            this.centroidalMomentumCalculator = null;
        }
        this.centroidalMomentumRateCalculator = new CentroidalMomentumRateCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput, this.centerOfMassFrame);
    }

    public void setupForInverseKinematicsSolver() {
        this.enableInverseKinematicsModule = true;
        if (this.centroidalMomentumRateCalculator == null) {
            this.centroidalMomentumCalculator = new CentroidalMomentumCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput, this.centerOfMassFrame);
        }
    }

    public void setupForVirtualModelControlSolver(RigidBodyBasics vmcMainBody, List<? extends ContactablePlaneBody> contactablePlaneBodies) {
        this.enableVirtualModelControlModule = true;
        this.vmcMainBody = vmcMainBody;
        this.contactablePlaneBodies = contactablePlaneBodies;
        if (this.centroidalMomentumCalculator != null) {
            this.centroidalMomentumCalculator = null;
        }
        this.centroidalMomentumRateCalculator = new CentroidalMomentumRateCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput, this.centerOfMassFrame);
    }

    public boolean isEnableInverseDynamicsModule() {
        return this.enableInverseDynamicsModule;
    }

    public boolean isEnableInverseKinematicsModule() {
        return this.enableInverseKinematicsModule;
    }

    public boolean isEnableVirtualModelControlModule() {
        return this.enableVirtualModelControlModule;
    }

    public MultiBodySystemBasics getMultiBodySystemInput() {
        return this.multiBodySystemInput;
    }

    public List<KinematicLoopFunction> getKinematicLoopFunctions() {
        return this.kinematicLoopFunctions;
    }

    public MotionQPInputCalculator getMotionQPInputCalculator() {
        if (this.motionQPInputCalculator == null) {
            if (this.centroidalMomentumRateCalculator != null) {
                this.motionQPInputCalculator = new MotionQPInputCalculator(this.centerOfMassFrame, this.centroidalMomentumRateCalculator, this.jointIndexHandler, this.jointPrivilegedConfigurationParameters, this.registry);
            } else {
                Objects.requireNonNull(this.centroidalMomentumCalculator);
                this.motionQPInputCalculator = new MotionQPInputCalculator(this.centerOfMassFrame, this.centroidalMomentumCalculator, this.jointIndexHandler, this.jointPrivilegedConfigurationParameters, this.registry);
            }
        }
        return this.motionQPInputCalculator;
    }

    public WholeBodyControllerBoundCalculator getQPBoundCalculator() {
        if (this.qpBoundCalculator == null) {
            boolean areJointVelocityLimitsConsidered = this.optimizationSettings.areJointVelocityLimitsConsidered();
            this.qpBoundCalculator = new WholeBodyControllerBoundCalculator(this.jointIndexHandler, this.controlDT, areJointVelocityLimitsConsidered, this.registry);
        }
        return this.qpBoundCalculator;
    }

    public WrenchMatrixCalculator getWrenchMatrixCalculator() {
        if (this.wrenchMatrixCalculator == null) {
            this.wrenchMatrixCalculator = new WrenchMatrixCalculator(this, this.registry);
        }
        return this.wrenchMatrixCalculator;
    }

    public ControllerCoreOptimizationSettings getOptimizationSettings() {
        return this.optimizationSettings;
    }

    public FeedbackControllerSettings getFeedbackControllerSettings() {
        return this.feedbackControllerSettings;
    }

    public JointPrivilegedConfigurationParameters getJointPrivilegedConfigurationParameters() {
        return this.jointPrivilegedConfigurationParameters;
    }

    public RigidBodyAccelerationProvider getRigidBodyAccelerationProvider() {
        return this.rigidBodyAccelerationProvider;
    }

    public InverseDynamicsCalculator getInverseDynamicsCalculator() {
        return this.inverseDynamicsCalculator;
    }

    public GravityCoriolisExternalWrenchMatrixCalculator getGravityCoriolisExternalWrenchMatrixCalculator() {
        if (this.gravityCoriolisExternalWrenchMatrixCalculator == null) {
            this.gravityCoriolisExternalWrenchMatrixCalculator = new GravityCoriolisExternalWrenchMatrixCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput);
            this.gravityCoriolisExternalWrenchMatrixCalculator.setGravitionalAcceleration(-Math.abs(this.gravityZ));
        }
        return this.gravityCoriolisExternalWrenchMatrixCalculator;
    }

    public ContactWrenchMatrixCalculator getContactWrenchMatrixCalculator() {
        if (this.contactWrenchMatrixCalculator == null) {
            this.contactWrenchMatrixCalculator = new ContactWrenchMatrixCalculator(this);
        }
        return this.contactWrenchMatrixCalculator;
    }

    public CentroidalMomentumRateCalculator getCentroidalMomentumRateCalculator() {
        return this.centroidalMomentumRateCalculator;
    }

    public CompositeRigidBodyMassMatrixCalculator getMassMatrixCalculator() {
        if (this.massMatrixCalculator == null) {
            this.massMatrixCalculator = new CompositeRigidBodyMassMatrixCalculator((MultiBodySystemReadOnly)this.multiBodySystemInput);
        }
        return this.massMatrixCalculator;
    }

    public FloatingJointBasics getRootJoint() {
        return this.rootJoint;
    }

    public RigidBodyBasics getRootBody() {
        return this.multiBodySystemInput.getRootBody();
    }

    public RigidBodyBasics getVirtualModelControlMainBody() {
        return this.vmcMainBody;
    }

    public double getControlDT() {
        return this.controlDT;
    }

    public ReferenceFrame getCenterOfMassFrame() {
        return this.centerOfMassFrame;
    }

    public double getGravityZ() {
        return this.gravityZ;
    }

    public double getTotalRobotMass() {
        return this.totalRobotMass;
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return this.yoGraphicsListRegistry;
    }

    public List<? extends ContactablePlaneBody> getContactablePlaneBodies() {
        return this.contactablePlaneBodies;
    }

    public PlaneContactWrenchProcessor getPlaneContactWrenchProcessor() {
        if (this.planeContactWrenchProcessor == null) {
            this.planeContactWrenchProcessor = new PlaneContactWrenchProcessor(this.contactablePlaneBodies, this.yoGraphicsListRegistry, this.registry);
        }
        return this.planeContactWrenchProcessor;
    }

    public CenterOfPressureDataHolder getDesiredCenterOfPressureDataHolder() {
        return this.getPlaneContactWrenchProcessor().getDesiredCenterOfPressureDataHolder();
    }

    public DesiredExternalWrenchHolder getDesiredExternalWrenchHolder() {
        return this.getPlaneContactWrenchProcessor().getDesiredExternalWrenchHolder();
    }

    public WrenchVisualizer getWrenchVisualizer() {
        if (this.yoGraphicsListRegistry == null) {
            return null;
        }
        if (this.wrenchVisualizer == null) {
            this.wrenchVisualizer = WrenchVisualizer.createWrenchVisualizerWithContactableBodies("DesiredExternalWrench", this.contactablePlaneBodies, 1.0, this.yoGraphicsListRegistry, this.registry);
        }
        return this.wrenchVisualizer;
    }

    public YoFrameVector3D getYoDesiredMomentumRateLinear() {
        if (this.yoDesiredMomentumRateLinear == null) {
            this.yoDesiredMomentumRateLinear = new YoFrameVector3D("desiredMomentumRateLinear", worldFrame, this.registry);
        }
        return this.yoDesiredMomentumRateLinear;
    }

    public YoFrameVector3D getYoAchievedMomentumRateLinear() {
        if (this.yoAchievedMomentumRateLinear == null) {
            this.yoAchievedMomentumRateLinear = new YoFrameVector3D("achievedMomentumRateLinear", worldFrame, this.registry);
        }
        return this.yoAchievedMomentumRateLinear;
    }

    public YoFrameVector3D getYoDesiredMomentumRateAngular() {
        if (this.yoDesiredMomentumRateAngular == null) {
            this.yoDesiredMomentumRateAngular = new YoFrameVector3D("desiredMomentumRateAngular", worldFrame, this.registry);
        }
        return this.yoDesiredMomentumRateAngular;
    }

    public YoFrameVector3D getYoAchievedMomentumRateAngular() {
        if (this.yoAchievedMomentumRateAngular == null) {
            this.yoAchievedMomentumRateAngular = new YoFrameVector3D("achievedMomentumRateAngular", worldFrame, this.registry);
        }
        return this.yoAchievedMomentumRateAngular;
    }

    public YoFrameVector3D getYoDesiredMomentumLinear() {
        if (this.yoDesiredMomentumLinear == null) {
            this.yoDesiredMomentumLinear = new YoFrameVector3D("desiredMomentumLinear", worldFrame, this.registry);
        }
        return this.yoDesiredMomentumLinear;
    }

    public YoFrameVector3D getYoDesiredMomentumAngular() {
        if (this.yoDesiredMomentumAngular == null) {
            this.yoDesiredMomentumAngular = new YoFrameVector3D("desiredMomentumAngular", worldFrame, this.registry);
        }
        return this.yoDesiredMomentumAngular;
    }

    public YoFrameVector3D getYoAchievedMomentumLinear() {
        if (this.yoAchievedMomentumLinear == null) {
            this.yoAchievedMomentumLinear = new YoFrameVector3D("achievedMomentumLinear", worldFrame, this.registry);
        }
        return this.yoAchievedMomentumLinear;
    }

    public YoFrameVector3D getYoAchievedMomentumAngular() {
        if (this.yoAchievedMomentumAngular == null) {
            this.yoAchievedMomentumAngular = new YoFrameVector3D("achievedMomentumAngular", worldFrame, this.registry);
        }
        return this.yoAchievedMomentumAngular;
    }

    public YoFrameVector3D getYoResidualRootJointForce() {
        if (this.yoResidualRootJointForce == null) {
            this.yoResidualRootJointForce = new YoFrameVector3D("residualRootJointForce", worldFrame, this.registry);
        }
        return this.yoResidualRootJointForce;
    }

    public YoFrameVector3D getYoResidualRootJointTorque() {
        if (this.yoResidualRootJointTorque == null) {
            this.yoResidualRootJointTorque = new YoFrameVector3D("residualRootJointTorque", worldFrame, this.registry);
        }
        return this.yoResidualRootJointTorque;
    }

    public JointIndexHandler getJointIndexHandler() {
        return this.jointIndexHandler;
    }

    public int getNumberOfBasisVectorsPerContactPoint() {
        return this.optimizationSettings.getNumberOfBasisVectorsPerContactPoint();
    }

    public int getNumberOfContactPointsPerContactableBody() {
        return this.optimizationSettings.getNumberOfContactPointsPerContactableBody();
    }

    public int getNumberOfContactableBodies() {
        return this.optimizationSettings.getNumberOfContactableBodies();
    }

    public int getRhoSize() {
        return this.optimizationSettings.getRhoSize();
    }

    public boolean getDeactiveRhoWhenNotInContact() {
        return this.optimizationSettings.getDeactivateRhoWhenNotInContact();
    }
}

