/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.commonWalkingControlModules.controllerCore;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import us.ihmc.commonWalkingControlModules.controllerCore.command.ControllerCoreCommandType;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.FeedbackControlCommandList;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OneDoFJointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.OrientationFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.PointFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.controllerCore.command.feedbackController.SpatialFeedbackControlCommand;
import us.ihmc.commonWalkingControlModules.momentumBasedController.feedbackController.FeedbackControllerFactory;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;

public class FeedbackControllerTemplate {
    private boolean allowDynamicControllerConstruction = false;
    private final Map<RigidBodyBasics, Integer> spatialFeedbackControllerTemplate = new HashMap<RigidBodyBasics, Integer>();
    private final Map<RigidBodyBasics, Integer> orientationFeedbackControllerTemplate = new HashMap<RigidBodyBasics, Integer>();
    private final Map<RigidBodyBasics, Integer> pointFeedbackControllerTemplate = new HashMap<RigidBodyBasics, Integer>();
    private final Set<OneDoFJointBasics> oneDoFJointFeedbackControllerTemplate = new HashSet<OneDoFJointBasics>();
    private boolean enableCenterOfMassFeedbackController = false;
    private FeedbackControllerFactory feedbackControllerFactory = new FeedbackControllerFactory();

    public FeedbackControllerTemplate() {
    }

    public FeedbackControllerTemplate(FeedbackControlCommandList commandTemplate) {
        this.convert(commandTemplate);
    }

    public void convert(FeedbackControlCommandList commandTemplate) {
        block8: for (int i = 0; i < commandTemplate.getNumberOfCommands(); ++i) {
            FeedbackControlCommand<?> commandExample = commandTemplate.getCommand(i);
            ControllerCoreCommandType commandType = commandExample.getCommandType();
            switch (commandType) {
                case TASKSPACE: {
                    this.enableSpatialFeedbackController(((SpatialFeedbackControlCommand)commandExample).getEndEffector());
                    continue block8;
                }
                case POINT: {
                    this.enablePointFeedbackController(((PointFeedbackControlCommand)commandExample).getEndEffector());
                    continue block8;
                }
                case ORIENTATION: {
                    this.enableOrientationFeedbackController(((OrientationFeedbackControlCommand)commandExample).getEndEffector());
                    continue block8;
                }
                case JOINTSPACE: {
                    this.enableOneDoFJointFeedbackController(((OneDoFJointFeedbackControlCommand)commandExample).getJoint());
                    continue block8;
                }
                case MOMENTUM: {
                    this.enableCenterOfMassFeedbackController();
                    continue block8;
                }
                case COMMAND_LIST: {
                    this.convert((FeedbackControlCommandList)commandExample);
                    continue block8;
                }
                default: {
                    throw new RuntimeException("The command type: " + (Object)((Object)commandExample.getCommandType()) + " is not handled.");
                }
            }
        }
    }

    public void setAllowDynamicControllerConstruction(boolean allowDynamicControllerConstruction) {
        this.allowDynamicControllerConstruction = allowDynamicControllerConstruction;
    }

    public void enableSpatialFeedbackController(RigidBodyBasics endEffector) {
        this.enableSpatialFeedbackController(endEffector, 1);
    }

    public void enableSpatialFeedbackController(RigidBodyBasics endEffector, int numberOfControllers) {
        this.spatialFeedbackControllerTemplate.put(endEffector, numberOfControllers);
    }

    public void enableOrientationFeedbackController(RigidBodyBasics endEffector) {
        this.enableOrientationFeedbackController(endEffector, 1);
    }

    public void enableOrientationFeedbackController(RigidBodyBasics endEffector, int numberOfControllers) {
        this.orientationFeedbackControllerTemplate.put(endEffector, numberOfControllers);
    }

    public void enablePointFeedbackController(RigidBodyBasics endEffector) {
        this.enablePointFeedbackController(endEffector, 1);
    }

    public void enablePointFeedbackController(RigidBodyBasics endEffector, int numberOfControllers) {
        this.pointFeedbackControllerTemplate.put(endEffector, 1);
    }

    public void enableOneDoFJointFeedbackController(OneDoFJointBasics joint) {
        this.oneDoFJointFeedbackControllerTemplate.add(joint);
    }

    public void enableCenterOfMassFeedbackController() {
        this.enableCenterOfMassFeedbackController = true;
    }

    public void setFeedbackControllerFactory(FeedbackControllerFactory feedbackControllerFactory) {
        this.feedbackControllerFactory = feedbackControllerFactory;
    }

    public boolean isDynamicControllerConstructionAllowed() {
        return this.allowDynamicControllerConstruction;
    }

    public Map<RigidBodyBasics, Integer> getSpatialFeedbackControllerTemplate() {
        return this.spatialFeedbackControllerTemplate;
    }

    public Map<RigidBodyBasics, Integer> getOrientationFeedbackControllerTemplate() {
        return this.orientationFeedbackControllerTemplate;
    }

    public Map<RigidBodyBasics, Integer> getPointFeedbackControllerTemplate() {
        return this.pointFeedbackControllerTemplate;
    }

    public Set<OneDoFJointBasics> getOneDoFJointFeedbackControllerTemplate() {
        return this.oneDoFJointFeedbackControllerTemplate;
    }

    public boolean isCenterOfMassFeedbackControllerEnabled() {
        return this.enableCenterOfMassFeedbackController;
    }

    public FeedbackControllerFactory getFeedbackControllerFactory() {
        return this.feedbackControllerFactory;
    }
}

